/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.handler;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.actiondispatcher.ActionUtil;
import kd.bos.context.OperationContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.exception.LoginErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.filter.LoginFilter;
import kd.bos.login.handler.LoginHandlerChain;
import kd.bos.login.handler.LoginHandlerContext;
import kd.bos.login.handler.LoginHandlerResult;
import kd.bos.login.handler.RequestWrapperAnalysis;
import kd.bos.login.utils.Constants;
import kd.bos.login.utils.LoginUtils;

public class NewLoginFilter {
    private static Log logger = LogFactory.getLog(LoginFilter.class);
    private LoginHandlerContext handlerContext;
    private LoginHandlerResult handlerResult;
    private LoginHandlerChain handlerChain;
    private static final String APP_SYS = "sys";

    public NewLoginFilter() {
        this(null, null, null);
    }

    public NewLoginFilter(LoginHandlerContext handlerContext, LoginHandlerResult handlerResult, LoginHandlerChain handlerChain) {
        this.handlerContext = handlerContext == null ? new LoginHandlerContext() : handlerContext;
        this.handlerResult = handlerResult == null ? new LoginHandlerResult(this.handlerContext) : handlerResult;
        this.handlerChain = handlerChain == null ? LoginHandlerChain.getInstance(this.handlerContext, this.handlerResult) : handlerChain;
    }

    public void doFilter(ServletRequest servletRequestOld, ServletResponse servletResponse, FilterChain filterChain) throws IOException {
        this.doFilterThrow(servletRequestOld, servletResponse, filterChain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFilterThrow(ServletRequest servletRequestOld, ServletResponse servletResponse, FilterChain filterChain) throws IOException {
        try {
            OperationContext oc = new OperationContext();
            oc.setAppId(APP_SYS);
            OperationContext.set((OperationContext)oc);
            HttpServletRequest requestWrapper = RequestWrapperAnalysis.getRequestWrapper(servletRequestOld);
            HttpServletResponse responseWrapper = (HttpServletResponse)servletResponse;
            this.handlerContext.init(filterChain, requestWrapper, responseWrapper, this.handlerResult);
            this.handlerChain.handle();
        }
        catch (KDException ex) {
            logger.info(ex.getMessage());
            ErrorCode code = ex.getErrorCode();
            if (Constants.KD_WEB_EXCEPTION.equals((Object)code)) {
                String resp = LoginUtils.getErrorPageString(ex.getMessage());
                ActionUtil.writeResponseResult((ServletResponse)servletResponse, (CharSequence)resp);
            } else {
                String resp = LoginUtils.getLoginResponse(String.valueOf(code.getCode()), ex.getMessage());
                ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)resp);
            }
        }
        catch (Throwable e) {
            logger.warn(e);
            KDException kd = new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002%s", (String)"LoginAction_50", (String)"bos-login", (Object[])new Object[]{e.getMessage()})});
            String resp = LoginUtils.getLoginResponse(String.valueOf(kd.getErrorCode().getCode()), kd.getMessage());
            try {
                ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)resp);
            }
            catch (Exception ex) {
                try {
                    throw e;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        finally {
            if (this.handlerResult != null) {
                this.handlerResult.toLog();
            }
        }
    }
}

