/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.handler.impl.auth;

import kd.bos.exception.KDException;
import kd.bos.exception.LoginErrorCode;
import kd.bos.login.handler.LoginHandlerContext;
import kd.bos.login.handler.LoginHandlerResult;
import kd.bos.login.handler.impl.AbstractLoginAuthHandler;
import kd.bos.login.sso.ISSOAuth;
import kd.bos.login.sso.SSOAuth;
import kd.bos.login.sso.SSOAuthResult;
import kd.bos.login.sso.SSOErrorCode;
import kd.bos.login.thirdauth.AllSSOHandler;

public class SSOAuthHandler
extends AbstractLoginAuthHandler {
    private ISSOAuth ssoAuth;

    public SSOAuthHandler(LoginHandlerContext context, LoginHandlerResult handlerResult) {
        super(context, handlerResult);
    }

    @Override
    public boolean doMatch() {
        AllSSOHandler.handleLogoutLogic(this.context.getRequestWrapper());
        try {
            this.ssoAuth = new SSOAuth(this.context.getRequestWrapper(), this.context.getResponseWrapper());
        }
        catch (KDException e) {
            if (SSOErrorCode.match(e.getErrorCode())) {
                return false;
            }
            throw e;
        }
        return true;
    }

    @Override
    protected void doHandle() throws Exception {
        SSOAuthResult ssoAuthResult = this.loginSSOInterceptor();
        if (ssoAuthResult.getType() == SSOAuthResult.SSOSessionType.DONOTHING) {
            return;
        }
        if (ssoAuthResult.getType() == SSOAuthResult.SSOSessionType.SET) {
            this.doSuccess(ssoAuthResult.getSessionId());
            return;
        }
        throw new KDException(LoginErrorCode.systemError, new Object[0]);
    }

    private SSOAuthResult loginSSOInterceptor() {
        try {
            return this.ssoAuth.auth();
        }
        catch (KDException e) {
            if (SSOErrorCode.match(e.getErrorCode())) {
                return SSOAuthResult.donothing();
            }
            throw e;
        }
    }
}

