/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.handler.impl.auth;

import kd.bos.login.handler.LoginHandlerContext;
import kd.bos.login.handler.LoginHandlerResult;
import kd.bos.login.handler.impl.AbstractLoginAuthHandler;
import kd.bos.login.service.apps.ThirdAppsService;
import kd.bos.login.service.apps.impl.ThirdAppsServiceImpl;
import org.apache.commons.lang3.StringUtils;

public class ThirdAppAuthHandler
extends AbstractLoginAuthHandler {
    private ThirdAppsService thirdAppsService = new ThirdAppsServiceImpl();

    public ThirdAppAuthHandler(LoginHandlerContext context, LoginHandlerResult handlerResult) {
        super(context, handlerResult);
    }

    @Override
    protected boolean doMatch() {
        boolean needThirdAppHandle = this.thirdAppsService.isNeedThirdAppHandle(this.context.getRequestWrapper());
        if (needThirdAppHandle) {
            this.handlerResult.setRedirectParams("thirdApp");
        }
        return needThirdAppHandle;
    }

    @Override
    protected void doHandle() throws Exception {
        this.tryCreateSession();
    }

    private void tryCreateSession() throws Exception {
        String thirdSessionId = this.thirdAppsService.getThirdSessionId(this.context.getRequestWrapper(), this.context.getResponseWrapper(), this.handlerResult.getLoginUser());
        if (StringUtils.isNotEmpty((CharSequence)thirdSessionId)) {
            this.doSuccess(thirdSessionId);
        }
    }
}

