/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.handler.impl.common;

import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.login.CacheLoginData;
import kd.bos.login.handler.LoginHandlerContext;
import kd.bos.login.handler.LoginHandlerResult;
import kd.bos.login.handler.impl.AbstractLoginHandler;
import kd.bos.login.utils.LoginUtils;
import kd.bos.share.NoCodeShare;
import kd.bos.share.service.NoCodeShareSerivce;
import kd.bos.share.service.ShareSerivce;
import kd.bos.share.session.ShareSession;
import kd.bos.url.UrlService;
import org.apache.commons.lang3.StringUtils;

public class CodelessShareResourceHandler
extends AbstractLoginHandler {
    private ShareSerivce shareSerivce = new NoCodeShareSerivce();
    private static final String NO_CODE_SHARE_PREFIX = "/share/";
    private static final String UNDER_LINE = "_";
    private static final String errorCode = "40100";

    public CodelessShareResourceHandler(LoginHandlerContext context, LoginHandlerResult handlerResult) {
        super(context, handlerResult);
    }

    @Override
    public boolean isMatch() {
        String shareIdCache;
        if (!this.context.getRequestURI().contains(NO_CODE_SHARE_PREFIX)) {
            return false;
        }
        if (this.validClientSession() && StringUtils.isEmpty((CharSequence)(shareIdCache = CacheLoginData.getAttribute((String)"nocode_share", (String)this.getClientSession())))) {
            String userId = LoginUtils.getUserIdFromSession(this.getClientSession(), true);
            return StringUtils.isBlank((CharSequence)userId) || "-1".equals(userId) || "0".equals(userId);
        }
        return true;
    }

    @Override
    protected void doHandle() throws Exception {
        try {
            Optional<String> session = this.route(this.context.getRequestWrapper(), this.context.getResponseWrapper());
            if (session.isPresent()) {
                this.doSuccess(session.get());
            }
        }
        catch (KDException ex) {
            logger.error((Throwable)ex);
            if (errorCode.equals(ex.getErrorCode().getCode())) {
                HttpServletResponse response = this.context.getResponseWrapper();
                response.sendRedirect(UrlService.getDomainContextUrl() + "/nocode/shareExpired.html");
                this.doResponse(new String[0]);
            }
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
        }
    }

    private Optional<String> route(HttpServletRequest request, HttpServletResponse response) {
        String[] shares = this.context.getRealUrl().split(NO_CODE_SHARE_PREFIX);
        String shareid = null;
        if (shares.length != 0) {
            shareid = shares[1];
        }
        if (shareid == null) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u6ca1\u6709shareid\uff01", (String)"ShareRouteService_0", (String)"bos-login", (Object[])new Object[0]));
        }
        if (shareid.contains(UNDER_LINE)) {
            String[] strings = shareid.split(UNDER_LINE);
            if (!StringUtils.isNumeric((CharSequence)strings[0])) {
                return Optional.empty();
            }
            NoCodeShare noCodeShare = (NoCodeShare)this.shareSerivce.getShareById(strings[0], strings[1]);
            long now = System.currentTimeMillis();
            if (now > noCodeShare.getExpireTime()) {
                throw new KDException(new ErrorCode(errorCode, ResManager.loadKDString((String)"\u5206\u4eab\u94fe\u63a5\u5df2\u8fc7\u671f\uff01", (String)"ShareRouteService_1", (String)"bos-login", (Object[])new Object[0])), new Object[0]);
            }
            if (noCodeShare == null) {
                throw new KDException(new ErrorCode(errorCode, ResManager.loadKDString((String)"\u5206\u4eab\u94fe\u63a5\u5df2\u5931\u6548\uff01", (String)"ShareRouteService_2", (String)"bos-login", (Object[])new Object[0])), new Object[0]);
            }
            return Optional.of(ShareSession.getShareSessionId(request, response, strings[0], strings[1], strings[2]));
        }
        return Optional.empty();
    }
}

