/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.handler.impl.common;

import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.mc.tenant.AccountType;
import kd.bos.login.CacheLoginData;
import kd.bos.login.LoginType;
import kd.bos.login.filter.LoginManage;
import kd.bos.login.handler.LoginHandlerContext;
import kd.bos.login.handler.LoginHandlerResult;
import kd.bos.login.handler.impl.AbstractLoginHandler;
import kd.bos.login.thirdauth.ThirdSSOAuthHandler;
import kd.bos.login.utils.AgentUtil;
import kd.bos.login.utils.BeanUtils;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.OnlineUserUtil;
import kd.bos.login.utils.StringUtils;
import kd.bos.login.utils.URLUtils;
import kd.bos.login.utils.account.LoginAccountFactory;
import kd.bos.session.SessionDAO;
import kd.bos.session.SessionDAOFactory;
import kd.bos.util.RevProxyUtil;

public class LoginOutResourceHandler
extends AbstractLoginHandler {
    private static final String LOGOUT_URL = "/auth/logout.do";

    public LoginOutResourceHandler(LoginHandlerContext context, LoginHandlerResult handlerResult) {
        super(context, handlerResult);
    }

    @Override
    public boolean isMatch() {
        return this.context.getRequestURI().contains(LOGOUT_URL);
    }

    @Override
    protected void doHandle() throws Exception {
        this.doLogout(this.context.getRequestWrapper(), this.context.getResponseWrapper());
        this.doResponse(new String[0]);
    }

    private void doLogout(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.loginoutForSession(request, response)) {
            return;
        }
        String mainWebSite = RevProxyUtil.getURLContextPath((HttpServletRequest)request);
        String redirectPage = request.getParameter("redirect");
        redirectPage = URLUtils.checkRedirectUrl(request, redirectPage);
        if (this.isStandLone()) {
            response.sendRedirect(String.format("%s", mainWebSite));
        } else if (AgentUtil.isMobile(request)) {
            String redirect = request.getParameter("redirect");
            redirect = URLUtils.checkRedirectUrl(request, redirect);
            String url = String.format("%slogin-mobile.html", mainWebSite);
            if (StringUtils.isNotEmpty(redirect)) {
                url = url + "?redirect=" + redirect;
            }
            response.sendRedirect(url);
        } else if (LoginUtils.isMCSystem()) {
            if (kd.bos.util.StringUtils.isEmpty((String)redirectPage)) {
                response.sendRedirect(String.format("%slogin-mc.html", mainWebSite));
            } else {
                response.sendRedirect(String.format("%s%s", mainWebSite, redirectPage));
            }
        } else if (kd.bos.util.StringUtils.isEmpty((String)redirectPage)) {
            response.sendRedirect(String.format("%slogin.html", mainWebSite));
        } else {
            response.sendRedirect(String.format("%s%s", mainWebSite, redirectPage));
        }
    }

    private boolean loginoutForSession(HttpServletRequest request, HttpServletResponse response) {
        String sessionId = this.getClientSession();
        SessionDAO sessionDAO = SessionDAOFactory.getSessionDAO((String)sessionId);
        Map attributes = sessionDAO.getAttributesAsMap(new String[]{"apptype", "client"});
        attributes.put("sessionId", sessionId);
        String accountId = "";
        String tenantId = RevProxyUtil.getTenantCode((HttpServletRequest)request);
        accountId = new LoginManage().removeSessionId(request, response, sessionId, accountId, tenantId);
        try {
            OnlineUserUtil.logout(attributes);
        }
        catch (Exception e) {
            logger.error("onlineUser===>" + e.getMessage());
        }
        Account currentCenter = LoginAccountFactory.createInstanceByCustom(accountId, request).getAccount();
        String plugin = currentCenter.getSsoPlugin();
        if (LoginUtils.hasPrevilige(AccountType.ThridParty.toString(), currentCenter.getAllSourceTypes()) && StringUtils.isNotEmpty(plugin)) {
            String cacheValue;
            boolean needExe = true;
            if (LoginUtils.isSupportLoginUnderSSO(currentCenter) && StringUtils.isNotEmpty(cacheValue = CacheLoginData.getAttribute((String)"", (String)LoginUtils.getSSOSupportCachkey(sessionId, currentCenter.getAccountId())))) {
                needExe = false;
            }
            if (needExe) {
                ThirdSSOAuthHandler sso = (ThirdSSOAuthHandler)BeanUtils.getBean(plugin);
                String site = sso.getERPCallback(request, tenantId, currentCenter.getAccountId());
                sso.callTrdSSOLogin(request, response, site);
                return true;
            }
        }
        return false;
    }

    private boolean isStandLone() {
        return LoginType.STANDALONE == this.context.getLoginType();
    }
}

