/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.handler.impl.verify;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import kd.bos.context.RequestContextCreator;
import kd.bos.context.api.ApiContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.api.model.Account;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.lang.Lang;
import kd.bos.login.LoginClientEnum;
import kd.bos.login.filter.HandleResult;
import kd.bos.login.handler.LoginHandlerContext;
import kd.bos.login.handler.LoginHandlerResult;
import kd.bos.login.handler.impl.AbstractLoginHandler;
import kd.bos.login.lang.LoginLangUtils;
import kd.bos.login.service.openapi.TokenErrorCode;
import kd.bos.login.spi.OpenApiServiceManager;
import kd.bos.login.user.LoginUserService;
import kd.bos.login.utils.SessionUtils;
import kd.bos.login.utils.StringUtils;
import kd.bos.login.utils.account.LoginAccountFactory;
import kd.bos.service.authorize.http.KDSignHttpServletRequestWrapper;
import kd.bos.service.authorize.model.ApiCommonResult;
import kd.bos.service.authorize.model.AuthResult;
import kd.bos.session.SessionInfo;
import kd.bos.util.NetAddressUtils;
import org.apache.commons.collections4.MapUtils;

public class NewApiVerifyHandler
extends AbstractLoginHandler {
    private static final String KAPI_RESOURCE_URL = "/kapi/";
    private ApiCommonResult<AuthResult> apiAuthResult;

    public NewApiVerifyHandler(LoginHandlerContext context, LoginHandlerResult handlerResult) {
        super(context, handlerResult);
    }

    @Override
    public boolean isMatch() {
        return this.context.getRealUrl().startsWith(KAPI_RESOURCE_URL);
    }

    @Override
    protected void doHandle() throws Exception {
        KDSignHttpServletRequestWrapper requestWrapperNew = new KDSignHttpServletRequestWrapper(this.context.getRequestWrapper());
        this.apiAuthResult = OpenApiServiceManager.getApiAuthorizeService().auth((HttpServletRequest)requestWrapperNew, this.context.getResponseWrapper(), this.context.getFilterChain());
        if (!this.apiAuthResult.getStatus().booleanValue() && TokenErrorCode.OLD_VALIDWAY.getCode().equalsIgnoreCase(this.apiAuthResult.getErrorCode())) {
            return;
        }
        if (!this.apiAuthResult.getStatus().booleanValue()) {
            this.doResponse(new String[0]);
            return;
        }
        HandleResult result = new HandleResult();
        result.setAccountId(((AuthResult)this.apiAuthResult.getData()).getAccountId());
        Account currentCenter = LoginAccountFactory.createInstanceByCustom(((AuthResult)this.apiAuthResult.getData()).getAccountId(), this.context.getTenantId()).getAccount();
        Long agentUserId = ((AuthResult)this.apiAuthResult.getData()).getAgentUserId();
        Map<String, String> userInfo = ((AuthResult)this.apiAuthResult.getData()).getUserInfo();
        if (agentUserId == null && MapUtils.isEmpty((Map)userInfo)) {
            throw new KDException(new ErrorCode(TokenErrorCode.API_REQUEST_INVALID_PARAMETERS.getCode(), ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u7528\u6237\u4e0d\u5b58\u5728\u3002", (String)"LoginAPI_8", (String)"bos-login", (Object[])new Object[0])), new Object[0]);
        }
        if (agentUserId != null) {
            Lang lang = LoginLangUtils.getLoginLanguage((HttpServletRequest)requestWrapperNew);
            userInfo = LoginUserService.getErpUserInfoByUserId(currentCenter, agentUserId.toString(), lang.name());
        }
        if (MapUtils.isEmpty((Map)userInfo)) {
            throw new KDException(new ErrorCode(TokenErrorCode.API_REQUEST_INVALID_PARAMETERS.getCode(), ResManager.loadKDString((String)"\u60a8\u7684\u8d26\u53f7\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"LoginFilter_10", (String)"bos-login", (Object[])new Object[0])), new Object[0]);
        }
        result.setUserInfo(userInfo);
        this.handlerResult.changeSessionId(((AuthResult)this.apiAuthResult.getData()).getAccessToken());
        this.createRequestForLoadSession(result, currentCenter, userInfo);
        this.doForward((HttpServletRequest)requestWrapperNew, new String[0]);
    }

    private void createRequestForLoadSession(HandleResult result, Account currentCenter, Map<String, String> userInfo) {
        if (StringUtils.isNotEmpty(this.handlerResult.getSessionId())) {
            SessionInfo sessionInfo = SessionUtils.getSessinInfoBySessionId(this.handlerResult.getSessionId());
            RequestContextCreator.create((HttpServletRequest)this.context.getRequestWrapper(), (String)this.handlerResult.getSessionId(), (SessionInfo)sessionInfo, (boolean)false);
        } else {
            ApiContext apiContext = ApiContext.create();
            apiContext.setAppNum(((AuthResult)this.apiAuthResult.getData()).getThirdAppNumber());
            apiContext.setAppId(((AuthResult)this.apiAuthResult.getData()).getThirdId());
            ApiContext.set((ApiContext)apiContext);
            SessionInfo si = new SessionInfo();
            if (currentCenter != null) {
                si.setTenantId(currentCenter.getTenantId());
            }
            si.setOrgId(userInfo.get("forgid"));
            si.setUserId(userInfo.get("fid"));
            si.setUserName(userInfo.get("ftruename"));
            si.setUserOpenId(userInfo.get("fopenid"));
            si.setUserType(userInfo.get("userType"));
            si.setLoginIP(NetAddressUtils.getRemoteHost((HttpServletRequest)this.context.getRequestWrapper()));
            if (result.getLanguage() != null) {
                si.setLanguage(result.getLanguage().toString());
            }
            si.setUid(userInfo.get("fuid"));
            si.setClient(LoginClientEnum.API.getDesc());
            si.setAccountId(currentCenter.getAccountId());
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            si.setLoginTime(df.format(new Date()));
            si.setAuthType(result.getAuthType());
            if (StringUtils.isNotBlank(((AuthResult)this.apiAuthResult.getData()).getAuthType())) {
                si.setAuthType(((AuthResult)this.apiAuthResult.getData()).getAuthType());
            }
            si.setApi3rdAppId(((AuthResult)this.apiAuthResult.getData()).getThirdId() + "");
            si.setApi3rdAppNum(((AuthResult)this.apiAuthResult.getData()).getThirdAppNumber());
            RequestContextCreator.create((HttpServletRequest)this.context.getRequestWrapper(), (String)"-1", (SessionInfo)si, (boolean)false);
        }
    }
}

