/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.handler.impl.verify;

import java.util.Map;
import kd.bos.login.handler.LoginHandlerContext;
import kd.bos.login.handler.LoginHandlerResult;
import kd.bos.login.handler.impl.AbstractLoginVerifyHandler;
import kd.bos.login.service.apps.ThirdAppsService;
import kd.bos.login.service.apps.impl.ThirdAppsServiceImpl;
import kd.bos.login.utils.LoginUtils;
import kd.bos.session.SessionDAO;
import kd.bos.session.SessionDAOFactory;
import org.apache.commons.lang3.StringUtils;

public class ThirdAppVerifyHandler
extends AbstractLoginVerifyHandler {
    private ThirdAppsService thirdAppsService = new ThirdAppsServiceImpl();

    public ThirdAppVerifyHandler(LoginHandlerContext context, LoginHandlerResult handlerResult) {
        super(context, handlerResult);
    }

    @Override
    public boolean doMatch() {
        return this.thirdAppsService.isNeedThirdAppHandle(this.context.getRequestWrapper());
    }

    @Override
    protected void doHandle() throws Exception {
        this.validCookieForThirdAuth();
    }

    private void validCookieForThirdAuth() throws Exception {
        Map sessionInfo;
        String accountIdParameter = this.context.getRequestWrapper().getParameter("accountId");
        SessionDAO sessionDAO = null;
        if (StringUtils.isNotEmpty((CharSequence)accountIdParameter) && !accountIdParameter.equals((sessionInfo = (sessionDAO = SessionDAOFactory.getSessionDAO((String)this.getClientSession())).getAttributesAsMap(new String[]{"tenantId", "sandboxId", "language", "userId", "userName", "userOpenId", "orgId", "userType", "yzjAppId", "yzjAppTicket", "accountId", "uid", "loginOrg", "client"})).get("accountId"))) {
            this.doFail("request account is change");
            return;
        }
        String oldUserId = LoginUtils.getUserIdFromSession(sessionDAO, this.getClientSession());
        if (StringUtils.isNotEmpty((CharSequence)oldUserId)) {
            Map<String, String> userInfo = this.thirdAppsService.getThirdAppUserInfo(this.context.getRequestWrapper());
            if (userInfo != null && !oldUserId.equals(userInfo.get(userInfo.get("fid")))) {
                this.handlerResult.setLoginUser(userInfo);
                this.doFail("request user is change");
                return;
            }
            this.doSuccess(this.getClientSession());
        }
    }
}

