/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.handler.requestcontext;

import java.io.IOException;
import java.util.HashMap;
import java.util.Optional;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import kd.bos.actiondispatcher.ActionUtil;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.api.model.Account;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.CacheLoginData;
import kd.bos.login.LoginClientEnum;
import kd.bos.login.LoginType;
import kd.bos.login.actions.ApiInterfaceAction;
import kd.bos.login.handler.LoginHandlerContext;
import kd.bos.login.handler.requestcontext.IRequestContextManager;
import kd.bos.login.lang.LoginLangUtils;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.SecurityUtils;
import kd.bos.login.utils.SessionUtils;
import kd.bos.login.utils.account.LoginAccountFactory;
import kd.bos.login.yunzhijia.lightapp.LingappVerifier;
import kd.bos.session.SessionInfo;
import kd.bos.session.SessionManager;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.util.JSONUtils;
import kd.bos.util.RevProxyUtil;
import org.apache.commons.lang3.StringUtils;

public class RequestContextManager
implements IRequestContextManager {
    private static Log logger = LogFactory.getLog(RequestContextManager.class);
    private LoginHandlerContext context;

    public RequestContextManager(LoginHandlerContext context) {
        this.context = context;
    }

    @Override
    public void createRequestContext(String sessionId, boolean isGuest) throws Exception {
        Optional<SessionInfo> sessionInfo = this.convertToSessionInfo(sessionId, isGuest);
        if (!sessionInfo.isPresent()) {
            return;
        }
        RequestContextCreator.create((HttpServletRequest)this.context.getRequestWrapper(), (String)sessionId, (SessionInfo)sessionInfo.get());
        if (this.context.isDownloadPlugin()) {
            ApiInterfaceAction.getDetailByPath(this.context.getRequestWrapper(), this.context.getResponseWrapper());
            return;
        }
        boolean isHideTicket = this.hideTicket(sessionInfo.get().getAccountId());
        if (isHideTicket) {
            return;
        }
        if (LoginUtils.isPortal(this.context.getRequestWrapper())) {
            LoginUtils.outputPortalString(this.context.getRequestWrapper(), this.context.getResponseWrapper());
        }
        if (LoginUtils.isIndexHTML(this.context.getRequestWrapper())) {
            LoginUtils.outputString(this.context.getResponseWrapper(), LoginUtils.getIndexHtml(this.context.getRequestWrapper()));
        } else if (this.context.getRequestURI().contains("/nocode.html") || this.context.getRequestURI().contains("/nocodedebug.html")) {
            LoginUtils.outputString(this.context.getResponseWrapper(), LoginUtils.getNoceIndexHtml(this.context.getRequestWrapper()));
        } else if (!LoginUtils.isHandledUrlMap(this.context.getRequestWrapper(), this.context.getResponseWrapper())) {
            this.context.doFilter();
        }
    }

    @Override
    public void createGuestRequestContext(String sessionId) throws Exception {
        SessionInfo si = this.getGuestSessionData(this.context.getRequestWrapper());
        if (!LoginUtils.isGuestSessionId(sessionId)) {
            sessionId = LoginUtils.getGuestGloalSessionId(this.context.getRequestWrapper(), this.context.getResponseWrapper(), this.context.isAPI());
        }
        RequestContextCreator.create((HttpServletRequest)this.context.getRequestWrapper(), (String)sessionId, (SessionInfo)si);
        if (LoginUtils.isIndexHTML(this.context.getRequestWrapper())) {
            LoginUtils.outputString(this.context.getResponseWrapper(), LoginUtils.getIndexHtml(this.context.getRequestWrapper()));
        } else if (!LoginUtils.isHandledUrlMap(this.context.getRequestWrapper(), this.context.getResponseWrapper())) {
            this.context.doFilter();
        }
    }

    private SessionInfo getGuestSessionData(HttpServletRequest request) {
        SessionInfo si = new SessionInfo();
        String tenantId = RevProxyUtil.getTenantCode((HttpServletRequest)request);
        si.setTenantId(tenantId);
        si.setSandboxId(null);
        si.setUserId("-1");
        si.setUserName("Guest");
        si.setUserOpenId("");
        si.setUserType("1");
        si.setYzjAppId("");
        si.setYzjAppTicket("");
        si.setLanguage(LoginLangUtils.getLoginLanguage(request).toString());
        si.setUid("-1");
        Account currentCenter = LoginAccountFactory.createInstanceByHttpRequest(request, Optional.empty()).getAccount();
        si.setAccountId(currentCenter.getAccountId());
        String loginType = request.getParameter("logintype");
        String lType = LoginClientEnum.WEB.getDesc();
        if ("mobile".equalsIgnoreCase(loginType)) {
            lType = LoginClientEnum.MOBILE.getDesc();
        }
        si.setClient(lType);
        si.setLoginOrg("0");
        return si;
    }

    private Optional<SessionInfo> convertToSessionInfo(String sessionId, boolean isGuest) throws Exception {
        boolean security;
        SessionInfo sessionInfo = SessionUtils.getSessinInfoBySessionId(sessionId);
        boolean valid = this.checkSessionValid(sessionInfo);
        if (!valid) {
            return Optional.empty();
        }
        if (LoginType.MOBILE == this.context.getLoginType()) {
            if (this.context.getAppId() != null && !this.context.getAppId().equals(sessionInfo.getYzjAppId())) {
                SessionManager.editSessionValue((String)sessionId, (String)"yzjAppId", (String)this.context.getAppId());
                sessionInfo.setYzjAppId(this.context.getAppId());
            }
            if (this.context.getCloudTicket() != null && !this.context.getCloudTicket().equals(sessionInfo.getYzjAppTicket())) {
                SessionManager.editSessionValue((String)sessionId, (String)"yzjAppTicket", (String)this.context.getCloudTicket());
                sessionInfo.setYzjAppTicket(this.context.getCloudTicket());
            }
        }
        if (LoginUtils.isNeedAddOperation(this.context.getRequestWrapper())) {
            sessionInfo.setOperationType("MA");
        }
        if (!(security = this.checkSecurity(isGuest, sessionInfo.getUserId(), sessionInfo.getKdCsrfToken(), sessionInfo.getLoginIP()))) {
            return Optional.empty();
        }
        if (!this.checkAppPermission(sessionInfo)) {
            return Optional.empty();
        }
        return Optional.of(sessionInfo);
    }

    private boolean checkAppPermission(SessionInfo sessionInfo) {
        String appNumber = this.context.getRequestWrapper().getParameter("appNumber");
        return !StringUtils.isNotBlank((CharSequence)appNumber) || !"true".equalsIgnoreCase(SystemPropertyUtils.getProptyByTenant((String)"login_app_number_enable", (String)sessionInfo.getTenantId())) || !LingappVerifier.verifyAll(this.context.getRequestWrapper(), this.context.getResponseWrapper(), sessionInfo.getYzjAppId(), sessionInfo.getYzjAppTicket(), sessionInfo.getAccountId(), sessionInfo.getSandboxId(), sessionInfo.getUserOpenId());
    }

    private boolean checkSessionValid(SessionInfo sessionInfo) throws Exception {
        if (sessionInfo.getTenantId() == null || sessionInfo.getUserId() == null) {
            if (this.context.isAjax()) {
                this.outputAjaxSessionError((ServletResponse)this.context.getResponseWrapper());
            } else if (this.context.isAPI()) {
                this.outputAPISessionErroror((ServletResponse)this.context.getResponseWrapper());
            } else if (this.context.isWebService()) {
                this.outputWebServiceSessionErroror((ServletResponse)this.context.getResponseWrapper());
            }
            return false;
        }
        String reqTenantNo = RevProxyUtil.getTenantCode((HttpServletRequest)this.context.getRequestWrapper());
        if (!reqTenantNo.equalsIgnoreCase(sessionInfo.getTenantId())) {
            throw new Exception(ResManager.loadKDString((String)"\u975e\u6cd5\u8bbf\u95ee\uff0cCSRF\u653b\u51fb\u3002", (String)"LoginFilter_21", (String)"bos-login", (Object[])new Object[0]));
        }
        return true;
    }

    private void outputAjaxSessionError(ServletResponse servletResponse) throws IOException {
        HashMap<String, Object> mpErr = new HashMap<String, Object>();
        mpErr.put("success", false);
        mpErr.put("error_code", 100);
        mpErr.put("error_desc", ResManager.loadKDString((String)"Ajax session\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002 ", (String)"LoginFilter_14", (String)"bos-login", (Object[])new Object[0]));
        String sLoginJson = JSONUtils.toString(mpErr);
        ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)sLoginJson);
    }

    private void outputAPISessionErroror(ServletResponse servletResponse) throws IOException {
        HashMap<String, Object> mpErr = new HashMap<String, Object>();
        mpErr.put("success", false);
        mpErr.put("error_code", 1);
        mpErr.put("error_desc", ResManager.loadKDString((String)"session\u6570\u636e\u4e0d\u6b63\u786e\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002 ", (String)"LoginFilter_5", (String)"bos-login", (Object[])new Object[0]));
        String sLoginJson = JSONUtils.toString(mpErr);
        ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)sLoginJson);
    }

    private void outputWebServiceSessionErroror(ServletResponse servletResponse) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">");
        sb.append("    <soap:Body>");
        sb.append("        <soap:Fault>");
        sb.append("            <faultcode>soap:Server</faultcode>");
        sb.append("            <faultstring>%s</faultstring>");
        sb.append("        </soap:Fault>");
        sb.append("    </soap:Body>");
        sb.append("</soap:Envelope>");
        ActionUtil.writeResponseXml((ServletResponse)servletResponse, (CharSequence)String.format(sb.toString(), ResManager.loadKDString((String)"webService\u6ca1\u6709\u8bbf\u95ee\u6743\u9650\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\u3002", (String)"LoginFilter_20", (String)"bos-login", (Object[])new Object[0])));
    }

    private boolean checkSecurity(boolean isGuest, String userId, String csrfToken, String loginIP) throws IOException {
        boolean needCheck = this.isNeedCheck(this.context.isWebService(), this.context.isAPI(), isGuest, userId);
        if (needCheck && !LoginUtils.chekCSRF(this.context.getRequestWrapper(), csrfToken)) {
            SecurityUtils.checkCsrf(this.context.getRequestWrapper(), this.context.getResponseWrapper(), ResManager.loadKDString((String)"\u7cfb\u7edf\u68c0\u6d4b\u5230CSRF\u653b\u51fb\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\u7cfb\u7edf\u3002", (String)"LoginFilter_31", (String)"bos-login", (Object[])new Object[0]));
            return false;
        }
        if (needCheck && !this.context.isWebService() && !LoginUtils.chekIP(this.context.getRequestWrapper(), loginIP)) {
            SecurityUtils.checkCsrf(this.context.getRequestWrapper(), this.context.getResponseWrapper(), ResManager.loadKDString((String)"\u7cfb\u7edf\u68c0\u6d4b\u5230\u60a8\u7684IP\u5730\u5740\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\u7cfb\u7edf\u3002", (String)"LoginFilter_30", (String)"bos-login", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean isNeedCheck(boolean isWebService, boolean bAPI, boolean needGuest, String userId) {
        return !"-1".equals(userId) && !bAPI && !isWebService && !needGuest;
    }

    private boolean hideTicket(String accountId) {
        String ticket = this.context.getRequestWrapper().getParameter("ticket");
        if (StringUtils.isBlank((CharSequence)ticket)) {
            return false;
        }
        boolean isHideTicket = false;
        try {
            String queryS = this.context.getRequestWrapper().getQueryString();
            String path = this.context.getRequestURI();
            String ticketCache = CacheLoginData.getAttribute((String)accountId, (String)ticket);
            if (StringUtils.isBlank((CharSequence)ticketCache)) {
                return false;
            }
            isHideTicket = true;
            queryS = queryS.replace("ticket=", "").replace(ticket, "");
            StringBuilder builder = new StringBuilder(RevProxyUtil.getURLContextPath((HttpServletRequest)this.context.getRequestWrapper()));
            if (path.contains("/mobile.html")) {
                builder.append("mobile.html");
            } else if (path.contains("/index.html")) {
                builder.append("index.html");
            } else if (path.contains("/integration/yzjShareOpen.do")) {
                builder.append("integration/yzjShareOpen.do");
            } else {
                isHideTicket = false;
            }
            if (isHideTicket) {
                builder.append("?").append(queryS);
                this.context.getResponseWrapper().sendRedirect(builder.toString());
            }
        }
        catch (Exception e) {
            logger.info(e.getMessage());
        }
        return isHideTicket;
    }
}

