/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.http;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.StreamUtils;

public class KDSignHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private byte[] body;
    private AtomicBoolean isFirst = new AtomicBoolean(true);

    public KDSignHttpServletRequestWrapper(HttpServletRequest request) {
        super(request);
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.isFirst.get()) {
            if (this.isMultipart()) {
                return super.getInputStream();
            }
            this.isFirst.set(false);
            this.body = StreamUtils.readBytes(super.getInputStream());
        }
        return new KDSignServletInputStream(this.body);
    }

    private boolean isMultipart() {
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        return "post".equalsIgnoreCase(request.getMethod()) && LoginUtils.isMultipart(request);
    }

    public void setBody(byte[] body) {
        this.isFirst.set(false);
        this.body = body;
    }

    class KDSignServletInputStream
    extends ServletInputStream {
        private InputStream sourceStream;
        private boolean finished = false;

        public KDSignServletInputStream(byte[] bytes) {
            this.sourceStream = new ByteArrayInputStream(bytes);
        }

        public boolean isFinished() {
            return this.finished;
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener readListener) {
            throw new UnsupportedOperationException();
        }

        public int read() throws IOException {
            int data = this.sourceStream.read();
            if (data == -1) {
                this.finished = true;
            }
            return data;
        }

        public int available() throws IOException {
            return this.sourceStream.available();
        }

        public void close() throws IOException {
            super.close();
            this.sourceStream.close();
        }
    }
}

