/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.install;

import java.io.File;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import kd.bos.dc.api.model.DBInstance;
import kd.bos.dc.utils.MCDBUtil;
import kd.bos.encrypt.Encrypters;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.exception.LoginErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.emun.MCDBType;
import kd.bos.login.user.DefaultParameterService;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.MCUtils;
import kd.bos.login.utils.SecurityUtils;
import kd.bos.login.utils.ZKUtils;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.StringUtils;
import kd.bos.zk.ZKFactory;
import org.apache.commons.lang.time.DateFormatUtils;

public class MCInstall {
    private static final String COSMIC = "cosmic";
    private static final String MC_PORT = "MC_PORT";
    private static final String CURRENT_DIR = "CURRENT_DIR";
    private static final String CONFIG_COMMON_PROP = "/config/common/prop/";
    private static final String FILE_S = "file://%s";
    private static final String DATA_CENTER_CONFIG_ERROR = "The data center database parameters are incorrectly set. Contact the system administrator to check the data.";
    private static final String UNLOAD_DB_DRIVER = "Unable to load DBDriver";
    private static final String DATABASE_CONFIG_OR_TABLE_ERROR = "The database configuration or table structure is incorrect. Contact your system administrator.";
    private static final String PATTERN_D_HH_MM_SS_THREAD_LEVEL_LOGGER_M_L_M_N_PATTERN = "            <pattern>%d{HH:mm:ss} [%thread] %level %logger.%M\\(%L\\):%m%n</pattern>";
    private static final String APPENDER = "    </appender>";
    private static final String APPEND_LOGGER = "    </logger>";
    private static final String APPENDER_REF_REF_STDOT = "        <appender-ref ref=\"stdot\" />";
    private static final Log logger = LogFactory.getLog(MCInstall.class);
    static String fid = "619413166509558784";

    private static String getEnv(String key) {
        String returnValue = System.getenv(key);
        if (StringUtils.isEmpty((String)returnValue)) {
            returnValue = System.getProperty(key);
        }
        return returnValue;
    }

    public static void executeUpdatingLogic() {
        try {
            String mcTenant;
            String mcDB;
            String cqDB = "hq_cosmic_sys";
            String zkUrl = MCInstall.getZKUrl();
            String dbPort = MCInstall.getEnv("DB_PORT");
            String dbPassword = DefaultParameterService.getDefaultValueByKey("cosmic_sys_dbPassword", "1");
            String dbInsatnce = mcDB = COSMIC;
            String dbUser = DefaultParameterService.getDefaultValueByKey("cosmic_sys_dbUser", "1");
            String dbHost = "127.0.0.1";
            String dbType = "2";
            DBInstance mcDBInstance = new DBInstance();
            mcDBInstance.setDbuser(dbUser);
            mcDBInstance.setDbpassword(dbPassword);
            mcDBInstance.setDbip(dbHost);
            mcDBInstance.setDbport(dbPort);
            mcDBInstance.setDbtype(dbType);
            mcDBInstance.setDBInsatnce(dbInsatnce);
            MCInstall.setMCDBSetting(zkUrl, dbInsatnce, mcDBInstance);
            DBInstance cqDBInstance = new DBInstance();
            cqDBInstance.setDbuser(dbUser);
            cqDBInstance.setDbpassword(dbPassword);
            cqDBInstance.setDbip(dbHost);
            cqDBInstance.setDbport(dbPort);
            cqDBInstance.setDbtype(dbType);
            cqDBInstance.setDBInsatnce(cqDB);
            String cqTenant = "cosmic-simple";
            String cosimicClusterName = MCInstall.getCosmicClusterName();
            MCInstall.setCQDBString(zkUrl, cqDBInstance, cqTenant, cosimicClusterName);
            MCInstall.setDomainConext(zkUrl, cosimicClusterName);
            String idKey = "IDService.store.zookeeper";
            String idZKKey = "/config/common/var/";
            MCInstall.setCQKeyValue(idKey, idZKKey, MCInstall.getZKUrl());
            String mcClusterName = mcTenant = MCInstall.getMCTenantClustername();
            MCInstall.setMCKeyValue(idKey, idZKKey, MCInstall.getZKUrl());
            String idSKey = "IDService.properties";
            String idSZKKey = CONFIG_COMMON_PROP;
            StringBuilder sb = new StringBuilder();
            sb.append("IDService.store.path=/{{clusterName}}/runtime/{{appName}}/idService/store\n");
            sb.append("IDService.store.zookeeper=" + MCInstall.getZKUrl() + "\n");
            sb.append("IDService.worker=2");
            MCInstall.setCQKeyValue(idSKey, idSZKKey, sb.toString());
            MCInstall.setMCKeyValue(idSKey, idSZKKey, sb.toString());
            String sId = "Schedule.zk.server.ip_port";
            String sIdKey = "/config/common/var/";
            String zkValue = MCInstall.getZKUrl().replace("127.0.0.1", dbHost);
            MCInstall.setCQKeyValue(sId, sIdKey, zkValue);
            Properties mcProperties = MCInstall.getPropertiesByDBInstance(mcDBInstance);
            Connection conn = MCDBUtil.getConnection((Properties)mcProperties);
            MCInstall.saveCommonConfValue(conn, new Long("625985344449282082"), zkValue);
            String currentDir = MCInstall.getCurrentDir();
            String cqSeriveUrl = String.format("%s:%s", dbHost, MCInstall.getCosmicPort());
            MCInstall.saveCosmicEnvironmentInfo(mcDBInstance, currentDir, zkValue, cqSeriveUrl);
            MCInstall.saveWebDBLog(mcDBInstance);
            MCInstall.saveServiceDBLog(mcDBInstance);
            String webLogKey = MCInstall.getWebLogkey();
            MCInstall.setCQKeyValue(webLogKey, MCInstall.getWebLogString());
            MCInstall.setCQKeyValue(MCInstall.getServiceLogKey(), MCInstall.getServiceLogString());
            MCInstall.createDataSaveTable(mcDBInstance);
            System.exit(0);
        }
        catch (Exception e) {
            logger.info(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
    }

    private static String getCosmicClusterName() {
        return COSMIC;
    }

    private static void setCQKeyValue(String key, String zkKey, String value) throws Exception {
        String cqIDZKKey = MCInstall.getZKRootPath() + MCInstall.getCosmicClusterName() + zkKey + key;
        System.setProperty(key, value);
        String zkUrl = MCInstall.getZKUrl();
        ZKUtils.setZkData(zkUrl, cqIDZKKey, value);
        logger.info("cqIDZKKey=" + value);
    }

    private static void setCQKeyValue(String zkKey, String value) throws Exception {
        String cqIDZKKey = MCInstall.getZKRootPath() + MCInstall.getCosmicClusterName() + zkKey;
        String zkUrl = MCInstall.getZKUrl();
        ZKUtils.setZkData(zkUrl, cqIDZKKey, value);
        logger.info("cqIDZKKey=" + value);
    }

    private static void setMCKeyValue(String key, String zkKey, String value) throws Exception {
        String cqIDZKKey = MCInstall.getZKRootPath() + MCInstall.getMCTenantClustername() + zkKey + key;
        System.setProperty(key, value);
        String zkUrl = MCInstall.getZKUrl();
        ZKUtils.setZkData(zkUrl, cqIDZKKey, value);
    }

    private static void setDomainConext(String zkUrl, String cosimicClusterName) throws Exception {
        String domainKey = "domain.contextUrl";
        String domainZKKey = MCInstall.getZKRootPath() + cosimicClusterName + CONFIG_COMMON_PROP + domainKey;
        String cosmicPort = MCInstall.getCosmicPort();
        String domainValue = String.format("http://127.0.0.1:%s/ierp", cosmicPort);
        System.setProperty(domainZKKey, domainValue);
        ZKUtils.setZkData(zkUrl, domainZKKey, domainValue);
    }

    private static String getCosmicPort() {
        return MCInstall.getEnv("COSMIC_PORT");
    }

    private static String getCurrentDir() {
        String dir = MCInstall.getEnv(CURRENT_DIR);
        if (dir != null) {
            dir = dir.replaceAll("\"", "");
        }
        return dir;
    }

    private static void saveWebDBLog(DBInstance mcDBInstance) {
        String sql = String.format("update t_mc_commonconf set fvalue='%s' where fid=612946159022900227", MCInstall.getWebLogString());
        Properties mcProperties = MCInstall.getPropertiesByDBInstance(mcDBInstance);
        MCInstall.exeSQl(sql, mcProperties);
    }

    private static void createDataSaveTable(DBInstance mcDBInstance) {
        Properties mcProperties;
        String sql;
        try {
            sql = String.format("DROP TABLE IF EXISTS t_mc_datasave", new Object[0]);
            mcProperties = MCInstall.getPropertiesByDBInstance(mcDBInstance);
            MCInstall.exeSQl(sql, mcProperties);
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        try {
            sql = MCInstall.getCreateDataSaveTableString();
            mcProperties = MCInstall.getPropertiesByDBInstance(mcDBInstance);
            MCInstall.exeSQl(sql, mcProperties);
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
    }

    private static String getCreateDataSaveTableString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE t_mc_datasave  (");
        sb.append("  FID bigint(20) NOT NULL,");
        sb.append("  fkey varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT ' ',");
        sb.append("  fvalue varchar(2000) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT ' ',");
        sb.append("  fdcid varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT ' ',");
        sb.append("  fvalue_tag varchar(2000) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,");
        sb.append("  PRIMARY KEY (FID) USING BTREE");
        sb.append(") ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;");
        return sb.toString();
    }

    private static void saveServiceDBLog(DBInstance mcDBInstance) {
        String sql = String.format("update t_mc_commonconf set fvalue='%s' where fid=612923093110752256", MCInstall.getServiceLogString());
        Properties mcProperties = MCInstall.getPropertiesByDBInstance(mcDBInstance);
        MCInstall.exeSQl(sql, mcProperties);
    }

    private static void saveCosmicEnvironmentInfo(DBInstance mcDBInstance, String currentDir, String zkUrl, String serviceUrl) {
        String staticPath = String.format(FILE_S + File.separator + "static-file-service", currentDir);
        String cqAppstoteUrl = String.format(FILE_S + File.separator + "apppackage-cosmic", currentDir);
        String sql = String.format("update  t_mc_environment  set fstatic_rs_path='%s',fappstoremachineid=%s,fstatic_rs_machineid=%s ,fpath='%s',furl='%s' ,fzkurl='%s',fserviceurl='%s' where fid=678095010368848896", staticPath, fid, fid, cqAppstoteUrl, cqAppstoteUrl, zkUrl, serviceUrl);
        sql = sql.replaceAll("\\\\", "\\\\\\\\");
        Properties mcProperties = MCInstall.getPropertiesByDBInstance(mcDBInstance);
        MCInstall.exeSQl(sql, mcProperties);
    }

    private static void setMCDBSetting(String zkUrl, String dbInsatnce, DBInstance db) {
        String mcTenant;
        String mcClusterName = mcTenant = MCInstall.getMCTenantClustername();
        MCDBType mysql = MCDBType.MYSQL;
        String data = MCUtils.getTenantData(mysql.getType(), mysql.getType4Login(), db.getDbip(), Integer.parseInt(db.getDbport()), db.getDbuser(), Encrypters.encode((String)db.getDbpassword()), db.getDBInsatnce());
        String dbKey = String.format("mc.tenant.%s.data", mcTenant);
        String dbZKKey = MCInstall.getZKRootPath() + mcClusterName + CONFIG_COMMON_PROP + dbKey;
        System.setProperty(dbKey, data);
        System.setProperty("mc.type", "ZK");
        Properties mcProperties = MCInstall.getPropertiesByDBInstance(db);
        MCInstall.saveDBData(db.getDbport(), db.getDbpassword(), db.getDbtype(), db.getDbuser(), db.getDbip(), db.getDBInsatnce(), mcProperties);
        MCInstall.saveConfData("dbname", dbInsatnce, mcProperties);
        MCInstall.saveConfData("dbconnection", "1", mcProperties);
        MCInstall.gernerateMachine(db, mcProperties, fid);
        MCInstall.saveConfData("mcserviceurl", "http://" + db.getDbip() + ":" + MCInstall.getEnv(MC_PORT), mcProperties);
        MCInstall.saveConfData("attachmenthttpport", "8100", mcProperties);
        MCInstall.saveConfData("attachmentip", db.getDbip(), mcProperties);
        MCInstall.saveConfData("attachmenttcpport", "8765", mcProperties);
        MCInstall.saveConfData("attachmenturl", db.getDbip() + ":" + 8100, mcProperties);
        String currentDir = MCInstall.getCurrentDir();
        String mcAppstoteUrl = String.format(FILE_S + File.separator + "apppackage", currentDir);
        String staticPath = String.format(FILE_S + File.separator + "static-mc-service", currentDir);
        MCInstall.saveConfData("mcappstoremachine", fid, mcProperties);
        MCInstall.saveConfData("mcappstorepath", mcAppstoteUrl, mcProperties);
        MCInstall.saveConfData("mcstaticresourcemachine", fid, mcProperties);
        MCInstall.saveConfData("mcstaticresourcepath", staticPath, mcProperties);
        String patchStore = String.format(FILE_S + File.separator + "patchwarehouse", currentDir);
        MCInstall.saveConfData("patchwarehouseurl", patchStore, mcProperties);
        MCInstall.saveConfData("patchwarehousepath", patchStore, mcProperties);
        MCInstall.saveConfData("patchwarehousemachine", fid, mcProperties);
        ZKUtils.setZkData(zkUrl, dbZKKey, data);
    }

    private static String getMCTenantClustername() {
        return "new-mc";
    }

    private static void gernerateMachine(DBInstance mcDBInstance, Properties mcProperties, String fid) {
        String delSql = "delete from `t_mc_machine` where fid=" + fid;
        MCInstall.exeSQl(delSql, mcProperties);
        delSql = "delete from t_mc_machine_l where fid=" + fid;
        MCInstall.exeSQl(delSql, mcProperties);
        String sql = "INSERT INTO `t_mc_machine`(`FID`, `fnumber`, `fstatus`, `fcreatorid`, `fmodifierid`, `fenable`, `fcreatetime`, `fmodifytime`, `fmasterid`, `fip`, `fport`, `floginuser`, `floginpassword`) VALUES (619413166509558784, ' ', 'C', 14065, 13648, '1', '%s', '%s', 619413166509558784, '%s', 22, 'james', '')";
        String now = DateFormatUtils.format((java.util.Date)new java.util.Date(), (String)"yyyy-MM-dd HH:mm:ss");
        sql = String.format(sql, now, now, mcDBInstance.getDbip());
        MCInstall.exeSQl(sql, mcProperties);
        sql = "INSERT INTO `t_mc_machine_l`(`FPKID`, `FID`, `FLocaleID`, `fname`) VALUES ('213124', 619413166509558784, 'zh_CN', ' ');";
        MCInstall.exeSQl(sql, mcProperties);
    }

    private static void setCQDBString(String zkUrl, DBInstance db, String cqTenant, String cosimicClusterName) throws Exception {
        String ip = db.getDbip();
        int port = Integer.parseInt(db.getDbport());
        MCDBType mysql = MCDBType.MYSQL;
        String dbCenter = MCUtils.getTenantData(mysql.getType(), mysql.getType4Login(), ip + ":" + port, db.getDbip(), Integer.parseInt(db.getDbport()), db.getDbuser(), Encrypters.encode((String)db.getDbpassword()), db.getDBInsatnce(), 679008189806542848L, StringUtils.getEmpty()).replaceAll("", "");
        String dbKey = String.format("mc.tenant.%s.data", cqTenant);
        String dbZKKey = MCInstall.getZKRootPath() + cosimicClusterName + CONFIG_COMMON_PROP + dbKey;
        System.setProperty(dbKey, dbCenter);
        System.setProperty("mc.type", "ZK");
        ZKUtils.setZkData(zkUrl, dbZKKey, dbCenter);
    }

    public static Properties getPropertiesByDBInstance(DBInstance instance) {
        if (instance != null && !StringUtils.isEmpty((String)instance.getDbip())) {
            int dbType = Integer.parseInt(instance.getDbtype());
            String user = instance.getDbuser();
            String ip = instance.getDbip();
            String password = instance.getDbpassword();
            String port = instance.getDbport();
            String dbInstance = instance.getDBInsatnce();
            String driver = "";
            String url = "";
            if (dbType == 0) {
                driver = "oracle.jdbc.driver.OracleDriver";
                url = "jdbc:oracle:thin:@" + ip + ":" + port + ":" + dbInstance;
            } else if (dbType == 2) {
                boolean mairaDB = Boolean.valueOf(System.getProperty("datasource.mariadb", "true"));
                if (mairaDB) {
                    driver = "org.mariadb.jdbc.Driver";
                    url = "jdbc:mariadb://" + ip + ":" + port + "/" + dbInstance;
                } else {
                    driver = "com.mysql.cj.jdbc.Driver";
                    url = "jdbc:mysql://" + ip + ":" + port + "/" + dbInstance;
                }
            } else {
                driver = "org.postgresql.Driver";
                url = "jdbc:postgresql://" + ip + ":" + port + "/" + dbInstance;
            }
            Properties dbProperties = MCInstall.putDBInfo(driver, url, user, password);
            return dbProperties;
        }
        throw new KDException(LoginErrorCode.loginBizException, new Object[]{"The data center database fails to be obtained. Contact the system administrator to check the data."});
    }

    private static Properties putDBInfo(String driver, String url, String user, String password) {
        Properties props = new Properties();
        props.setProperty("driverClassName", driver);
        props.setProperty("url", url);
        props.setProperty("username", user);
        props.setProperty("password", password);
        props.setProperty("user", user);
        props.setProperty("password", password);
        return props;
    }

    public static String getZKRootPath() {
        String url = MCInstall.getZKUrl();
        return ZKFactory.getZkRootPath((String)url);
    }

    public static String getZKUrl() {
        return MCInstall.getEnv("configUrl");
    }

    private static void saveConfValue(Connection conn, long fid, String confValue) throws SQLException {
        if (conn != null) {
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                String sql = "select fvalue from t_mc_selfconf where fid=?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setLong(1, fid);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    sql = "update t_mc_selfconf set fvalue=? where fid=?";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, confValue);
                    pstmt.setLong(2, fid);
                    pstmt.execute();
                } else {
                    sql = "insert into t_mc_selfconf(fid,fvalue)  values(?,?)";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setLong(1, fid);
                    pstmt.setString(2, confValue);
                    pstmt.execute();
                }
            }
            catch (SQLException var18) {
                throw var18;
            }
            finally {
                if (pstmt != null) {
                    try {
                        pstmt.close();
                    }
                    catch (Exception var17) {
                        logger.error((Throwable)var17);
                    }
                }
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception var16) {
                        logger.error((Throwable)var16);
                    }
                }
            }
        }
    }

    private static void saveCommonConfValue(Connection conn, long fid, String confValue) throws SQLException {
        if (conn != null) {
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                String sql = "select fvalue from t_mc_commonconf where fid=?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setLong(1, fid);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    sql = "update t_mc_commonconf set fvalue=? where fid=?";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, confValue);
                    pstmt.setLong(2, fid);
                    pstmt.execute();
                } else {
                    sql = "insert into t_mc_commonconf(fid,fvalue)  values(?,?)";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setLong(1, fid);
                    pstmt.setString(2, confValue);
                    pstmt.execute();
                }
            }
            catch (SQLException var18) {
                throw var18;
            }
            finally {
                if (pstmt != null) {
                    try {
                        pstmt.close();
                    }
                    catch (Exception var17) {
                        logger.error((Throwable)var17);
                    }
                }
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception var16) {
                        logger.error((Throwable)var16);
                    }
                }
            }
        }
    }

    public static void saveConfData(String confName, String confValue, Properties dataBaseProperties) {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = "";
        try {
            if (dataBaseProperties == null) {
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{DATA_CENTER_CONFIG_ERROR});
            }
            conn = MCDBUtil.getConnection((Properties)dataBaseProperties);
            long fid = MCInstall.getFidByKey(conn, confName);
            if (fid != 0L) {
                MCInstall.saveConfValue(conn, fid, confValue);
            } else {
                fid = Long.parseLong(StringUtils.randomNumber((int)15));
                sql = "INSERT INTO t_mc_selfconf(FID, fvalue) VALUES (?, ?)";
                pstmt = conn.prepareStatement(sql);
                pstmt.setLong(1, fid);
                pstmt.setString(2, confValue);
                pstmt.execute();
                sql = "INSERT INTO t_mc_selfconf_l(FPKID, FID, FLocaleID, fkey) VALUES (?, ?, 'zh_CN', ?)";
                String pkId = StringUtils.randomWord((int)12);
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, pkId);
                pstmt.setLong(2, fid);
                pstmt.setString(3, confName);
                pstmt.execute();
            }
        }
        catch (ClassNotFoundException var17) {
            throw new KDException((Throwable)var17, BosErrorCode.cannotLoadBeanClass, new Object[]{UNLOAD_DB_DRIVER});
        }
        catch (SQLException var18) {
            throw new KDException((Throwable)var18, BosErrorCode.sQLConnection, new Object[]{DATABASE_CONFIG_OR_TABLE_ERROR + LoginUtils.SPLIT_SIGN + ExceptionUtils.getExceptionStackTraceMessage((Exception)var18)});
        }
        catch (Exception var19) {
            throw new KDException((Throwable)var19, BosErrorCode.sQLConnection, new Object[]{DATABASE_CONFIG_OR_TABLE_ERROR + LoginUtils.SPLIT_SIGN + ExceptionUtils.getExceptionStackTraceMessage((Exception)var19)});
        }
        finally {
            MCInstall.cleanup(rs, pstmt, conn);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void saveDBData(String dbPort, String dbPassword, String dbType, String dbUser, String dbHost, String dbInsatnce, Properties dataBaseProperties) {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        boolean Succeed = false;
        try {
            if (dataBaseProperties == null) {
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{DATA_CENTER_CONFIG_ERROR});
            }
            conn = MCDBUtil.getConnection((Properties)dataBaseProperties);
            conn.setAutoCommit(false);
            String sql = "select * from t_mc_dbconnection where fid=1";
            pstmt = conn.prepareStatement(sql);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                sql = "UPDATE t_mc_dbconnection SET  fstatus = 'C', fcreatorid = 13648, fmodifierid = 14065, fenable = '1',  fmodifytime = ?, fmasterid = 603561364304233472, fip = ?, fpassword = ?, fusername = ?, fdbtype =?, fport = ?, fconnectstatus = '1',  finstancename = ' ', finstancename_enp = NULL WHERE FID = 1; ";
                pstmt = conn.prepareStatement(sql);
                pstmt.setDate(1, new Date(System.currentTimeMillis()));
                pstmt.setString(2, dbHost);
                pstmt.setString(3, Encrypters.encode((String)dbPassword));
                pstmt.setString(4, dbUser);
                pstmt.setString(5, MCInstall.getDBType(dbType));
                pstmt.setInt(6, Integer.parseInt(dbPort));
                pstmt.execute();
            } else {
                sql = "INSERT INTO t_mc_dbconnection(FID, fnumber, fstatus, fcreatorid, fmodifierid, fenable, fcreatetime, fmodifytime, fmasterid, fip, fpassword, fusername, fdbtype, fport, fconnectstatus, finstancename, finstancename_enp) VALUES (1, 'mc_DB', 'C', 13648, 14065, '1', ?, ?, 1, ?, ?, ?, ?, ?, '1',  ' ', NULL);";
                pstmt = conn.prepareStatement(sql);
                pstmt.setDate(1, new Date(System.currentTimeMillis()));
                pstmt.setDate(2, new Date(System.currentTimeMillis()));
                pstmt.setString(3, dbHost);
                pstmt.setString(4, Encrypters.encode((String)dbPassword));
                pstmt.setString(5, dbUser);
                pstmt.setString(6, MCInstall.getDBType(dbType));
                pstmt.setInt(7, Integer.parseInt(dbPort));
                pstmt.execute();
                sql = "INSERT INTO t_mc_dbconnection_l(FPKID, FID, FLocaleID,fname) VALUES (1, 1, 'zh_CN', 'mc_DB')";
                pstmt = conn.prepareStatement(sql);
                pstmt.execute();
            }
            conn.commit();
            Succeed = true;
        }
        catch (ClassNotFoundException var23) {
            try {
                throw new KDException((Throwable)var23, BosErrorCode.cannotLoadBeanClass, new Object[]{UNLOAD_DB_DRIVER});
                catch (SQLException var24) {
                    throw new KDException((Throwable)var24, BosErrorCode.sQLConnection, new Object[]{DATABASE_CONFIG_OR_TABLE_ERROR + LoginUtils.SPLIT_SIGN + ExceptionUtils.getExceptionStackTraceMessage((Exception)var24)});
                }
                catch (Exception var25) {
                    throw new KDException((Throwable)var25, BosErrorCode.sQLConnection, new Object[]{DATABASE_CONFIG_OR_TABLE_ERROR + LoginUtils.SPLIT_SIGN + ExceptionUtils.getExceptionStackTraceMessage((Exception)var25)});
                }
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null && !Succeed) {
                        conn.rollback();
                    }
                }
                catch (Exception var22) {
                    logger.error((Throwable)var22);
                }
                MCInstall.cleanup(rs, pstmt, conn);
                throw throwable;
            }
        }
        try {
            if (conn != null && !Succeed) {
                conn.rollback();
            }
        }
        catch (Exception var22) {
            logger.error((Throwable)var22);
        }
        MCInstall.cleanup(rs, pstmt, conn);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void exeSQl(String sql, Properties dataBaseProperties) {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        boolean Succeed = false;
        try {
            if (dataBaseProperties == null) {
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{DATA_CENTER_CONFIG_ERROR});
            }
            conn = MCDBUtil.getConnection((Properties)dataBaseProperties);
            conn.setAutoCommit(false);
            if (!StringUtils.isEmpty((String)sql) && !SecurityUtils.containsSqlInjection(sql)) {
                pstmt = conn.prepareStatement(sql);
                pstmt.execute();
                conn.commit();
                Succeed = true;
            } else {
                logger.info("exeSQl--containsSqlInjection:" + sql);
            }
        }
        catch (ClassNotFoundException var23) {
            try {
                throw new KDException((Throwable)var23, BosErrorCode.cannotLoadBeanClass, new Object[]{UNLOAD_DB_DRIVER});
                catch (SQLException var24) {
                    throw new KDException((Throwable)var24, BosErrorCode.sQLConnection, new Object[]{DATABASE_CONFIG_OR_TABLE_ERROR + LoginUtils.SPLIT_SIGN + ExceptionUtils.getExceptionStackTraceMessage((Exception)var24)});
                }
                catch (Exception var25) {
                    throw new KDException((Throwable)var25, BosErrorCode.sQLConnection, new Object[]{DATABASE_CONFIG_OR_TABLE_ERROR + LoginUtils.SPLIT_SIGN + ExceptionUtils.getExceptionStackTraceMessage((Exception)var25)});
                }
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null && !Succeed) {
                        conn.rollback();
                    }
                }
                catch (Exception var22) {
                    logger.error((Throwable)var22);
                }
                MCInstall.cleanup(rs, pstmt, conn);
                throw throwable;
            }
        }
        try {
            if (conn != null && !Succeed) {
                conn.rollback();
            }
        }
        catch (Exception var22) {
            logger.error((Throwable)var22);
        }
        MCInstall.cleanup(rs, pstmt, conn);
    }

    public static void cleanup(ResultSet rs, Statement stmt, Connection cn) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Exception var6) {
                MCInstall.logError(var6);
            }
            rs = null;
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Exception var5) {
                MCInstall.logError(var5);
            }
            stmt = null;
        }
        if (cn != null) {
            try {
                cn.close();
            }
            catch (Exception var4) {
                MCInstall.logError(var4);
            }
            cn = null;
        }
    }

    public static void logError(Exception e) {
        logger.info(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
    }

    private static String getDBType(String dbType) {
        String returnType = "mysql";
        if ("1".equals(dbType)) {
            returnType = "oracle";
        } else if ("2".equals(dbType)) {
            returnType = "mysql";
        }
        return returnType;
    }

    private static long getFidByKey(Connection conn, String confName) throws SQLException {
        long fid = 0L;
        if (conn != null) {
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                String sql = "select fid from t_mc_selfconf_l  where fkey=?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, confName);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    fid = rs.getLong("fid");
                }
            }
            catch (SQLException var18) {
                throw var18;
            }
            finally {
                if (pstmt != null) {
                    try {
                        pstmt.close();
                    }
                    catch (Exception var17) {
                        logger.error((Throwable)var17);
                    }
                }
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception var16) {
                        logger.error((Throwable)var16);
                    }
                }
            }
        }
        return fid;
    }

    private static String getServiceLogKey() {
        return "/config/mservice/prop/log.config";
    }

    private static String getServiceLogString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        sb.append("<!--30 seconds  scan=\"true\" scanPeriod=\"1 minutes\" -->");
        sb.append("<configuration>");
        sb.append("    <property name=\"LOG_HOME\" value=\"../logs\"/>");
        sb.append("");
        sb.append("    <appender name=\"metric\" class=\"kd.bos.metric.instruments.logback.MetricAppender\">");
        sb.append("   </appender>");
        sb.append("    <appender name=\"stdot\" class=\"ch.qos.logback.core.ConsoleAppender\">");
        sb.append("        <layout class=\"ch.qos.logback.classic.PatternLayout\">");
        sb.append(PATTERN_D_HH_MM_SS_THREAD_LEVEL_LOGGER_M_L_M_N_PATTERN);
        sb.append("        </layout>");
        sb.append(APPENDER);
        sb.append("");
        sb.append("");
        sb.append("    <appender name=\"kafka\" class=\"kd.bos.logging.console.slf4j.logback.KafkaAppender\">");
        sb.append("        <topic>{{clusterName}}-log</topic>");
        sb.append("        <brokerList>{{log.kafka.ip_port}}</brokerList>");
        sb.append("        <compressionType>none</compressionType>");
        sb.append("        <syncSend>false</syncSend>");
        sb.append("        <keySerializerClass>org.apache.kafka.common.serialization.StringSerializer</keySerializerClass>");
        sb.append("        <valueSerializerClass>org.apache.kafka.common.serialization.StringSerializer</valueSerializerClass>");
        sb.append(APPENDER);
        sb.append("");
        sb.append("");
        sb.append("    <appender name=\"file\" class=\"ch.qos.logback.core.rolling.RollingFileAppender\">");
        sb.append("        <rollingPolicy class=\"ch.qos.logback.core.rolling.TimeBasedRollingPolicy\">");
        sb.append("            <FileNamePattern>${LOG_HOME}/log.%d{yyyy-MM-dd}(%i).log</FileNamePattern>");
        sb.append("            <cleanHistoryOnStart>true</cleanHistoryOnStart>");
        sb.append("            <maxHistory>5</maxHistory>");
        sb.append("            <TimeBasedFileNamingAndTriggeringPolicy class=\"ch.qos.logback.core.rolling.SizeAndTimeBasedFNATP\">");
        sb.append("                <MaxFileSize>10MB</MaxFileSize>");
        sb.append("            </TimeBasedFileNamingAndTriggeringPolicy>");
        sb.append("        </rollingPolicy>");
        sb.append("        <encoder>");
        sb.append("            <charset>utf-8</charset>");
        sb.append(PATTERN_D_HH_MM_SS_THREAD_LEVEL_LOGGER_M_L_M_N_PATTERN);
        sb.append("        </encoder>");
        sb.append("        <append>false</append>");
        sb.append("        <prudent>false</prudent>");
        sb.append(APPENDER);
        sb.append("");
        sb.append("    <logger name=\"org.apache\" additivity=\"false\"  level=\"ERROR\">");
        sb.append(APPENDER_REF_REF_STDOT);
        sb.append(APPEND_LOGGER);
        sb.append("    <logger name=\"org.javaswift.joss.command.impl.core.AbstractCommand\" additivity=\"false\"  level=\"OFF\">");
        sb.append(APPENDER_REF_REF_STDOT);
        sb.append(APPEND_LOGGER);
        sb.append("    ");
        sb.append("   <logger name=\"kd.bos.dc.utils.AccountUtils\" additivity=\"false\"  level=\"ERROR\">");
        sb.append("        <appender-ref ref=\"kafka\" />");
        sb.append(APPEND_LOGGER);
        sb.append("");
        sb.append("");
        sb.append("    <root level=\"INFO\">");
        sb.append("");
        sb.append("        ");
        sb.append("        <appender-ref ref=\"file\" />");
        sb.append(APPENDER_REF_REF_STDOT);
        sb.append("");
        sb.append("    </root>");
        sb.append("");
        sb.append("</configuration>");
        return sb.toString();
    }

    private static String getWebLogkey() {
        return "/config/web/prop/log.config";
    }

    private static String getWebLogString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        sb.append("<!--30 seconds  scan=\"true\" scanPeriod=\"1 minutes\" -->");
        sb.append("<configuration>");
        sb.append("    <property name=\"LOG_HOME\" value=\"../logs\"/>");
        sb.append("");
        sb.append("    <appender name=\"metric\" class=\"kd.bos.metric.instruments.logback.MetricAppender\">");
        sb.append("   </appender>");
        sb.append("    <appender name=\"stdot\" class=\"ch.qos.logback.core.ConsoleAppender\">");
        sb.append("        <layout class=\"ch.qos.logback.classic.PatternLayout\">");
        sb.append(PATTERN_D_HH_MM_SS_THREAD_LEVEL_LOGGER_M_L_M_N_PATTERN);
        sb.append("        </layout>");
        sb.append(APPENDER);
        sb.append("");
        sb.append("    <appender name=\"kafka\" class=\"kd.bos.logging.console.slf4j.logback.KafkaAppender\">");
        sb.append("        <topic>{{clusterName}}-log</topic>");
        sb.append("        <brokerList>{{log.kafka.ip_port}}</brokerList>");
        sb.append("        <compressionType>none</compressionType>");
        sb.append("        <syncSend>false</syncSend>");
        sb.append("        <keySerializerClass>org.apache.kafka.common.serialization.StringSerializer</keySerializerClass>");
        sb.append("        <valueSerializerClass>org.apache.kafka.common.serialization.StringSerializer</valueSerializerClass>");
        sb.append(APPENDER);
        sb.append("");
        sb.append("    <appender name=\"file\" class=\"ch.qos.logback.core.rolling.RollingFileAppender\">");
        sb.append("        <rollingPolicy class=\"ch.qos.logback.core.rolling.TimeBasedRollingPolicy\">");
        sb.append("            <FileNamePattern>${LOG_HOME}/log.%d{yyyy-MM-dd}-(%i).log</FileNamePattern>");
        sb.append("            <cleanHistoryOnStart>true</cleanHistoryOnStart>");
        sb.append("            <maxHistory>5</maxHistory>");
        sb.append("            <TimeBasedFileNamingAndTriggeringPolicy class=\"ch.qos.logback.core.rolling.SizeAndTimeBasedFNATP\">");
        sb.append("                <MaxFileSize>10MB</MaxFileSize>");
        sb.append("            </TimeBasedFileNamingAndTriggeringPolicy>");
        sb.append("        </rollingPolicy>");
        sb.append("        <encoder>");
        sb.append("            <charset>utf-8</charset>");
        sb.append(PATTERN_D_HH_MM_SS_THREAD_LEVEL_LOGGER_M_L_M_N_PATTERN);
        sb.append("        </encoder>");
        sb.append("        <append>false</append>");
        sb.append("        <prudent>false</prudent>");
        sb.append(APPENDER);
        sb.append("<!--");
        sb.append("        <appender name=\"report\" class=\"kd.bos.logging.logback.report.ExceptionReportAppender\">");
        sb.append("        ");
        sb.append(APPENDER);
        sb.append("-->");
        sb.append("    <logger name=\"org.apache\" additivity=\"false\"  level=\"ERROR\">");
        sb.append(APPENDER_REF_REF_STDOT);
        sb.append(APPEND_LOGGER);
        sb.append("");
        sb.append("    <root level=\"INFO\">");
        sb.append("");
        sb.append("        <!--<appender-ref ref=\"file\" />-->");
        sb.append("        <appender-ref ref=\"file\" />");
        sb.append("\t\t <appender-ref ref=\"stdot\" />");
        sb.append("        <!--<appender-ref ref=\"report\" />-->");
        sb.append("");
        sb.append("    </root>");
        sb.append("");
        sb.append("</configuration>");
        return sb.toString();
    }
}

