/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.lang;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import kd.bos.lang.Lang;
import kd.bos.lang.LangHolder;
import kd.bos.login.lang.LangContext;
import kd.bos.login.lang.LoginLangHolder;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public final class LoginLangUtils {
    public static final String KEY_REQUEST_LANGUAGE = "language";

    @SdkInternal
    public static Lang getLoginLanguage(HttpServletRequest servletRequest) {
        String lang = servletRequest.getParameter(KEY_REQUEST_LANGUAGE);
        return LoginLangUtils.getLang(lang);
    }

    @SdkInternal
    public static Lang getLoginLanguage(Map<String, String> req) {
        String lang = req.get(KEY_REQUEST_LANGUAGE);
        return LoginLangUtils.getLang(lang);
    }

    @SdkInternal
    public static Lang getLang(String lang) {
        if ("en".equalsIgnoreCase(lang) || "en_US".equalsIgnoreCase(lang)) {
            return Lang.en_US;
        }
        return Lang.from((String)lang);
    }

    private LoginLangUtils() {
    }

    public static void setLang(Lang lang) {
        if (lang != null) {
            LangContext.setLang(lang);
        }
        Lang.setHolder((LangHolder)new LoginLangHolder());
    }

    @SdkInternal
    public static Lang getLang() {
        Lang lang = LangContext.getLang();
        if (lang == null) {
            lang = LangContext.getDefaultLang();
        }
        if (lang == null) {
            lang = Lang.defaultLang();
        }
        return lang;
    }
}

