/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.mc.model;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.encrypt.Encrypters;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.emun.MCDBType;
import kd.bos.login.mc.ProcessHelper;
import kd.bos.login.mc.exception.MCInitException;
import kd.bos.login.mc.service.MCService;
import kd.bos.login.utils.DBUtils;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.StringUtils;

public class Database {
    private MCDBType type;
    private String host;
    private int port;
    private String urls;
    private String originUrls;
    private String username;
    private String psd;
    private String instance;
    private Connection connection;
    private JSONObject cache;
    private boolean isTestConnection = false;
    private boolean isNeedCreateDB = false;
    private boolean isNeedCreateTB = false;
    private static final String KEY_TYPE = "dbtype";
    private static final String KEY_HOST = "dbhost";
    private static final String KEY_PORT = "dbport";
    private static final String KEY_INSTANCE = "dbinstance";
    private static final String KEY_USERNAME = "dbuser";
    private static final String KEY_PWD = "dbpassword";
    private static final String KEY_DATABASE = "doDatabase";
    private static final String KEY_NEED_CREATE_DB = "needCreateDB";
    private static final String KEY_NEED_CREATE_TB = "needCreateTB";
    private static final String DEFAULT_DB_ERROR_CODE = "300";
    private static final String TB_NOT_EXIST_ERROR_TAG = "exist";
    private static final Pattern PATTERN_TABLE = Pattern.compile("t_(_|[a-zA-Z])+");
    private static final String DB_FILE_MC_SQL = "mc.sql";
    private static final String DB_FILE_MC_DUMP = "mc.dump";
    private static final int TIMEOUT_DEFAULT = 3000;
    private static final Log LOGGER = LogFactory.getLog(Database.class);

    public Database() throws MCInitException {
        this.cache = MCService.getZKCache(KEY_DATABASE);
        this.setDatabaseInfo(this.cache);
    }

    public Database(HttpServletRequest request) throws MCInitException {
        JSONObject cache = new JSONObject();
        cache.put(KEY_TYPE, (Object)request.getParameter(KEY_TYPE));
        cache.put(KEY_HOST, (Object)request.getParameter(KEY_HOST));
        cache.put(KEY_PORT, (Object)request.getParameter(KEY_PORT));
        cache.put(KEY_INSTANCE, (Object)request.getParameter(KEY_INSTANCE));
        cache.put(KEY_USERNAME, (Object)request.getParameter(KEY_USERNAME));
        cache.put(KEY_NEED_CREATE_DB, (Object)false);
        cache.put(KEY_NEED_CREATE_TB, (Object)false);
        String psd = request.getParameter(KEY_PWD);
        cache.put(KEY_PWD, (Object)new String(Base64.getDecoder().decode(psd)));
        this.setDatabaseInfo(cache);
        MCService.setZKCache(KEY_DATABASE, cache);
        this.cache = cache;
    }

    private void setDatabaseInfo(JSONObject info) {
        this.type = MCDBType.getByCode(info.getString(KEY_TYPE));
        this.host = info.getString(KEY_HOST);
        this.port = info.getIntValue(KEY_PORT);
        this.instance = info.getString(KEY_INSTANCE);
        this.username = info.getString(KEY_USERNAME);
        this.psd = info.getString(KEY_PWD);
        this.urls = MCDBType.getURLs(this.host, this.port);
        this.originUrls = info.getString(KEY_HOST);
        this.isNeedCreateDB = info.getBooleanValue(KEY_NEED_CREATE_DB);
        this.isNeedCreateTB = info.getBooleanValue(KEY_NEED_CREATE_TB);
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    public void setTestConnection(boolean testConnection) {
        this.isTestConnection = testConnection;
    }

    private void setNeedCreateDB(boolean needCreateDB) {
        this.isNeedCreateDB = needCreateDB;
        this.cache.put(KEY_NEED_CREATE_DB, (Object)needCreateDB);
        MCService.setZKCache(KEY_DATABASE, this.cache);
    }

    private void setNeedCreateTB(boolean needCreateTB) {
        this.isNeedCreateTB = needCreateTB;
        this.cache.put(KEY_NEED_CREATE_TB, (Object)needCreateTB);
        MCService.setZKCache(KEY_DATABASE, this.cache);
    }

    public MCDBType getType() {
        return this.type;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getOriginUrls() {
        return this.originUrls;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public boolean isNeedCreateDB() {
        return this.isNeedCreateDB;
    }

    public boolean isNeedCreateTB() {
        return this.isNeedCreateTB;
    }

    public String getEncryptedPassword() {
        return Encrypters.encode((String)this.psd);
    }

    private String getSql(String sql) {
        try {
            return DBUtils.batchTranslatedSQL(sql, this.type.getType4KSQL());
        }
        catch (Exception e) {
            throw new MCInitException(e.getMessage());
        }
    }

    private List<JSONObject> getQueryResults(ResultSet rs) throws Exception {
        ResultSetMetaData md = rs.getMetaData();
        int count = md.getColumnCount();
        ArrayList<JSONObject> results = new ArrayList<JSONObject>(count);
        while (rs.next()) {
            JSONObject result = new JSONObject();
            for (int i = 1; i <= count; ++i) {
                result.put(md.getColumnName(i).toLowerCase(Locale.ENGLISH), rs.getObject(i));
            }
            results.add(result);
        }
        return results;
    }

    public void connect(boolean isAutoCommit) throws MCInitException {
        if (Objects.nonNull(this.connection)) {
            return;
        }
        try {
            this.connection = this.getDBConnection(this.instance);
            this.connection.setAutoCommit(isAutoCommit);
        }
        catch (Exception e) {
            String msg = e.getMessage().toLowerCase(Locale.ENGLISH);
            if (msg.contains(this.instance.toLowerCase(Locale.ENGLISH))) {
                this.setNeedCreateDB(true);
                this.setNeedCreateTB(true);
                if (this.isTestConnection) {
                    throw new MCInitException(DEFAULT_DB_ERROR_CODE, this.getDbNotExistErrorDesc());
                }
                return;
            }
            throw new MCInitException(this.getDbConnectErrorDesc());
        }
    }

    private String getDbNotExistErrorDesc() {
        return ResManager.loadKDString((String)"\u6307\u5b9a\u5b9e\u4f8b\u4e0d\u5b58\u5728\uff0c\u521d\u59cb\u5316\u64cd\u4f5c\u5c06\u6267\u884c\u5efa\u5e93\uff01", (String)"Database_1", (String)"bos-login", (Object[])new Object[0]);
    }

    private String getDbConnectErrorDesc() {
        return ResManager.loadKDString((String)"\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u53c2\u6570\uff01", (String)"Database_0", (String)"bos-login", (Object[])new Object[0]);
    }

    private Properties getDBProperties(String instance) {
        Properties prop = new Properties();
        prop.setProperty("driverClassName", this.type.getDriver());
        prop.setProperty("url", this.type.getURL(this.urls, instance));
        prop.setProperty("user", this.username);
        prop.setProperty("password", this.psd);
        if (StringUtils.isNotEmpty((String)instance) && MCDBType.ORACLE != this.type) {
            prop.setProperty("database", instance);
        }
        return prop;
    }

    private Connection getDBConnection(String instance) throws Exception {
        Properties prop = this.getDBProperties(instance);
        prop.setProperty("connectTimeout", String.valueOf(3000));
        prop.setProperty("socketTimeout", String.valueOf(3000));
        prop.setProperty("initialTimeout", String.valueOf(3000));
        Driver driver = (Driver)Class.forName(prop.getProperty("driverClassName")).newInstance();
        String url = prop.getProperty("url");
        LOGGER.info("Using JDBC: " + url);
        this.type.checkInvalidUrl(url);
        return driver.connect(url, prop);
    }

    public List<JSONObject> query(String sql) {
        return this.query(sql, false);
    }

    /*
     * Exception decompiling
     */
    private List<JSONObject> query(String sql, boolean autoClose) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getTbNotExistErrorDesc() {
        return ResManager.loadKDString((String)"\u6307\u5b9a\u5b9e\u4f8b\u65e0\u76f8\u5173\u6570\u636e\u8868\uff0c\u521d\u59cb\u5316\u64cd\u4f5c\u5c06\u6267\u884c\u5efa\u5e93\uff01", (String)"Database_2", (String)"bos-login", (Object[])new Object[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(String sql) {
        if (Objects.isNull(this.connection)) {
            this.connect(true);
        }
        if (Objects.isNull(this.connection)) {
            return false;
        }
        try (PreparedStatement stat = this.connection.prepareStatement(sql);){
            boolean bl = stat.execute();
            return bl;
        }
        catch (Exception e) {
            throw new MCInitException(e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int update(String sql) {
        if (Objects.isNull(this.connection)) {
            this.connect(true);
        }
        if (Objects.isNull(this.connection)) {
            return 0;
        }
        try (PreparedStatement stat = this.connection.prepareStatement(this.getSql(sql));){
            int n = stat.executeUpdate();
            return n;
        }
        catch (Exception e) {
            throw new MCInitException(e.getMessage());
        }
    }

    public void commit() {
        if (Objects.isNull(this.connection)) {
            return;
        }
        try {
            this.connection.commit();
        }
        catch (Exception e) {
            LOGGER.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
    }

    public void rollback() {
        if (Objects.isNull(this.connection)) {
            return;
        }
        try {
            this.connection.rollback();
        }
        catch (Exception e) {
            LOGGER.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
    }

    public void close() {
        if (Objects.isNull(this.connection)) {
            return;
        }
        try {
            this.connection.close();
            this.connection = null;
        }
        catch (Exception e) {
            LOGGER.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
    }

    public void exeSqlFile(String instance) throws Exception {
        boolean isWindows = System.getProperty("os.name").toLowerCase().contains("win");
        String[] commands = isWindows ? this.exeSqlFile4Windows(instance) : this.exeSqlFile4Linux(instance);
        ProcessHelper processHelper = new ProcessHelper(commands);
        processHelper.setEnv("PGPASSWORD", this.psd);
        if (processHelper.execute()) {
            return;
        }
        String message = processHelper.getMessage();
        if (MCDBType.PG != this.type) {
            throw new Exception(message);
        }
        if (StringUtils.isEmpty((String)message)) {
            return;
        }
        String[] logs = message.split("\n");
        ArrayList<String> errs = new ArrayList<String>(logs.length);
        for (String log : logs) {
            if (!(log = log.toLowerCase()).contains("error") || log.contains("already exists")) continue;
            errs.add(log);
        }
        if (errs.isEmpty()) {
            return;
        }
        throw new Exception(String.join((CharSequence)"\n", errs));
    }

    private String[] exeSqlFile4Windows(String instance) throws Exception {
        String[] cmd;
        String sqlDir = Database.getPath(Database.getSqlDir(), false);
        String toolPath = Database.getPath(Database.getToolDir(), false).replace("(", "^(").replace(")", "^)");
        switch (this.type) {
            case MYSQL: {
                cmd = new String[]{"cmd", "/c", toolPath + "mysql", "-h" + this.host, "-u" + this.username, "-p" + this.psd, "-P" + this.port, "--default-character-set=utf8", instance, "<", sqlDir + DB_FILE_MC_SQL};
                break;
            }
            case ORACLE: {
                throw new Exception(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301Oracle\u6570\u636e\u5e93\u7c7b\u578b\u6267\u884c\u5efa\u5e93", (String)"Database_4", (String)"bos-login", (Object[])new Object[0]));
            }
            default: {
                throw new Exception(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b", (String)"Database_5", (String)"bos-login", (Object[])new Object[0]));
            }
        }
        return cmd;
    }

    private String[] exeSqlFile4Linux(String instance) throws Exception {
        String[] shells;
        String sqlDir = Database.getPath(Database.getSqlDir(), false);
        String toolsPath = Database.getPath(Database.getToolDir(), false);
        switch (this.type) {
            case MYSQL: {
                shells = new String[]{"/bin/bash", "-c", "DB_HOST=\"" + this.host + "\"\nDB_NAME=\"" + instance + "\"\nDB_USER=\"" + this.username + "\"\nDB_PASS=\"" + this.psd + "\"\nDB_PORT=\"" + this.port + "\"\n" + toolsPath + "mysql -u$DB_USER -P$DB_PORT -p$DB_PASS -h $DB_HOST --default-character-set=utf8 $DB_NAME <<EOF \nsource " + sqlDir + DB_FILE_MC_SQL + ";\nEOF\nexit; \n"};
                break;
            }
            case PG: {
                shells = new String[]{toolsPath + "pg_restore", "--no-owner", "-c", "--if-exists", "--no-data-for-failed-tables", "--role", this.username, "-h", this.host, "-p", String.valueOf(this.port), "-U", this.username, "-d", instance, "-v", sqlDir + DB_FILE_MC_DUMP};
                break;
            }
            case ORACLE: {
                throw new Exception(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301Oracle\u6570\u636e\u5e93\u7c7b\u578b\u6267\u884c\u5efa\u5e93", (String)"Database_4", (String)"bos-login", (Object[])new Object[0]));
            }
            default: {
                throw new Exception(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b", (String)"Database_5", (String)"bos-login", (Object[])new Object[0]));
            }
        }
        return shells;
    }

    private static String getToolDir() {
        return Database.getLocalDir() + File.separator + "tools";
    }

    private static String getSqlDir() {
        return Database.getLocalDir() + File.separator + "db" + File.separator + "mc";
    }

    private static String getLocalDir() {
        File root;
        String path = StringUtils.getEmpty();
        String tmp = System.getProperty("user.dir");
        if (!tmp.endsWith("/") && !tmp.endsWith("\\")) {
            tmp = tmp + File.separator;
        }
        if ((root = new File(tmp)).isDirectory()) {
            path = root.getParent();
        }
        return path;
    }

    private static String getPath(String path, boolean isFile) {
        if (StringUtils.isEmpty((String)path)) {
            return path;
        }
        if (!(isFile || path.endsWith("/") || path.endsWith("\\"))) {
            path = path + File.separator;
        }
        return Database.getCorrectPath(path, null);
    }

    private static String getCorrectPath(String path, String separator) {
        if (StringUtils.isEmpty((String)path)) {
            return StringUtils.getEmpty();
        }
        if (StringUtils.isEmpty((String)separator)) {
            separator = File.separator;
        }
        return path.replaceAll("[\\\\/]+", Matcher.quoteReplacement(separator));
    }

    private static String getTableName(String sql) {
        Matcher matcher = PATTERN_TABLE.matcher(sql);
        if (matcher.find()) {
            return matcher.group();
        }
        return TB_NOT_EXIST_ERROR_TAG;
    }

    public void setWriteable() {
        if (StringUtils.isEmpty((String)this.urls)) {
            return;
        }
        String[] urlsArr = this.urls.split(",");
        List urlList = Arrays.stream(urlsArr).distinct().collect(Collectors.toList());
        if (urlList.size() <= 1) {
            return;
        }
        String originInstance = this.instance;
        if (this.isNeedCreateDB) {
            this.instance = "postgres";
        }
        for (String url : urlList) {
            String[] ipPort = url.split(":");
            this.host = ipPort[0];
            this.port = Integer.parseInt(ipPort[1]);
            this.urls = this.host + ":" + this.port;
            if (!this.isWriteable()) continue;
            break;
        }
        this.instance = originInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isWriteable() {
        this.connect(true);
        try (Connection connection = this.getConnection();
             Statement st = connection.createStatement();){
            try {
                st.execute("CREATE TABLE T_MC_TEST (FID BIGINT NOT NULL);");
                st.execute("DROP TABLE T_MC_TEST;");
            }
            catch (Exception e) {
                LOGGER.info(e.getMessage());
                boolean bl = false;
                if (st != null) {
                    if (var4_8 != null) {
                        try {
                            st.close();
                        }
                        catch (Throwable throwable) {
                            var4_8.addSuppressed(throwable);
                        }
                    } else {
                        st.close();
                    }
                }
                if (connection != null) {
                    if (var2_3 != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable) {
                            var2_3.addSuppressed(throwable);
                        }
                    } else {
                        connection.close();
                    }
                }
                this.close();
                return bl;
            }
        }
        catch (Exception ex) {
            LOGGER.info(ex.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            this.close();
        }
        return true;
    }
}

