/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.mc.service;

import com.alibaba.fastjson.JSONObject;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.emun.MCDBType;
import kd.bos.login.mc.model.Database;
import kd.bos.login.utils.MCUtils;
import kd.bos.login.utils.ZKUtils;
import kd.bos.util.StringUtils;
import kd.bos.zk.ZKFactory;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.zookeeper.CreateMode;

public class MCService {
    public static final int ACCOUNT_ID_LENGTH = 19;
    public static final long CONNECTION_ID_DEFAULT = 1L;
    public static final String PG_INSTANCE_DEFAULT = "postgres";
    private static final String KEY_CACHE_CONF = "mc.init.cache";
    private static final Log LOGGER = LogFactory.getLog(MCService.class);

    public static String getDBZKValue(Database db, String accountId, String ssoPlugin) {
        MCDBType mcDbType = db.getType();
        return MCUtils.getTenantData(mcDbType.getType(), mcDbType.getType4Login(), db.getOriginUrls(), db.getHost(), db.getPort(), db.getUsername(), db.getEncryptedPassword(), db.getInstance(), Long.parseLong(accountId), ssoPlugin);
    }

    public static void setReplaceConfigs() {
        MCUtils.putReplaceItem("workflow.engine.start", "false");
        MCUtils.putReplaceItem("fulltext.enable", "false");
        MCUtils.putReplaceItem("xdb.enable", "false");
        MCUtils.putReplaceItem("dubbo.protocol.port", "21880");
        MCUtils.putReplaceItem("login.session.terminalLimit", "true");
        MCUtils.putReplaceItem("attachmentServer.ip", "127.0.0.1");
        MCUtils.putReplaceItem("attachmentServer.httpport", "8100");
        MCUtils.putReplaceItem("mc.type", "ZK");
    }

    public static void saveDbConnection(Database database) {
        MCDBType type = database.getType();
        String instance = database.getInstance();
        String now = DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
        String psd = database.getEncryptedPassword();
        String[] urls = database.getOriginUrls().split(",");
        boolean isCluster = urls.length > 1;
        String isClusterValue = isCluster ? "1" : "0";
        String sql = String.format("update t_mc_dbconnection set fenable = '1', fmodifytime = {ts'%s'}, fdbtype = '%s', fip = '%s', fport = %s, fusername = '%s', fpassword = '%s', finstancename = '%s' where FID = %s", now, type.getType(), database.getHost(), database.getPort(), database.getUsername(), psd, instance, 1L);
        if (database.update(sql) <= 0) {
            sql = String.format("insert into t_mc_dbconnection(FID, fnumber, fstatus, fcreatorid, fmodifierid, fenable, fcreatetime, fmodifytime, fmasterid, fdbtype, fip, fport, fusername, fpassword, finstancename) values(%s, 'mc_DB', 'C', 1, 1, '1', {ts'%s'}, {ts'%s'}, 1, '%s', '%s', %s, '%s', '%s', '%s')", 1L, now, now, type.getType(), database.getHost(), database.getPort(), database.getUsername(), psd, instance);
            database.update(sql);
            sql = String.format("insert into t_mc_dbconnection_l(FPKID, FID, FLocaleID, fname) values(%s, %s, 'zh_CN', 'mc_DB')", 1L, 1L);
            database.update(sql);
        }
        try {
            sql = String.format("update t_mc_dbconnection set fiscluster = '%s' where fid = %s", isClusterValue, 1L);
            database.update(sql);
            if (!isCluster) {
                return;
            }
            sql = String.format("delete from t_mc_dbconnection_urls where fid = %s", 1L);
            database.update(sql);
            for (int i = 0; i < urls.length; ++i) {
                String[] ipPort = urls[i].split(":");
                String ip = ipPort[0];
                int port = Integer.parseInt(ipPort[1]);
                int index = i + 1;
                sql = String.format("insert into t_mc_dbconnection_urls(FID, FEntryId, FSeq, fip, fport) values(%s, %s, %s, '%s', %s)", 1L, index, index, ip, port);
                database.update(sql);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u96c6\u7fa4\u6a21\u5f0f\u4fe1\u606f\u66f4\u65b0\u5931\u8d25\uff0c\u5f53\u524dMC\u53ef\u80fd\u4e3a\u65e7\u7248\u672c\u3002", (Throwable)e);
        }
    }

    public static JSONObject getSelfConfigs(Database database, String ... keys) {
        JSONObject res = new JSONObject();
        ArrayList<String> keyList = new ArrayList<String>();
        for (String key : keys) {
            keyList.add(String.format("'%s'", key));
        }
        String sql = String.format("select fkey, fid from t_mc_selfconf_l where fkey in (%s)", String.join((CharSequence)",", keyList));
        HashMap<String, Long> confIds = new HashMap<String, Long>();
        List<JSONObject> results = database.query(sql);
        for (JSONObject rs : results) {
            confIds.put(rs.getString("fkey"), rs.getLong("fid"));
        }
        if (confIds.isEmpty()) {
            return res;
        }
        HashMap<Long, String> confValues = new HashMap<Long, String>();
        String valueStr = confIds.values().toString().replaceAll("[\\[\\]]", StringUtils.getEmpty());
        sql = String.format("select fid, fvalue from t_mc_selfconf where fid in (%s)", valueStr);
        results = database.query(sql);
        for (JSONObject rs : results) {
            confValues.put(rs.getLong("fid"), rs.getString("fvalue"));
        }
        confIds.forEach((k, v) -> res.put(k, confValues.get(v)));
        return res;
    }

    public static void saveSelfConfigs(Database database, JSONObject configs) {
        ArrayList<String> keyList = new ArrayList<String>();
        for (String key : configs.keySet()) {
            keyList.add(String.format("'%s'", key));
        }
        String sql = String.format("select fkey, fid from t_mc_selfconf_l where fkey in (%s)", String.join((CharSequence)",", keyList));
        List<JSONObject> results = database.query(sql);
        for (JSONObject rs : results) {
            String key = rs.getString("fkey");
            database.update(String.format("update t_mc_selfconf set fvalue = '%s' where fid = %s", configs.remove((Object)key), rs.get((Object)"fid")));
        }
        if (configs.isEmpty()) {
            return;
        }
        ArrayList selfConfValues = new ArrayList();
        ArrayList selfConfLValues = new ArrayList();
        configs.forEach((k, v) -> {
            long fid = Long.parseLong(StringUtils.randomNumber((int)15));
            String pkId = StringUtils.randomWord((int)12);
            selfConfValues.add(String.format("(%s, '%s')", fid, v));
            selfConfLValues.add(String.format("('%s', %s, 'zh_CN', '%s')", pkId, fid, k));
        });
        for (String value : selfConfValues) {
            database.update(String.format("insert into t_mc_selfconf(FID, fvalue) values %s", value));
        }
        for (String value : selfConfLValues) {
            database.update(String.format("insert into t_mc_selfconf_l(FPKID, FID, FLocaleID, fkey) values %s", value));
        }
    }

    public static void updateCommonConfigs(Database database, Map<String, String> configs) {
        for (Map.Entry<String, String> e : configs.entrySet()) {
            database.update(String.format("update t_mc_commonconf set fvalue='%s' where fnumber='%s'", e.getValue(), e.getKey()));
        }
    }

    public static String getZKUrl() {
        return System.getProperty("configUrl");
    }

    private static String getZKRoot() {
        return ZKFactory.getZkRootPath((String)MCService.getZKUrl());
    }

    private static String getZKClusterPath() {
        return MCService.getZKRoot() + Instance.getClusterName();
    }

    public static String getZKCommonVarPath(String key) {
        return MCService.getZKClusterPath() + "/config/common/var/" + key;
    }

    public static String getZKCommonPropPath(String key) {
        return MCService.getZKRoot() + Instance.getClusterName() + "/config/common/prop/" + key;
    }

    private static String getMCInitTokenPath(String key) {
        return MCService.getZKRoot() + Instance.getClusterName() + "/runtime/" + key;
    }

    public static String getMCInitToken(String tokenKey) {
        try {
            return ZKUtils.getZkData(MCService.getZKUrl(), MCService.getMCInitTokenPath(tokenKey));
        }
        catch (Exception e) {
            LOGGER.info("Get token for initializing error: " + e.getMessage());
            return StringUtils.getEmpty();
        }
    }

    public static void setMCInitToken(String tokenKey, String pwdEncrypted) {
        try {
            MCService.setZKTmpData(MCService.getMCInitTokenPath(tokenKey), pwdEncrypted);
        }
        catch (Exception e) {
            LOGGER.info("Set token for initializing error: " + e.getMessage());
        }
    }

    public static void removeMCInitToken(String tokenKey) {
        try {
            ZKUtils.deleteZkKey(MCService.getZKUrl(), MCService.getMCInitTokenPath(tokenKey));
        }
        catch (Exception e) {
            LOGGER.info("Delete token for initializing error: " + e.getMessage());
        }
    }

    public static JSONObject getZKCache(String infoType) {
        String encryptedJson = StringUtils.getEmpty();
        try {
            encryptedJson = ZKUtils.getZkData(MCService.getZKUrl(), MCService.getInfoZkKey());
        }
        catch (Exception e) {
            LOGGER.info("Get cache from zk error: " + e.getMessage());
        }
        if (StringUtils.isEmpty((String)encryptedJson)) {
            return new JSONObject();
        }
        String json = new String(Base64.getDecoder().decode(encryptedJson));
        JSONObject info = JSONObject.parseObject((String)json);
        if (StringUtils.isEmpty((String)infoType)) {
            return info;
        }
        if (Objects.isNull(info.get((Object)infoType))) {
            return new JSONObject();
        }
        return info.getJSONObject(infoType);
    }

    public static void setZKCache(String infoType, JSONObject data) {
        JSONObject info = new JSONObject();
        try {
            String encryptedJson = ZKUtils.getZkData(MCService.getZKUrl(), MCService.getInfoZkKey());
            if (StringUtils.isNotEmpty((String)encryptedJson)) {
                String json = new String(Base64.getDecoder().decode(encryptedJson));
                info = JSONObject.parseObject((String)json);
            }
        }
        catch (Exception e) {
            LOGGER.info("Get cache from zk error: " + e.getMessage());
        }
        info.put(infoType, (Object)data);
        String s = Base64.getEncoder().encodeToString(info.toJSONString().getBytes());
        ZKUtils.setZkData(MCService.getZKUrl(), MCService.getInfoZkKey(), s);
    }

    public static void removeZKCache() {
        try {
            ZKUtils.deleteZkKey(MCService.getZKUrl(), MCService.getInfoZkKey());
        }
        catch (Exception e) {
            LOGGER.info("Delete cache from zk error: " + e.getMessage());
        }
    }

    private static String getInfoZkKey() {
        String encodedKey = Base64.getEncoder().encodeToString(KEY_CACHE_CONF.getBytes());
        String key = encodedKey.substring(encodedKey.length() - 16);
        return MCService.getMCInitTokenPath(key);
    }

    private static void setZKTmpData(String key, String data) throws Exception {
        String zkUrl = MCService.getZKUrl();
        CuratorFramework zkClient = ZKFactory.getZKClient((String)zkUrl);
        byte[] dataBytes = data.getBytes(Charset.defaultCharset());
        if (zkClient.checkExists().forPath(key) == null) {
            ((ACLBackgroundPathAndBytesable)zkClient.create().creatingParentContainersIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(key, dataBytes);
        } else {
            zkClient.setData().forPath(key, dataBytes);
        }
    }
}

