/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.mq;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.dc.utils.MCDBUtil;
import kd.bos.dc.utils.SQLUtils;
import kd.bos.login.utils.ErrorCodeUtils;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.util.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginLogConsumer
implements MessageConsumer {
    private static final String BOS_LOGIN = "bos-login";
    private static final Logger logger = LoggerFactory.getLogger(LoginLogConsumer.class);

    public void onMessage(Object body, String messageId, boolean resend, MessageAcker acker) {
        try {
            Map logInfo = new HashMap();
            if (body instanceof Map) {
                logInfo = (Map)body;
            } else {
                logger.error("\u767b\u5f55mq\u6d88\u606f\u65e5\u5fd7\u9519\u8bef!");
                acker.ack(messageId);
            }
            String accountId = this.getString(logInfo.get("accountId"));
            String tenantId = this.getString(logInfo.get("tenantId"));
            String userid = this.getString(logInfo.get("userid"));
            String orgid = this.getString(logInfo.get("orgid"));
            String flag = this.getString(logInfo.get("flag"));
            String clientType = this.getString(logInfo.get("clientType"));
            String ip = this.getString(logInfo.get("ip"));
            if (RequestContext.get() != null) {
                accountId = RequestContext.get().getAccountId();
                tenantId = RequestContext.get().getTenantId();
            }
            Account currentCenter = AccountUtils.getCorrectAccount((String)accountId, (String)tenantId);
            LoginLogConsumer.addLoginLog(currentCenter, userid, orgid, flag, clientType, ip);
            acker.ack(messageId);
        }
        catch (Exception e) {
            boolean discard = e instanceof IOException;
            if (discard) {
                acker.discard(messageId);
            }
            acker.deny(messageId);
        }
    }

    private String getString(Object obj) {
        String returnValue = "";
        if (obj instanceof String) {
            returnValue = (String)obj;
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addLoginLog(Account currentCenter, String userid, String orgid, String flag, String clientType, String ip) {
        PreparedStatement stmt_l;
        PreparedStatement stmt;
        Connection conn;
        block13: {
            Properties dataBaseProperties;
            block12: {
                conn = null;
                stmt = null;
                stmt_l = null;
                dataBaseProperties = AccountUtils.getTenantDBInfoByRoutekey((Account)currentCenter, (String)"log");
                if (dataBaseProperties != null) break block12;
                logger.error(ErrorCodeUtils.getDBGetError());
                SQLUtils.cleanup(stmt, (Connection)conn);
                SQLUtils.cleanup(stmt_l, (Connection)conn);
                return;
            }
            conn = MCDBUtil.getConnection((Account)currentCenter, (Properties)dataBaseProperties);
            if (null != conn) break block13;
            logger.error(ErrorCodeUtils.getDBGetError());
            SQLUtils.cleanup(stmt, (Connection)conn);
            SQLUtils.cleanup(stmt_l, (Connection)conn);
            return;
        }
        try {
            String log_sql = "INSERT INTO t_log_app (FID, FUSERID, FBIZAPPID, FBIZOBJID, FORGID, FOPTIME, FCLIENTTYPE, FCLIENTIP, FARCHIVETIME) VALUES (?,?,?,?,?,?,?,?,?)";
            String log_l_sql = "INSERT INTO t_log_app_l (FPKID, FID, FLOCALEID, FOPNAME, FOPDESCRIPTION, FCLIENTNAME) VALUES (?,?,?,?,?,?)";
            conn.setAutoCommit(false);
            stmt = conn.prepareStatement(log_sql);
            int index = 1;
            Date now = new Date();
            Timestamp sqlDate = new Timestamp(now.getTime());
            String id = userid + now.getTime();
            stmt.setString(index++, id);
            stmt.setString(index++, userid);
            stmt.setString(index++, "83bfebc8000037ac");
            stmt.setString(index++, "bos_user");
            stmt.setString(index++, orgid);
            stmt.setTimestamp(index++, sqlDate);
            stmt.setString(index++, clientType);
            stmt.setString(index++, ip);
            stmt.setTimestamp(index++, null);
            stmt.execute();
            index = 1;
            stmt_l = conn.prepareStatement(log_l_sql);
            stmt_l.setString(index++, id + 1);
            stmt_l.setString(index++, id);
            stmt_l.setString(index++, "zh_CN");
            if (flag.equals("1")) {
                stmt_l.setString(index++, ResManager.loadKDString((String)"\u767b\u5f55", (String)"SessionUtils_0", (String)BOS_LOGIN, (Object[])new Object[0]));
                stmt_l.setString(index++, ResManager.loadKDString((String)"\u767b\u5f55\u6210\u529f", (String)"SessionUtils_1", (String)BOS_LOGIN, (Object[])new Object[0]));
            } else if (flag.equals("0")) {
                stmt_l.setString(index++, ResManager.loadKDString((String)"\u8e22\u51fa\u7528\u6237", (String)"SessionUtils_2", (String)BOS_LOGIN, (Object[])new Object[0]));
                stmt_l.setString(index++, ResManager.loadKDString((String)"\u8e22\u51fa\u7528\u6237\u6210\u529f", (String)"SessionUtils_3", (String)BOS_LOGIN, (Object[])new Object[0]));
            }
            stmt_l.setString(index++, "");
            stmt_l.execute();
            conn.commit();
        }
        catch (Exception e) {
            try {
                try {
                    if (conn != null) {
                        conn.rollback();
                    }
                }
                catch (SQLException e1) {
                    logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, conn);
                SQLUtils.cleanup(stmt_l, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup(stmt, (Connection)conn);
            SQLUtils.cleanup(stmt_l, (Connection)conn);
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        SQLUtils.cleanup((Statement)stmt_l, (Connection)conn);
    }
}

