/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.service;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.service.DispatchService;
import kd.bos.service.lookup.ServiceLookup;
import kd.sdk.annotation.SdkInternal;

public class DispatchServiceHelper {
    private static final String KD_BOS_SERVICE_SERVICE_FACTORY = "kd.bos.service.ServiceFactory";
    private static Map<String, Object> proxyMap = new ConcurrentHashMap<String, Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getBOSService(final String appId, String serviceName, Class<T> bizCls) {
        String key;
        Object obj;
        if (serviceName == null) {
            serviceName = bizCls.getSimpleName();
        }
        if ((obj = proxyMap.get(key = (appId + "#" + serviceName + "#" + bizCls.getName()).toLowerCase())) == null) {
            Map<String, Object> map = proxyMap;
            synchronized (map) {
                obj = proxyMap.get(key);
                if (obj == null) {
                    final String sn = serviceName;
                    obj = Proxy.newProxyInstance(bizCls.getClassLoader(), new Class[]{bizCls}, new InvocationHandler(){

                        @Override
                        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                            return DispatchServiceHelper.invokeBOSServiceByAppId(appId, sn, method.getName(), args);
                        }
                    });
                    proxyMap.put(key, obj);
                }
            }
        }
        return (T)obj;
    }

    public static Object invokeBOSServiceByFormId(String formId, String serviceName, String methodName, Object ... paras) {
        String appId = (String)DispatchServiceHelper.invokeBOSService("FormService", "getAppId", formId);
        DispatchService service = DispatchServiceHelper.serviceLookup(appId);
        return service.invoke(KD_BOS_SERVICE_SERVICE_FACTORY, serviceName, methodName, paras);
    }

    private static DispatchService serviceLookup(String appId) {
        DispatchService service = null;
        String serviceAppId = ServiceLookup.getServiceAppId((String)appId);
        service = (DispatchService)ServiceLookup.lookup(DispatchService.class, (String)serviceAppId);
        return service;
    }

    @SdkInternal
    public static Object invokeBOSServiceByAppId(String appId, String serviceName, String methodName, Object ... paras) {
        DispatchService service = DispatchServiceHelper.serviceLookup(appId);
        return service.invoke(KD_BOS_SERVICE_SERVICE_FACTORY, serviceName, methodName, paras);
    }

    public static Object invokeBOSService(String serviceName, String methodName, Object ... paras) {
        DispatchService service = (DispatchService)ServiceLookup.lookup(DispatchService.class, (String)"bos");
        return service.invoke(KD_BOS_SERVICE_SERVICE_FACTORY, serviceName, methodName, paras);
    }

    static {
        ServiceLookup.addSystemAppId((String[])new String[]{"bos", "bd"});
        ServiceLookup.addSystemAppId((String[])new String[]{"pur", "pbd", "quo", "scp", "sou", "srm", "bdm", "mm", "lbd", "im", "bid", "adm", "ent"});
        ServiceLookup.addSystemAppId((String[])new String[]{"er", "exp", "em", "ir", "tra"});
        ServiceLookup.addSystemAppId((String[])new String[]{"ssc", "task"});
        ServiceLookup.addSystemAppId((String[])new String[]{"iscb"});
        ServiceLookup.addSystemAppId((String[])new String[]{"fibd", "ai", "ap", "bcm", "cas", "iep", "gl", "pa", "fa", "rpt", "cm", "aifs"});
        ServiceLookup.addSystemAppId((String[])new String[]{"bcm_calcnode"});
        ServiceLookup.addSystemAppId((String[])new String[]{"haos", "hbp", "hbss", "hjms", "hers", "hbom"});
        ServiceLookup.addSystemAppId((String[])new String[]{"mdr", "dpa", "dbp", "dbd", "bbc", "mem"});
        ServiceLookup.addSystemAppId((String[])new String[]{"tc"});
    }
}

