/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.service;

import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.base.parameter.ParameterService;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.db.DBRoute;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.APIUtils;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.StringUtils;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.portal.InitailVersionServiceHelper;
import kd.bos.session.SessionInfo;
import kd.bos.session.service.DBUtils;
import kd.bos.util.RevProxyUtil;

public class NewPortalService {
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("new_portal_setting", new DistributeCacheHAPolicy(true, true));
    private static final String HOME_PAGE = "home_page";
    private static final String PC_MAIN_CONSOLE = "pc_main_console";
    private static List<String> portalPage = Arrays.asList("home_page", "pc_main_console");
    private static final Log logger = LogFactory.getLog(NewPortalService.class);

    private static String buildCacheType(String accountId) {
        return String.format("%s.%s", "newportalsetting", accountId);
    }

    private static String buildCacheKey(String key, String userId) {
        return String.format("%s.%s", key, userId);
    }

    public static void removeNewPortalSetting(String accountId, String key, String userId) {
        String value = (String)cache.get(NewPortalService.buildCacheType(accountId), NewPortalService.buildCacheKey(key, userId));
        logger.info(String.format("removeNewPortalSetting--userId:%s, accountId:%s, key:%s, value:%s", userId, accountId, key, value));
        cache.remove(NewPortalService.buildCacheType(accountId), NewPortalService.buildCacheKey(key, userId));
    }

    public static void removeAllUserNewPortalSetting(String accountId) {
        cache.removeType(NewPortalService.buildCacheType(accountId));
    }

    public static boolean isPersonalSettingNewPortal(long userId, String accountId) {
        boolean isSupport;
        String key;
        String type = NewPortalService.buildCacheType(accountId);
        String value = (String)cache.get(type, key = NewPortalService.buildCacheKey("newportalconfig", userId + ""));
        if (value != null) {
            isSupport = Boolean.parseBoolean(value);
        } else {
            Account account = AccountUtils.getAccountById((String)accountId);
            isSupport = NewPortalService.getPersonalSetting(userId, account);
            logger.info(String.format("isPersonalSettingNewPortal from db,userId:%s, accountId:%s, isSupport:%s", userId, accountId, isSupport));
            cache.put(type, key, (Object)String.valueOf(isSupport));
        }
        return isSupport;
    }

    private static boolean getPersonalSetting(Long userId, Account account) {
        String selectSql = "select fusenewportal from t_bas_user_paras_config where fuserid = ?";
        Object[] params = new Object[]{userId};
        String useNewPortal = (String)DBUtils.query((Account)account, (DBRoute)DBRoute.base, (String)selectSql, (Object[])params, rs -> {
            if (rs.next()) {
                return rs.getString("fusenewportal");
            }
            return null;
        });
        logger.info(String.format("getPersonalSetting from db, userrId:%s, accountId:%s, useNewPortal:%s", userId, account.getAccountId(), useNewPortal));
        if (StringUtils.isNotBlank(useNewPortal)) {
            return "1".equals(useNewPortal) || "true".equals(useNewPortal);
        }
        boolean isNewTenant = InitailVersionServiceHelper.isInitailVersion((int)6);
        logger.info(String.format("getPersonalSetting isNewTenant:%s, accountId:%s", isNewTenant, account.getAccountId()));
        return isNewTenant;
    }

    public static boolean newPortalFilter(HttpServletRequest request, HttpServletResponse response, String glableSessoionId) {
        try {
            boolean isNewPortal;
            boolean isMatch = NewPortalService.isMatch(request);
            if (!isMatch) {
                return false;
            }
            SessionInfo sessionInfo = null;
            if (StringUtils.isNotEmpty(glableSessoionId)) {
                sessionInfo = LoginUtils.getSessinInfoBySessionId(glableSessoionId);
            }
            if (sessionInfo == null) {
                return false;
            }
            boolean needRedirect = false;
            if (NewPortalService.isGalaxyMode()) {
                isNewPortal = true;
            } else {
                Long userId = Long.valueOf(sessionInfo.getUserId());
                String accountId = sessionInfo.getAccountId();
                boolean personsetting = NewPortalService.isPersonalSettingNewPortal(userId, accountId);
                logger.info(String.format("NewPortalFilter--userId:%s, accountId:%s, personsetting:%s,", userId, accountId, personsetting));
                isNewPortal = ParameterService.enableNewPortal() && personsetting;
            }
            String form = NewPortalService.getFormIdByRequest(request);
            if (isNewPortal && !HOME_PAGE.equals(form)) {
                form = HOME_PAGE;
                needRedirect = true;
            } else if (!isNewPortal && !PC_MAIN_CONSOLE.equals(form)) {
                form = PC_MAIN_CONSOLE;
                needRedirect = true;
            }
            if (needRedirect) {
                String url = "?formId=" + form;
                String params = LoginUtils.builderParamter(request);
                url = RevProxyUtil.getURLContextPath((HttpServletRequest)request) + url + params;
                response.sendRedirect(url);
                return true;
            }
        }
        catch (Exception ex) {
            logger.error("NewPortalFilter--error", (Throwable)ex);
            APIUtils.outputErrorMessage(response, "8", ex.getMessage());
        }
        return false;
    }

    public static boolean isMatch(HttpServletRequest request) {
        boolean isMobilePage = LoginUtils.isRootPathPage(request, new String[]{"mobile.html"});
        if (isMobilePage) {
            return false;
        }
        if (NewPortalService.isIncludBillFormId(request)) {
            return false;
        }
        String form = NewPortalService.getFormIdByRequest(request);
        if (StringUtils.isEmpty(form) && LoginUtils.isRootPage(request) && !LoginUtils.isIincludePageId(request)) {
            form = PC_MAIN_CONSOLE;
        }
        return portalPage.contains(form);
    }

    private static boolean isIncludBillFormId(HttpServletRequest request) {
        String billFormId = request.getParameter("billFormId");
        return StringUtils.isNotEmpty(billFormId);
    }

    private static String getFormIdByRequest(HttpServletRequest request) {
        return request.getParameter("formId");
    }

    private static boolean isGalaxyMode() {
        int modelType = LicenseServiceHelper.getModeType();
        return modelType == 2 || modelType == 4;
    }
}

