/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.service;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.LoginClientEnum;
import kd.bos.login.service.session.event.CreateSessionEvent;
import kd.bos.login.utils.OnlineUserUtil;

public class OnlineUserManager {
    private static Log logger = LogFactory.getLog(OnlineUserManager.class);

    @Subscribe
    @AllowConcurrentEvents
    public void loginOnlineUser(CreateSessionEvent event) {
        if (!this.validateForClient(event)) {
            return;
        }
        if (!this.validateForGuest(event)) {
            return;
        }
        if (!this.validateForOther(event)) {
            return;
        }
        try {
            OnlineUserUtil.login(event.getSessionId(), event.getClientLevel1().getDesc(), event.getParams().getTimeOut());
        }
        catch (Exception e) {
            logger.error("onlineUser====>" + e.getMessage());
        }
    }

    private boolean validateForOther(CreateSessionEvent event) {
        return !"YZJAPI".equals(event.getParams().getAppType());
    }

    private boolean validateForClient(CreateSessionEvent event) {
        return LoginClientEnum.WEB == event.getClientLevel1() || LoginClientEnum.MOBILE == event.getClientLevel1();
    }

    private boolean validateForGuest(CreateSessionEvent event) {
        Map<String, String> userInfo = event.getUserInfo();
        return userInfo.get("fid") != null && !"0".equals(userInfo.get("fid")) && !"-1".equals(userInfo.get("fid"));
    }
}

