/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.service;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import kd.bos.api.ApiRequestContext;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.exception.LoginErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.CacheLoginData;
import kd.bos.login.model.AuthSignatureResult;
import kd.bos.login.model.SSOAuthConfig;
import kd.bos.login.model.ThirdAppMapping;
import kd.bos.login.model.ThirdAuthApp;
import kd.bos.login.service.ILoginAuthenticationService;
import kd.bos.login.thirdauth.app.ThirdAppAuthFactory;
import kd.bos.login.thirdauth.app.ThirdAppAuthStrategy;
import kd.bos.login.thirdauth.app.sky.SkyUtils;
import kd.bos.login.thirdauth.app.tencent.wechat.WXBizMsgCrypt;
import kd.bos.login.user.DefaultParameterService;
import kd.bos.login.utils.BeanUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.session.SessionDAO;
import kd.bos.session.SessionDAOFactory;
import kd.bos.util.JSONUtils;
import kd.bos.util.RevProxyUtil;
import kd.bos.util.StringUtils;

public class ThirdAppService {
    private static String CTS_QYWXH = "cts_wxqyh";
    private static String BOS_THIRDAPPS_CONFIG = "bos_thirdapps_config";
    private static String BAS_INSTANTMSGTYPE = "bas_instantmsgtype";
    private static String STR = "QrqO5Gtf/Inoa76Hy7rajw==";
    private static Log logger = LogFactory.getLog(ThirdAppService.class);

    public static String dealPushData(HttpServletRequest servletRequest) {
        Map<String, Object> result = new HashMap<String, Object>(8);
        result.put("success", false);
        try {
            String accessToken = servletRequest.getHeader("accessToken");
            if (StringUtils.isEmpty((String)accessToken)) {
                result.put("message", "accessToken is null.");
                return JSON.toJSONString(result);
            }
            SessionDAO sessionDAO = SessionDAOFactory.getSessionDAO((String)accessToken);
            Map sessionInfo = sessionDAO.getAttributesAsMap(new String[]{"userId"});
            String userId = (String)sessionInfo.get("userId");
            if ("1".equals(userId)) {
                ApiRequestContext ctx = ApiRequestContext.get();
                String bodyData = ctx.getPostData();
                if (StringUtils.isNotEmpty((String)bodyData)) {
                    Account account = AccountUtils.getCorrectAccount((String)((String)sessionInfo.get("accountId")), (String)RevProxyUtil.getTenantCode((HttpServletRequest)ctx.getRequest()));
                    String className = DefaultParameterService.getDefaultParamsConfig(account, "init_kingdee_sky_config_className");
                    if (StringUtils.isNotEmpty((String)className)) {
                        result = ThirdAppService.initThirdAppsConfig(servletRequest, userId, bodyData, className);
                    } else {
                        ThirdAppService.dealThirdappsConfig(servletRequest, userId, bodyData);
                        result.put("success", true);
                    }
                } else {
                    result.put("message", "params is null");
                }
            } else {
                result.put("message", ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u8d85\u7ea7\u7ba1\u7406\u5458\u8d26\u53f7\u8fdb\u884c\u9a8c\u8bc1\u3002", (String)"ThirdAppService_1", (String)"bos-login", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            result.put("message", e.getMessage());
            logger.info("kd.bos.login.service.ThirdAppService.dealPushData", (Object)e);
        }
        return JSON.toJSONString(result);
    }

    private static void dealThirdappsConfig(HttpServletRequest servletRequest, String userId, String bodyData) throws Exception, GeneralSecurityException {
        String customData;
        Map map = (Map)JSONUtils.cast((String)bodyData, HashMap.class);
        String opType = String.valueOf(map.get("opType"));
        if ("1".equals(opType) && StringUtils.isNotEmpty((String)(customData = String.valueOf(map.get("data"))))) {
            customData = WXBizMsgCrypt.decryptToString(STR, customData);
            map = (Map)JSONUtils.cast((String)customData, HashMap.class);
            String thirdAppType = String.valueOf(map.get("entryRole"));
            Object erpRole = map.get("erpRole");
            if (!ThirdAppService.checkSystemEnv(erpRole)) {
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u521d\u59cb\u5316\u73af\u5883\u5730\u5740\u548c\u5e94\u7528\u7ba1\u5bb6\u7c7b\u578b\u4e0d\u5339\u914d\u3002", (String)"ThirdAppService_5", (String)"bos-login", (Object[])new Object[0])});
            }
            ThirdAppService.saveThirdappsConfig(userId, map, customData);
            CacheLoginData.remove((String)"kingdee_sky", (String)(String.valueOf(map.get("eid")) + RequestContext.get().getAccountId()));
            if ("1".equals(thirdAppType)) {
                MessageCenterServiceHelper.updateWxqyPublicAuthorizeData((String)customData);
            }
        }
    }

    public static DynamicObject[] getBasQywxh(String corpid) {
        QFilter[] qFilter = new QFilter[]{new QFilter("corpid", "=", (Object)corpid)};
        DynamicObject[] data = BusinessDataServiceHelper.load((String)CTS_QYWXH, (String)"corpid,corpsecret,customdata", (QFilter[])qFilter);
        return data;
    }

    public static String getImMapping(String qywxhUserid) {
        return ThirdAppService.getImMapping(qywxhUserid, 3L);
    }

    public static String getImMapping(String qywxhUserid, Long imtype) {
        String userId = "";
        if (imtype == 0L) {
            Object[] userArray = BusinessDataServiceHelper.load((String)"bos_user", (String)"id", (QFilter[])new QFilter[]{new QFilter("useropenid", "=", (Object)qywxhUserid)});
            if (!ObjectUtils.isEmpty((Object[])userArray)) {
                userId = userArray[0].get("id").toString();
            }
        } else {
            Object[] imMapping = BusinessDataServiceHelper.load((String)"bas_immapping", (String)"id,userid,openid", (QFilter[])new QFilter[]{new QFilter("encryopenid", "=", (Object)qywxhUserid).or(new QFilter("openid", "=", (Object)qywxhUserid)), new QFilter("imtype", "=", (Object)imtype)});
            if (!ObjectUtils.isEmpty((Object[])imMapping)) {
                userId = imMapping[0].get("userid").toString();
            }
        }
        return userId;
    }

    public static void saveImappingData(String userId, String userInfo, long imTypeId) {
        ThirdAppService.saveImappingData(userId, userInfo, imTypeId, true);
    }

    public static void saveImappingData(String userId, String userInfo, long imTypeId, boolean isEncrypt) {
        ThirdAppMapping thirdAppMapping = ThirdAppService.wrapToMapping(userId, userInfo);
        String openId = thirdAppMapping.getOpenId();
        DynamicObject[] imMapping = BusinessDataServiceHelper.load((String)"bas_immapping", (String)"id,userid,openid,encryopenid", (QFilter[])new QFilter[]{new QFilter("openid", "=", (Object)openId).or(new QFilter("encryopenid", "=", (Object)openId)).or(new QFilter("userid", "=", (Object)Long.parseLong(userId))), new QFilter("imtype", "=", (Object)imTypeId)});
        MainEntityType imMappingType = EntityMetadataCache.getDataEntityType((String)"bas_immapping");
        DynamicObject mapping = new DynamicObject((DynamicObjectType)imMappingType);
        if (imMapping == null || imMapping.length == 0) {
            mapping.set("userid", (Object)userId);
            mapping.set("user", (Object)userId);
            mapping.set("imtype", (Object)imTypeId);
            if (!isEncrypt) {
                mapping.set("openid", (Object)openId);
            } else {
                mapping.set("encryopenid", (Object)openId);
            }
            mapping.set("thirdappcorpid", (Object)thirdAppMapping.getThirdAppCorpId());
            mapping.set("thirdappusername", (Object)thirdAppMapping.getThirdAppUserName());
            mapping.set("createdate", (Object)new Date());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mapping});
        } else {
            mapping = imMapping[0];
            if (!isEncrypt) {
                if (ObjectUtils.isEmpty((Object)mapping.get("openid"))) {
                    mapping.set("openid", (Object)openId);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mapping});
                }
            } else if (ObjectUtils.isEmpty((Object)mapping.get("encryopenid"))) {
                mapping.set("encryopenid", (Object)openId);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mapping});
            }
        }
    }

    public static Long getThirdAppUserType(String thirdAppType) {
        Long thirdAppUserType = null;
        if ("1".equals(thirdAppType)) {
            thirdAppUserType = 3L;
        } else if ("3".equals(thirdAppType)) {
            thirdAppUserType = 4L;
        } else if (!"3".equals(thirdAppType) && !"4".equals(thirdAppType) && StringUtils.isNumeric((String)thirdAppType)) {
            thirdAppUserType = Long.parseLong(thirdAppType);
        }
        return thirdAppUserType;
    }

    public static DynamicObject[] getThirdappsConfigByCorpid(String corpid, Long thirdapptype) {
        QFilter[] qFilter = new QFilter[]{new QFilter("corpid", "=", (Object)corpid), new QFilter("thirdapptype.id", "=", (Object)thirdapptype)};
        DynamicObject[] data = BusinessDataServiceHelper.load((String)BOS_THIRDAPPS_CONFIG, (String)"corpid,corpname,corpsecret,thirdapptype.id,data", (QFilter[])qFilter);
        return data;
    }

    public static DynamicObject[] getThirdAppsByEntryRole(Long entryRole) {
        QFilter[] qFilter = new QFilter[]{new QFilter("id", "=", (Object)entryRole)};
        DynamicObject[] data = BusinessDataServiceHelper.load((String)BAS_INSTANTMSGTYPE, (String)"id,number,status", (QFilter[])qFilter);
        return data;
    }

    public static String getThirdAppTypeByEntryRole(Long entryRole) {
        DynamicObject[] data = ThirdAppService.getThirdAppsByEntryRole(entryRole);
        String type = null;
        for (DynamicObject datum : data) {
            if (entryRole.longValue() != datum.getLong("id")) continue;
            type = datum.getString("number");
            break;
        }
        return type;
    }

    private static void saveThirdappsConfig(String userId, Map<String, Object> map, String customData) {
        DynamicObject data = BusinessDataServiceHelper.newDynamicObject((String)BOS_THIRDAPPS_CONFIG);
        String entryRole = StringUtils.getStringValue((Object)map.get("entryRole"));
        DynamicObject[] thirdappsConfig = ThirdAppService.getThirdappsConfigByCorpid(String.valueOf(map.get("eid")), ThirdAppService.getThirdAppUserType(entryRole));
        if (thirdappsConfig != null && thirdappsConfig.length > 0) {
            data = thirdappsConfig[0];
        } else {
            data.set("corpid", map.get("eid"));
            data.set("createdate", (Object)new Date());
            data.set("creatorid", (Object)Long.parseLong(userId));
            if (!ObjectUtils.isEmpty((Object)entryRole)) {
                data.set("thirdapptype", (Object)ThirdAppService.getThirdAppUserType(entryRole));
            }
        }
        data.set("corpsecret", map.get("secret"));
        data.set("corpname", map.get("ename"));
        data.set("data", (Object)customData);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{data});
    }

    private static ThirdAppMapping wrapToMapping(String userId, String userInfo) {
        ThirdAppMapping thirdAppMapping = new ThirdAppMapping();
        if (StringUtils.isNotEmpty((String)userId)) {
            thirdAppMapping.setUserId(Long.parseLong(userId));
        }
        if (StringUtils.isNotEmpty((String)userInfo) && (userInfo.contains("{") || userInfo.contains("}"))) {
            try {
                Map map = (Map)JSONUtils.cast((String)userInfo, HashMap.class);
                thirdAppMapping.setOpenId(StringUtils.getStringValue(map.get("openId")));
                thirdAppMapping.setThirdAppCorpId(StringUtils.getStringValue(map.get("eid")));
                thirdAppMapping.setThirdAppUserName(StringUtils.getStringValue(map.get("name")));
            }
            catch (IOException iOException) {}
        } else {
            thirdAppMapping.setOpenId(userInfo);
        }
        return thirdAppMapping;
    }

    private static Map<String, Object> initThirdAppsConfig(HttpServletRequest servletRequest, String userId, String thirdAppsConfigData, String className) throws IOException, GeneralSecurityException {
        HashMap<String, Object> result = new HashMap(8);
        Map map = (Map)JSONUtils.cast((String)thirdAppsConfigData, HashMap.class);
        String opType = String.valueOf(map.get("opType"));
        thirdAppsConfigData = WXBizMsgCrypt.decryptToString(STR, String.valueOf(map.get("data")));
        ILoginAuthenticationService loginAuthenticationService = (ILoginAuthenticationService)BeanUtils.getBean(className);
        result = loginAuthenticationService.initThirdAppsConfig(opType, thirdAppsConfigData);
        return result;
    }

    private static boolean checkSystemEnv(Object erpRole) {
        boolean flag = false;
        if (ObjectUtils.isEmpty((Object)erpRole)) {
            return true;
        }
        if (erpRole.toString().equals(SkyUtils.getSystemEnv()) || "99".equals(SkyUtils.getSystemEnv())) {
            flag = true;
        }
        return flag;
    }

    public static List<AuthSignatureResult> getAuthSignatureList(Account currentCenter, ThirdAuthApp thirdAuthAppInfo) {
        List<AuthSignatureResult> list = new ArrayList<AuthSignatureResult>(2);
        ThirdAppAuthStrategy thirdAppAuthStrategy = ThirdAppAuthFactory.getInstance().getThirdAppAuthStrategy(currentCenter, thirdAuthAppInfo);
        if (thirdAppAuthStrategy != null) {
            list = thirdAppAuthStrategy.getJsSignatureList(currentCenter, thirdAuthAppInfo);
        }
        return list;
    }

    private static SSOAuthConfig getThirdSSOAuthConfig(QFilter[] qFilter) {
        SSOAuthConfig ssoAuthConfig = new SSOAuthConfig();
        try {
            Map ssoAuthConfigMap = BusinessDataServiceHelper.loadFromCache((String)"third_sso_auth_config", (String)"id,integmode,accountid,url,userflag,appid,appsecret,thirduser,sso_plugin,default_login_page", (QFilter[])qFilter);
            Iterator iterator = ssoAuthConfigMap.entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                DynamicObject config = (DynamicObject)entry.getValue();
                ssoAuthConfig.setAccountId(config.getString("accountid"));
                ssoAuthConfig.setIntegMode(config.getString("integmode"));
                ssoAuthConfig.setUrl(config.getString("url"));
                ssoAuthConfig.setUserFlag(config.getString("userflag"));
                ssoAuthConfig.setAppId(config.getString("appid"));
                ssoAuthConfig.setAppSecret(config.getString("appsecret"));
                ssoAuthConfig.setThirdUser(config.getString("thirduser"));
                ssoAuthConfig.setSsoPlugin(config.getString("sso_plugin"));
                ssoAuthConfig.setDefaultLoginPage(config.getString("default_login_page"));
                return ssoAuthConfig;
            }
        }
        catch (Exception e) {
            logger.info("getThirdSSOAuthConfig#error", (Object)e);
        }
        return ssoAuthConfig;
    }

    public static String getThirdSSOLoginPage() {
        QFilter[] qFilter = new QFilter[]{new QFilter("default_login_page", "=", (Object)"1")};
        SSOAuthConfig ssoAuthConfig = ThirdAppService.getThirdSSOAuthConfig(qFilter);
        String url = ssoAuthConfig.getUrl();
        return url;
    }

    public static SSOAuthConfig getThirdSSOAuthConfig(String appId, String thirdAccountId, String defaultLoginPage) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(8);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)appId)) {
            qFilters.add(new QFilter("appid", "=", (Object)appId));
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)thirdAccountId)) {
            qFilters.add(new QFilter("accountid", "=", (Object)thirdAccountId));
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)defaultLoginPage)) {
            qFilters.add(new QFilter("default_login_page", "=", (Object)defaultLoginPage));
        }
        qFilters.add(new QFilter("enable", "=", (Object)"1"));
        SSOAuthConfig ssoAuthConfig = new SSOAuthConfig();
        if (qFilters != null && qFilters.size() > 0) {
            ssoAuthConfig = ThirdAppService.getThirdSSOAuthConfig(qFilters.toArray(new QFilter[qFilters.size()]));
        }
        return ssoAuthConfig;
    }
}

