/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.service.apps.impl;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.api.model.Account;
import kd.bos.exception.KDException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.CacheLoginData;
import kd.bos.login.LoginClientEnum;
import kd.bos.login.filter.LoginManage;
import kd.bos.login.lang.LoginLangUtils;
import kd.bos.login.service.ThirdAppService;
import kd.bos.login.service.apps.ThirdAppsService;
import kd.bos.login.service.apps.ThirdAppsServiceExt;
import kd.bos.login.service.apps.impl.ThirdAppsServiceExtImpl;
import kd.bos.login.service.session.SessionService;
import kd.bos.login.service.session.SessionServiceFactory;
import kd.bos.login.service.session.dto.SessionParams;
import kd.bos.login.thirdauth.app.AppAuthResult;
import kd.bos.login.thirdauth.app.ThirdAppAuthtication;
import kd.bos.login.thirdauth.app.dingding.DDAuthticationPublic;
import kd.bos.login.thirdauth.app.feishu.FeiShuAuthtication;
import kd.bos.login.thirdauth.app.sky.SkyAuthtication;
import kd.bos.login.thirdauth.app.tencent.WxqyhAuthtication;
import kd.bos.login.thirdauth.app.welink.WeLinkAuthtication;
import kd.bos.login.user.LoginUserService;
import kd.bos.login.utils.AgentUtil;
import kd.bos.login.utils.Constants;
import kd.bos.login.utils.StringUtils;
import kd.bos.login.utils.URLUtils;
import kd.bos.login.utils.account.LoginAccountFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.session.SessionDAO;
import kd.bos.util.NetAddressUtils;
import kd.bos.util.RevProxyUtil;

public class ThirdAppsServiceImpl
implements ThirdAppsService {
    private static Log log = LogFactory.getLog(ThirdAppsServiceImpl.class);
    private static final String ACCOUNT_ID = "accountId";
    private static final String SUCCESS = "success";
    private static final String BOS_LOGIN = "bos-login";
    private static final String HCODE_TICKET = "ticket";
    private final SessionService sessionService = SessionServiceFactory.createSessionService();
    private final ThirdAppsServiceExt thirdAppsServiceExt = new ThirdAppsServiceExtImpl();

    @Override
    public String thirdAppLogin(HttpServletRequest request, HttpServletResponse response) {
        String globalSessionId = null;
        try {
            Map<String, String> userInfo = this.getUserInfo(request);
            if (userInfo != null) {
                globalSessionId = this.getHandleSessionId(request, response, userInfo);
            }
        }
        catch (Exception e) {
            throw new KDException(Constants.KD_WEB_EXCEPTION, new Object[]{e.getMessage()});
        }
        return globalSessionId;
    }

    private Map<String, String> getUserInfo(HttpServletRequest request) {
        List<ThirdAppAuthtication> authtications = this.getAllAuthtication(request);
        for (ThirdAppAuthtication appAuthtication : authtications) {
            AppAuthResult result = this.handleAppAuthtication(request, appAuthtication);
            boolean check = this.checkResult(result);
            if (!check) continue;
            return this.getUserInfoByResult(request, result);
        }
        return null;
    }

    @Override
    public String getThirdAppUserId(HttpServletRequest request) {
        Map<String, String> userInfo = this.getUserInfo(request);
        if (userInfo != null) {
            return userInfo.get("fid");
        }
        return null;
    }

    @Override
    public boolean isNeedThirdAppHandle(HttpServletRequest request) {
        ThirdAppAuthtication authtication = this.getAuthtication(request);
        Account currentAccount = LoginAccountFactory.createInstanceByHttpRequest(request, Optional.empty()).getAccount();
        return this.isNeedHandle(request, currentAccount, authtication);
    }

    private List<ThirdAppAuthtication> getAllAuthtication(HttpServletRequest request) {
        ArrayList<ThirdAppAuthtication> authtications = new ArrayList<ThirdAppAuthtication>(4);
        Set<String> allAppAuthtication = this.getAppConfig(request);
        Account currentAccount = LoginAccountFactory.createInstanceByHttpRequest(request, Optional.empty()).getAccount();
        for (String appAuth : allAppAuthtication) {
            try {
                ThirdAppAuthtication authtication = (ThirdAppAuthtication)Class.forName(appAuth).newInstance();
                if (!this.isNeedHandle(request, currentAccount, authtication)) continue;
                authtications.add(authtication);
            }
            catch (Exception e) {
                log.error(ResManager.loadKDString((String)"\u7cfb\u7edf\u9519\u8bef\uff0c\u7b2c\u4e09\u65b9\u6821\u9a8c\u5668\u914d\u7f6e\u4e0d\u6b63\u786e\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002\n", (String)"LoginFilter_6", (String)BOS_LOGIN, (Object[])new Object[0]) + e);
            }
        }
        return authtications;
    }

    @Override
    public void toSendLogin(HttpServletRequest request, HttpServletResponse response) {
        try {
            String s = URLUtils.buildRedirectUrl((ServletRequest)request);
            boolean hasParams = StringUtils.isNotEmpty(request.getQueryString());
            String url = this.addUrlParams(s, hasParams, "hideDataCenter=1");
            String redirectUrl = URLEncoder.encode(url, "UTF-8");
            String urlContextPath = RevProxyUtil.getURLContextPath((HttpServletRequest)request);
            redirectUrl = urlContextPath + "login-mobile.html?redirect=" + redirectUrl;
            boolean hasPlugin = this.thirdAppsServiceExt.hasLoginThirdAppPlugin();
            if (hasPlugin) {
                response.sendRedirect(redirectUrl);
                return;
            }
            new LoginManage().showThirdAppLoginPage(request, response, redirectUrl);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    @Override
    public Map<String, Object> checkExtPlugin(HttpServletRequest servletRequest, Long userId) {
        boolean isThirdApp;
        String redirect = servletRequest.getParameter("redirect");
        if (redirect == null) {
            return null;
        }
        boolean bl = isThirdApp = redirect.contains("apptype") && redirect.contains("hideDataCenter");
        if (userId == null || !isThirdApp) {
            return null;
        }
        Map<String, String> params = this.getRequestParams(redirect);
        return this.thirdAppsServiceExt.afterLoginApps(userId, params.get("apptype"), params.get("entryRole"));
    }

    private String createAppsSessionId(HttpServletRequest request, HttpServletResponse response, String userId) {
        Lang lang = LoginLangUtils.getLoginLanguage(request);
        Map<String, String> userInfo = this.getUserInfoById(userId, lang);
        userInfo.put("appType", request.getParameter("apptype"));
        userInfo.put("lightAppId", request.getParameter("lightAppId"));
        userInfo.put("thirdAppTypeID", String.valueOf(ThirdAppService.getThirdAppUserType(request.getParameter("entryRole"))));
        return this.getHandleSessionId(request, response, userInfo);
    }

    @Override
    public String getThirdSessionId(HttpServletRequest request, HttpServletResponse response, String thirdAppUserId) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)thirdAppUserId)) {
            return this.createAppsSessionId(request, response, thirdAppUserId);
        }
        return this.thirdAppLogin(request, response);
    }

    @Override
    public Map<String, String> getThirdAppUserInfo(HttpServletRequest request) {
        return this.getUserInfo(request);
    }

    @Override
    public String getThirdSessionId(HttpServletRequest request, HttpServletResponse response, Map<String, String> thirdAppUser) {
        if (thirdAppUser != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)thirdAppUser.get("fid"))) {
            return this.getHandleSessionId(request, response, thirdAppUser);
        }
        return this.thirdAppLogin(request, response);
    }

    private Map<String, String> getUserInfoById(String userId, Lang lang) {
        Account account = LoginAccountFactory.createInstanceByRequestContext(Optional.empty()).getAccount();
        Map<String, String> infoByUserId = LoginUserService.getErpUserInfoByUserId(account, userId, lang.name());
        return infoByUserId;
    }

    private Map<String, String> getRequestParams(String redirect) {
        HashMap<String, String> hashMap = new HashMap<String, String>(8);
        if (redirect.indexOf("?") != -1) {
            String[] str;
            for (String s : str = redirect.split("[?]")[1].split("&")) {
                String[] strings = s.split("=");
                if (strings.length <= 1) continue;
                hashMap.put(strings[0], strings[1]);
            }
        }
        return hashMap;
    }

    private String addUrlParams(String url, boolean hasParams, String params) {
        if (hasParams) {
            return url + "&" + params;
        }
        return url + "?" + params;
    }

    private ThirdAppAuthtication getAuthtication(HttpServletRequest request) {
        ThirdAppAuthtication authtication = null;
        Set<String> allAppAuthtication = this.getAppConfig(request);
        Account currentAccount = LoginAccountFactory.createInstanceByHttpRequest(request, Optional.empty()).getAccount();
        for (String appAuth : allAppAuthtication) {
            try {
                authtication = (ThirdAppAuthtication)Class.forName(appAuth).newInstance();
                if (!this.isNeedHandle(request, currentAccount, authtication)) continue;
                break;
            }
            catch (Exception e) {
                log.error(ResManager.loadKDString((String)"\u7cfb\u7edf\u9519\u8bef\uff0c\u7b2c\u4e09\u65b9\u6821\u9a8c\u5668\u914d\u7f6e\u4e0d\u6b63\u786e\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002\n", (String)"LoginFilter_6", (String)BOS_LOGIN, (Object[])new Object[0]) + e);
            }
        }
        return authtication;
    }

    private String getHandleSessionId(HttpServletRequest request, HttpServletResponse response, Map<String, String> userInfo) {
        Lang lang = LoginLangUtils.getLoginLanguage(request);
        String ticket = request.getParameter(HCODE_TICKET);
        Account currentCenter = LoginAccountFactory.createInstanceByHttpRequest(request, Optional.empty()).getAccount();
        String appId = this.getAPPId(request);
        HashMap<String, String> appLoginInfo = new HashMap<String, String>(16);
        appLoginInfo.put("yzjAppId", appId);
        appLoginInfo.put("yzjAppTicket", ticket);
        LoginClientEnum loginClient = LoginClientEnum.WEB;
        if (AgentUtil.isMobile(request)) {
            loginClient = LoginClientEnum.MOBILE;
        }
        SessionParams sessionParams = new SessionParams();
        sessionParams.setMpUser(userInfo);
        sessionParams.setLang(lang);
        sessionParams.setIP(NetAddressUtils.getRemoteHost((HttpServletRequest)request));
        sessionParams.setCopyToClient(true);
        sessionParams.setClientEnum(loginClient);
        sessionParams.setAppType(userInfo.get("appType"));
        sessionParams.setTimeOut(SessionDAO.getSessionTimeout((String)currentCenter.getTenantId()));
        sessionParams.setLightAppId(userInfo.get("lightAppId"));
        sessionParams.setThirdAppTypeID(userInfo.get("thirdAppTypeID"));
        String globalSessionId = this.sessionService.createNewSession(request, response, currentCenter, sessionParams);
        log.info("clienttype  :" + (Object)((Object)loginClient) + ",username:" + userInfo.get("userName") + ",url:" + request.getRemoteAddr() + "apptype\uff1a+" + userInfo.get("appType"));
        Map cacheKey = CacheLoginData.getCache((String)CacheLoginData.getType4YzjEKey((String)currentCenter.getAccountId()));
        if (cacheKey == null || cacheKey.size() == 0) {
            HashMap<String, String> mpYzjEidKeyData = new HashMap<String, String>();
            mpYzjEidKeyData.put("Eid", currentCenter.getEid());
            mpYzjEidKeyData.put("KeyData", currentCenter.getKeyFile());
            CacheLoginData.setAttributes((String)CacheLoginData.getType4YzjEKey((String)currentCenter.getAccountId()), mpYzjEidKeyData);
            log.info("@Yunzhijia_Login...\u5b8c\u6210\u7f13\u5b58\u79df\u6237\u7684Eid\u548cKey\u6587\u4ef6\u3002");
        }
        return globalSessionId;
    }

    public String getAPPId(HttpServletRequest request) {
        String appId = request.getParameter("client_id");
        if (StringUtils.isEmpty(appId) && StringUtils.isEmpty(appId = request.getParameter("appid"))) {
            appId = request.getParameter("appId");
        }
        return appId;
    }

    private Map<String, String> getUserInfoByResult(HttpServletRequest request, AppAuthResult result) {
        Map<String, String> userInfo = null;
        Account currentCenter = LoginAccountFactory.createInstanceByHttpRequest(request, Optional.empty()).getAccount();
        Lang lang = LoginLangUtils.getLoginLanguage(request);
        switch (result.getUserType()) {
            case OPEN_ID: {
                userInfo = LoginUserService.getErpUserInfo(currentCenter, result.getUserFlag(), lang.name());
                break;
            }
            case YZJUID: 
            case UID: {
                userInfo = LoginUserService.getErpUserInfo(currentCenter, Long.parseLong(result.getUserFlag()), lang.name());
                break;
            }
            case MOBILE_PHONE: {
                userInfo = LoginUserService.getErpUserInfoByPhone(currentCenter, result.getUserFlag(), lang.name());
                break;
            }
            case USER_NAME: {
                userInfo = LoginUserService.getErpUserInfoByUserName(currentCenter, result.getUserFlag(), lang.name());
                break;
            }
            case EMAIL: {
                userInfo = LoginUserService.getErpUserInfoByEmail(currentCenter, result.getUserFlag(), lang.name());
                break;
            }
            case USER_ID: {
                userInfo = LoginUserService.getErpUserInfoByUserId(currentCenter, result.getUserFlag(), lang.name());
                break;
            }
            case WORKER_NUMBER: {
                userInfo = LoginUserService.getErpUserInfoByNumber(currentCenter, result.getUserFlag(), lang.name());
                break;
            }
            default: {
                userInfo = null;
            }
        }
        if (userInfo == null || userInfo.size() == 0 || Constants.NO.equalsIgnoreCase(userInfo.get(SUCCESS))) {
            throw new KDException(Constants.KD_WEB_EXCEPTION, new Object[]{ResManager.loadKDString((String)"\u8be5\u8d26\u53f7\u4e0d\u53ef\u7528\uff0c\u53ef\u80fd\u7684\u539f\u56e0\u6709\uff1a1.\u8be5\u8d26\u53f7\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff1b2.\u8be5\u8d26\u53f7\u672a\u542f\u7528\u3002", (String)"ThirdAppsService_0", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
        userInfo.put("appType", result.getAppType());
        userInfo.put("lightAppId", result.getLightAppId());
        userInfo.put("thirdAppTypeID", result.getThirdAppTypeID());
        return userInfo;
    }

    private boolean checkResult(AppAuthResult result) {
        if (result == null) {
            throw new KDException(Constants.KD_WEB_EXCEPTION, new Object[]{ResManager.loadKDString((String)"%s\u7b2c\u4e09\u65b9\u5904\u7406\u5668\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"LoginFilter_8", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
        boolean isSuccess = result.isSucceed();
        String errorMessage = result.getErrorMessage();
        if (!isSuccess) {
            log.info(errorMessage);
        } else if (result.getUserType() == null || StringUtils.isEmpty(result.getUserFlag())) {
            throw new KDException(Constants.KD_WEB_EXCEPTION, new Object[]{String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u9519\u8bef\uff0c\u6821\u9a8c\u5668\u6ca1\u6709\u6b63\u786e\u8fd4\u56de\u7528\u6237\u7c7b\u578b", (String)"LoginFilter_9", (String)BOS_LOGIN, (Object[])new Object[0]), new Object[0])});
        }
        return isSuccess;
    }

    private AppAuthResult handleAppAuthtication(HttpServletRequest request, ThirdAppAuthtication authtication) {
        Account account = LoginAccountFactory.createInstanceByHttpRequest(request, Optional.empty()).getAccount();
        if (authtication != null) {
            return authtication.appAuthtication(request, account);
        }
        return null;
    }

    private boolean isNeedHandle(HttpServletRequest request, Account account, ThirdAppAuthtication authtication) {
        boolean isNeed;
        boolean returnValue = false;
        if (authtication != null && (isNeed = authtication.isNeedHandle(request, account))) {
            log.info(String.format("%s's isNeed=%s", authtication.getClass().toString(), isNeed));
            returnValue = true;
        }
        return returnValue;
    }

    private Set<String> getAppConfig(HttpServletRequest request) {
        Set<String> authticationPlugins = this.getThirdAppAuthtication();
        String tenantId = RevProxyUtil.getTenantCode((HttpServletRequest)request);
        String allAppAuthtication = System.getProperty(tenantId + "_" + "authtication.apps");
        if (StringUtils.isEmpty(allAppAuthtication)) {
            allAppAuthtication = System.getProperty("authtication.apps");
        }
        if (StringUtils.isNotEmpty(allAppAuthtication)) {
            String[] allAppAuthticationArr = allAppAuthtication.split(",");
            Set mcAppAuthtications = Stream.of(allAppAuthticationArr).collect(Collectors.toSet());
            authticationPlugins.addAll(mcAppAuthtications);
        }
        authticationPlugins.add(this.getSkyAuthtication());
        return authticationPlugins;
    }

    private Set<String> getThirdAppAuthtication() {
        HashSet<String> authtications = new HashSet<String>(4);
        try {
            QFilter imtypeFilter = new QFilter("imtype", "in", Arrays.asList(2, 3, 4, 6));
            Map pluginDatas = BusinessDataServiceHelper.loadFromCache((String)"bos_thirdapp_plugin", (String)"imtype, pluginconfig, pluginname", (QFilter[])new QFilter[]{imtypeFilter});
            for (DynamicObject pluginData : pluginDatas.values()) {
                String authtication = null;
                String pluginconfig = pluginData.getString("pluginconfig");
                if ("1".equals(pluginconfig)) {
                    DynamicObject imtype = pluginData.getDynamicObject("imtype");
                    if (imtype != null) {
                        int id = imtype.getInt("id");
                        authtication = this.getThirdAppAuthticationByImType(id);
                    }
                } else if ("2".equals(pluginconfig)) {
                    authtication = pluginData.getString("pluginname");
                }
                if (authtication == null) continue;
                authtications.add(authtication);
            }
        }
        catch (Exception e) {
            log.info("get pluginDatas error", (Object)e);
        }
        return authtications;
    }

    private String getThirdAppAuthticationByImType(int imtype) {
        String thirdAppAuthtication = null;
        switch (imtype) {
            case 2: {
                thirdAppAuthtication = DDAuthticationPublic.class.getName();
                break;
            }
            case 3: {
                thirdAppAuthtication = WxqyhAuthtication.class.getName();
                break;
            }
            case 4: {
                thirdAppAuthtication = WeLinkAuthtication.class.getName();
                break;
            }
            case 6: {
                thirdAppAuthtication = FeiShuAuthtication.class.getName();
                break;
            }
        }
        return thirdAppAuthtication;
    }

    private String getSkyAuthtication() {
        return SkyAuthtication.class.getName();
    }
}

