/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.service.impl;

import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.api.model.Account;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.cache.LoginCacheService;
import kd.bos.login.service.ILoginAuthenticationService;
import kd.bos.openapi.base.security.api.impl.OpenApiAuthServiceImpl;
import kd.bos.openapi.security.auth.OpenApiAuthService;
import kd.bos.openapi.security.model.SsoIpInfoDto;
import kd.bos.session.SessionDAO;
import kd.bos.session.SessionDAOFactory;
import org.apache.commons.lang3.StringUtils;

public class LoginAuthenticationServiceImpl
implements ILoginAuthenticationService {
    private LoginCacheService cacheService = new LoginCacheService();
    private static Log logger = LogFactory.getLog(LoginAuthenticationServiceImpl.class);
    private OpenApiAuthService openApiAuthService = new OpenApiAuthServiceImpl();

    @Override
    public Map<String, Object> generateRedirectURL(HttpServletRequest servletRequest, Account currentCenter, String sessionId) {
        Map<String, Object> result = new HashMap<String, Object>(8);
        try {
            String redirectUri = servletRequest.getParameter("redirect_uri");
            if (StringUtils.isBlank((CharSequence)redirectUri)) {
                redirectUri = servletRequest.getParameter("redirect");
            }
            if (StringUtils.isBlank((CharSequence)redirectUri)) {
                result.put("message", "redirect is null");
                return result;
            }
            redirectUri = URLDecoder.decode(redirectUri, "UTF-8");
            String appId = servletRequest.getParameter("app_client_id");
            if (StringUtils.isBlank((CharSequence)appId) && redirectUri.contains("app_client_id=")) {
                appId = this.getParam(redirectUri, "app_client_id=");
            }
            if (StringUtils.isBlank((CharSequence)appId)) {
                result.put("message", "app_client_id is null");
                return result;
            }
            if (!this.checkReliableRedirect(appId, redirectUri)) {
                result.put("message", ResManager.loadKDString((String)"redirect\u975e\u53ef\u4fe1\u8df3\u8f6c\u5730\u5740\u3002", (String)"LoginAuthenticationServiceImpl_1", (String)"bos-login", (Object[])new Object[0]));
                return result;
            }
            SessionDAO sessionDAO = SessionDAOFactory.getSessionDAO((String)sessionId);
            String userId = sessionDAO.getAttribute("userId");
            result = this.generateAuthorizaCode(servletRequest, currentCenter, userId);
            if (result != null && "0".equals(result.get("errorCode"))) {
                redirectUri = redirectUri.contains("?") ? redirectUri + "&code=" : redirectUri + "?code=";
                redirectUri = redirectUri + result.get("code");
                result.put("redirectUri", redirectUri);
            }
        }
        catch (Exception e) {
            result.put("message", e.getMessage());
            logger.info("kd.bos.login.service.impl.LoginAuthenticationServiceImpl.generateRedirectURL#error", (Object)e);
        }
        return result;
    }

    private boolean checkReliableRedirect(String appId, String redirectUri) {
        int length;
        if (StringUtils.isBlank((CharSequence)redirectUri)) {
            return false;
        }
        if (redirectUri.startsWith("https://")) {
            length = "https://".length();
            redirectUri = redirectUri.substring(length);
        } else if (redirectUri.startsWith("http://")) {
            length = "http://".length();
            redirectUri = redirectUri.substring(length);
        }
        List list = this.openApiAuthService.findSsoIpInfoByThirdAppNum(appId);
        for (SsoIpInfoDto ssoIpInfoDto : list) {
            if (!redirectUri.split("/")[0].equals(ssoIpInfoDto.getDomainIp())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<String, Object> generateAuthorizaCode(HttpServletRequest servletRequest, Account currentCenter, String userId) {
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        if (StringUtils.isBlank((CharSequence)userId)) {
            result.put("message", "session is invalid");
            return result;
        }
        String code = kd.bos.login.utils.StringUtils.randomWord(64);
        this.cacheService.put(code, userId, 300, TimeUnit.SECONDS);
        result.put("errorCode", "0");
        result.put("code", code);
        return result;
    }

    @Override
    public Map<String, Object> initThirdAppsConfig(String opType, String thirdAppsConfigData) {
        return null;
    }

    private String getParam(String redirect, String s) {
        String param = null;
        param = redirect.substring(redirect.indexOf(s));
        if (param.indexOf("&") >= 1) {
            param = param.substring(0, param.indexOf("&"));
        }
        param = param.substring(param.indexOf("=") + 1);
        return param;
    }
}

