/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.service.session;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.Map;
import java.util.Optional;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dc.api.model.Account;
import kd.bos.login.LoginClientEnum;
import kd.bos.login.service.session.dto.SessionParams;
import kd.bos.login.service.session.event.CreateSessionEvent;
import kd.bos.session.SessionDAO;
import kd.bos.session.SessionDAOFactory;
import kd.bos.session.SessionManager;
import org.apache.commons.lang3.StringUtils;

public class ApiSessionReusingManager {
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("API_SESSION_DATA", new DistributeCacheHAPolicy(true, true));

    @Subscribe
    @AllowConcurrentEvents
    public void recordSession(CreateSessionEvent event) {
        if (!this.validateForClient(event.getClientLevel1(), event.getClientLevel2())) {
            return;
        }
        if (!this.validateForPostData(event)) {
            return;
        }
        RequestParam requestParam = new RequestParam(event.getPostData(), event.getParams().getIP(), event.getCurrentCenter());
        if (!requestParam.validate()) {
            return;
        }
        cache.put(requestParam.getCacheKey(), (Object)event.getSessionId(), event.getParams().getTimeOut());
    }

    public Optional<String> tryReusingSession(Map<String, String> postData, SessionParams params, Account currentCenter) {
        if (postData == null || postData.isEmpty()) {
            return Optional.empty();
        }
        RequestParam requestParam = new RequestParam(postData, params.getIP(), currentCenter);
        if (!requestParam.validate()) {
            return Optional.empty();
        }
        String sessionId = (String)cache.get(requestParam.getCacheKey());
        if (StringUtils.isBlank((CharSequence)sessionId)) {
            return Optional.empty();
        }
        if (!this.existSessionInfo(sessionId)) {
            return Optional.empty();
        }
        SessionManager.touchSession((String)sessionId);
        this.touchReusingSession(requestParam.getCacheKey(), params.getTimeOut());
        return Optional.of(sessionId);
    }

    private boolean existSessionInfo(String sessionId) {
        SessionDAO sessionDAO = SessionDAOFactory.getSessionDAO((String)sessionId);
        String attribute = sessionDAO.getAttribute("tenantId");
        return StringUtils.isNotBlank((CharSequence)attribute);
    }

    private void touchReusingSession(String cacheKey, int timeOut) {
        cache.expireAfter(cacheKey, timeOut);
    }

    private boolean validateForPostData(CreateSessionEvent event) {
        Map<String, String> postData = event.getPostData();
        return postData != null && !postData.isEmpty();
    }

    private boolean validateForClient(LoginClientEnum clientLevel1, LoginClientEnum clientLevel2) {
        return LoginClientEnum.API == clientLevel1 && LoginClientEnum.NEWAPI != clientLevel2;
    }

    class RequestParam {
        private String accountId;
        private String appId;
        private String appSecuret;
        private String user;
        private String usertype;
        private String password;
        private String language;
        private String ip;

        public RequestParam(Map<String, String> postData, String ip, Account currentCenter) {
            this.accountId = currentCenter.getAccountId();
            this.appId = postData.get("appId");
            this.appSecuret = postData.get("appSecuret");
            this.user = postData.get("user");
            this.usertype = postData.get("usertype");
            this.password = postData.get("password");
            this.language = postData.get("language");
            this.ip = ip;
        }

        public boolean validate() {
            return !StringUtils.isBlank((CharSequence)this.accountId) && !StringUtils.isBlank((CharSequence)this.appId) && !StringUtils.isBlank((CharSequence)this.appSecuret) && !StringUtils.isBlank((CharSequence)this.user);
        }

        private String getCachePrefix() {
            return "apisession_reusing_";
        }

        public String getCacheKey() {
            return this.getCachePrefix() + String.format("_%s_%s_%s_%s_%s_%s", this.ip, this.accountId, this.appId, this.user, this.usertype, this.language);
        }
    }
}

