/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.service.session.impl;

import com.google.common.eventbus.EventBus;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.SessionIdUtils;
import kd.bos.context.RequestContextCreator;
import kd.bos.context.api.ApiContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.api.model.Account;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.CacheLoginData;
import kd.bos.login.LoginClientEnum;
import kd.bos.login.after.LoginAfterBase;
import kd.bos.login.service.DispatchServiceHelper;
import kd.bos.login.service.session.SessionService;
import kd.bos.login.service.session.dto.SessionParams;
import kd.bos.login.service.session.event.CreateSessionEvent;
import kd.bos.login.thirdauth.app.tencent.WxqyhLoginAfter;
import kd.bos.login.user.ConfigureationService;
import kd.bos.login.util.cache.CacheLoginUtils;
import kd.bos.login.utils.AgentUtil;
import kd.bos.login.utils.BeanUtils;
import kd.bos.login.utils.DateUtils;
import kd.bos.login.utils.JSONUtils;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.OnlineUserUtil;
import kd.bos.login.utils.SessionUtils;
import kd.bos.login.utils.StringUtils;
import kd.bos.login.utils.SystemPropertyUtils;
import kd.bos.login.utils.account.LoginAccountFactory;
import kd.bos.login.utils.log.LoginLogUtils;
import kd.bos.mservice.sysparam.SystemParamService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.session.SessionInfo;
import kd.bos.session.SessionManager;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.RevProxyUtil;

public class SessionServiceImpl
implements SessionService {
    private static final String FORGID = "forgid";
    private static final String FTRUENAME = "ftruename";
    private static final String FOPENID = "fopenid";
    private static final String USER_TYPE = "userType";
    private static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    private static final String BOS_LOGIN = "bos-login";
    private static Log logger = LogFactory.getLog(SessionServiceImpl.class);
    private EventBus eventBus = new EventBus();

    @Override
    public void listenSessionEvent(Object object) {
        this.eventBus.register(object);
    }

    @Override
    public String getSession(HttpServletRequest request, HttpServletResponse response, Account currentCenter, SessionParams params) {
        return this.createNewSession(request, response, currentCenter, params);
    }

    @Override
    public String createNewSession(HttpServletRequest request, HttpServletResponse response, Account currentCenter, SessionParams params) {
        String sessionId = this.createNewSession0(request, response, currentCenter, params);
        this.sendCreateSessionEvent(request, response, currentCenter, params, sessionId);
        return sessionId;
    }

    protected String createNewSession0(HttpServletRequest request, HttpServletResponse response, Account currentCenter, SessionParams params) {
        Map<String, String> userInfo = params.getMpUser();
        SessionInfo si = SessionServiceImpl.initLoginSession(currentCenter, params);
        si.setClient(this.getClientEnumLevel1(request, params).getDesc());
        si.setAppType(SessionServiceImpl.initAppType(params, request));
        String bizPartnerId = userInfo.get("fbizpartnerid");
        SessionServiceImpl.getSessionInfo(si, bizPartnerId);
        si.setThirdAppTypeID(params.getThirdAppTypeID());
        si.setLightAppId(params.getLightAppId());
        return this.getSessionId(request, response, params, si);
    }

    protected LoginClientEnum getClientEnumLevel1(HttpServletRequest request, SessionParams params) {
        LoginClientEnum clientEnum = params.getClientEnum();
        if (LoginClientEnum.WEB.equals((Object)clientEnum) && AgentUtil.isMobile(request)) {
            clientEnum = LoginClientEnum.MOBILE;
        }
        return LoginClientEnum.getClientForLevel1(clientEnum);
    }

    protected void sendCreateSessionEvent(HttpServletRequest request, HttpServletResponse response, Account currentCenter, SessionParams params, String sessionId) {
        CreateSessionEvent event = new CreateSessionEvent(sessionId, this.getClientEnumLevel1(request, params), params.getClientEnum(), params.getMpUser(), params, currentCenter);
        event.trySetPostData(request, response, this.getClientEnumLevel1(request, params));
        this.eventBus.post((Object)event);
    }

    private void saveCacheData(SessionParams params, String clientType) {
        try {
            HashMap<String, String> map = new HashMap<String, String>(8);
            map.put("sessionId", params.getSessionId());
            map.put("clientType", clientType);
            CacheLoginUtils.addList((String)params.getCacheKey(), (String[])new String[]{JSONUtils.toString(map)}, (int)(params.getTimeOut() * 2), (int)100);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    private static SessionInfo initLoginSession(Account currentCenter, SessionParams params) {
        SessionInfo si = new SessionInfo();
        Map<String, String> mpUser = params.getMpUser();
        si.setTenantId(currentCenter.getTenantId());
        si.setOrgId(mpUser.get(FORGID));
        si.setUserId(mpUser.get("fid"));
        si.setUserName(mpUser.get(FTRUENAME));
        si.setUserOpenId(mpUser.get(FOPENID));
        si.setUserType(mpUser.get(USER_TYPE));
        si.setLoginIP(params.getIP());
        si.setLanguage(params.getLang().toString());
        si.setUid(mpUser.get("fuid"));
        SessionServiceImpl.setApiClientContext(si);
        si.setAccountId(currentCenter.getAccountId());
        SimpleDateFormat df = new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS);
        si.setLoginTime(df.format(new Date()));
        return si;
    }

    private static void setApiClientContext(SessionInfo si) {
        ApiContext context;
        if ((LoginClientEnum.API.getDesc().equals(si.getClient()) || LoginClientEnum.WEBSERVICE.getDesc().equals(si.getClient())) && (context = ApiContext.get()) != null) {
            si.setApi3rdAppId(StringUtils.getStringValue(context.getAppId()));
            si.setApi3rdAppNum(context.getAppNum());
        }
    }

    private static void getSessionInfo(SessionInfo si, String bizPartnerId) {
        try {
            SystemParamService systemParamService = (SystemParamService)ServiceFactory.getService(SystemParamService.class);
            Object enableSwitchBizpartner = systemParamService.loadPublicParameterFromCache("enable_switch_bizpartner");
            if (enableSwitchBizpartner == null || !Boolean.parseBoolean(enableSwitchBizpartner.toString())) {
                return;
            }
            List bizPartnerIdList = UserServiceHelper.getBizPartnerByUserId((long)Long.parseLong(si.getUserId()));
            if (bizPartnerIdList != null && bizPartnerIdList.size() > 0 && (Long)bizPartnerIdList.get(0) != 0L) {
                if (kd.bos.util.StringUtils.isNotEmpty((String)bizPartnerId) && !bizPartnerId.equals("0")) {
                    if (bizPartnerIdList.contains(Long.parseLong(bizPartnerId))) {
                        si.setBizPartnerId(bizPartnerId);
                    } else {
                        si.setBizPartnerId(((Long)bizPartnerIdList.get(0)).toString());
                    }
                } else {
                    si.setBizPartnerId(((Long)bizPartnerIdList.get(0)).toString());
                }
            }
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u83b7\u53d6\u5546\u52a1\u5408\u4f5c\u4f19\u4f34\u5f02\u5e38", (Throwable)e);
        }
    }

    private String getSessionId(HttpServletRequest request, HttpServletResponse response, SessionParams params, SessionInfo si) {
        String sessionString = SessionServiceImpl.createNewSessionId(request, response, params, si);
        params.setSessionId(sessionString);
        Account currentCenter = LoginAccountFactory.createInstanceBySession(si, Optional.empty()).getAccount();
        LoginLogUtils.addLog(currentCenter, LoginLogUtils.initLoginLogInfo(si, params, "login"), sessionString, si);
        String clientType = SessionServiceImpl.doAppTypeEnum(params);
        String cacheKey = SessionServiceImpl.getCacheKeyByClient(si.getUserId(), si.getTenantId(), si.getAccountId());
        params.setCacheKey(cacheKey);
        SessionServiceImpl.removeOldUser(si, params, currentCenter);
        this.saveCacheData(params, clientType);
        SessionServiceImpl.handleAfterLogin(request, si, sessionString, params.isTemporaryLogin());
        return sessionString;
    }

    private static String doAppTypeEnum(SessionParams params) {
        String appType = params.getAppType();
        String clientType = params.getClientEnum().toString();
        if (null != appType) {
            return clientType + "-" + appType.toUpperCase();
        }
        return clientType;
    }

    private static void removeOldUser(SessionInfo si, SessionParams params, Account currentCenter) {
        try {
            boolean isNoNeed = SessionServiceImpl.getIsNoNeed(si, params);
            if (isNoNeed) {
                return;
            }
            String[] list = CacheLoginUtils.getList((String)params.getCacheKey());
            for (int i = list.length - 1; i >= 0; --i) {
                String userInfo = list[i];
                Map cast = JSONUtils.cast(userInfo, Map.class);
                String sessionId = (String)cast.get("sessionId");
                if (sessionId == null || !SessionServiceImpl.doAppTypeEnum(params).equals(cast.get("clientType")) || isNoNeed) continue;
                LoginLogUtils.addLog(currentCenter, LoginLogUtils.initLoginLogInfo(si, params, "remove"), sessionId, si);
                OnlineUserUtil.logout(sessionId);
                SessionManager.removeSession((String)sessionId);
                boolean multiLoginIp = SessionServiceImpl.getMultiLoginIp(currentCenter);
                String notifyMessage = multiLoginIp ? String.format(ResManager.loadKDString((String)"\u60a8\u7684\u8d26\u6237\u5df2\u4e8e%1s\u5728\u8bbe\u5907%2s\u767b\u5f55\uff0c\u60a8\u88ab\u8feb\u4e0b\u7ebf\u3002\u82e5\u975e\u672c\u4eba\u64cd\u4f5c\uff0c\u60a8\u7684\u767b\u5f55\u5bc6\u7801\u53ef\u80fd\u6cc4\u9732\uff0c\u8bf7\u53ca\u65f6\u4fee\u6539\u3002", (String)"SessionUtils_4", (String)BOS_LOGIN, (Object[])new Object[0]), DateUtils.getDateTime(), si.getLoginIP()) : String.format(ResManager.loadKDString((String)"\u60a8\u7684\u8d26\u6237\u5df2\u4e8e%s\u5728\u5176\u4ed6\u673a\u5668\u767b\u5f55\uff0c\u60a8\u88ab\u8feb\u4e0b\u7ebf\u3002\u82e5\u975e\u672c\u4eba\u64cd\u4f5c\uff0c\u60a8\u7684\u767b\u5f55\u5bc6\u7801\u53ef\u80fd\u6cc4\u9732\uff0c\u8bf7\u53ca\u65f6\u4fee\u6539\u3002", (String)"SessionUtils_7", (String)BOS_LOGIN, (Object[])new Object[0]), DateUtils.getDateTime());
                SessionServiceImpl.setLoginExitMessageBySessionId(sessionId, notifyMessage, SessionIdUtils.getTimeout((String)sessionId));
                CacheLoginUtils.removeListObject((String)params.getCacheKey(), (int)i);
            }
            SessionServiceImpl.releaseByReLogin(si, params);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    private static void releaseByReLogin(SessionInfo si, SessionParams params) {
        try {
            RequestContextCreator.createForOnlySesssion((String)params.getSessionId(), (SessionInfo)si, (String)params.getClientEnum().toString());
            DispatchServiceHelper.invokeBOSService("DataMutexService", "releaseByReLogin", new Object[0]);
        }
        catch (Exception e) {
            logger.error("\u7f51\u7edc\u4e92\u65a5\u9501\u91ca\u653e\u5931\u8d25", (Throwable)e);
        }
        catch (Error er) {
            logger.error("\u7f51\u7edc\u4e92\u65a5\u9501\u91ca\u653e\u5931\u8d25", (Throwable)er);
        }
    }

    private static String createNewSessionId(HttpServletRequest request, HttpServletResponse response, SessionParams params, SessionInfo si) {
        String sessionString = null;
        int timeOut = params.getTimeOut();
        sessionString = response == null ? SessionManager.newSession((SessionInfo)si, (int)timeOut) : SessionManager.newSession((HttpServletRequest)request, (HttpServletResponse)response, (SessionInfo)si, (boolean)params.isCopyToClient());
        return sessionString;
    }

    private static void handleAfterLogin(HttpServletRequest request, SessionInfo si, String sessionString, boolean temporaryLogin) {
        si.setGloableSessionId(sessionString);
        String loginAfterClasses = SystemPropertyUtils.getProptyByTenant("login.after.handle.classes", RevProxyUtil.getTenantCode((HttpServletRequest)request));
        if (kd.bos.util.StringUtils.isNotEmpty((String)loginAfterClasses)) {
            String[] classes;
            for (String loginClass : classes = loginAfterClasses.split(",")) {
                try {
                    LoginAfterBase loginHandler = (LoginAfterBase)BeanUtils.getBean(loginClass.trim());
                    loginHandler.handling(request, si);
                }
                catch (Exception e) {
                    logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                    try {
                        SessionManager.removeSession((String)sessionString);
                    }
                    catch (Exception ex) {
                        logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)ex));
                    }
                    throw e;
                }
            }
        }
        if (!temporaryLogin) {
            WxqyhLoginAfter wxqyhLoginAfter = new WxqyhLoginAfter();
            ((LoginAfterBase)wxqyhLoginAfter).handling(request, si);
        }
    }

    public static void setLoginExitMessageBySessionId(String sessionId, String notifyMessage, int timeOut) {
        CacheLoginData.setAttribute((String)"", (String)LoginUtils.getExistsCachkey(sessionId), (String)notifyMessage, (int)timeOut);
    }

    private static boolean getMultiLoginIp(Account currentCenter) {
        Map<String, Object> commonParameters = ConfigureationService.getCommonParameters(currentCenter);
        Object multiLoginIp = commonParameters.get("multi_login_ip");
        if (null == multiLoginIp) {
            return false;
        }
        if (multiLoginIp instanceof Boolean) {
            return (Boolean)multiLoginIp;
        }
        return false;
    }

    public static boolean isMultiClientUserId(String tenantId, String userId) {
        String specailUserId = SystemPropertyUtils.getProptyByTenant("allow_multiclient_user_id", tenantId);
        return kd.bos.util.StringUtils.isNotEmpty((String)specailUserId) && specailUserId.equals(userId);
    }

    public static String getCacheKeyByClient(String session, String tenantId, String accountId, String clientType) {
        String sessionId = null;
        if (clientType != null && session != null) {
            sessionId = tenantId + accountId + "_" + session + "_" + clientType;
        }
        return sessionId;
    }

    public static String getCacheKeyByClient(String session, String tenantId, String accountId) {
        String sessionId = null;
        if (session != null) {
            sessionId = tenantId + accountId + "_" + session;
        }
        return sessionId;
    }

    public static boolean getIsNoNeed(SessionInfo si, SessionParams params) {
        boolean isNoNeed = false;
        try {
            String needString = System.getProperty(si.getTenantId() + "_" + "login.session.terminalLimit");
            if (kd.bos.util.StringUtils.isEmpty((String)needString)) {
                needString = System.getProperty("login.session.terminalLimit");
            }
            isNoNeed = StringUtils.getBooleanValue(needString);
            if (LoginClientEnum.API == params.getClientEnum() || LoginClientEnum.WEBSERVICE == params.getClientEnum() || "YZJAPI".equals(params.getAppType()) || "YZJ".equalsIgnoreCase(params.getAppType())) {
                isNoNeed = true;
            }
            if (params.isNeedMutilClient()) {
                isNoNeed = true;
            }
            if (!isNoNeed) {
                if ("-1".equals(si.getUserId()) || "0".equals(si.getUserId())) {
                    isNoNeed = true;
                }
                if (SessionUtils.isMultiClientUserId(si.getTenantId(), si.getUserId())) {
                    isNoNeed = true;
                }
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return isNoNeed;
    }

    private static String initAppType(SessionParams params, HttpServletRequest request) {
        String appType = params.getAppType();
        if (null != appType) {
            return appType.toUpperCase();
        }
        if (request.getHeader("User-Agent") != null && request.getHeader("User-Agent").toUpperCase(Locale.ENGLISH).contains("DINGTALK")) {
            String type = "dd";
            params.setAppType(type);
            return type.toUpperCase();
        }
        if (AgentUtil.isMobile(request)) {
            return LoginClientEnum.MOBILE.getDesc().toUpperCase();
        }
        return null;
    }
}

