/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.spi;

import java.util.Iterator;
import java.util.ServiceLoader;
import kd.bos.exception.KDException;
import kd.bos.exception.LoginErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.authorize.ApiAuthService;
import kd.bos.service.authorize.auth.ApiAuthorizeService;

public class OpenApiServiceManager {
    private static Log log = LogFactory.getLog(OpenApiServiceManager.class);
    private static ApiAuthService apiAuthService = (ApiAuthService)OpenApiServiceManager.loadService(ApiAuthService.class);
    private static ApiAuthorizeService apiAuthorizeService = (ApiAuthorizeService)OpenApiServiceManager.loadService(ApiAuthorizeService.class);

    private static Object loadService(Class<?> clazz) {
        ServiceLoader<?> loadedService = ServiceLoader.load(clazz);
        Iterator<?> serviceIterator = loadedService.iterator();
        if (serviceIterator.hasNext()) {
            return serviceIterator.next();
        }
        throw new KDException(LoginErrorCode.loginBizException, new Object[]{"Cannot found ServiceImpl:" + clazz.getCanonicalName()});
    }

    public static ApiAuthService getApiAuthService() {
        if (apiAuthService == null) {
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{"An error occurred while getting the ApiAuthService."});
        }
        return apiAuthService;
    }

    public static ApiAuthorizeService getApiAuthorizeService() {
        if (apiAuthorizeService == null) {
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{"An error occurred while getting the ApiAuthorizeService."});
        }
        return apiAuthorizeService;
    }
}

