/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.sso;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.mc.LoginMCService;
import kd.bos.dc.mc.tenant.LptaParameter;
import kd.bos.entity.param.CustomParam;
import kd.bos.exception.KDException;
import kd.bos.exception.LoginErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.sso.LMBCSUtil;
import kd.bos.login.sso.LtpaToken;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.session.SystemPropertyUtils;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

public class LtpaTokenManager {
    private static Log logger = LogFactory.getLog(LtpaTokenManager.class);
    public static final String entityID_easconfig = "bas_easconfig";
    private static final String DOMINO_SECRET = "domino.secret";
    private static final String TOKEN_EXPIRATION = "token.expiration";
    private static final String ISLMBCSENCODE = "isLMBCSEncode";
    private static boolean existSSOConfig = true;
    private static Map<String, Map<String, String>> config = new ConcurrentHashMap<String, Map<String, String>>();
    private static Object lockObj = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generate(Account currentCenter, String user) {
        Map<String, String> tenantConfig = config.get(currentCenter.getAccountId());
        if (tenantConfig == null) {
            Object object = lockObj;
            synchronized (object) {
                try {
                    LtpaTokenManager.genTenantConfig(currentCenter);
                }
                catch (Exception e) {
                    throw new KDException(LoginErrorCode.loginBizException, new Object[]{e.getMessage()});
                }
            }
        }
        Date creationDate = new Date();
        Date expirationDate = new Date();
        tenantConfig = config.get(currentCenter.getAccountId());
        int interval = Integer.parseInt(tenantConfig.get(TOKEN_EXPIRATION));
        expirationDate.setTime(creationDate.getTime() + (long)(60000 * interval));
        return LtpaTokenManager.generate(currentCenter.getAccountId(), user, creationDate, expirationDate);
    }

    private static String generate(String tenantId, String user, Date tokenCreation, Date tokenExpires) {
        boolean isLMBCSEncode = false;
        Map<String, String> tenantConfig = config.get(tenantId);
        String isLMBC = tenantConfig.get(ISLMBCSENCODE);
        if (isLMBC != null && "true".equals(isLMBC)) {
            isLMBCSEncode = true;
        }
        return LtpaTokenManager.generate(tenantId, user, tokenCreation, tokenExpires, isLMBCSEncode);
    }

    private static String generate(String tenantId, String user, Date tokenCreation, Date tokenExpires, boolean isLMBCSEncode) {
        LtpaToken ltpa = new LtpaToken();
        Calendar calendar = Calendar.getInstance();
        MessageDigest md = ltpa.getMessageDigest();
        ltpa.setHeader(new byte[]{0, 1, 2, 3});
        if (isLMBCSEncode) {
            try {
                ltpa.setUser(LMBCSUtil.getLMBCSLocalGroupBytes(user));
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Throwable)e);
            }
        } else {
            try {
                ltpa.setUser(user.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                ltpa.setUser(user.getBytes());
            }
        }
        byte[] token = null;
        calendar.setTime(tokenCreation);
        ltpa.setCreation(Long.toHexString(calendar.getTime().getTime() / 1000L).toUpperCase().getBytes());
        calendar.setTime(tokenExpires);
        ltpa.setExpires(Long.toHexString(calendar.getTime().getTime() / 1000L).toUpperCase().getBytes());
        token = LMBCSUtil.concatenate(token, ltpa.getHeader());
        token = LMBCSUtil.concatenate(token, ltpa.getCreation());
        token = LMBCSUtil.concatenate(token, ltpa.getExpires());
        token = LMBCSUtil.concatenate(token, ltpa.getUser());
        md.update(token);
        Map<String, String> tenantConfig = config.get(tenantId);
        byte[] digest = md.digest(Base64.decodeBase64((String)tenantConfig.get(DOMINO_SECRET)));
        ltpa.setDigest(digest);
        token = LMBCSUtil.concatenate(token, digest);
        String tokenStr = Base64.encodeBase64String((byte[])token);
        StringBuilder result = new StringBuilder();
        StringTokenizer st = new StringTokenizer(tokenStr);
        while (st.hasMoreTokens()) {
            result.append(st.nextToken());
        }
        return new LtpaToken(result.toString()).toString();
    }

    private static boolean isValid(String tenantId, String ltpaToken) {
        Map<String, String> tenantConfig;
        if (!existSSOConfig) {
            return false;
        }
        LtpaToken ltpa = new LtpaToken(LtpaToken.decodeToken(ltpaToken));
        boolean result = ltpa.isValid((tenantConfig = config.get(tenantId)).get(DOMINO_SECRET));
        if (!result) {
            logger.error("LTPA token compare false");
        }
        return result;
    }

    private static boolean compare(String tenantId, String token, String userNumber) {
        boolean result = false;
        LtpaToken lt = new LtpaToken(LtpaToken.decodeToken(token));
        String username = lt.getUsername();
        boolean bl = result = username == null ? false : username.equals(userNumber);
        if (!result) {
            logger.info("LTPA token compare false, userName: " + userNumber);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean verifyToken(Account currentCenter, String token, String userNumber) {
        Map<String, String> tenantConfig = config.get(currentCenter.getAccountId());
        if (tenantConfig == null || StringUtils.isBlank((CharSequence)tenantConfig.get(DOMINO_SECRET))) {
            Object object = lockObj;
            synchronized (object) {
                try {
                    LtpaTokenManager.genTenantConfig(currentCenter);
                }
                catch (Exception e) {
                    throw new KDException(LoginErrorCode.loginBizException, new Object[]{e.getMessage()});
                }
            }
        }
        boolean result = false;
        boolean isValid = LtpaTokenManager.isValid(currentCenter.getAccountId(), LtpaToken.decodeToken(token));
        if (isValid) {
            result = LtpaTokenManager.compare(currentCenter.getAccountId(), LtpaToken.decodeToken(token), userNumber);
            if (!result) {
                logger.info("LTPA token compare false, userName: " + userNumber);
            }
        } else {
            logger.info("LTPA token isValid false,userName: " + userNumber);
        }
        return result;
    }

    private static void genTenantConfig(Account currentAccount) {
        LptaParameter para = LoginMCService.create().getLptaParameter(currentAccount);
        if (para != null) {
            ConcurrentHashMap<String, String> tenantConfig = new ConcurrentHashMap<String, String>(3);
            String str = "";
            try {
                str = LtpaTokenManager.getLtpaAuthConfig(currentAccount);
            }
            catch (Exception e) {
                logger.info("genTenantConfig", (Object)e);
                str = para.getSecret();
            }
            tenantConfig.put(DOMINO_SECRET, str);
            tenantConfig.put(TOKEN_EXPIRATION, para.getExpiration());
            tenantConfig.put(ISLMBCSENCODE, para.getIsLMBCSEncode());
            config.put(currentAccount.getAccountId(), tenantConfig);
        }
    }

    private static String getLtpaAuthConfig(Account currentAccount) {
        String str = SystemPropertyUtils.getProptyByTenant((String)"bos_svc_ltpa_auth_config", (String)currentAccount.getTenantId());
        if (StringUtils.isNotBlank((CharSequence)str)) {
            return str;
        }
        CustomParam customParam = new CustomParam();
        HashSet<String> keySet = new HashSet<String>(8);
        keySet.add("bos_svc_ltpa_auth_config");
        customParam.setSearchKeySet(keySet);
        Map map = SystemParamServiceHelper.loadCustomParameterFromCache((CustomParam)customParam);
        if (map == null || map.size() <= 0) {
            return "";
        }
        str = (String)map.get("bos_svc_ltpa_auth_config");
        if (StringUtils.isBlank((CharSequence)str)) {
            return "";
        }
        return str;
    }
}

