/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.sso;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.encrypt.Encrypters;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.filter.LoginManage;
import kd.bos.login.model.SSOAuthConfig;
import kd.bos.login.service.ThirdAppService;
import kd.bos.login.thirdauth.ThirdSSOAuthHandler;
import kd.bos.login.thirdauth.UserAuthResult;
import kd.bos.login.thirdauth.UserProperType;
import kd.bos.url.UrlService;
import kd.bos.util.DisCardUtil;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.JSONUtils;
import org.apache.commons.lang3.StringUtils;

public class MultiTenantSSOAuth
implements ThirdSSOAuthHandler {
    private static final Log logger = LogFactory.getLog(MultiTenantSSOAuth.class);

    @Override
    public void callTrdSSOLogin(HttpServletRequest servletRequest, HttpServletResponse servletResponse, String backUrl) {
        try {
            SSOAuthConfig ssoAuthConfig = ThirdAppService.getThirdSSOAuthConfig(null, null, "1");
            if (ssoAuthConfig != null && StringUtils.isNotBlank((CharSequence)ssoAuthConfig.getUrl())) {
                StringBuilder url = new StringBuilder();
                url.append(UrlService.getDomainContextUrl()).append("/index.html?");
                if (StringUtils.isNotBlank((CharSequence)servletRequest.getQueryString())) {
                    url.append(servletRequest.getQueryString());
                }
                url.append("&app_client_id=").append(ssoAuthConfig.getAppId()).append("&thirdAccountId=").append(ssoAuthConfig.getAccountId()).append("&response_code=code");
                servletResponse.sendRedirect(ssoAuthConfig.getUrl() + "/login.html?redirect=" + URLEncoder.encode(url.toString(), "UTF-8"));
                return;
            }
            LoginManage loginManage = new LoginManage();
            loginManage.redirectToStandardLogin(servletRequest, servletResponse);
        }
        catch (IOException e) {
            DisCardUtil.discard();
        }
    }

    @Override
    public UserAuthResult getTrdSSOAuth(HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        UserAuthResult userAuthResult = new UserAuthResult();
        userAuthResult.setSucess(false);
        SSOAuthConfig ssoAuthConfig = ThirdAppService.getThirdSSOAuthConfig(servletRequest.getParameter("app_client_id"), servletRequest.getParameter("thirdAccountId"), null);
        try {
            Map result;
            Map result2;
            HashMap headerParam = new HashMap(8);
            HashMap<String, String> body = new HashMap<String, String>(8);
            body.put("user", ssoAuthConfig.getThirdUser());
            body.put("usertype", "UserName");
            String appId = ssoAuthConfig.getAppId();
            body.put("appId", appId);
            String thirdAccountId = ssoAuthConfig.getAccountId();
            body.put("accountId", thirdAccountId);
            String appSecuret = ssoAuthConfig.getAppSecret();
            if (Encrypters.isEncrypted((String)appSecuret)) {
                appSecuret = Encrypters.decode((String)appSecuret);
            }
            body.put("appSecuret", appSecuret);
            String token = "";
            String resp = HttpClientUtils.postAppJson((String)(ssoAuthConfig.getUrl() + "/api/login.do"), headerParam, body, (int)5000, (int)6000);
            if (StringUtils.isNotEmpty((CharSequence)resp) && (result2 = (Map)JSONUtils.cast((String)resp, HashMap.class, (boolean)true)).get("data") != null) {
                Map tokenData = (Map)result2.get("data");
                token = tokenData.get("access_token").toString();
            }
            String code = servletRequest.getParameter("code");
            resp = HttpClientUtils.get((String)(ssoAuthConfig.getUrl() + "/kapi/v2/secm/authen/getUserInfo?code=" + code + "&access_token=" + token + "&accountId=" + thirdAccountId));
            if (StringUtils.isNotEmpty((CharSequence)resp) && (result = (Map)JSONUtils.cast((String)resp, HashMap.class, (boolean)true)).get("data") != null) {
                Map data = (Map)result.get("data");
                if ((userAuthResult = this.handleUserAuthResult(userAuthResult, data, ssoAuthConfig)).getUser() == null || StringUtils.isBlank((CharSequence)userAuthResult.getUser().toString())) {
                    userAuthResult.setSucess(false);
                    return userAuthResult;
                }
                userAuthResult.setSucess(true);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return userAuthResult;
    }

    private UserAuthResult handleUserAuthResult(UserAuthResult userAuthResult, Map<String, Object> data, SSOAuthConfig ssoAuthConfig) {
        if (StringUtils.isBlank((CharSequence)ssoAuthConfig.getUserFlag())) {
            return userAuthResult;
        }
        switch (ssoAuthConfig.getUserFlag()) {
            case "0": {
                userAuthResult.setUserType(UserProperType.UserName);
                userAuthResult.setUser(data.get("userName"));
                break;
            }
            case "1": {
                userAuthResult.setUserType(UserProperType.Mobile);
                userAuthResult.setUser(data.get("mobile"));
                break;
            }
            case "2": {
                userAuthResult.setUserType(UserProperType.Email);
                userAuthResult.setUser(data.get("email"));
                break;
            }
            case "3": {
                userAuthResult.setUserType(UserProperType.WorkerNumber);
                userAuthResult.setUser(data.get("workNumber"));
            }
        }
        return userAuthResult;
    }
}

