/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.thirdauth;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.zip.Inflater;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.DatatypeConverter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import org.jasig.cas.client.util.XmlUtils;

public class SingleSignOutHandler {
    private static Log logger = LogFactory.getLog(SingleSignOutHandler.class);
    private static SingleSignOutHandler ssoHandler;
    private static final int DECOMPRESSION_FACTOR = 10;
    private String logoutParameterName = "logoutRequest";
    private List<String> safeParameters = Collections.singletonList(this.logoutParameterName);
    private String logoutCallbackPath;

    public static SingleSignOutHandler getSingleSignOutHandler() {
        if (ssoHandler == null) {
            ssoHandler = new SingleSignOutHandler();
        }
        return ssoHandler;
    }

    private SingleSignOutHandler() {
    }

    public boolean isLogoutRequest(HttpServletRequest request) {
        if ("POST".equalsIgnoreCase(request.getMethod())) {
            return !this.isMultipartRequest(request) && this.pathEligibleForLogout(request) && StringUtils.isNotEmpty((String)this.safeGetParameter(request, this.logoutParameterName, this.safeParameters));
        }
        if ("GET".equalsIgnoreCase(request.getMethod())) {
            return StringUtils.isNotEmpty((String)this.safeGetParameter(request, this.logoutParameterName, this.safeParameters));
        }
        return false;
    }

    private boolean isMultipartRequest(HttpServletRequest request) {
        return request.getContentType() != null && request.getContentType().toLowerCase(Locale.ENGLISH).startsWith("multipart");
    }

    private boolean pathEligibleForLogout(HttpServletRequest request) {
        return this.logoutCallbackPath == null || this.logoutCallbackPath.equals(this.getPath(request));
    }

    public String safeGetParameter(HttpServletRequest request, String parameter, List<String> parameters) {
        if ("POST".equals(request.getMethod()) && parameters.contains(parameter)) {
            return request.getParameter(parameter);
        }
        return request.getQueryString() == null || !request.getQueryString().contains(parameter) ? null : request.getParameter(parameter);
    }

    public String safeGetParameter(HttpServletRequest request, String parameter) {
        return this.safeGetParameter(request, parameter, Collections.singletonList("logoutRequest"));
    }

    private String getPath(HttpServletRequest request) {
        return request.getPathInfo();
    }

    public String getLogoutTicket(HttpServletRequest request) {
        String logoutTicket = "";
        String logoutMessage = this.safeGetParameter(request, this.logoutParameterName, this.safeParameters);
        if (!StringUtils.isEmpty((String)logoutMessage)) {
            String token;
            if (!logoutMessage.contains("SessionIndex")) {
                logoutMessage = this.uncompressLogoutMessage(logoutMessage);
            }
            logger.debug(String.format("Logout request:\n%s", logoutMessage));
            logoutTicket = token = XmlUtils.getTextForElement((String)logoutMessage, (String)"SessionIndex");
        }
        return logoutTicket;
    }

    private String uncompressLogoutMessage(String originalMessage) {
        byte[] binaryMessage = DatatypeConverter.parseBase64Binary((String)originalMessage);
        Inflater decompresser = null;
        try {
            decompresser = new Inflater();
            decompresser.setInput(binaryMessage);
            byte[] result = new byte[binaryMessage.length * 10];
            int resultLength = decompresser.inflate(result);
            String string = new String(result, 0, resultLength, "UTF-8");
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (decompresser != null) {
                decompresser.end();
            }
        }
    }
}

