/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.thirdauth.app.dingding;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import kd.bos.dc.api.model.Account;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.thirdauth.app.AppAuthResult;
import kd.bos.login.thirdauth.app.ThirdAppAuthtication;
import kd.bos.login.thirdauth.app.UserType;
import kd.bos.login.thirdauth.app.dingding.DDErrorMsg;
import kd.bos.login.thirdauth.app.dingding.DDUtils;
import kd.bos.login.utils.StringUtils;
import kd.bos.login.utils.log.ThirdAppLogInfo;
import kd.bos.login.utils.log.ThirdAppLogUtils;
import kd.bos.util.RevProxyUtil;

public class DDAuthticationPublic
extends ThirdAppAuthtication {
    private static final String ERRMSG = "errmsg";
    private static Log logger = LogFactory.getLog(DDAuthticationPublic.class);

    @Override
    public boolean isNeedHandle(HttpServletRequest request, Account currentCenter) {
        String app_type = request.getParameter("apptype");
        String code = request.getParameter("code");
        return !StringUtils.isEmpty(app_type) && app_type.equalsIgnoreCase("dd") && !StringUtils.isEmpty(code);
    }

    @Override
    public AppAuthResult appAuthtication(HttpServletRequest request, Account currentCenter) {
        AppAuthResult result = new AppAuthResult();
        result.setSucceed(false);
        String app_type = request.getParameter("apptype");
        if (StringUtils.isEmpty(app_type)) {
            return result;
        }
        String code = request.getParameter("code");
        if (StringUtils.isEmpty(code)) {
            result.setErrorMessage("code is null");
            return result;
        }
        String appkey = request.getParameter("appkey");
        String corpid = request.getParameter("corpid");
        try {
            String tenant = RevProxyUtil.getTenantCode((HttpServletRequest)request);
            String reurnType = DDUtils.getLoginType(currentCenter, tenant);
            if (StringUtils.isEmpty(appkey)) {
                throw new KDException(new ErrorCode("DDErrorMsg_2", DDErrorMsg.getCodeMsg("DDErrorMsg_2")), new Object[0]);
            }
            if (!DDUtils.isDDEnable(appkey)) {
                throw new KDException(new ErrorCode("DDErrorMsg_9", DDErrorMsg.getCodeMsg("DDErrorMsg_9")), new Object[0]);
            }
            String appsecret = request.getParameter("appsecret");
            if (StringUtils.isEmpty(appsecret) && StringUtils.isEmpty(appsecret = StringUtils.getTrimedBlank(DDUtils.getAppSecret(appkey, currentCenter)))) {
                throw new KDException(new ErrorCode("DDErrorMsg_3", DDErrorMsg.getCodeMsg("DDErrorMsg_3")), new Object[0]);
            }
            String access_token = DDUtils.getAccessTokenWithException(appkey, appsecret, currentCenter);
            if (StringUtils.isEmpty(access_token)) {
                throw new KDException(new ErrorCode("DDErrorMsg_4", DDErrorMsg.getCodeMsg("DDErrorMsg_4")), new Object[0]);
            }
            logger.info("dd: code is : " + code);
            String userId = DDUtils.getUserIdWithEcception(access_token, code, currentCenter);
            if (StringUtils.isEmpty(userId)) {
                logger.info("dd\uff1auserId is null !");
                result.setErrorMessage("userId is null !");
                return result;
            }
            HashMap<String, Object> userMap = DDUtils.getUserInfo(access_token, userId, currentCenter);
            if (null == userMap) {
                throw new KDException(new ErrorCode("DDErrorMsg_6", DDErrorMsg.getCodeMsg("DDErrorMsg_6")), new Object[0]);
            }
            if (!"0".equals(userMap.get("errcode").toString())) {
                throw new KDException(new ErrorCode("DDErrorMsg_13", DDErrorMsg.getCodeMsg("DDErrorMsg_13")), new Object[]{userMap.get(ERRMSG).toString()});
            }
            return this.getAppAuthResult(reurnType, userMap, app_type);
        }
        catch (KDException kde) {
            ErrorCode errorCode = kde.getErrorCode();
            String resourceId = errorCode != null ? errorCode.getCode() : "";
            boolean codeExist = StringUtils.isNotEmpty(DDErrorMsg.getCodeMsg(resourceId));
            ThirdAppLogInfo thirdAppLogInfo = ThirdAppLogUtils.wrapThirdAppLogInfo(kde, request, codeExist);
            thirdAppLogInfo.setThirdType(2L);
            thirdAppLogInfo.setCorpid(corpid);
            thirdAppLogInfo.setAgentid(appkey);
            ThirdAppLogUtils.addLog(thirdAppLogInfo);
            result.setErrorMessage(kde.getMessage());
        }
        catch (Exception e) {
            logger.info("appAuthtication error", (Object)e);
            result.setErrorMessage(e.getMessage());
        }
        return result;
    }

    private AppAuthResult getAppAuthResult(String reurnType, HashMap<String, Object> userMap, String appType) {
        AppAuthResult result = new AppAuthResult();
        result.setSucceed(true);
        result.setAppType(appType);
        if ("email".equalsIgnoreCase(reurnType)) {
            String email = StringUtils.getStringValue(userMap.get("orgEmail"));
            if (StringUtils.isEmpty(email)) {
                email = StringUtils.getStringValue(userMap.get("email"));
            }
            if (StringUtils.isEmpty(email)) {
                throw new KDException(new ErrorCode("DDErrorMsg_7", DDErrorMsg.getCodeMsg("DDErrorMsg_7")), new Object[0]);
            }
            result.setUserFlag(email);
            result.setUserType(UserType.EMAIL);
            return result;
        }
        String mobile = StringUtils.getStringValue(userMap.get("mobile"));
        if (StringUtils.isEmpty(mobile)) {
            throw new KDException(new ErrorCode("DDErrorMsg_8", DDErrorMsg.getCodeMsg("DDErrorMsg_8")), new Object[0]);
        }
        result.setUserFlag(mobile);
        result.setUserType(UserType.MOBILE_PHONE);
        return result;
    }
}

