/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.thirdauth.app.dingding;

import com.alibaba.fastjson.JSON;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.dc.utils.MCDBUtil;
import kd.bos.dc.utils.SQLUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.thirdauth.app.dingding.DDAppInfo;
import kd.bos.login.thirdauth.app.dingding.DDErrorMsg;
import kd.bos.login.utils.ErrorCodeUtils;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.ParametersUtils;
import kd.bos.login.utils.account.LoginAccountFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.RevProxyUtil;

public class DDUtils {
    private static final String LOGGER_ACCESS_TOKEN_URL = "access_token_url : ";
    private static final String LOGGER_ACCESS_TOKEN_URL_RESPONSE = "access_token_url response: ";
    private static final String ERRCODE = "errcode";
    private static final String HCODE_ACCESS_TOKEN = "access_token";
    private static final String DDHOST = "ddhost";
    private static final String LOGIN_TYPE = "logintype";
    private static final String ERRMSG = "errmsg";
    private static Log logger = LogFactory.getLog(DDUtils.class);
    private static HashMap<String, String> access_token_Map = new HashMap();
    private static HashMap<String, Long> access_token_expires_Map = new HashMap();
    private static HashMap<String, Long> access_token_time_Map = new HashMap();
    private static HashMap<String, String> jsapi_ticket_Map = new HashMap();
    private static HashMap<String, Long> jsapi_ticket_expires_Map = new HashMap();
    private static HashMap<String, Long> jsapi_ticket_time_Map = new HashMap();
    private static Object lockObj = new Object();

    public static String getAccess_token(String appkey, String appsecret) {
        return DDUtils.getAccess_token(appkey, appsecret, RequestContext.get().getTenantId());
    }

    public static String getUserId(String access_token, String code) {
        return DDUtils.getUserId(access_token, code, RequestContext.get().getTenantId());
    }

    public static HashMap<String, Object> getUserInfo(String access_token, String userId) {
        return DDUtils.getUserInfo(access_token, userId, RequestContext.get().getTenantId());
    }

    @Deprecated
    public static String getDDHost(String tenant) {
        String host = "https://oapi.dingtalk.com";
        String hostString = System.getProperty(tenant + "_dingding_host");
        if (StringUtils.isEmpty((CharSequence)hostString)) {
            hostString = System.getProperty("dingding_host");
        }
        if (StringUtils.isNotEmpty((CharSequence)hostString)) {
            host = hostString;
        }
        return RevProxyUtil.addSlash((String)host);
    }

    public static String getDDHost(Account currentCenter, String tenant) {
        String host = DDUtils.getFromParameters(currentCenter);
        if (kd.bos.util.StringUtils.isEmpty((String)host)) {
            host = DDUtils.getDDHost(tenant);
        }
        return RevProxyUtil.addSlash((String)host);
    }

    private static String getFromParameters(Account currentCenter) {
        Map<String, Object> parameters;
        String hostStr = null;
        if (null != currentCenter && null != (parameters = ParametersUtils.getCommonParameters(currentCenter)) && !ObjectUtils.isEmpty((Object)parameters.get(DDHOST))) {
            hostStr = String.valueOf(parameters.get(DDHOST));
        }
        return hostStr;
    }

    private static boolean isNeedCache(String tenant) {
        boolean needCache = false;
        String needString = System.getProperty(tenant + "_dingding_need_cache");
        if (StringUtils.isEmpty((CharSequence)needString)) {
            needString = System.getProperty(tenant + "_dingding_need_cache");
        }
        if (StringUtils.isNotEmpty((CharSequence)needString)) {
            needCache = kd.bos.login.utils.StringUtils.getBooleanValue(needString);
        }
        return needCache;
    }

    @Deprecated
    public static String getAccess_token(String appkey, String appsecret, String tenant) {
        if (DDUtils.isNeedCache(tenant)) {
            return DDUtils.getAccessTokenByCache(appkey, appsecret, tenant);
        }
        return DDUtils.getAccessTokenDirect(appkey, appsecret, tenant);
    }

    public static String getAccess_token(String appkey, String appsecret, Account account) {
        try {
            return DDUtils.getAccessTokenWithException(appkey, appsecret, account);
        }
        catch (Exception e) {
            logger.info("getAccess_token error", (Object)e);
            return null;
        }
    }

    public static String getAccessTokenWithException(String appkey, String appsecret, Account account) throws Exception {
        if (DDUtils.isNeedCache(account.getTenantId())) {
            return DDUtils.getAccessTokenByCacheWithException(appkey, appsecret, account);
        }
        return DDUtils.getAccessTokenDirectWithException(appkey, appsecret, account);
    }

    @Deprecated
    public static String getAccessTokenDirect(String appkey, String appsecret, String tenant) {
        if (null == appkey || appkey.trim().isEmpty()) {
            logger.info("error ::: appkey is null !");
            return null;
        }
        if (null == appsecret || appsecret.trim().isEmpty()) {
            logger.info("error ::: appsecret is null !");
            return null;
        }
        Account account = LoginAccountFactory.createInstanceByRequestContext(Optional.empty()).getAccount();
        HashMap<String, Object> map = DDUtils.getParamsMap(tenant, appsecret, appkey, account);
        if (map == null) {
            return null;
        }
        return DDUtils.accessSet(appkey, appsecret, map);
    }

    public static String getAccessTokenDirect(String appkey, String appsecret, Account account) {
        try {
            return DDUtils.getAccessTokenDirectWithException(appkey, appsecret, account);
        }
        catch (Exception e) {
            logger.info("getAccessTokenDirect", (Object)e);
            return null;
        }
    }

    public static String getAccessTokenDirectWithException(String appkey, String appsecret, Account account) throws Exception {
        if (null == appkey || appkey.trim().isEmpty()) {
            logger.info("error ::: appkey is null !");
            return null;
        }
        if (null == appsecret || appsecret.trim().isEmpty()) {
            logger.info("error ::: appsecret is null !");
            return null;
        }
        HashMap<String, Object> map = DDUtils.getParamsMap(RequestContext.get().getTenantId(), appsecret, appkey, account);
        if (map == null) {
            return null;
        }
        return DDUtils.accessSet(appkey, appsecret, map);
    }

    private static String accessSet(String appkey, String appsecret, HashMap<String, Object> map) {
        String key = appkey + appsecret;
        if ("0".equals(map.get(ERRCODE).toString())) {
            access_token_Map.put(key, map.get(HCODE_ACCESS_TOKEN).toString());
            access_token_expires_Map.put(key, 7200L);
            access_token_time_Map.put(key, System.currentTimeMillis());
            return map.get(HCODE_ACCESS_TOKEN).toString();
        }
        throw new KDException(new ErrorCode("DDErrorMsg_11", DDErrorMsg.getCodeMsg("DDErrorMsg_11")), new Object[]{map.get(ERRMSG).toString()});
    }

    private static HashMap<String, Object> getParamsMap(String tenant, String appsecret, String appkey, Account account) {
        HashMap map = null;
        String ddHost = "";
        try {
            ddHost = DDUtils.getDDHost(account, tenant);
            StringBuilder access_token_url = new StringBuilder(ddHost).append("gettoken?appkey=");
            access_token_url.append(appkey).append("&appsecret=").append(appsecret);
            String data = HttpClientUtils.get((String)access_token_url.toString());
            map = (HashMap)JSON.parseObject((String)data, HashMap.class);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDException(new ErrorCode("DDErrorMsg_10", DDErrorMsg.getCodeMsg("DDErrorMsg_10")), new Object[]{e.getMessage()});
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static String getAccessTokenByCache(String appkey, String appsecret, String tenant) {
        if (null == appkey || appkey.trim().isEmpty()) {
            return null;
        }
        if (null == appsecret || appsecret.trim().isEmpty()) {
            return null;
        }
        long current_time = System.currentTimeMillis();
        String key = appkey + appsecret;
        String access_token = access_token_Map.get(key);
        Long access_token_expires = access_token_expires_Map.get(key);
        Long access_token_time = access_token_time_Map.get(key);
        if (null != access_token && (current_time - access_token_time) / 1000L < access_token_expires - 30L) {
            return access_token_Map.get(key);
        }
        Object object = lockObj;
        synchronized (object) {
            current_time = System.currentTimeMillis();
            if (null != access_token_Map.get(key) && (current_time - access_token_time) / 1000L < access_token_expires - 30L) {
                return access_token_Map.get(key);
            }
            StringBuilder access_token_url = new StringBuilder(DDUtils.getDDHost(tenant)).append("gettoken?appkey=");
            access_token_url.append(appkey).append("&appsecret=").append(appsecret);
            HashMap map = null;
            try {
                String data = HttpClientUtils.get((String)access_token_url.toString());
                map = (HashMap)JSON.parseObject((String)data, HashMap.class);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
            if (map == null) {
                return null;
            }
            if ("0".equals(map.get(ERRCODE).toString())) {
                access_token_Map.put(key, map.get(HCODE_ACCESS_TOKEN).toString());
                access_token_expires_Map.put(key, 7200L);
                access_token_time_Map.put(key, System.currentTimeMillis());
                return map.get(HCODE_ACCESS_TOKEN).toString();
            }
            return null;
        }
    }

    public static String getAccessTokenByCache(String appkey, String appsecret, Account account) {
        try {
            return DDUtils.getAccessTokenByCacheWithException(appkey, appsecret, account);
        }
        catch (Exception e) {
            logger.info("getAccessTokenByCache error", (Object)e);
            return null;
        }
    }

    public static String getAccessTokenByCacheWithException(String appkey, String appsecret, Account account) throws Exception {
        if (null == appkey || appkey.trim().isEmpty()) {
            logger.info("error ::: appkey is null !");
            return null;
        }
        if (null == appsecret || appsecret.trim().isEmpty()) {
            logger.info("error ::: appsecret is null !");
            return null;
        }
        long current_time = System.currentTimeMillis();
        String key = appkey + appsecret;
        String access_token = access_token_Map.get(key);
        Long access_token_expires = access_token_expires_Map.get(key);
        Long access_token_time = access_token_time_Map.get(key);
        if (null != access_token && (current_time - access_token_time) / 1000L < access_token_expires - 30L) {
            return access_token_Map.get(key);
        }
        Object object = lockObj;
        synchronized (object) {
            current_time = System.currentTimeMillis();
            if (null != access_token_Map.get(key) && (current_time - access_token_time) / 1000L < access_token_expires - 30L) {
                return access_token_Map.get(key);
            }
            StringBuilder access_token_url = new StringBuilder(DDUtils.getDDHost(account, account.getTenantId())).append("gettoken?appkey=");
            access_token_url.append(appkey).append("&appsecret=").append(appsecret);
            HashMap map = null;
            try {
                String data = HttpClientUtils.get((String)access_token_url.toString());
                map = (HashMap)JSON.parseObject((String)data, HashMap.class);
            }
            catch (Exception e) {
                logger.info("getToken error", (Object)e);
                throw new KDException(new ErrorCode("DDErrorMsg_11", DDErrorMsg.getCodeMsg("DDErrorMsg_11")), new Object[]{e.getMessage()});
            }
            if (map == null) {
                return null;
            }
            if ("0".equals(map.get(ERRCODE).toString())) {
                access_token_Map.put(key, map.get(HCODE_ACCESS_TOKEN).toString());
                access_token_expires_Map.put(key, 7200L);
                access_token_time_Map.put(key, System.currentTimeMillis());
                return map.get(HCODE_ACCESS_TOKEN).toString();
            }
            throw new KDException(new ErrorCode("DDErrorMsg_11", DDErrorMsg.getCodeMsg("DDErrorMsg_11")), new Object[]{map.get(ERRMSG).toString()});
        }
    }

    @Deprecated
    public static String getUserId(String access_token, String code, String tenant) {
        if (null == code || code.trim().isEmpty()) {
            return null;
        }
        if (null == access_token || access_token.trim().isEmpty()) {
            return null;
        }
        Account account = LoginAccountFactory.createInstanceByRequestContext(Optional.empty()).getAccount();
        try {
            return DDUtils.getUserIdParamsWithException(access_token, code, tenant, account);
        }
        catch (Exception e) {
            logger.info("getUserId error", (Object)e);
            return null;
        }
    }

    public static String getUserId(String access_token, String code, Account account) {
        try {
            return DDUtils.getUserIdWithEcception(access_token, code, account);
        }
        catch (Exception e) {
            logger.info("getUserId error", (Object)e);
            return null;
        }
    }

    public static String getUserIdWithEcception(String access_token, String code, Account account) throws Exception {
        if (null == code || code.trim().isEmpty()) {
            logger.info("error ::: code is null !");
            return null;
        }
        if (null == access_token || access_token.trim().isEmpty()) {
            logger.info("error ::: access_token is null !");
            return null;
        }
        return DDUtils.getUserIdParamsWithException(access_token, code, RequestContext.get().getTenantId(), account);
    }

    private static String getUserIdParamsWithException(String access_token, String code, String tenant, Account account) throws Exception {
        StringBuilder getUserId_url = new StringBuilder(DDUtils.getDDHost(account, tenant)).append("user/getuserinfo?access_token=");
        getUserId_url.append(access_token).append("&code=").append(code);
        HashMap map = null;
        try {
            String data = HttpClientUtils.get((String)getUserId_url.toString());
            map = (HashMap)JSON.parseObject((String)data, HashMap.class);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDException(new ErrorCode("DDErrorMsg_12", DDErrorMsg.getCodeMsg("DDErrorMsg_12")), new Object[]{e.getMessage()});
        }
        if (map == null) {
            return null;
        }
        if (!"0".equals(map.get(ERRCODE).toString()) && !"40078".equals(map.get(ERRCODE).toString())) {
            throw new KDException(new ErrorCode("DDErrorMsg_12", DDErrorMsg.getCodeMsg("DDErrorMsg_12")), new Object[]{map.get(ERRMSG).toString()});
        }
        if ("40078".equals(map.get(ERRCODE) + "")) {
            return null;
        }
        return map.get("userid").toString();
    }

    @Deprecated
    public static HashMap<String, Object> getUserInfo(String access_token, String userId, String tenant) {
        if (null == userId || userId.trim().isEmpty()) {
            return null;
        }
        if (null == access_token || access_token.trim().isEmpty()) {
            return null;
        }
        Account account = LoginAccountFactory.createInstanceByRequestContext(Optional.empty()).getAccount();
        try {
            return DDUtils.getUserInfoParamsWithExceptino(access_token, userId, tenant, account);
        }
        catch (Exception e) {
            logger.info("getUserInfo error", (Object)e);
            return null;
        }
    }

    public static HashMap<String, Object> getUserInfo(String access_token, String userId, Account account) {
        if (null == userId || userId.trim().isEmpty()) {
            logger.info("error ::: userId is null !");
            return null;
        }
        if (null == access_token || access_token.trim().isEmpty()) {
            logger.info("error ::: access_token is null !");
            return null;
        }
        try {
            return DDUtils.getUserInfoParamsWithExceptino(access_token, userId, null, account);
        }
        catch (Exception e) {
            logger.info("getUserInfo error", (Object)e);
            return null;
        }
    }

    private static HashMap<String, Object> getUserInfoParamsWithExceptino(String access_token, String userId, String tenant, Account account) throws Exception {
        StringBuilder getUserInfo_url = new StringBuilder(DDUtils.getDDHost(account, tenant)).append("user/get?access_token=");
        getUserInfo_url.append(access_token).append("&userid=").append(userId);
        HashMap map = null;
        try {
            String data = HttpClientUtils.get((String)getUserInfo_url.toString());
            map = (HashMap)JSON.parseObject((String)data, HashMap.class);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDException(new ErrorCode("DDErrorMsg_13", DDErrorMsg.getCodeMsg("DDErrorMsg_13")), new Object[]{e.getMessage()});
        }
        if (map == null) {
            return null;
        }
        if ("0".equals(map.get(ERRCODE).toString())) {
            String mobileAndState = DDUtils.getMobileAndState(map);
            map.put("mobile", mobileAndState);
            return map;
        }
        logger.error(map.get(ERRMSG).toString());
        throw new KDException(new ErrorCode("DDErrorMsg_13", DDErrorMsg.getCodeMsg("DDErrorMsg_13")), new Object[]{map.get(ERRMSG).toString()});
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DDAppInfo getAppInfo(Account currentCenter) {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection conn;
        block6: {
            DDAppInfo dDAppInfo;
            Properties dataBaseProperties = AccountUtils.getTenantDBInfo((Account)currentCenter);
            if (dataBaseProperties == null) {
                logger.error(ErrorCodeUtils.getDBGetError());
                throw new KDException(BosErrorCode.configNotFound, new Object[]{ErrorCodeUtils.getDBGetError()});
            }
            conn = null;
            pstmt = null;
            rs = null;
            try {
                conn = MCDBUtil.getConnection((Account)currentCenter, (Properties)dataBaseProperties);
                String sql = "select fappkey, fappsecret from t_bas_dingding";
                pstmt = conn.prepareStatement(sql);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block6;
                String appKey = rs.getString("fappkey");
                String appSecret = rs.getString("fappsecret");
                dDAppInfo = new DDAppInfo(appKey, appSecret);
            }
            catch (SQLException e) {
                try {
                    throw new KDException((Throwable)e, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + LoginUtils.SPLIT_SIGN + e.getMessage()});
                    catch (Exception e2) {
                        throw new KDException((Throwable)e2, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + LoginUtils.SPLIT_SIGN + e2.getMessage()});
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
            return dDAppInfo;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return null;
    }

    @Deprecated
    public static String getJsapiTicket(String appKey, String accessToken) {
        return DDUtils.getJsapiTicket(appKey, accessToken, RequestContext.get().getTenantId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getJsapiTicket(String appKey, String accessToken, String tenant) {
        if (null == accessToken || accessToken.trim().isEmpty()) {
            logger.info("error ::: accessToken is null !");
            return null;
        }
        long current_time = System.currentTimeMillis();
        String key = "JsapiTicket" + appKey;
        String jsapi_ticket = jsapi_ticket_Map.get(key);
        Long jsapi_ticket_expires = jsapi_ticket_expires_Map.get(key);
        Long jsapi_ticket_time = jsapi_ticket_time_Map.get(key);
        if (null != jsapi_ticket && (current_time - jsapi_ticket_time) / 1000L < jsapi_ticket_expires - 30L) {
            logger.info("from cache get jsapi_ticket  ");
            return jsapi_ticket_Map.get(key);
        }
        Object object = lockObj;
        synchronized (object) {
            HashMap map = null;
            try {
                Account account = LoginAccountFactory.createInstanceByRequestContext(Optional.empty()).getAccount();
                StringBuilder jsapi_ticket_url = new StringBuilder(DDUtils.getDDHost(account, tenant)).append("get_jsapi_ticket?access_token=");
                jsapi_ticket_url.append(accessToken);
                String data = HttpClientUtils.get((String)jsapi_ticket_url.toString());
                map = (HashMap)JSON.parseObject((String)data, HashMap.class);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
            if (map == null) {
                return null;
            }
            if ("0".equals(map.get(ERRCODE).toString())) {
                jsapi_ticket_Map.put(key, map.get("ticket").toString());
                jsapi_ticket_expires_Map.put(key, Long.valueOf(map.get("expires_in").toString()));
                jsapi_ticket_time_Map.put(key, System.currentTimeMillis());
                return map.get("ticket").toString();
            }
            logger.error(map.get(ERRMSG).toString());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getJsapiTicket(String appKey, String accessToken, Account account) {
        if (null == accessToken || accessToken.trim().isEmpty()) {
            logger.info("error ::: accessToken is null !");
            return null;
        }
        long current_time = System.currentTimeMillis();
        String key = "JsapiTicket" + appKey;
        String jsapi_ticket = jsapi_ticket_Map.get(key);
        Long jsapi_ticket_expires = jsapi_ticket_expires_Map.get(key);
        Long jsapi_ticket_time = jsapi_ticket_time_Map.get(key);
        if (null != jsapi_ticket && (current_time - jsapi_ticket_time) / 1000L < jsapi_ticket_expires - 30L) {
            logger.info("from cache get jsapi_ticket  ");
            return jsapi_ticket_Map.get(key);
        }
        Object object = lockObj;
        synchronized (object) {
            HashMap map = null;
            try {
                StringBuilder jsapi_ticket_url = new StringBuilder(DDUtils.getDDHost(account, account.getTenantId())).append("get_jsapi_ticket?access_token=");
                jsapi_ticket_url.append(accessToken);
                String data = HttpClientUtils.get((String)jsapi_ticket_url.toString());
                map = (HashMap)JSON.parseObject((String)data, HashMap.class);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
            if (map == null) {
                return null;
            }
            if ("0".equals(map.get(ERRCODE).toString())) {
                jsapi_ticket_Map.put(key, map.get("ticket").toString());
                jsapi_ticket_expires_Map.put(key, Long.valueOf(map.get("expires_in").toString()));
                jsapi_ticket_time_Map.put(key, System.currentTimeMillis());
                return map.get("ticket").toString();
            }
            logger.error(map.get(ERRMSG).toString());
            return null;
        }
    }

    public static String getLoginType(Account currentCenter, String tenant) {
        Map<String, Object> parameters = null;
        if (null != currentCenter) {
            parameters = ParametersUtils.getCommonParameters(currentCenter);
        }
        String loginType = "mobile";
        String reurnType = System.getProperty(tenant + "_dingding_login_type");
        if (null != reurnType) {
            loginType = reurnType;
        }
        if (null == parameters) {
            return loginType;
        }
        if (null != parameters.get(LOGIN_TYPE) && !"".equals(parameters.get(LOGIN_TYPE))) {
            loginType = String.valueOf(parameters.get(LOGIN_TYPE));
        }
        return loginType;
    }

    public static String getAppSecret(String appKey, Account currentCenter) {
        Optional<DynamicObject> enable;
        DynamicObject[] load = DDUtils.loadAppData(appKey);
        if (null != load && load.length > 0 && (enable = Arrays.stream(load).filter(v -> v.getBoolean("enable")).findFirst()).isPresent()) {
            return enable.get().getString("appsecret");
        }
        return null;
    }

    public static boolean isDDEnable(String appKey) {
        DynamicObject[] dynamicObjects = DDUtils.loadAppData(appKey);
        if (null == dynamicObjects || dynamicObjects.length < 1) {
            return true;
        }
        Optional<DynamicObject> enable = Arrays.stream(dynamicObjects).filter(v -> v.getBoolean("enable")).findFirst();
        return enable.isPresent();
    }

    private static DynamicObject[] loadAppData(String appKey) {
        return BusinessDataServiceHelper.load((String)"bos_dingding_config", (String)"appsecret,enable", (QFilter[])new QFilter[]{new QFilter("appkey", "=", (Object)appKey)});
    }

    public static String getMobileAndState(Map<String, Object> result) {
        if (ObjectUtils.isEmpty((Object)result.get("mobile"))) {
            return "";
        }
        String state = DDUtils.getStateCode(result);
        String mobile = result.get("mobile").toString();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)state) || "86".equals(state)) {
            return mobile;
        }
        return state + "-" + mobile;
    }

    private static String getStateCode(Map<String, Object> result) {
        if (!ObjectUtils.isEmpty((Object)result.get("state_code"))) {
            return result.get("state_code").toString();
        }
        if (!ObjectUtils.isEmpty((Object)result.get("stateCode"))) {
            return result.get("stateCode").toString();
        }
        if (!ObjectUtils.isEmpty((Object)result.get("statecode"))) {
            return result.get("statecode").toString();
        }
        return null;
    }
}

