/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.thirdauth.app.feishu;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dc.api.model.Account;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.CacheLoginData;
import kd.bos.login.thirdauth.app.feishu.FeiShuErrorMsg;
import kd.bos.login.utils.JSONUtils;
import kd.bos.login.utils.StringUtils;
import kd.bos.login.utils.SystemPropertyUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.HttpClientUtils;

public class FeiShuUtils {
    private static final String FEISHU_APP_SECRET = "feishu_app_secret";
    private static final String FEISHU_APP_ID = "feishu_app_id";
    private static Log logger = LogFactory.getLog(FeiShuUtils.class);
    public static final String FEISHU_URL_KEY = "feishu_api_url";
    public static final String FEISHU_CACHE_KEY = "feishu";

    public static String getMobile(String mobileNumber) {
        String mobil = "";
        if (StringUtils.isEmpty(mobileNumber)) {
            return mobil;
        }
        if (mobileNumber.startsWith("+86")) {
            return mobileNumber.substring(3);
        }
        return mobileNumber;
    }

    public static String getAppAccessToken(Map<String, Object> parameters, Account currentCenter) {
        try {
            return FeiShuUtils.getAppAccessTokenWithException(parameters, currentCenter);
        }
        catch (Exception e) {
            logger.info("getAppAccessToken error", (Object)e);
            return null;
        }
    }

    public static String getAppAccessTokenWithException(Map<String, Object> parameters, Account currentCenter) throws Exception {
        String flyBookAppSecret;
        Object flyBookAppId;
        String appAccessToken = "";
        StringBuilder url = new StringBuilder(StringUtils.getTrimedBlank(parameters.get(FEISHU_URL_KEY).toString()));
        url.append("/open-apis/auth/v3/app_access_token/internal/");
        String appId = "";
        String appSecret = "";
        if (null != parameters.get(FEISHU_APP_ID)) {
            appId = parameters.get(FEISHU_APP_ID).toString().trim();
        }
        if (null != parameters.get(FEISHU_APP_SECRET)) {
            appSecret = parameters.get(FEISHU_APP_SECRET).toString().trim();
        }
        if (null != (flyBookAppId = parameters.get("flyBookAppId")) && StringUtils.isNotEmpty(flyBookAppSecret = FeiShuUtils.getAppSecret(currentCenter, flyBookAppId.toString()))) {
            appId = flyBookAppId.toString().trim();
            appSecret = flyBookAppSecret.trim();
        }
        if (StringUtils.isEmpty(appId)) {
            throw new KDException(new ErrorCode("FeiShuErrorMsg_3", FeiShuErrorMsg.getCodeMsg("FeiShuErrorMsg_3")), new Object[0]);
        }
        if (StringUtils.isEmpty(appSecret)) {
            throw new KDException(new ErrorCode("FeiShuErrorMsg_5", FeiShuErrorMsg.getCodeMsg("FeiShuErrorMsg_5")), new Object[0]);
        }
        String key = appId + currentCenter.getAccountId();
        appAccessToken = CacheLoginData.getAttribute((String)FEISHU_CACHE_KEY, (String)key);
        if (StringUtils.isNotEmpty(appAccessToken)) {
            return appAccessToken;
        }
        HashMap header = new HashMap(8);
        Map map = new HashMap<String, String>(16);
        try {
            map.put("app_id", appId);
            map.put("app_secret", appSecret);
            String data = HttpClientUtils.post((String)url.toString(), header, map);
            map = (Map)JSON.parseObject((String)data, HashMap.class);
            if (!"0".equals(map.get("code").toString())) {
                throw new KDException(new ErrorCode("FeiShuErrorMsg_9", FeiShuErrorMsg.getCodeMsg("FeiShuErrorMsg_9")), new Object[]{map.get("msg").toString()});
            }
            appAccessToken = map.get("app_access_token").toString();
            int timeOut = (Integer)map.get("expire");
            CacheLoginData.setAttribute((String)FEISHU_CACHE_KEY, (String)key, (String)appAccessToken, (int)(timeOut -= 1200));
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDException(new ErrorCode("FeiShuErrorMsg_9", FeiShuErrorMsg.getCodeMsg("FeiShuErrorMsg_9")), new Object[]{e.getMessage()});
        }
        return appAccessToken;
    }

    public static Map<String, Object> getAuthUserInfo(Map<String, Object> parameters, String appAccessToken, String code) {
        try {
            return FeiShuUtils.getAuthUserInfoWithException(parameters, appAccessToken, code);
        }
        catch (Exception e) {
            logger.info("getAuthUserInfo error", (Object)e);
            return null;
        }
    }

    public static Map<String, Object> getAuthUserInfoWithException(Map<String, Object> parameters, String appAccessToken, String code) throws Exception {
        Map<String, Object> result = new HashMap(16);
        StringBuilder url = new StringBuilder(StringUtils.getTrimedBlank(parameters.get(FEISHU_URL_KEY).toString()));
        url.append("/open-apis/authen/v1/access_token");
        HashMap<String, String> header = new HashMap<String, String>(8);
        HashMap<String, String> params = new HashMap<String, String>(16);
        try {
            header.put("Content-Type", "application/json;charset=utf-8");
            params.put("app_access_token", appAccessToken);
            params.put("grant_type", "authorization_code");
            params.put("code", code);
            String data = HttpClientUtils.postjson((String)url.toString(), header, (String)JSONUtils.toString(params));
            result = (Map)JSON.parseObject((String)data, HashMap.class);
            if (!"0".equals(result.get("code").toString())) {
                logger.error(result.toString());
                throw new KDException(new ErrorCode("FeiShuErrorMsg_10", FeiShuErrorMsg.getCodeMsg("FeiShuErrorMsg_10")), new Object[]{result.toString()});
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDException(new ErrorCode("FeiShuErrorMsg_10", FeiShuErrorMsg.getCodeMsg("FeiShuErrorMsg_10")), new Object[]{e.getMessage()});
        }
        return result;
    }

    private static String getAppSecret(Account currentCenter, String flyBookAppId) {
        QFilter appidFilter;
        QFilter enableFilter = new QFilter("enable", "=", (Object)true);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"bos_fly_book_config", (String)"app_secret", (QFilter[])new QFilter[]{enableFilter, appidFilter = new QFilter("appid", "=", (Object)flyBookAppId)});
        if (load != null && load.length > 0) {
            return load[0].getString("app_secret");
        }
        return null;
    }

    public static String getFlyUrl(Account currentCenter) {
        String host = SystemPropertyUtils.getProptyByTenant("feishu_host", currentCenter.getTenantId());
        return host == null ? "https://open.feishu.cn/" : host;
    }

    public static String getJsapiTicket(Account currentCenter, String accessToken) {
        String jsapiTicket = "";
        StringBuilder url = new StringBuilder(StringUtils.getTrimedBlank(FeiShuUtils.getFlyUrl(currentCenter).toString()));
        url.append("open-apis/jssdk/ticket/get");
        HashMap<String, String> header = new HashMap<String, String>(8);
        HashMap params = new HashMap(16);
        try {
            header.put("Authorization", "Bearer " + accessToken);
            String data = HttpClientUtils.postjson((String)url.toString(), header, (String)JSONUtils.toString(params));
            Map result = (Map)JSON.parseObject((String)data, HashMap.class);
            if (!"0".equals(String.valueOf(result.get("code")))) {
                logger.error(result.toString());
                return jsapiTicket;
            }
            JSONObject json = JSONObject.parseObject((String)String.valueOf(result.get("data")));
            jsapiTicket = String.valueOf(json.get((Object)"ticket"));
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return jsapiTicket;
    }
}

