/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.thirdauth.app.qrcode;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.dc.utils.MCDBUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.after.LoginAfterBase;
import kd.bos.login.thirdauth.app.qrcode.ScanEnum;
import kd.bos.session.SessionInfo;
import kd.bos.util.RevProxyUtil;
import org.apache.commons.lang.math.RandomUtils;

public class ScanLoginAfter
extends LoginAfterBase {
    private static final Log logger = LogFactory.getLog(ScanLoginAfter.class);

    @Override
    public void handling(HttpServletRequest request, SessionInfo sessionInfo) {
        Account currentAccount = null;
        String type = request.getParameter("scantype");
        try {
            String accountIdParameter = sessionInfo.getAccountId();
            String tenantNo = RevProxyUtil.getTenantCode((HttpServletRequest)request);
            currentAccount = AccountUtils.getCorrectAccount((String)accountIdParameter, (String)tenantNo);
        }
        catch (Exception e) {
            logger.error("\u7b2c\u4e09\u65b9\u5e94\u7528\u626b\u7801\u767b\u5f55\u540e\u7f6e\u901a\u7528\u5904\u7406\u83b7\u53d6account\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38\uff1a", (Throwable)e);
        }
        if (ScanEnum.WEIXIN_WORK.getValue().equals(type)) {
            this.doBinding(request, currentAccount, Long.parseLong(sessionInfo.getUserId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doBinding(HttpServletRequest request, Account currentAccount, long userId) {
        Connection conn = null;
        Statement stmt = null;
        ResultSet resultSet = null;
        try {
            String openId = request.getParameter("openid");
            Properties dataBaseProperties = AccountUtils.getTenantDBInfoByRoutekey((Account)currentAccount, (String)"sys");
            conn = MCDBUtil.getConnection((Account)currentAccount, (Properties)dataBaseProperties);
            String selectSql = "select fid,fuserid from t_bas_immapping where fuserid=? and fimtypeid=3";
            stmt = conn.prepareStatement(selectSql);
            stmt.setLong(1, userId);
            resultSet = stmt.executeQuery();
            boolean alreadyBinding = resultSet.next();
            if (!alreadyBinding) {
                DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("qrcode_scan_login", new DistributeCacheHAPolicy(true, true));
                String token = request.getParameter("token");
                String accountId = currentAccount.getAccountId();
                String scanType = request.getParameter("scantype");
                String cacheKey = scanType + "_qrcodescan_login_" + token + "_" + accountId + "_" + openId;
                if (cache.contains(cacheKey)) {
                    String insertSql = "insert into t_bas_immapping (fid,fimtypeid,fuserid,fopenid,frefuserid) values(?,?,?,?,?)";
                    stmt = conn.prepareStatement(insertSql);
                    stmt.setLong(1, this.getId());
                    stmt.setLong(2, 3L);
                    stmt.setLong(3, userId);
                    stmt.setString(4, openId);
                    stmt.setLong(5, userId);
                    stmt.execute();
                } else {
                    logger.error("\u7b2c\u4e09\u65b9\u5e94\u7528\u626b\u7801\u767b\u5f55\u540e\u7f6e\u901a\u7528\u5904\u7406\u4e2d\u7528\u6237\u8fdb\u884c\u7ed1\u5b9a\u5df2\u8d85\u65f6\uff0c\u9ed8\u8ba4\u65f6\u95f4\u4e3a5\u5206\u949f");
                }
            }
        }
        catch (Exception e) {
            logger.error("\u7b2c\u4e09\u65b9\u5e94\u7528\u626b\u7801\u767b\u5f55\u540e\u7f6e\u901a\u7528\u5904\u7406\u4e2d\u7528\u6237\u8fdb\u884c\u7ed1\u5b9a\u51fa\u73b0\u5f02\u5e38\uff1a", (Throwable)e);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException ignore) {
                    logger.error((Throwable)ignore);
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException ignore) {
                    logger.error((Throwable)ignore);
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException ignore) {
                    logger.error((Throwable)ignore);
                }
            }
        }
    }

    private long getId() {
        long time = System.currentTimeMillis();
        int max = 999999;
        int min = 100000;
        int randomValue = RandomUtils.nextInt((int)(max - min + 1)) + min;
        return time * 1000000L + (long)randomValue;
    }
}

