/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.thirdauth.app.qrcode;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.api.model.Account;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.thirdauth.app.qrcode.ScanStrategy;
import kd.bos.login.thirdauth.app.qrcode.service.WxWorkConfigService;
import kd.bos.login.thirdauth.app.tencent.WxqyhUtils;
import kd.bos.login.utils.ParametersUtils;
import kd.bos.util.HttpClientUtils;
import org.apache.commons.lang.StringUtils;

public class WxWorkStrategy
implements ScanStrategy {
    private static final Log logger = LogFactory.getLog(WxWorkStrategy.class);
    private static final String BOS_LOGIN = "bos-login";

    @Override
    public Log getLogger() {
        return logger;
    }

    @Override
    public String getToken(String appId, String secretKey) {
        return WxqyhUtils.getAccess_token(appId, secretKey, null);
    }

    @Override
    public String getToken(String appId, String secretKey, Account account) {
        return WxqyhUtils.getAccess_token(appId, secretKey, account);
    }

    @Override
    public Map<String, Object> getAuthUserInfo(HttpServletRequest request, Account currentAccount) {
        String errorMsg;
        HashMap<String, Object> userInfo;
        block15: {
            userInfo = new HashMap<String, Object>(16);
            errorMsg = "";
            String accountId = request.getParameter("accountid");
            if (currentAccount != null) {
                Map<String, Object> paramMap = ParametersUtils.getCommonParameters(currentAccount);
                if (paramMap != null && !paramMap.isEmpty() && paramMap.containsKey("isenablewxqyh")) {
                    boolean isEnableWxBusiness = Boolean.parseBoolean(String.valueOf(paramMap.get("isenablewxqyh")));
                    if (isEnableWxBusiness) {
                        Map<String, String> config = WxWorkConfigService.getWorkWxConfig(currentAccount);
                        if (config != null) {
                            String cropId = config.get("corpId");
                            String cropSecret = config.get("corpSecret");
                            if (!"null".equals(cropId) && !"null".equals(cropSecret)) {
                                String token = this.getToken(cropId, cropSecret, currentAccount);
                                if (StringUtils.isNotEmpty((String)token)) {
                                    String url = WxqyhUtils.getQywxhHost(currentAccount) + "cgi-bin/user/getuserinfo?access_token=" + token + "&code=" + request.getParameter("code");
                                    try {
                                        String responseContent = HttpClientUtils.get((String)url);
                                        ObjectMapper mapper = new ObjectMapper();
                                        Map jsonMap = (Map)mapper.readValue(responseContent, Map.class);
                                        if ("0".equals(String.valueOf(jsonMap.get("errcode")))) {
                                            userInfo.putIfAbsent("code", "0");
                                            userInfo.putIfAbsent("userId", jsonMap.get("UserId"));
                                            break block15;
                                        }
                                        errorMsg = String.format(ResManager.loadKDString((String)"\u4f01\u4e1a\u5fae\u4fe1\u626b\u7801\u767b\u5f55\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u6821\u9a8c\u5931\u8d25\uff1a%s\u3002", (String)"WxWorkScanLogin_0", (String)BOS_LOGIN, (Object[])new Object[0]), responseContent);
                                    }
                                    catch (Exception e) {
                                        errorMsg = ResManager.loadKDString((String)"\u4f01\u4e1a\u5fae\u4fe1\u626b\u7801\u767b\u5f55\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\u3002", (String)"WxWorkScanLogin_1", (String)BOS_LOGIN, (Object[])new Object[0]);
                                    }
                                } else {
                                    errorMsg = ResManager.loadKDString((String)"\u4f01\u4e1a\u5fae\u4fe1\u626b\u7801\u767b\u5f55\u56de\u8c03\u63a5\u53e3\u4e2d\u83b7\u53d6\u4f01\u4e1a\u5fae\u4fe1token\u5931\u8d25", (String)"WxWorkScanLogin_2", (String)BOS_LOGIN, (Object[])new Object[0]);
                                }
                            } else {
                                errorMsg = ResManager.loadKDString((String)"\u4f01\u4e1a\u5fae\u4fe1\u626b\u7801\u767b\u5f55\u56de\u8c03\u63a5\u53e3\u4e2d\u83b7\u53d6\u7cfb\u7edf\u5168\u5c40\u914d\u7f6e\u4fe1\u606f\u662f\u5426\u542f\u7528\u4f01\u4e1a\u5fae\u4fe1,cropId\u548ccropSecret\u914d\u7f6e\u9519\u8bef", (String)"WxWorkScanLogin_3", (String)BOS_LOGIN, (Object[])new Object[0]);
                            }
                        } else {
                            errorMsg = ResManager.loadKDString((String)"\u4f01\u4e1a\u5fae\u4fe1\u626b\u7801\u767b\u5f55\u56de\u8c03\u63a5\u53e3\u4e2d\u83b7\u53d6\u7cfb\u7edf\u5168\u5c40\u914d\u7f6e\u7684\u626b\u7801\u5e94\u7528\u4fe1\u606f\u4e3a\u7a7a", (String)"WxWorkScanLogin_4", (String)BOS_LOGIN, (Object[])new Object[0]);
                        }
                    } else {
                        errorMsg = ResManager.loadKDString((String)"\u4f01\u4e1a\u5fae\u4fe1\u626b\u7801\u767b\u5f55\u672a\u542f\u7528\uff0c\u626b\u7801\u56de\u8c03\u5931\u8d25\u3002", (String)"WxWorkScanLogin_5", (String)BOS_LOGIN, (Object[])new Object[0]);
                    }
                } else {
                    errorMsg = ResManager.loadKDString((String)"\u4f01\u4e1a\u5fae\u4fe1\u626b\u7801\u767b\u5f55\u83b7\u53d6\u53c2\u6570\u5931\u8d25\u3002", (String)"WxWorkScanLogin_6", (String)BOS_LOGIN, (Object[])new Object[0]);
                }
            } else {
                errorMsg = String.format(ResManager.loadKDString((String)"\u4f01\u4e1a\u5fae\u4fe1\u626b\u7801\u767b\u5f55\u56de\u8c03\u63a5\u53e3\u4e2d\u83b7\u53d6\u79df\u6237\u4fe1\u606f\u4e3a\u7a7a\uff0c\u5f53\u524daccountId:%s", (String)"WxWorkScanLogin_7", (String)BOS_LOGIN, (Object[])new Object[0]), accountId);
            }
        }
        userInfo.putIfAbsent("error", errorMsg);
        userInfo.putIfAbsent("code", "-1");
        return userInfo;
    }
}

