/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.thirdauth.app.sky;

import javax.servlet.http.HttpServletRequest;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dc.api.model.Account;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.model.ThirdAuthApp;
import kd.bos.login.service.ThirdAppService;
import kd.bos.login.thirdauth.app.AppAuthResult;
import kd.bos.login.thirdauth.app.ThirdAppAuthtication;
import kd.bos.login.thirdauth.app.UserType;
import kd.bos.login.thirdauth.app.sky.SkyUtils;
import kd.bos.login.utils.StringUtils;

public class SkyAuthtication
extends ThirdAppAuthtication {
    private static Log logger = LogFactory.getLog(SkyAuthtication.class);

    @Override
    public boolean isNeedHandle(HttpServletRequest request, Account currentCenter) {
        String appType = request.getParameter("apptype");
        String entryRole = request.getParameter("entryRole");
        boolean isNeedHandle = false;
        if ("kingdee_sky".equals(appType) && StringUtils.isNotEmpty(entryRole)) {
            isNeedHandle = true;
        }
        return isNeedHandle;
    }

    @Override
    public AppAuthResult appAuthtication(HttpServletRequest request, Account currentCenter) {
        AppAuthResult result = new AppAuthResult();
        result.setSucceed(false);
        String code = request.getParameter("code");
        if (StringUtils.isNotEmpty(code)) {
            result = this.getAuthResult(request, currentCenter);
        }
        return result;
    }

    private AppAuthResult getAuthResult(HttpServletRequest request, Account currentCenter) {
        String accessToken;
        AppAuthResult result = new AppAuthResult();
        result.setSucceed(false);
        String corpId = request.getParameter("corpid");
        if (StringUtils.isEmpty(corpId) && StringUtils.isEmpty(corpId = request.getParameter("eid"))) {
            result.setErrorMessage("login: corpId is null !");
            return result;
        }
        String corpSecret = null;
        String entryRole = request.getParameter("entryRole");
        DynamicObject[] data = ThirdAppService.getThirdappsConfigByCorpid(corpId, ThirdAppService.getThirdAppUserType(entryRole));
        ThirdAuthApp thirdAuthAppInfo = new ThirdAuthApp();
        if (data != null && data.length > 0) {
            corpSecret = String.valueOf(data[0].get("corpsecret"));
            if (StringUtils.isEmpty(corpSecret)) {
                result.setErrorMessage("login: corpsecret is null !");
                return result;
            }
            thirdAuthAppInfo = this.wrapData(data[0]);
            thirdAuthAppInfo.setEntryRole(entryRole);
        }
        if (StringUtils.isEmpty(accessToken = SkyUtils.getSkyAccessToken(currentCenter, thirdAuthAppInfo))) {
            result.setErrorMessage("access_token is null !");
            return result;
        }
        String code = request.getParameter("code");
        String lightAppId = request.getParameter("lightAppId");
        String userId = SkyUtils.getSkyUserInfo(currentCenter, accessToken, code, thirdAuthAppInfo);
        if (StringUtils.isNotEmpty(userId)) {
            String type = ThirdAppService.getThirdAppTypeByEntryRole(ThirdAppService.getThirdAppUserType(entryRole));
            result.setSucceed(true);
            result.setUserType(UserType.USER_ID);
            result.setUserFlag(userId);
            result.setAppType(type);
            result.setThirdAppTypeID(String.valueOf(ThirdAppService.getThirdAppUserType(entryRole)));
            result.setLightAppId(lightAppId);
        }
        return result;
    }

    private ThirdAuthApp wrapData(DynamicObject data) {
        ThirdAuthApp thirdAuthAppInfo = new ThirdAuthApp();
        thirdAuthAppInfo.setCorpId(String.valueOf(data.get("corpid")));
        thirdAuthAppInfo.setSecret(String.valueOf(data.get("corpsecret")));
        thirdAuthAppInfo.setErpRole(SkyUtils.getSystemEnv());
        return thirdAuthAppInfo;
    }
}

