/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.thirdauth.app.sky;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dc.api.model.Account;
import kd.bos.encrypt.Encrypters;
import kd.bos.license.NextCloud;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.CacheLoginData;
import kd.bos.login.model.AuthSignatureResult;
import kd.bos.login.model.ThirdAuthApp;
import kd.bos.login.service.ThirdAppService;
import kd.bos.login.user.DefaultParameterService;
import kd.bos.login.utils.JSONUtils;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.util.HttpClientUtils;
import org.apache.commons.lang.StringUtils;

public class SkyUtils {
    private static Log logger = LogFactory.getLog(SkyUtils.class);
    private static Map<String, String> systemEnvKV = new HashMap<String, String>(8);

    public static String getSkyAccessToken(Account currentCenter, ThirdAuthApp thirdAuthAppInfo) {
        String skyAccessToken = CacheLoginData.getAttribute((String)"kingdee_sky", (String)(thirdAuthAppInfo.getCorpId() + currentCenter.getAccountId()));
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)skyAccessToken)) {
            return skyAccessToken;
        }
        StringBuilder url = new StringBuilder();
        String kingdeeSkyUrl = DefaultParameterService.getDefaultValueByKey("kingdee_sky_url");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)kingdeeSkyUrl)) {
            kingdeeSkyUrl = kd.bos.login.utils.StringUtils.getPathString(NextCloud.CLOUD_URL) + "kcclightservice";
        }
        url.append(kingdeeSkyUrl);
        url.append("/connect/getAccessToken?");
        url.append("client_id=").append(SkyUtils.getCloudClientId()).append("&client_secret=").append(SkyUtils.getClientSecret());
        HashMap header = new HashMap(8);
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("eid", thirdAuthAppInfo.getCorpId());
        map.put("secret", thirdAuthAppInfo.getSecret());
        map.put("entryRole", thirdAuthAppInfo.getEntryRole());
        map.put("erpRole", thirdAuthAppInfo.getErpRole());
        map.put("timestamp", System.currentTimeMillis());
        map.put("accountId", currentCenter.getAccountId());
        try {
            String data = HttpClientUtils.post((String)url.toString(), header, map);
            Map result = (Map)kd.bos.util.JSONUtils.cast((String)data, HashMap.class);
            if (result.get("success") != null && Boolean.parseBoolean(result.get("success").toString())) {
                Double expireInTime = (result = (HashMap)result.get("data")).get("expireIn") != null ? Double.parseDouble(result.get("expireIn").toString()) * 0.5 : 1.0;
                skyAccessToken = result.get("accessToken").toString();
                CacheLoginData.setAttribute((String)"kingdee_sky", (String)(thirdAuthAppInfo.getCorpId() + currentCenter.getAccountId()), (String)skyAccessToken, (int)(expireInTime.intValue() > 0 ? expireInTime.intValue() : 1));
            } else {
                logger.info(data);
            }
        }
        catch (Exception e) {
            logger.info("kd.bos.login.thirdauth.app.sky.SkyUtils#getSkyAccessToken", (Object)e);
        }
        return skyAccessToken;
    }

    public static String getSkyUserInfo(Account currentCenter, String accessToken, String code, ThirdAuthApp thirdAuthApp) {
        StringBuilder url = new StringBuilder();
        String kingdeeSkyUrl = DefaultParameterService.getDefaultValueByKey("kingdee_sky_url");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)kingdeeSkyUrl)) {
            kingdeeSkyUrl = kd.bos.login.utils.StringUtils.getPathString(NextCloud.CLOUD_URL) + "kcclightservice";
        }
        url.append(kingdeeSkyUrl);
        url.append("/connect/getUserInfo?");
        url.append("client_id=").append(SkyUtils.getCloudClientId()).append("&client_secret=").append(SkyUtils.getClientSecret());
        HashMap<String, String> header = new HashMap<String, String>(8);
        header.put("Authorization", "Bearer " + accessToken);
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("grant_type", "authorization_code");
        map.put("code", code);
        String userId = "";
        try {
            String data = HttpClientUtils.post((String)url.toString(), header, map);
            Map result = (Map)kd.bos.util.JSONUtils.cast((String)data, HashMap.class);
            if (result.get("success") != null && Boolean.parseBoolean(result.get("success").toString())) {
                String openId = (result = (HashMap)result.get("data")).get("openId") != null ? result.get("openId").toString() : "";
                userId = ThirdAppService.getImMapping(openId, ThirdAppService.getThirdAppUserType(thirdAuthApp.getEntryRole()));
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)userId) && !"0".equals(thirdAuthApp.getEntryRole())) {
                    CacheLoginData.setAttribute((String)"kingdee_sky", (String)code, (String)kd.bos.util.JSONUtils.toString((Object)result), (int)1200);
                }
            } else {
                logger.info(data);
            }
        }
        catch (Exception e) {
            logger.info("kd.bos.login.thirdauth.app.sky.SkyUtils#getSkyUserInfo", (Object)e);
        }
        return userId;
    }

    private static String getCloudClientId() {
        String cloudId = System.getProperty("clientId");
        if (StringUtils.isEmpty((String)cloudId)) {
            cloudId = "201230";
        }
        return cloudId;
    }

    private static String getClientSecret() {
        String clientSecret = System.getProperty("clientSecret");
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)clientSecret)) {
            clientSecret = Encrypters.decode((String)clientSecret);
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)clientSecret)) {
            clientSecret = DefaultParameterService.getDefaultValueByKey("client_param");
        }
        return clientSecret;
    }

    public static String getSystemEnv() {
        String systemEnvForDef = "1";
        List productInfos = LicenseServiceHelper.getProductInfos();
        if (ObjectUtils.isEmpty((Object)productInfos)) {
            return systemEnvForDef;
        }
        Optional<String> optional = productInfos.stream().map(v -> (String)v.get("prodid")).filter(systemEnvKV::containsKey).findFirst();
        if (!optional.isPresent()) {
            return systemEnvForDef;
        }
        String result = systemEnvKV.get(optional.get());
        return org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)result) ? result : systemEnvForDef;
    }

    public static List<AuthSignatureResult> getAuthSignatureResultList(Account currentCenter, String accessToken, ThirdAuthApp thirdAuthAppInfo) {
        List<AuthSignatureResult> list = new ArrayList<AuthSignatureResult>(2);
        StringBuilder url = new StringBuilder();
        String kingdeeSkyUrl = DefaultParameterService.getDefaultValueByKey("kingdee_sky_url");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)kingdeeSkyUrl)) {
            kingdeeSkyUrl = kd.bos.login.utils.StringUtils.getPathString(NextCloud.CLOUD_URL) + "kcclightservice";
        }
        url.append(kingdeeSkyUrl);
        url.append("/connect/getJsConfigSignature?");
        url.append("client_id=").append(SkyUtils.getCloudClientId()).append("&client_secret=").append(SkyUtils.getClientSecret());
        HashMap<String, String> header = new HashMap<String, String>(8);
        header.put("Authorization", "Bearer " + accessToken);
        header.put("Content-Type", "application/json; charset=utf-8");
        try {
            HashMap<String, String> map = new HashMap<String, String>(16);
            map.put("appId", thirdAuthAppInfo.getLightAppId());
            map.put("url", URLEncoder.encode(thirdAuthAppInfo.getAccessUrl(), "UTF-8"));
            String data = HttpClientUtils.postjson((String)url.toString(), header, (String)JSONUtils.toString(map));
            Map result = (Map)JSON.parseObject((String)data, HashMap.class);
            if (!"0".equals(result.get("errorCode").toString())) {
                logger.error(result.toString());
                return list;
            }
            list = SkyUtils.wrapAuthSignatureData(result);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return list;
    }

    private static List<AuthSignatureResult> wrapAuthSignatureData(Map<String, Object> result) {
        AuthSignatureResult authSignatureResult;
        ArrayList<AuthSignatureResult> list = new ArrayList<AuthSignatureResult>(2);
        Object data = result.get("data");
        if (ObjectUtils.isEmpty((Object)data)) {
            return list;
        }
        JSONObject json = JSONObject.parseObject((String)data.toString());
        JSONObject config = json.getJSONObject("config");
        if (!ObjectUtils.isEmpty((Object)config)) {
            authSignatureResult = SkyUtils.getAuthSignatureResult(config);
            authSignatureResult.setConfigType("config");
            list.add(authSignatureResult);
        }
        if (!ObjectUtils.isEmpty((Object)(config = json.getJSONObject("agentConfig")))) {
            authSignatureResult = SkyUtils.getAuthSignatureResult(config);
            authSignatureResult.setConfigType("agentConfig");
            list.add(authSignatureResult);
        }
        return list;
    }

    private static AuthSignatureResult getAuthSignatureResult(JSONObject config) {
        AuthSignatureResult authSignatureResult = new AuthSignatureResult();
        authSignatureResult.setAgentId(String.valueOf(config.get((Object)"agentId")));
        authSignatureResult.setSignature(String.valueOf(config.get((Object)"signature")));
        authSignatureResult.setAppId(String.valueOf(config.get((Object)"appId")));
        authSignatureResult.setEid(String.valueOf(config.get((Object)"eid")));
        authSignatureResult.setTimestamp(config.getLong("timestamp"));
        authSignatureResult.setNonce(String.valueOf(config.get((Object)"nonce")));
        return authSignatureResult;
    }

    static {
        systemEnvKV.put("1I6CUBKTC4GY", "1");
        systemEnvKV.put("1I6COPY94UBO", "1");
        systemEnvKV.put("2D3=SA5XL/92", "2");
        systemEnvKV.put("2D3=SA5XL/93", "2");
    }
}

