/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.thirdauth.app.tencent;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.dc.utils.MCDBUtil;
import kd.bos.dc.utils.SQLUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.CacheLoginData;
import kd.bos.login.thirdauth.app.AppAuthResult;
import kd.bos.login.thirdauth.app.ThirdAppAuthtication;
import kd.bos.login.thirdauth.app.UserType;
import kd.bos.login.thirdauth.app.tencent.WxgzhUtils;
import kd.bos.login.utils.ErrorCodeUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.RevProxyUtil;
import kd.bos.util.StringUtils;

public class WxgzhAuthtication
extends ThirdAppAuthtication {
    private static final String WXGZH_OPENID = "wxgzh_openid";
    private static Log logger = LogFactory.getLog(WxgzhAuthtication.class);
    public static final String SPLIT = "_split_";
    private static final String WXGZHLOGIN = "wxgzhlogin";

    @Override
    public boolean isNeedHandle(HttpServletRequest request, Account currentCenter) {
        String state = request.getParameter("state");
        if (StringUtils.isEmpty((String)state)) {
            return false;
        }
        String app_type = state.split(SPLIT)[0];
        if (StringUtils.isEmpty((String)app_type)) {
            return false;
        }
        return app_type.equalsIgnoreCase("wxgzh");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AppAuthResult appAuthtication(HttpServletRequest request, Account currentCenter) {
        String phone;
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        String app_type;
        AppAuthResult result;
        block17: {
            String uid;
            String sql;
            block16: {
                result = new AppAuthResult();
                result.setSucceed(false);
                String state = request.getParameter("state");
                app_type = state.split(SPLIT)[0];
                if (StringUtils.isEmpty((String)app_type)) {
                    return result;
                }
                String code = request.getParameter("code");
                if (StringUtils.isEmpty((String)code)) {
                    result.setErrorMessage("wxgzh login: code is blank !");
                    return result;
                }
                String openid = CacheLoginData.getAttribute((String)WXGZHLOGIN, (String)code);
                if (StringUtils.isEmpty((String)openid)) {
                    openid = CacheLoginData.getAttribute((String)WXGZH_OPENID, (String)code);
                }
                String accountIdParameter = request.getParameter("accountId");
                String tenantNo = RevProxyUtil.getTenantCode((HttpServletRequest)request);
                Account currentAccount = AccountUtils.getCorrectAccount((String)accountIdParameter, (String)tenantNo);
                if (StringUtils.isEmpty((String)openid)) {
                    String secret;
                    String appid;
                    String[] stateInfo = state.split(SPLIT);
                    String string = appid = stateInfo.length > 1 ? stateInfo[1] : "";
                    if (StringUtils.isEmpty((String)appid)) {
                        result.setErrorMessage("wxgzh login: appid is blank !");
                        return result;
                    }
                    String string2 = secret = stateInfo.length > 2 ? stateInfo[2] : this.getSecret(appid, currentCenter);
                    if (StringUtils.isEmpty((String)secret)) {
                        result.setErrorMessage("wxgzh login: secret is blank !");
                        return result;
                    }
                    String tokenAndOpenid = WxgzhUtils.getAccess_token(appid, secret, code);
                    if (StringUtils.isEmpty((String)tokenAndOpenid)) {
                        result.setErrorMessage("wxgzh\uff1atokenAndOpenid is null !");
                        return result;
                    }
                    openid = tokenAndOpenid.split("token_openid_split")[1];
                    if (StringUtils.isNotEmpty((String)openid)) {
                        CacheLoginData.setAttribute((String)WXGZH_OPENID, (String)code, (String)openid, (int)3600);
                    }
                }
                logger.info("wxgzh: openid ");
                conn = null;
                stmt = null;
                rs = null;
                phone = null;
                logger.info("@\u5f00\u59cb\u7528\u6237\u4e0e\u79df\u6237\u7684\u5bf9\u5e94\u5173\u7cfb\u9a8c\u8bc1\u3002");
                Properties dataBaseProperties = AccountUtils.getTenantDBInfo((Account)currentAccount);
                if (dataBaseProperties == null) {
                    logger.error(ErrorCodeUtils.getDBGetError());
                    throw new KDException(BosErrorCode.configNotFound, new Object[]{ErrorCodeUtils.getDBGetError()});
                }
                conn = MCDBUtil.getConnection((Account)currentAccount, (Properties)dataBaseProperties);
                sql = "SELECT fuserid from t_bas_immapping WHERE fopenid = ? and FIMTypeID = 1  ";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, openid);
                rs = stmt.executeQuery();
                uid = "";
                if (rs.next()) {
                    uid = rs.getString(1);
                }
                if (!StringUtils.isEmpty((String)uid)) break block16;
                logger.info("wxgzh:uid is null");
                CacheLoginData.setAttribute((String)WXGZHLOGIN, (String)code, (String)openid, (int)3600);
                AppAuthResult appAuthResult = result;
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
                return appAuthResult;
            }
            try {
                sql = "SELECT fphone from t_sec_user where fid= ?";
                stmt = conn.prepareStatement(sql);
                stmt.setLong(1, Long.parseLong(uid));
                rs = stmt.executeQuery();
                if (!rs.next()) break block17;
                phone = rs.getString(1);
            }
            catch (SQLException e) {
                try {
                    throw new KDException(BosErrorCode.sQLConnection, new Object[]{e.getMessage()});
                    catch (Exception e2) {
                        throw new KDException(BosErrorCode.sQLConnection, new Object[]{e2.getMessage()});
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, stmt, conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        logger.info("wxgzh:user's phone number:");
        result.setSucceed(true);
        result.setUserFlag(phone);
        result.setAppType(app_type);
        result.setUserType(UserType.MOBILE_PHONE);
        return result;
    }

    private String getSecret(String appid, Account currentCenter) {
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"cts_wxgzh", (String)"secret", (QFilter[])new QFilter[]{new QFilter("appid", "=", (Object)appid)});
        if (load != null && load.length > 0) {
            return load[0].getString("secret");
        }
        return null;
    }
}

