/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.thirdauth.app.tencent;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dc.api.model.Account;
import kd.bos.exception.KDException;
import kd.bos.exception.LoginErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.model.AuthSignatureResult;
import kd.bos.login.model.ThirdAuthApp;
import kd.bos.login.thirdauth.app.ThirdAppAuthStrategy;
import kd.bos.login.thirdauth.app.tencent.CorpObj;
import kd.bos.login.thirdauth.app.tencent.WxgzhAuthtication;
import kd.bos.login.thirdauth.app.tencent.WxqyhUtils;
import kd.bos.login.utils.SHAUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class WxqyhAuthStrategy
implements ThirdAppAuthStrategy {
    private static Log logger = LogFactory.getLog(WxgzhAuthtication.class);

    @Override
    public List<AuthSignatureResult> getJsSignatureList(Account currentCenter, ThirdAuthApp thirdAuthAppInfo) {
        ArrayList<AuthSignatureResult> authSignatureResultList = new ArrayList<AuthSignatureResult>(2);
        try {
            CorpObj corpObj;
            AuthSignatureResult authSignatureResult = new AuthSignatureResult();
            String corpSecret = kd.bos.login.utils.StringUtils.getTrimedBlank(this.getCorpSecret(thirdAuthAppInfo.getCorpId(), thirdAuthAppInfo.getAgentId(), currentCenter));
            if (StringUtils.isBlank((CharSequence)corpSecret) && (corpObj = WxqyhUtils.getCorpSecret(currentCenter)) != null) {
                corpSecret = corpObj.getCorpSecret();
                thirdAuthAppInfo.setCorpId(corpObj.getCorpId());
            }
            if (StringUtils.isBlank((CharSequence)thirdAuthAppInfo.getCorpId())) {
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{"corpId is null"});
            }
            if (StringUtils.isBlank((CharSequence)corpSecret)) {
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{"secret is null"});
            }
            String accessToken = WxqyhUtils.getAccess_token(thirdAuthAppInfo.getCorpId(), corpSecret, currentCenter);
            if (StringUtils.isBlank((CharSequence)accessToken)) {
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{"accessToken is null,please check the configuration."});
            }
            String ticket = WxqyhUtils.getWeixinTicket(accessToken, currentCenter);
            String noncestr = kd.bos.login.utils.StringUtils.randomWord(16);
            long timestamp = new Date().getTime();
            StringBuilder sign = new StringBuilder();
            sign.append("jsapi_ticket=").append(ticket).append("&noncestr=").append(noncestr).append("&timestamp=").append(timestamp).append("&url=").append(thirdAuthAppInfo.getAccessUrl());
            String signature = SHAUtils.sha(sign.toString());
            authSignatureResult.setSignature(signature);
            authSignatureResult.setNonce(noncestr);
            authSignatureResult.setTimestamp(timestamp);
            authSignatureResult.setEid(thirdAuthAppInfo.getCorpId());
            authSignatureResult.setAppId(thirdAuthAppInfo.getLightAppId());
            authSignatureResult.setAgentId(thirdAuthAppInfo.getAgentId());
            authSignatureResult.setConfigType("config");
            authSignatureResultList.add(authSignatureResult);
        }
        catch (KDException e) {
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{e.getMessage()});
        }
        catch (Exception e) {
            logger.info("getAuthSignatureList error", (Object)e);
        }
        return authSignatureResultList;
    }

    private String getCorpSecret(String corpId, String agentId, Account currentCenter) {
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"cts_wxqyh", (String)"corpsecret", (QFilter[])new QFilter[]{new QFilter("corpid", "=", (Object)corpId), new QFilter("agentid", "=", (Object)agentId)});
        if (null != load && load.length > 0) {
            DynamicObject dynamicObject = load[0];
            return dynamicObject.getString("corpsecret");
        }
        return null;
    }
}

