/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.thirdauth.app.tencent.wechat;

import java.io.IOException;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kd.bos.login.thirdauth.app.tencent.wechat.AesException;
import kd.bos.login.thirdauth.app.tencent.wechat.PKCS7Encoder;
import kd.bos.login.thirdauth.app.tencent.wechat.XMLParse;
import kd.bos.login.user.DefaultParameterService;

public class WXBizMsgCrypt {
    static Charset CHARSET = Charset.forName("utf-8");
    org.apache.commons.codec.binary.Base64 base64 = new org.apache.commons.codec.binary.Base64();
    byte[] aesKey;
    String token;
    String receiveid;

    public WXBizMsgCrypt(String token, String encodingAesKey, String receiveid) throws AesException {
        if (encodingAesKey.length() != 43) {
            throw new AesException(-40004);
        }
        this.token = token;
        this.receiveid = receiveid;
        this.aesKey = org.apache.commons.codec.binary.Base64.decodeBase64((String)(encodingAesKey + "="));
    }

    int recoverNetworkBytesOrder(byte[] orderBytes) {
        int sourceNumber = 0;
        for (int i = 0; i < 4; ++i) {
            sourceNumber <<= 8;
            sourceNumber |= orderBytes[i] & 0xFF;
        }
        return sourceNumber;
    }

    private String decrypt(String text) throws AesException {
        String from_receiveid;
        String xmlContent;
        byte[] original;
        try {
            String decrypt = DefaultParameterService.getDefaultValueByKey("WXQYH_DECRYPT", "1");
            Cipher cipher = Cipher.getInstance(decrypt);
            SecretKeySpec key_spec = new SecretKeySpec(this.aesKey, "AES");
            IvParameterSpec iv = new IvParameterSpec(Arrays.copyOfRange(this.aesKey, 0, 16));
            cipher.init(2, (Key)key_spec, iv);
            byte[] encrypted = org.apache.commons.codec.binary.Base64.decodeBase64((String)text);
            original = cipher.doFinal(encrypted);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AesException(-40007);
        }
        try {
            byte[] bytes = PKCS7Encoder.decode(original);
            byte[] networkOrder = Arrays.copyOfRange(bytes, 16, 20);
            int xmlLength = this.recoverNetworkBytesOrder(networkOrder);
            xmlContent = new String(Arrays.copyOfRange(bytes, 20, 20 + xmlLength), CHARSET);
            from_receiveid = new String(Arrays.copyOfRange(bytes, 20 + xmlLength, bytes.length), CHARSET);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AesException(-40008);
        }
        if (!from_receiveid.equals(this.receiveid)) {
            throw new AesException(-40005);
        }
        return xmlContent;
    }

    @Deprecated
    public String DecryptMsg(String msgSignature, String timeStamp, String nonce, String postData) throws AesException {
        Object[] encrypt = XMLParse.extract(postData);
        String signature = WXBizMsgCrypt.getSHA(this.token, timeStamp, nonce, encrypt[1].toString());
        if (!signature.equals(msgSignature)) {
            throw new AesException(-40001);
        }
        String result = this.decrypt(encrypt[1].toString());
        return result;
    }

    @Deprecated
    public String VerifyURL(String msgSignature, String timeStamp, String nonce, String echoStr) throws AesException {
        String signature = WXBizMsgCrypt.getSHA(this.token, timeStamp, nonce, echoStr);
        if (!signature.equals(msgSignature)) {
            throw new AesException(-40001);
        }
        String result = this.decrypt(echoStr);
        return result;
    }

    @Deprecated
    private static String getSHA(String token, String timestamp, String nonce, String encrypt) throws AesException {
        try {
            Object[] array = new String[]{token, timestamp, nonce, encrypt};
            StringBuffer sb = new StringBuffer();
            Arrays.sort(array);
            for (int i = 0; i < 4; ++i) {
                sb.append((String)array[i]);
            }
            String str = sb.toString();
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(str.getBytes());
            byte[] digest = md.digest();
            StringBuffer hexstr = new StringBuffer();
            String shaHex = "";
            for (int i = 0; i < digest.length; ++i) {
                shaHex = Integer.toHexString(digest[i] & 0xFF);
                if (shaHex.length() < 2) {
                    hexstr.append(0);
                }
                hexstr.append(shaHex);
            }
            return hexstr.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AesException(-40003);
        }
    }

    public static String decryptToString(String key, String ciphertext) throws GeneralSecurityException, IOException {
        try {
            byte[] str = Base64.getDecoder().decode(ciphertext);
            byte[] nonce = new byte[16];
            byte[] content = new byte[str.length - nonce.length];
            System.arraycopy(str, 0, nonce, 0, nonce.length);
            System.arraycopy(str, nonce.length, content, 0, content.length);
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            SecretKeySpec a = new SecretKeySpec(Base64.getDecoder().decode(key), "AES");
            GCMParameterSpec spec = new GCMParameterSpec(128, nonce);
            cipher.init(2, (Key)a, spec);
            return new String(cipher.doFinal(content), "utf-8");
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new IllegalStateException(e);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

