/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.thirdauth.app.welink;

import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import kd.bos.dc.api.model.Account;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.ksql.util.StringUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.thirdauth.app.AppAuthResult;
import kd.bos.login.thirdauth.app.ThirdAppAuthtication;
import kd.bos.login.thirdauth.app.UserType;
import kd.bos.login.thirdauth.app.welink.TicketResp;
import kd.bos.login.thirdauth.app.welink.UserResp;
import kd.bos.login.thirdauth.app.welink.WeLinkErrorMsg;
import kd.bos.login.thirdauth.app.welink.WeLinkUserInfo;
import kd.bos.login.thirdauth.app.welink.WeLinkUtils;
import kd.bos.login.utils.StringUtils;
import kd.bos.login.utils.SystemPropertyUtils;
import kd.bos.login.utils.log.ThirdAppLogInfo;
import kd.bos.login.utils.log.ThirdAppLogUtils;
import kd.bos.util.RevProxyUtil;

public class WeLinkAuthtication
extends ThirdAppAuthtication {
    public static final String LOGIN_WELINK_CLIENT_ID = "login_welink_clientId";
    private static Log logger = LogFactory.getLog(WeLinkAuthtication.class);

    @Override
    public boolean isNeedHandle(HttpServletRequest request, Account currentCenter) {
        String app_type = request.getParameter("apptype");
        String code = request.getParameter("code");
        return !StringUtils.isEmpty(app_type) && app_type.equalsIgnoreCase("wl") && !StringUtils.isEmpty(code);
    }

    public static boolean getIsNoNeed(String tenantId) {
        boolean isNONeed = false;
        try {
            String needString = System.getProperty(tenantId + "_" + "login.session.terminalLimit");
            if (StringUtils.isEmpty(needString)) {
                needString = System.getProperty("login.session.terminalLimit");
            }
            isNONeed = StringUtils.getBooleanValue(needString);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return isNONeed;
    }

    @Override
    public AppAuthResult appAuthtication(HttpServletRequest request, Account currentCenter) {
        AppAuthResult result = new AppAuthResult();
        result.setSucceed(false);
        String code = request.getParameter("code");
        String clientId = request.getParameter("appid");
        if (StringUtils.isEmpty(clientId)) {
            String tenantId = RevProxyUtil.getTenantCode((HttpServletRequest)request);
            clientId = SystemPropertyUtils.getProptyByTenant(LOGIN_WELINK_CLIENT_ID, tenantId);
        }
        clientId = StringUtils.getTrimedBlank(clientId);
        try {
            String clientSecret = WeLinkUtils.getClientSecret(clientId);
            if (StringUtils.isEmpty(clientSecret)) {
                throw new KDException(new ErrorCode("WeLinkErrorMsg_2", WeLinkErrorMsg.getCodeMsg("WeLinkErrorMsg_2")), new Object[0]);
            }
            TicketResp ticketResp = WeLinkUtils.getAccessTokenWithException(clientId, clientSecret, currentCenter);
            if (Objects.isNull(ticketResp)) {
                throw new KDException(new ErrorCode("WeLinkErrorMsg_11", WeLinkErrorMsg.getCodeMsg("WeLinkErrorMsg_11")), new Object[0]);
            }
            if (!StringUtil.equals((String)ticketResp.getCode(), (String)"0")) {
                throw new KDException(new ErrorCode("WeLinkErrorMsg_17", WeLinkErrorMsg.getCodeMsg("WeLinkErrorMsg_17")), new Object[]{ticketResp.getMessage()});
            }
            UserResp userResp = WeLinkUtils.getUserRespWithException(code, ticketResp.getAccess_token(), currentCenter);
            if (Objects.isNull(userResp)) {
                throw new KDException(new ErrorCode("WeLinkErrorMsg_13", WeLinkErrorMsg.getCodeMsg("WeLinkErrorMsg_13")), new Object[0]);
            }
            if (!StringUtil.equals((String)userResp.getCode(), (String)"0")) {
                throw new KDException(new ErrorCode("WeLinkErrorMsg_18", WeLinkErrorMsg.getCodeMsg("WeLinkErrorMsg_18")), new Object[]{userResp.getMessage()});
            }
            WeLinkUserInfo weLinkUserInfo = WeLinkUtils.getUserInfoWithException(userResp.getUserId(), ticketResp.getAccess_token(), currentCenter);
            if (Objects.isNull(weLinkUserInfo)) {
                throw new KDException(new ErrorCode("WeLinkErrorMsg_15", WeLinkErrorMsg.getCodeMsg("WeLinkErrorMsg_15")), new Object[0]);
            }
            if (!StringUtil.equals((String)userResp.getCode(), (String)"0")) {
                throw new KDException(new ErrorCode("WeLinkErrorMsg_19", WeLinkErrorMsg.getCodeMsg("WeLinkErrorMsg_19")), new Object[]{weLinkUserInfo.getMessage()});
            }
            if (StringUtils.isEmpty(WeLinkUtils.getMobile(weLinkUserInfo.getMobileNumber()))) {
                throw new KDException(new ErrorCode("WeLinkErrorMsg_16", WeLinkErrorMsg.getCodeMsg("WeLinkErrorMsg_16")), new Object[0]);
            }
            result.setSucceed(true);
            result.setUserFlag(WeLinkUtils.getMobile(weLinkUserInfo.getMobileNumber()));
            result.setUserType(UserType.MOBILE_PHONE);
            result.setAppType(request.getParameter("apptype"));
        }
        catch (KDException kde) {
            ErrorCode errorCode = kde.getErrorCode();
            String resourceId = errorCode != null ? errorCode.getCode() : "";
            boolean codeExist = StringUtils.isNotEmpty(WeLinkErrorMsg.getCodeMsg(resourceId));
            ThirdAppLogInfo thirdAppLogInfo = ThirdAppLogUtils.wrapThirdAppLogInfo(kde, request, codeExist);
            thirdAppLogInfo.setThirdType(4L);
            thirdAppLogInfo.setCorpid("");
            thirdAppLogInfo.setAgentid(clientId);
            ThirdAppLogUtils.addLog(thirdAppLogInfo);
            result.setErrorMessage(kde.getMessage());
        }
        catch (Exception e) {
            logger.info("appAuthtication error", (Object)e);
            result.setErrorMessage(e.getMessage());
        }
        return result;
    }
}

