/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.thirdauth.app.ypt;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.http.HttpServletRequest;
import kd.bos.dc.api.model.Account;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.thirdauth.app.AppAuthResult;
import kd.bos.login.thirdauth.app.ThirdAppAuthtication;
import kd.bos.login.thirdauth.app.UserType;
import kd.bos.util.HttpClientUtils;
import org.apache.commons.lang.StringUtils;

public class KdPassportAuthtication
extends ThirdAppAuthtication {
    private static Log logger = LogFactory.getLog(KdPassportAuthtication.class);

    @Override
    public boolean isNeedHandle(HttpServletRequest request, Account account) {
        String code = request.getParameter("kd_passport_code");
        return !StringUtils.isEmpty((String)code);
    }

    @Override
    public AppAuthResult appAuthtication(HttpServletRequest request, Account account) {
        AppAuthResult result = new AppAuthResult();
        result.setSucceed(false);
        String code = request.getParameter("kd_passport_code");
        String clientId = System.getProperty("clientId");
        String apiUrl = System.getProperty("url");
        String clientSecret = System.getProperty("clientSecret");
        String url = String.format("%s/auth/user/auth_code/validation?client_id=%s&client_secret=%s&auth_code=%s", apiUrl, clientId, clientSecret, code);
        JSONObject tokenData = this.cloudApiRequest(url, "post");
        if (tokenData == null) {
            return result;
        }
        result.setUserType(UserType.YZJUID);
        result.setUserFlag(tokenData.getString("uid"));
        result.setSucceed(true);
        return result;
    }

    private JSONObject cloudApiRequest(String url, String method) {
        try {
            String respString = "get".equalsIgnoreCase(method) ? HttpClientUtils.get((String)url) : HttpClientUtils.post((String)url, null, null);
            logger.info("kdpassport_oauth get: " + url + "; result: " + respString);
            JSONObject jsonObject = JSON.parseObject((String)respString);
            if (jsonObject.getInteger("errcode") == 0) {
                return jsonObject.getJSONObject("data");
            }
        }
        finally {
            return null;
        }
        {
        }
    }
}

