/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.thirdauth.app.yzj;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.api.model.Account;
import kd.bos.exception.KDException;
import kd.bos.exception.LoginErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.thirdauth.app.AppAuthResult;
import kd.bos.login.thirdauth.app.ThirdAppAuthtication;
import kd.bos.login.thirdauth.app.UserType;
import kd.bos.login.utils.AgentUtil;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.StringUtils;
import kd.bos.login.yzjprivate.lightapp.AppContext;
import kd.bos.login.yzjprivate.lightapp.YunzhijiaPcdTicketService;

public class YZJPrivateAppAuthticationZSY
extends ThirdAppAuthtication {
    private static Log logger = LogFactory.getLog(YZJPrivateAppAuthticationZSY.class);

    @Override
    public boolean isNeedHandle(HttpServletRequest request, Account currentCenter) {
        boolean isNeed = false;
        String ticket = request.getParameter("ticket");
        String path = request.getServletPath();
        String appId = StringUtils.getTrimedBlank(LoginUtils.getAPPId(request));
        if ((path.toLowerCase(Locale.ENGLISH).contains("/mobile.html") || path.contains("/qing/lappEntrance.do") || StringUtils.isNotEmpty(appId)) && !StringUtils.isEmpty(ticket)) {
            isNeed = true;
        }
        return isNeed;
    }

    @Override
    public AppAuthResult appAuthtication(HttpServletRequest request, Account currentCenter) {
        AppAuthResult result = new AppAuthResult();
        result.setSucceed(false);
        try {
            String ticket = request.getParameter("ticket");
            String appId = StringUtils.getTrimedBlank(LoginUtils.getAPPId(request));
            logger.info(String.format("appIdnew=%s", appId));
            AppContext appCtx = YunzhijiaPcdTicketService.getContextByTicket(currentCenter.getTenantId(), appId, ticket, "jobNo");
            if (appCtx != null) {
                result.setSucceed(true);
                result.setUserFlag(appCtx.getMobile());
                result.setUserType(UserType.MOBILE_PHONE);
                if (!AgentUtil.isMobile(request)) {
                    result.setWeb(true);
                }
            }
            if (!AgentUtil.isMobile(request)) {
                result.setWeb(true);
            }
        }
        catch (KDException ex) {
            throw ex;
        }
        catch (Exception e) {
            String sMsg = String.format(ResManager.loadKDString((String)"App\u9a8c\u8bc1\u9519\u8bef:1)\u79df\u6237\u5c1a\u672a\u5f00\u901a\u4e91ERP\u30022)%s", (String)"YZJPrivateAppAuthticationZSY_0", (String)"bos-login", (Object[])new Object[0]), e.getMessage());
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{sMsg});
        }
        String loginType = request.getParameter("logintype");
        if ("web".equalsIgnoreCase(loginType)) {
            result.setWeb(true);
        }
        result.setAppType("yzj");
        return result;
    }
}

