/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.thirdauth.impl;

import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dc.api.model.Account;
import kd.bos.encrypt.Encrypters;
import kd.bos.exception.KDException;
import kd.bos.exception.LoginErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.thirdauth.LoginUserAuth;
import kd.bos.login.thirdauth.UserAccount;
import kd.bos.login.thirdauth.UserAuthResult;
import kd.bos.login.thirdauth.UserProperType;
import kd.bos.login.thirdauth.impl.ssl.SSLLdapContextSource;
import kd.bos.login.user.ConfigureationService;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.ParametersUtils;
import kd.bos.login.utils.StringUtils;
import kd.bos.login.utils.ssl.KDSSLSocketFactory;
import kd.bos.session.SystemPropertyUtils;
import org.springframework.ldap.core.AuthenticationSource;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.ldap.filter.EqualsFilter;

public class LdapLoginAuth
implements LoginUserAuth {
    private static final String LDAP_SSL_TRUST_STORE = "ldap_ssl_trust_store";
    private static final String LDAP_SSL_PASSWORD = "ldap_ssl_password";
    private static final String HCODE_DOMAIN = "domain";
    private Log log = LogFactory.getLog(LdapLoginAuth.class);

    @Override
    public UserAuthResult userAuthrize(UserAccount user, Account dataCenter) {
        UserAuthResult uar = new UserAuthResult();
        uar.setSucess(false);
        String userName = user.getAccount();
        String userPassword = user.getPassword();
        Map<String, Object> parameters = ConfigureationService.getCommonParameters(dataCenter);
        if ("0".equals(parameters.get("identitychecktype"))) {
            uar = this.newLdapAuthentication(user, dataCenter, uar, parameters);
        } else {
            Properties env = new Properties();
            env.put("java.naming.factory.initial", this.getLDAPContentFacotry(dataCenter.getTenantId()));
            env.put("java.naming.security.authentication", "simple");
            Map<String, String> ldapInfo = LoginUtils.getLdapInfo(dataCenter);
            String ldapURL = ldapInfo.get("url");
            String domain = ldapInfo.get(HCODE_DOMAIN);
            String prefix = this.getSearchPrefix(dataCenter);
            if (StringUtils.isNotEmpty(prefix)) {
                return this.userAuthrizeNew(user, dataCenter, ldapInfo, env);
            }
            String ldapUserName = userName;
            if (domain != null) {
                ldapUserName = userName + "@" + domain;
            }
            env.put("java.naming.security.principal", ldapUserName);
            env.put("java.naming.security.credentials", userPassword);
            env.put("java.naming.provider.url", ldapURL);
            if (this.isLDAPS(ldapURL)) {
                env.put("java.naming.security.protocol", "ssl");
                env.put("java.naming.ldap.factory.socket", KDSSLSocketFactory.class.getName());
            }
            try {
                InitialLdapContext ctx = new InitialLdapContext(env, null);
                this.log.info("LDAP_login:LDAP auth success\uff01");
                uar.setUserType(UserProperType.UserName);
                uar.setUser(userName);
                uar.setJoinedEids(null);
                uar.setSucess(true);
                ctx.close();
            }
            catch (NamingException e) {
                this.log.error("LDAP_login exception :" + e.toString());
                uar.setErrDesc(ResManager.loadKDString((String)"LDAP\u767b\u5f55\u5931\u8d25\u3002", (String)"LdapLoginAuth_0", (String)"bos-login", (Object[])new Object[0]));
            }
        }
        return uar;
    }

    private UserAuthResult newLdapAuthentication(UserAccount user, Account dataCenter, UserAuthResult uar, Map<String, Object> parameters) {
        String userName = user.getAccount();
        String userPassword = user.getPassword();
        uar.setSucess(false);
        try {
            final String dn = this.getParamsToString("admindn", parameters);
            String base = this.getParamsToString("userfdn", parameters);
            String url = this.getParamsToString("ldapurl", parameters);
            String ladpusermapping = this.getParamsToString("ladpusermapping", parameters);
            final String pwd = Encrypters.decode((String)this.getParamsToString("adminpassword", parameters));
            LdapContextSource cs = new LdapContextSource();
            if (url.startsWith("ldaps://")) {
                cs = new SSLLdapContextSource();
            }
            cs.setCacheEnvironmentProperties(false);
            cs.setUrl(url);
            cs.setAuthenticationSource(new AuthenticationSource(){

                public String getCredentials() {
                    return pwd;
                }

                public String getPrincipal() {
                    return dn;
                }
            });
            LdapTemplate ldapTemplate = new LdapTemplate((ContextSource)cs);
            EqualsFilter filter = new EqualsFilter(StringUtils.isEmpty(ladpusermapping) ? "sAMAccountName" : ladpusermapping, userName);
            ldapTemplate.setIgnorePartialResultException(true);
            boolean flag = ldapTemplate.authenticate(base, filter.toString(), userPassword);
            if (!flag) {
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u767b\u5f55\u5931\u8d25\uff0cAD\u57df\u7528\u6237\u6216\u5bc6\u7801\u9519\u8bef\u3002", (String)"PswStrategyService_31", (String)"bos-login", (Object[])new Object[0])});
            }
            uar.setUserType(UserProperType.UserName);
            uar.setUser(userName);
            uar.setJoinedEids(null);
            uar.setSucess(flag);
        }
        catch (KDException kdException) {
            throw kdException;
        }
        catch (Exception e) {
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"LDAP\u767b\u5f55\u5931\u8d25\u3002", (String)"LdapLoginAuth_0", (String)"bos-login", (Object[])new Object[0])});
        }
        return uar;
    }

    private String getParamsToString(String name, Map<String, Object> parameters) {
        String value = "";
        if (!ObjectUtils.isEmpty((Object)parameters.get(name))) {
            value = (String)parameters.get(name);
        }
        return value;
    }

    private boolean isLDAPS(String ldapURL) {
        boolean isLDAPS = false;
        if (StringUtils.isNotEmpty(ldapURL) && ldapURL.trim().toUpperCase(Locale.ENGLISH).startsWith("LDAPS")) {
            isLDAPS = true;
        }
        return isLDAPS;
    }

    private String getLDAPContentFacotry(String tenantId) {
        String factory = "com.sun.jndi.ldap.LdapCtxFactory";
        String factoryString = SystemPropertyUtils.getProptyByTenant((String)"ldap_context_factory", (String)tenantId);
        if (StringUtils.isNotEmpty(factoryString)) {
            factory = factoryString.trim();
        }
        return factory;
    }

    private String getSearchPrefix(Account dataCenter) {
        String prefix = ParametersUtils.getCommonStringParameters(dataCenter, "ldap_search_prefix");
        if (StringUtils.isEmpty(prefix)) {
            prefix = this.getSearchPrefixByTenant(dataCenter.getTenantId());
        }
        return prefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserAuthResult userAuthrizeNew(UserAccount user, Account dataCenter, Map<String, String> ldapInfo, Properties env) {
        UserAuthResult uar = new UserAuthResult();
        uar.setSucess(false);
        Context ctx = null;
        try {
            Control[] connCtls = null;
            String searchDnArrayString = this.getSearchDN(dataCenter);
            if (StringUtils.isEmpty(searchDnArrayString)) {
                ctx = this.LDAP_connect(user, dataCenter, ldapInfo, connCtls, "", env);
            } else {
                String[] searchDnArray = searchDnArrayString.split(";");
                if (searchDnArray.length > 1) {
                    for (int i = 0; i < searchDnArray.length; ++i) {
                        try {
                            ctx = this.LDAP_connect(user, dataCenter, ldapInfo, connCtls, searchDnArray[i], env);
                            break;
                        }
                        catch (NamingException e) {
                            if (i != searchDnArray.length - 1) continue;
                            throw e;
                        }
                    }
                } else {
                    ctx = this.LDAP_connect(user, dataCenter, ldapInfo, connCtls, searchDnArray[0], env);
                }
            }
            this.log.info("LDAP_login:LDAP auth success\uff01");
            uar.setUserType(UserProperType.UserName);
            uar.setUser(user.getAccount());
            uar.setJoinedEids(null);
            uar.setSucess(true);
        }
        catch (Exception e) {
            uar.setErrDesc(ResManager.loadKDString((String)"LDAP\u767b\u5f55\u5931\u8d25\u3002", (String)"LdapLoginAuth_0", (String)"bos-login", (Object[])new Object[0]));
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException namingException) {}
            }
        }
        return uar;
    }

    private String getSearchDN(Account dataCenter) {
        String searchDN = ParametersUtils.getCommonStringParameters(dataCenter, "ldap_search_dn");
        if (StringUtils.isEmpty(searchDN)) {
            searchDN = this.getSearchDNByTenant(dataCenter.getTenantId());
        }
        return searchDN;
    }

    public String getBaseDN(String domain) {
        StringBuilder sb = new StringBuilder();
        if (domain != null) {
            String[] subDomain = domain.split("\\.");
            for (int i = 0; i < subDomain.length; ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append("DC=").append(subDomain[i]);
            }
        }
        return sb.toString();
    }

    private LdapContext LDAP_connect(UserAccount user, Account dataCenter, Map<String, String> ldapInfo, Control[] connCtls, String searchDN, Properties env) throws NamingException {
        String ldapURL = ldapInfo.get("url");
        String domain = ldapInfo.get(HCODE_DOMAIN);
        String baseDomainDN = this.getBaseDN(domain);
        String prefix = this.getSearchPrefix(dataCenter);
        String principal = prefix + "=" + user.getAccount() + "," + baseDomainDN;
        if (StringUtils.isNotEmpty(searchDN)) {
            principal = prefix + "=" + user.getAccount() + "," + searchDN + "," + baseDomainDN;
        }
        String userPassword = user.getPassword();
        env.put("java.naming.provider.url", ldapURL);
        env.put("java.naming.security.principal", principal);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.credentials", userPassword);
        env.put("com.sun.jndi.ldap.connect.timeout", "3000");
        if (this.isLDAPS(ldapURL)) {
            env.put("java.naming.security.protocol", "ssl");
            env.put("java.naming.ldap.factory.socket", KDSSLSocketFactory.class.getName());
        }
        return new InitialLdapContext(env, connCtls);
    }

    private String getSearchDNByTenant(String tenantId) {
        return LdapLoginAuth.getProptyByTenant("ldap_search_dn", tenantId);
    }

    private String getSearchPrefixByTenant(String tenantId) {
        return LdapLoginAuth.getProptyByTenant("ldap_search_prefix", tenantId);
    }

    private static String getProptyByTenant(String key, String tenantId) {
        String pValue = System.getProperty(tenantId + "_" + key);
        if (StringUtils.isEmpty(pValue)) {
            pValue = System.getProperty(key);
        }
        return pValue;
    }
}

