/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.thirdauth.impl;

import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.api.model.Account;
import kd.bos.exception.KDException;
import kd.bos.exception.LoginErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.thirdauth.LoginUserAuth;
import kd.bos.login.thirdauth.UserAccount;
import kd.bos.login.thirdauth.UserAuthResult;
import kd.bos.login.thirdauth.UserProperType;
import kd.bos.login.utils.BeanUtils;
import kd.bos.login.utils.OAuth2Encrypter;
import kd.bos.login.utils.SystemPropertyUtils;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.StringUtils;
import kd.bos.util.UriQuery;

public class YzjPrvCloudAuth
implements LoginUserAuth {
    private static final String BOS_LOGIN = "bos-login";
    private Log logger = LogFactory.getLog(YzjPrvCloudAuth.class);
    private static final String YZJ_SYY_WBHOST = ".WBHost";
    private static final String YZJ_SYY_WEBLOGIN_API = "/snsapi/oauth/access_token";

    @Override
    public UserAuthResult userAuthrize(UserAccount user, Account dataCenter) {
        UserAuthResult uar = new UserAuthResult();
        uar.setSucess(false);
        uar.setErrDesc(ResManager.loadKDString((String)"\u4e91\u4e4b\u5bb6\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef\u3002", (String)"YzjPrvCloudAuth_0", (String)BOS_LOGIN, (Object[])new Object[0]));
        try {
            String webHost = "";
            if (StringUtils.isEmpty((String)webHost)) {
                webHost = System.getProperty(dataCenter.getTenantId() + YZJ_SYY_WBHOST);
            }
            if (StringUtils.isEmpty((String)webHost)) {
                throw new KDException(LoginErrorCode.loginBizException, new Object[]{String.format(ResManager.loadKDString((String)"\u4e91\u4e4b\u5bb6\u79c1\u6709\u4e91Web\u767b\u5f55\u5931\u8d25\uff0c\u65e0Web\u7ad9\u70b9\uff0c\u79df\u6237id=%s", (String)"YzjPrvCloudAuth_1", (String)BOS_LOGIN, (Object[])new Object[0]), dataCenter.getTenantId())});
            }
            String sQRURL = webHost + YZJ_SYY_WEBLOGIN_API;
            HashMap<String, String> mpBody = new HashMap<String, String>();
            mpBody.put("x_auth_username", user.getAccount());
            mpBody.put("x_auth_password", user.getPassword());
            mpBody.put("x_auth_mode", "client_auth");
            String oauth_signature_method = null;
            long oauth_timestamp = System.currentTimeMillis() / 1000L;
            String oauth_nonce = String.valueOf(oauth_timestamp + (long)new SecureRandom().nextInt());
            float oauth_version = 1.0f;
            String sAppID = "lRudaAEghEJGEHkw";
            String sAppSecret = SystemPropertyUtils.getProptyByTenant("yzjPrvCloudAuth_AppSecret", dataCenter.getTenantId());
            OAuth2Encrypter oauth2Encrypter = (OAuth2Encrypter)BeanUtils.getBean("kd.bos.login.utils.oauth2.OAuth2EncrypterImpl");
            String sAuthorization = oauth2Encrypter.generateAuthorizationHeader(sAppID, sAppSecret, oauth_signature_method, oauth_timestamp, oauth_nonce, oauth_version, null, null, null, sQRURL, mpBody, "POST");
            HashMap<String, String> header = new HashMap<String, String>();
            header.put("Authorization", sAuthorization);
            header.put("Content-type", "application/x-www-form-urlencoded;charset=UTF-8");
            String sToken = HttpClientUtils.post((String)sQRURL, header, mpBody);
            if (!StringUtils.isEmpty((String)sToken)) {
                Map token = null;
                if (StringUtils.isNotEmpty((String)sToken)) {
                    token = UriQuery.toMap((String)sToken);
                }
                if (token != null && StringUtils.isNotEmpty((String)((String)token.get("oauth_token")))) {
                    uar.setUserType(UserProperType.Mobile);
                    uar.setUser(user.getAccount());
                    uar.setErrDesc("");
                    uar.setSucess(true);
                }
            }
            return uar;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, LoginErrorCode.loginBizException, new Object[]{ResManager.loadKDString((String)"\u4e91\u4e4b\u5bb6\u767b\u5f55\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002", (String)"YzjPrvCloudAuth_2", (String)BOS_LOGIN, (Object[])new Object[0])});
        }
    }
}

