/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.user;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dc.api.model.Account;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.model.Language;
import kd.bos.login.utils.LoginUtils;
import kd.bos.servicehelper.inte.InteServiceHelper;

public class LanguageService {
    private static Log logger = LogFactory.getLog(LanguageService.class);

    public static List<Language> getAllLanguage(Account currentAccount) {
        List<Language> returnList = new ArrayList(8);
        try {
            returnList = InteServiceHelper.getAllLanguageForLogin((Account)currentAccount);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        if (returnList.size() <= 0) {
            Language language = new Language();
            language.setName("English");
            language.setNumber("en_US");
            language.setDefault(true);
            returnList.add(language);
        }
        return returnList;
    }

    public static Lang getDefaultLang(Account currentCenter) {
        List<Language> lList = LoginUtils.getAllLanguagesByAccount(currentCenter);
        for (Language language : lList) {
            if (!language.isDefault()) continue;
            return Lang.from((String)language.getName());
        }
        return Lang.defaultLang();
    }
}

