/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.user;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.dc.utils.MCDBUtil;
import kd.bos.dc.utils.SQLUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.service.ThirdAppService;
import kd.bos.login.thirdauth.UserAuthResult;
import kd.bos.login.thirdauth.UserProperType;
import kd.bos.login.utils.AdminUtils;
import kd.bos.login.utils.ErrorCodeUtils;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.ParametersUtils;
import kd.bos.login.utils.SecurityUtils;
import kd.bos.login.utils.ValidationUtils;
import kd.bos.login.utils.account.LoginAccountFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.util.NetAddressUtils;
import kd.bos.util.PasswordEncryptUtil;
import kd.bos.util.StringUtils;

public class LoginUserService {
    private static final String FID = "fid";
    private static final String S_LOGIN_PASSWORD = "s_login_password";
    private static final String FISACCOUNT = "fisaccount";
    private static final String SQL_LEFT_JOIN_T_SEC_USER_U_TU_ON_T1_FID_TU_FID = " left join t_sec_user_u tu on t1.fid=tu.fid ";
    private static final String SQL_FROM_T_SEC_USER_T1 = " from t_sec_user t1 ";
    private static final String SQL_LEFT_JOIN_T_SEC_USERPOSITION_POS_ON_T1_FID_POS_FID = " left join t_sec_userposition pos on t1.fid=pos.fid ";
    private static final String LEFT_JOIN_T_BAS_USERDEFAULTORG_UDO_ON_T1_FID_UDO_FUSERID = " left join t_bas_userdefaultorg udo on t1.fid = udo.fuserid ";
    private static final String USERID = "userid";
    private static final String FOPENID = "fopenid";
    private static final String FORGID = "forgid";
    private static final String FDPTID = "fdptid";
    private static final String FISACTIVED = "fisactived";
    private static final String FISREGISTED = "fisregisted";
    private static final String FLASTLOGINIP = "flastloginip";
    private static final String FLASTLOGINTIME = "flastlogintime";
    private static final String LOGIN_ORGFILTER = "login.orgfilter";
    private static final String AND_POS_FDPTID_NOT_IN_S = " and pos.fdptid not in (%s) ";
    private static final String LOGGER_YUNZHIJIA_ACTION_CAN_NOT_FIND_USER = "YunzhijiaAction can not find user :";
    private static final String SQL_SELECT_PARAM = " select t1.fenable, t1.femail,t1.fphone,tu.fusername, t1.feid,t1.fuid,t1.fid,t1.fopenid,t1.fusertype userType,CASE WHEN pos.fdptid is null then 0 else pos.fdptid end as fdptid,udo.forgid forgid ,u.fisactived,u.fisregisted";
    private static final String SQL_LEFT_JOIN_T_SEC_USER_U_U_ON_T1_FID_U_FID = " left join t_sec_user_u u on t1.fid=u.fid ";
    private static final String LOGGER_LOGIN_USER_SERVICE_CAN_NOT_FIND_USER = "LoginUserService can not find user :";
    private static final String FPASSWORD = "fpassword";
    private static final String FENABLE = "fenable";
    private static final String USER_SELECT_PROPERTIES = "id,number,entryentity.dpt,name,eid,isregisted,usertype,pswstrategy,isactived,phone,enable,fuid,email,username,useropenid,pswhisstr,isforbidden,psweffectivedate";
    private static Log logger = LogFactory.getLog(LoginUserService.class);
    private static Map<String, Map<String, String>> userMap = new HashMap<String, Map<String, String>>();
    private static final String BOS_USER = "bos_user";
    private static final String VALUE_0 = "0";
    private static final String VALUE_1 = "1";

    public static Map<String, String> getErpUserInfoByPhone(Account currentCenter, String mobile, String language) {
        Map<String, String> mapUser = new HashMap<String, String>(8);
        DynamicObject[] userArray = LoginUserService.getUserList(mobile, UserProperType.Mobile);
        if (userArray != null && userArray.length > 0) {
            DynamicObject user = userArray[0];
            mapUser = LoginUserService.wrapLoginUserInfo(user, language);
        }
        return mapUser;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> getErpUserInfoByUUID(Account currentCenter, String UUID2, String language) {
        HashMap<String, String> mapUser = new HashMap<String, String>();
        Properties dataBaseProperties = AccountUtils.getTenantDBInfo((Account)currentCenter);
        if (dataBaseProperties == null) {
            throw new KDException(BosErrorCode.configNotFound, new Object[]{ErrorCodeUtils.getDBIntralError()});
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = MCDBUtil.getConnection((Account)currentCenter, (Properties)dataBaseProperties);
            String sql = "";
            boolean index = true;
            int numbers = 2;
            sql = "select t1.fenable, t1.fphone,t1.feid,t1.fuid,t1.fid,t1.fopenid,fusertype userType, t3.fisactived,t3.fisregisted, CASE WHEN pos.fdptid is null then 0 else pos.fdptid end as fdptid,udo.forgid forgid,udo.fbizpartnerid  from t_sec_user t1  inner join  t_sec_user_l t2 on t1.fid=t2.fid  left join t_sec_userposition pos on t1.fid=pos.fid  left join t_bas_userdefaultorg udo on t1.fid = udo.fuserid  left join t_sec_user_u t3  on t1.fid = t3.fid  where  t3.fexternaluuid=? and t1.fenable='1' ";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, UUID2);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                mapUser.put("fphone", rs.getString("fphone"));
                mapUser.put("eid", rs.getString("feid"));
                mapUser.put(USERID, rs.getString(FID));
                mapUser.put("useropenid", rs.getString(FOPENID));
                mapUser.put(FORGID, rs.getString(FDPTID));
                mapUser.put(FOPENID, rs.getString(FOPENID));
                mapUser.put(FID, rs.getString(FID));
                mapUser.put("fuid", rs.getString("fuid"));
                mapUser.put("userType", rs.getString("userType"));
                String defaultOrgId = rs.getString(FORGID);
                if (LoginUserService.checkDefaultOrg(defaultOrgId)) {
                    mapUser.put(FORGID, defaultOrgId);
                }
                mapUser.put(FISACTIVED, rs.getString(FISACTIVED));
                mapUser.put(FISREGISTED, rs.getString(FISREGISTED));
                String trueName = LoginUserService.getTrueNameByFIDAndLanguage(conn, (String)mapUser.get(FID), language);
                if (trueName != null) {
                    mapUser.put("ftruename", trueName);
                    mapUser.put("username", trueName);
                }
                mapUser.put(FENABLE, rs.getString(FENABLE));
                mapUser.put("fbizpartnerid", rs.getString("fbizpartnerid"));
            }
        }
        catch (SQLException e) {
            try {
                throw new KDException((Throwable)e, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + ErrorCodeUtils.getSlipSignerror() + e.getMessage()});
                catch (Exception e2) {
                    throw new KDException((Throwable)e2, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + ErrorCodeUtils.getSlipSignerror() + e2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return mapUser;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> getErpUserInfoByPirviateCloudopenId(String tenantId, String accountId, String yzjUid, String language) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        HashMap<String, String> mpResult;
        block11: {
            String orgFilter = System.getProperty(LOGIN_ORGFILTER);
            mpResult = new HashMap<String, String>();
            mpResult.put("success", VALUE_0);
            conn = null;
            stmt = null;
            rs = null;
            try {
                Account currentAccount = LoginAccountFactory.createInstanceByCustom(accountId, tenantId).getAccount();
                Properties dataBaseProperties = AccountUtils.getTenantDBInfo((Account)currentAccount);
                if (dataBaseProperties == null) {
                    throw new KDException(BosErrorCode.configNotFound, new Object[]{ErrorCodeUtils.getDBIntralError()});
                }
                conn = MCDBUtil.getConnection((Account)currentAccount, (Properties)dataBaseProperties);
                StringBuilder sbSQl = new StringBuilder();
                sbSQl.append(" select t1.feid,t1.fuid,t1.fid,t1.fopenid,t1.fusertype userType,CASE WHEN pos.fdptid is null then 0 else pos.fdptid end as fdptid,udo.forgid forgid ");
                sbSQl.append(SQL_FROM_T_SEC_USER_T1);
                sbSQl.append(SQL_LEFT_JOIN_T_SEC_USERPOSITION_POS_ON_T1_FID_POS_FID);
                sbSQl.append(LEFT_JOIN_T_BAS_USERDEFAULTORG_UDO_ON_T1_FID_UDO_FUSERID);
                sbSQl.append(" where t1.fopenid=?  ");
                if (!StringUtils.isEmpty((String)orgFilter) && !SecurityUtils.containsSqlInjection(orgFilter)) {
                    sbSQl.append(String.format(AND_POS_FDPTID_NOT_IN_S, orgFilter));
                }
                stmt = conn.prepareStatement(sbSQl.toString());
                stmt.setString(1, yzjUid);
                rs = stmt.executeQuery();
                if (rs.next()) {
                    String trueName;
                    mpResult.put(FOPENID, rs.getString(FOPENID));
                    mpResult.put(FID, rs.getString(FID));
                    mpResult.put("feid", rs.getString("feid"));
                    mpResult.put("fuid", rs.getString("fuid"));
                    mpResult.put(USERID, rs.getString(FID));
                    mpResult.put(FORGID, rs.getString(FDPTID));
                    mpResult.put("userType", rs.getString("userType"));
                    String defaultOrgId = rs.getString(FORGID);
                    if (LoginUserService.checkDefaultOrg(defaultOrgId)) {
                        mpResult.put(FORGID, defaultOrgId);
                    }
                    if ((trueName = LoginUserService.getTrueNameByFIDAndLanguage(conn, (String)mpResult.get(FID), language)) != null) {
                        mpResult.put("ftruename", trueName);
                    }
                    mpResult.put("success", VALUE_1);
                    break block11;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug(LOGGER_YUNZHIJIA_ACTION_CAN_NOT_FIND_USER + yzjUid);
                }
            }
            catch (SQLException e) {
                try {
                    throw new KDException((Throwable)e, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + ErrorCodeUtils.getSlipSignerror() + e.getMessage()});
                    catch (Exception e2) {
                        throw new KDException((Throwable)e2, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + ErrorCodeUtils.getSlipSignerror() + e2.getMessage()});
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, stmt, conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return mpResult;
    }

    public static Map<String, String> getErpUserInfoByEmail(Account currentAccount, String userEmail, String language) {
        Map<String, String> mapUser = new HashMap<String, String>(8);
        DynamicObject[] userArray = LoginUserService.getUserList(userEmail, UserProperType.Email);
        if (userArray != null && userArray.length > 0) {
            DynamicObject user = userArray[0];
            mapUser = LoginUserService.wrapLoginUserInfo(user, language);
        }
        return mapUser;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> getErpUserInfoByUserId(Account currentAccount, String userId, String language) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        HashMap<String, String> mpResult;
        block12: {
            String orgFilter = System.getProperty(LOGIN_ORGFILTER);
            mpResult = new HashMap<String, String>();
            mpResult.put("success", VALUE_0);
            conn = null;
            stmt = null;
            rs = null;
            try {
                Properties dataBaseProperties = AccountUtils.getTenantDBInfo((Account)currentAccount);
                if (dataBaseProperties == null) {
                    throw new KDException(BosErrorCode.configNotFound, new Object[]{ErrorCodeUtils.getDBIntralError()});
                }
                conn = MCDBUtil.getConnection((Account)currentAccount, (Properties)dataBaseProperties);
                StringBuilder sbSQl = new StringBuilder();
                sbSQl.append(SQL_SELECT_PARAM);
                sbSQl.append(",udo.fbizpartnerid,u.fisforbidden ");
                sbSQl.append(SQL_FROM_T_SEC_USER_T1);
                sbSQl.append(SQL_LEFT_JOIN_T_SEC_USER_U_TU_ON_T1_FID_TU_FID);
                sbSQl.append(SQL_LEFT_JOIN_T_SEC_USERPOSITION_POS_ON_T1_FID_POS_FID);
                sbSQl.append(SQL_LEFT_JOIN_T_SEC_USER_U_U_ON_T1_FID_U_FID);
                sbSQl.append(LEFT_JOIN_T_BAS_USERDEFAULTORG_UDO_ON_T1_FID_UDO_FUSERID);
                sbSQl.append(" where t1.fid=? and t1.fenable='1' and u.fisforbidden = '0' ");
                if (!StringUtils.isEmpty((String)orgFilter) && !SecurityUtils.containsSqlInjection(orgFilter)) {
                    sbSQl.append(String.format(AND_POS_FDPTID_NOT_IN_S, orgFilter));
                }
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("LoginUserService\u4e2d\u4e91\u4e4b\u5bb6\u7528\u6237\u7684email\uff1a%s.", userId));
                }
                stmt = conn.prepareStatement(sbSQl.toString());
                stmt.setLong(1, Long.parseLong(userId));
                rs = stmt.executeQuery();
                if (rs.next()) {
                    mpResult.put(FOPENID, rs.getString(FOPENID));
                    mpResult.put(FID, rs.getString(FID));
                    mpResult.put(USERID, rs.getString(FID));
                    mpResult.put("feid", rs.getString("feid"));
                    mpResult.put("fuid", rs.getString("fuid"));
                    mpResult.put(FORGID, rs.getString(FDPTID));
                    mpResult.put("userType", rs.getString("userType"));
                    String defaultOrgId = rs.getString(FORGID);
                    if (LoginUserService.checkDefaultOrg(defaultOrgId)) {
                        mpResult.put(FORGID, defaultOrgId);
                    }
                    mpResult.put(FISACTIVED, rs.getString(FISACTIVED));
                    mpResult.put(FISREGISTED, rs.getString(FISREGISTED));
                    mpResult.put("success", VALUE_1);
                    String trueName = LoginUserService.getTrueNameByFIDAndLanguage(conn, (String)mpResult.get(FID), language);
                    if (trueName != null) {
                        mpResult.put("ftruename", trueName);
                    }
                    mpResult.put("fphone", rs.getString("fphone"));
                    mpResult.put("femail", rs.getString("femail"));
                    mpResult.put("fusername", rs.getString("fusername"));
                    mpResult.put(FENABLE, rs.getString(FENABLE));
                    mpResult.put("fbizpartnerid", rs.getString("fbizpartnerid"));
                    mpResult.put("fisforbidden", rs.getString("fisforbidden"));
                    break block12;
                }
                if (logger.isDebugEnabled()) {
                    logger.info(LOGGER_LOGIN_USER_SERVICE_CAN_NOT_FIND_USER + userId);
                }
            }
            catch (SQLException e) {
                try {
                    throw new KDException((Throwable)e, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + ErrorCodeUtils.getSlipSignerror() + e.getMessage()});
                    catch (Exception e2) {
                        throw new KDException((Throwable)e2, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + ErrorCodeUtils.getSlipSignerror() + e2.getMessage()});
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, stmt, conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return mpResult;
    }

    private static String getTrueNameByFIDAndLanguage(Connection conn, String fid, String language) {
        String trueName;
        block9: {
            trueName = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                String sql = "select  FTRUENAME,FLOCALEID from t_sec_user_l where fid=?";
                if (conn == null || !StringUtils.isNumericString((String)fid) || !StringUtils.isNotEmpty((String)language)) break block9;
                pstmt = conn.prepareStatement(sql);
                pstmt.setLong(1, Long.parseLong(fid));
                rs = pstmt.executeQuery();
                int i = 0;
                while (rs.next()) {
                    if (i == 0) {
                        trueName = rs.getString("FTRUENAME");
                    }
                    if (language.equals(rs.getString("FLOCALEID"))) {
                        trueName = rs.getString("FTRUENAME");
                        break;
                    }
                    ++i;
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + ErrorCodeUtils.getSlipSignerror() + e.getMessage()});
            }
            catch (Exception e) {
                throw new KDException((Throwable)e, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + ErrorCodeUtils.getSlipSignerror() + e.getMessage()});
            }
            finally {
                SQLUtils.cleanup(rs, pstmt, null);
            }
        }
        return trueName;
    }

    public static Map<String, String> getErpUserInfoByUserName(Account currentAccount, String userName, String language) {
        Map<String, String> mapUser = new HashMap<String, String>(8);
        DynamicObject[] userArray = LoginUserService.getUserList(userName, UserProperType.UserName);
        if (userArray != null && userArray.length > 0) {
            DynamicObject user = userArray[0];
            mapUser = LoginUserService.wrapLoginUserInfo(user, language);
        }
        return mapUser;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> getErpUserInfo(String tenantId, String accountId, long yzjUid, String language) {
        String orgFilter = System.getProperty(LOGIN_ORGFILTER);
        HashMap<String, String> mpResult = new HashMap<String, String>();
        mpResult.put("success", VALUE_0);
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            Account currentAccount = LoginAccountFactory.createInstanceByCustom(accountId, tenantId).getAccount();
            Properties dataBaseProperties = AccountUtils.getTenantDBInfo((Account)currentAccount);
            if (dataBaseProperties == null) {
                throw new KDException(BosErrorCode.configNotFound, new Object[]{ErrorCodeUtils.getDBIntralError()});
            }
            conn = MCDBUtil.getConnection((Account)currentAccount, (Properties)dataBaseProperties);
            StringBuilder sbSQl = new StringBuilder();
            sbSQl.append(" select t1.feid,t1.fuid,t1.fid,t1.fopenid,t1.fusertype userType,CASE WHEN pos.fdptid is null then 0 else pos.fdptid end as fdptid,udo.forgid forgid,udo.fbizpartnerid ");
            sbSQl.append(SQL_FROM_T_SEC_USER_T1);
            sbSQl.append(SQL_LEFT_JOIN_T_SEC_USERPOSITION_POS_ON_T1_FID_POS_FID);
            sbSQl.append(LEFT_JOIN_T_BAS_USERDEFAULTORG_UDO_ON_T1_FID_UDO_FUSERID);
            sbSQl.append(" where t1.fuid=? and t1.fenable='1' ");
            if (!StringUtils.isEmpty((String)orgFilter) && !SecurityUtils.containsSqlInjection(orgFilter)) {
                sbSQl.append(String.format(AND_POS_FDPTID_NOT_IN_S, orgFilter));
            }
            stmt = conn.prepareStatement(sbSQl.toString());
            stmt.setLong(1, yzjUid);
            rs = stmt.executeQuery();
            if (rs.next()) {
                mpResult.put("db_driver", LoginUserService.getDBDriver(dataBaseProperties));
                mpResult.put("db_url", LoginUserService.getDBUrl(dataBaseProperties));
                mpResult.put(FOPENID, rs.getString(FOPENID));
                mpResult.put(FID, rs.getString(FID));
                mpResult.put(USERID, rs.getString(FID));
                mpResult.put("feid", rs.getString("feid"));
                mpResult.put("fuid", rs.getString("fuid"));
                mpResult.put(FORGID, rs.getString(FDPTID));
                mpResult.put("userType", rs.getString("userType"));
                String defaultOrgId = rs.getString(FORGID);
                if (LoginUserService.checkDefaultOrg(defaultOrgId)) {
                    mpResult.put(FORGID, defaultOrgId);
                }
                mpResult.put("success", VALUE_1);
                String trueName = LoginUserService.getTrueNameByFIDAndLanguage(conn, (String)mpResult.get(FID), language);
                if (trueName != null) {
                    mpResult.put("ftruename", trueName);
                }
                mpResult.put("fbizpartnerid", rs.getString("fbizpartnerid"));
            } else {
                logger.info(LOGGER_YUNZHIJIA_ACTION_CAN_NOT_FIND_USER + yzjUid);
            }
        }
        catch (SQLException e) {
            try {
                throw new KDException((Throwable)e, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + ErrorCodeUtils.getSlipSignerror() + e.getMessage()});
                catch (Exception e2) {
                    throw new KDException((Throwable)e2, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + ErrorCodeUtils.getSlipSignerror() + e2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return mpResult;
    }

    private static String getDBUrl(Properties dataBaseProperties) {
        return dataBaseProperties.getProperty("url");
    }

    private static String getDBDriver(Properties dataBaseProperties) {
        return dataBaseProperties.getProperty("driverClassName");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> getErpUserInfo(Account currentAccount, long yzjUid, String language) {
        String orgFilter = System.getProperty(LOGIN_ORGFILTER);
        HashMap<String, String> mpResult = new HashMap<String, String>();
        mpResult.put("success", VALUE_0);
        if (0L == yzjUid) {
            return mpResult;
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            Properties dataBaseProperties = AccountUtils.getTenantDBInfo((Account)currentAccount);
            if (dataBaseProperties == null) {
                throw new KDException(BosErrorCode.configNotFound, new Object[]{ErrorCodeUtils.getDBIntralError()});
            }
            conn = MCDBUtil.getConnection((Account)currentAccount, (Properties)dataBaseProperties);
            StringBuilder sbSQl = new StringBuilder();
            sbSQl.append(" select t1.fphone,t1.feid,t1.fuid,t1.fid,t1.fopenid,t1.fusertype userType,t2.fisactived,t2.fisregisted,CASE WHEN pos.fdptid is null then 0 else pos.fdptid end as fdptid,udo.forgid forgid,t2.flastloginip,t2.flastlogintime,t2.fpswstrategyid,udo.fbizpartnerid ");
            sbSQl.append(SQL_FROM_T_SEC_USER_T1);
            sbSQl.append(SQL_LEFT_JOIN_T_SEC_USERPOSITION_POS_ON_T1_FID_POS_FID);
            sbSQl.append(LEFT_JOIN_T_BAS_USERDEFAULTORG_UDO_ON_T1_FID_UDO_FUSERID);
            sbSQl.append(" left join t_sec_user_u t2  on t1.fid = t2.fid ");
            sbSQl.append(" where t1.fuid=? and t1.fenable='1' and t2.fisforbidden = '0' ");
            if (!StringUtils.isEmpty((String)orgFilter) && !SecurityUtils.containsSqlInjection(orgFilter)) {
                sbSQl.append(String.format(AND_POS_FDPTID_NOT_IN_S, orgFilter));
            }
            stmt = conn.prepareStatement(sbSQl.toString());
            stmt.setLong(1, yzjUid);
            rs = stmt.executeQuery();
            if (rs.next()) {
                mpResult.put("db_driver", LoginUserService.getDBDriver(dataBaseProperties));
                mpResult.put("db_url", LoginUserService.getDBUrl(dataBaseProperties));
                mpResult.put("fphone", rs.getString("fphone"));
                mpResult.put(FOPENID, rs.getString(FOPENID));
                mpResult.put(FID, rs.getString(FID));
                mpResult.put(USERID, rs.getString(FID));
                mpResult.put("feid", rs.getString("feid"));
                mpResult.put(FORGID, rs.getString(FDPTID));
                mpResult.put("fuid", rs.getString("fuid"));
                mpResult.put("userType", rs.getString("userType"));
                String defaultOrgId = rs.getString(FORGID);
                if (LoginUserService.checkDefaultOrg(defaultOrgId)) {
                    mpResult.put(FORGID, defaultOrgId);
                }
                mpResult.put("success", VALUE_1);
                mpResult.put(FISACTIVED, rs.getString(FISACTIVED));
                mpResult.put(FISREGISTED, rs.getString(FISREGISTED));
                mpResult.put(FLASTLOGINIP, rs.getString(FLASTLOGINIP));
                mpResult.put(FLASTLOGINTIME, rs.getString(FLASTLOGINTIME));
                String trueName = LoginUserService.getTrueNameByFIDAndLanguage(conn, (String)mpResult.get(FID), language);
                if (trueName != null) {
                    mpResult.put("ftruename", trueName);
                }
                mpResult.put("fpswstrategyid", rs.getString("fpswstrategyid"));
                mpResult.put("fbizpartnerid", rs.getString("fbizpartnerid"));
            } else {
                logger.info(LOGGER_YUNZHIJIA_ACTION_CAN_NOT_FIND_USER + yzjUid);
            }
        }
        catch (SQLException e) {
            try {
                throw new KDException((Throwable)e, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + ErrorCodeUtils.getSlipSignerror() + e.getMessage()});
                catch (Exception e2) {
                    throw new KDException((Throwable)e2, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + ErrorCodeUtils.getSlipSignerror() + e2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return mpResult;
    }

    public static boolean isValidUserInfo(Map<String, String> userInfo) {
        return userInfo != null && !userInfo.isEmpty() && !VALUE_0.equalsIgnoreCase(userInfo.get("success"));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> getErpUserInfo(Account currentAccount, String yzjOpenId, String language) {
        HashMap<String, String> mpResult = new HashMap<String, String>();
        mpResult.put("success", VALUE_0);
        if (StringUtils.isEmpty((String)yzjOpenId)) {
            return mpResult;
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            Properties dataBaseProperties = AccountUtils.getTenantDBInfo((Account)currentAccount);
            if (dataBaseProperties == null) {
                throw new KDException(BosErrorCode.configNotFound, new Object[]{ErrorCodeUtils.getDBIntralError()});
            }
            conn = MCDBUtil.getConnection((Account)currentAccount, (Properties)dataBaseProperties);
            String sql = "";
            sql = "select t1.fenable,t1.feid,t1.fuid,t1.fid,t1.fopenid,t1.fusertype userType,CASE WHEN pos.fdptid is null then 0 else pos.fdptid end as fdptid ,udo.forgid forgid,t1.favatar,t2.fisactived,t2.fisregisted,udo.fbizpartnerid  from t_sec_user t1  left join t_sec_userposition pos on t1.fid=pos.fid  left join t_sec_user_u t2  on t1.fid = t2.fid  left join t_bas_userdefaultorg udo on t1.fid = udo.fuserid  where t1.fopenid=? and t1.fenable='1' and t2.fisforbidden = '0'";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, yzjOpenId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                mpResult.put("db_driver", LoginUserService.getDBDriver(dataBaseProperties));
                mpResult.put("db_url", LoginUserService.getDBUrl(dataBaseProperties));
                mpResult.put(FOPENID, rs.getString(FOPENID));
                mpResult.put(FID, rs.getString(FID));
                mpResult.put(USERID, rs.getString(FID));
                mpResult.put("feid", rs.getString("feid"));
                mpResult.put(FORGID, rs.getString(FDPTID));
                mpResult.put("favatar", rs.getString("favatar"));
                mpResult.put("fuid", rs.getString("fuid"));
                mpResult.put("userType", rs.getString("userType"));
                String defaultOrgId = rs.getString(FORGID);
                if (LoginUserService.checkDefaultOrg(defaultOrgId)) {
                    mpResult.put(FORGID, defaultOrgId);
                }
                mpResult.put(FISACTIVED, rs.getString(FISACTIVED));
                mpResult.put(FISREGISTED, rs.getString(FISREGISTED));
                mpResult.put("success", VALUE_1);
                String trueName = LoginUserService.getTrueNameByFIDAndLanguage(conn, (String)mpResult.get(FID), language);
                if (trueName != null) {
                    mpResult.put("ftruename", trueName);
                }
                mpResult.put(FENABLE, rs.getString(FENABLE));
                mpResult.put("fbizpartnerid", rs.getString("fbizpartnerid"));
            }
        }
        catch (SQLException e) {
            try {
                throw new KDException((Throwable)e, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + ErrorCodeUtils.getSlipSignerror() + e.getMessage()});
                catch (Exception e2) {
                    throw new KDException((Throwable)e2, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + ErrorCodeUtils.getSlipSignerror() + e2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return mpResult;
    }

    public static Map<String, String> proveErpUserPassword(Account currentAccount, String userNo, String password) {
        String key = userNo + S_LOGIN_PASSWORD + password;
        Map<String, String> tempResult = ParametersUtils.getUserInfoBykey(currentAccount, key);
        if (tempResult != null) {
            return tempResult;
        }
        HashMap<String, String> mpResult = new HashMap<String, String>(8);
        mpResult.put("success", VALUE_0);
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(8);
        qFilterList.add(new QFilter("enable", "=", (Object)VALUE_1));
        qFilterList.add(new QFilter("isforbidden", "=", (Object)VALUE_0));
        DynamicObject[] userArray = LoginUserService.getUserListInfo(userNo, UserProperType.Mobile, qFilterList, "id,password,phone");
        if (userArray != null && userArray.length > 0) {
            DynamicObject user = userArray[0];
            String OldPassword = user.getString("password");
            String userId = user.getString("id");
            if (PasswordEncryptUtil.checkPasswordWithSalt((String)LoginUtils.getCorrectUserIDSalt(userId), (String)password, (String)OldPassword)) {
                mpResult.put("fphone", user.getString("phone"));
                mpResult.put("success", VALUE_1);
                mpResult.put("userId", userId);
                ParametersUtils.putUserInfoBykey(currentAccount, key, mpResult);
            }
        }
        return mpResult;
    }

    public static Map<String, String> proveErpUserPasswordByEmail(Account currentAccount, String email, String password) {
        String key = email + S_LOGIN_PASSWORD + password;
        Map<String, String> tempResult = ParametersUtils.getUserInfoBykey(currentAccount, key);
        if (tempResult != null) {
            return tempResult;
        }
        HashMap<String, String> mpResult = new HashMap<String, String>(8);
        mpResult.put("success", VALUE_0);
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(8);
        qFilterList.add(new QFilter("enable", "=", (Object)VALUE_1));
        qFilterList.add(new QFilter("isforbidden", "=", (Object)VALUE_0));
        DynamicObject[] userArray = LoginUserService.getUserListInfo(email, UserProperType.Email, qFilterList, "id,password,email");
        if (userArray != null && userArray.length > 0) {
            DynamicObject user = userArray[0];
            String OldPassword = user.getString("password");
            String userId = user.getString("id");
            if (PasswordEncryptUtil.checkPasswordWithSalt((String)LoginUtils.getCorrectUserIDSalt(userId), (String)password, (String)OldPassword)) {
                mpResult.put("fphone", user.getString("email"));
                mpResult.put("success", VALUE_1);
                ParametersUtils.putUserInfoBykey(currentAccount, key, mpResult);
            }
        }
        return mpResult;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> proveErpUserPasswordByUserName(Account currentAccount, String userName, String password) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        HashMap<String, String> mpResult;
        block8: {
            String key = userName + S_LOGIN_PASSWORD + password;
            Map<String, String> tempResult = ParametersUtils.getUserInfoBykey(currentAccount, key);
            if (tempResult != null) {
                return tempResult;
            }
            mpResult = new HashMap<String, String>();
            mpResult.put("success", VALUE_0);
            conn = null;
            stmt = null;
            rs = null;
            try {
                Properties dataBaseProperties = AccountUtils.getTenantDBInfo((Account)currentAccount);
                if (dataBaseProperties == null) {
                    throw new KDException(BosErrorCode.configNotFound, new Object[]{ErrorCodeUtils.getDBIntralError()});
                }
                conn = MCDBUtil.getConnection((Account)currentAccount, (Properties)dataBaseProperties);
                String sql = "select t1.fid,t2.FUserName,t2.fpassword from t_sec_user t1 inner join t_sec_user_u t2 on t1.FID=t2.FID where t2.FUserName =?   and t1.fenable='1' and t2.fisforbidden = '0'";
                stmt = conn.prepareStatement(sql);
                int index = 1;
                stmt.setString(index++, userName);
                rs = stmt.executeQuery();
                if (!rs.next()) break block8;
                String OldPassword = rs.getString(FPASSWORD);
                String userId = rs.getString(FID);
                if (PasswordEncryptUtil.checkPasswordWithSalt((String)LoginUtils.getCorrectUserIDSalt(userId), (String)password, (String)OldPassword)) {
                    mpResult.put("fphone", rs.getString("FUserName"));
                    mpResult.put("success", VALUE_1);
                    ParametersUtils.putUserInfoBykey(currentAccount, key, mpResult);
                }
            }
            catch (SQLException e) {
                try {
                    throw new KDException((Throwable)e, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + ErrorCodeUtils.getSlipSignerror() + e.getMessage()});
                    catch (Exception e2) {
                        throw new KDException((Throwable)e2, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + ErrorCodeUtils.getSlipSignerror() + e2.getMessage()});
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, stmt, conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return mpResult;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> proveErpUserPassword(String tenantId, String accountId, String userNo, String password) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        HashMap<String, String> mpResult;
        block9: {
            String key;
            Account currentAccount = LoginAccountFactory.createInstanceByCustom(accountId, tenantId).getAccount();
            Map<String, String> tempResult = ParametersUtils.getUserInfoBykey(currentAccount, key = userNo + S_LOGIN_PASSWORD + password);
            if (tempResult != null) {
                return tempResult;
            }
            mpResult = new HashMap<String, String>();
            mpResult.put("success", VALUE_0);
            conn = null;
            stmt = null;
            rs = null;
            try {
                Properties dataBaseProperties = AccountUtils.getTenantDBInfo((Account)currentAccount);
                if (dataBaseProperties == null) {
                    throw new KDException(BosErrorCode.configNotFound, new Object[]{ErrorCodeUtils.getDBIntralError()});
                }
                conn = MCDBUtil.getConnection((Account)currentAccount, (Properties)dataBaseProperties);
                String sql = "select t1.fid,t1.FPhone,t2.fpassword from t_sec_user t1 inner join t_sec_user_u t2 on t1.FID=t2.FID where t1.FPhone =?  and t1.fenable='1' and t2.fisforbidden = '0' ";
                if (userNo != null && "administrator".equals(userNo)) {
                    sql = "select t1.fid,t1.FPhone,t2.fpassword from t_sec_user t1 inner join t_sec_user_u t2 on t1.FID=t2.FID where t1.FNumber =?  and t1.fenable='1' and t2.fisforbidden = '0' ";
                }
                stmt = conn.prepareStatement(sql);
                int index = 1;
                stmt.setString(index++, userNo);
                rs = stmt.executeQuery();
                if (!rs.next()) break block9;
                String OldPassword = rs.getString(FPASSWORD);
                String userId = rs.getString(FID);
                if (PasswordEncryptUtil.checkPasswordWithSalt((String)LoginUtils.getCorrectUserIDSalt(userId), (String)password, (String)OldPassword)) {
                    mpResult.put("fphone", rs.getString("FPhone"));
                    mpResult.put("success", VALUE_1);
                    ParametersUtils.putUserInfoBykey(currentAccount, key, mpResult);
                }
            }
            catch (SQLException e) {
                try {
                    throw new KDException((Throwable)e, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + ErrorCodeUtils.getSlipSignerror() + e.getMessage()});
                    catch (Exception e2) {
                        throw new KDException((Throwable)e2, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + ErrorCodeUtils.getSlipSignerror() + e2.getMessage()});
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, stmt, conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return mpResult;
    }

    public static boolean checkUserExisting(String tenantId, String accountId, String userNo) {
        DynamicObject[] userList;
        boolean isOk = false;
        if (StringUtils.isNotEmpty((String)userNo) && (userList = LoginUserService.getUserList(userNo, UserProperType.Mobile, true)) != null && userList.length >= 0) {
            isOk = true;
        }
        return isOk;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> getErpUserInfoByNumber(Account currentAccount, String userNumber, String language) {
        String orgFilter = System.getProperty(LOGIN_ORGFILTER);
        HashMap<String, String> mpResult = new HashMap<String, String>();
        mpResult.put("success", VALUE_0);
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            Properties dataBaseProperties = AccountUtils.getTenantDBInfo((Account)currentAccount);
            if (dataBaseProperties == null) {
                throw new KDException(BosErrorCode.configNotFound, new Object[]{ErrorCodeUtils.getDBIntralError()});
            }
            conn = MCDBUtil.getConnection((Account)currentAccount, (Properties)dataBaseProperties);
            StringBuilder sbSQl = new StringBuilder();
            sbSQl.append("select t1.fenable,t1.feid,t1.fuid,t1.fid,t1.fopenid,t1.fusertype userType,CASE WHEN pos.fdptid is null then 0 else pos.fdptid end as fdptid,udo.forgid forgid ,u.fisactived,u.fisregisted,udo.fbizpartnerid ");
            sbSQl.append(SQL_FROM_T_SEC_USER_T1);
            sbSQl.append(SQL_LEFT_JOIN_T_SEC_USERPOSITION_POS_ON_T1_FID_POS_FID);
            sbSQl.append(SQL_LEFT_JOIN_T_SEC_USER_U_U_ON_T1_FID_U_FID);
            sbSQl.append(LEFT_JOIN_T_BAS_USERDEFAULTORG_UDO_ON_T1_FID_UDO_FUSERID);
            sbSQl.append(" where t1.fnumber=? and t1.fenable='1' and u.fisforbidden = '0' ");
            if (!StringUtils.isEmpty((String)orgFilter) && !SecurityUtils.containsSqlInjection(orgFilter)) {
                sbSQl.append(String.format(AND_POS_FDPTID_NOT_IN_S, orgFilter));
            }
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("LoginUserService\u4e2d \u8c03\u7528\u5de5\u53f7\uff1a%s.", userNumber));
            }
            stmt = conn.prepareStatement(sbSQl.toString());
            int index = 1;
            stmt.setString(index++, userNumber);
            rs = stmt.executeQuery();
            if (rs.next()) {
                mpResult.put(FOPENID, rs.getString(FOPENID));
                mpResult.put(FID, rs.getString(FID));
                mpResult.put(USERID, rs.getString(FID));
                mpResult.put("feid", rs.getString("feid"));
                mpResult.put("fuid", rs.getString("fuid"));
                mpResult.put(FORGID, rs.getString(FDPTID));
                mpResult.put("userType", rs.getString("userType"));
                String defaultOrgId = rs.getString(FORGID);
                if (LoginUserService.checkDefaultOrg(defaultOrgId)) {
                    mpResult.put(FORGID, defaultOrgId);
                }
                mpResult.put(FISACTIVED, rs.getString(FISACTIVED));
                mpResult.put(FISREGISTED, rs.getString(FISREGISTED));
                mpResult.put("success", VALUE_1);
                String trueName = LoginUserService.getTrueNameByFIDAndLanguage(conn, (String)mpResult.get(FID), language);
                if (trueName != null) {
                    mpResult.put("ftruename", trueName);
                }
                mpResult.put("fbizpartnerid", rs.getString("fbizpartnerid"));
            } else {
                logger.info(LOGGER_LOGIN_USER_SERVICE_CAN_NOT_FIND_USER + userNumber);
            }
        }
        catch (SQLException e) {
            try {
                throw new KDException((Throwable)e, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + ErrorCodeUtils.getSlipSignerror() + e.getMessage()});
                catch (Exception e2) {
                    throw new KDException((Throwable)e2, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + ErrorCodeUtils.getSlipSignerror() + e2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return mpResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean updateErpUserInfoByPhone(Account currentAccount, String account, String uid) {
        Boolean flag;
        block11: {
            Properties dataBaseProperties = AccountUtils.getTenantDBInfo((Account)currentAccount);
            if (dataBaseProperties == null) {
                throw new KDException(BosErrorCode.configNotFound, new Object[]{ErrorCodeUtils.getDBGetError()});
            }
            Connection conn = null;
            PreparedStatement pstmt = null;
            PreparedStatement pstmtU = null;
            ResultSet rs = null;
            flag = false;
            try {
                conn = MCDBUtil.getConnection((Account)currentAccount, (Properties)dataBaseProperties);
                StringBuilder sql = new StringBuilder();
                if (uid.equals(VALUE_0)) {
                    sql.append("UPDATE t_sec_user_u SET FISACTIVED = '1'  where fid = (SELECT fid from t_sec_user where FENABLE = '1' and FPHONE = ? and FNUMBER not in('administrator','cosmic','security','auditor'))");
                    pstmt = conn.prepareStatement(sql.toString());
                    pstmt.setString(1, account);
                    pstmt.executeUpdate();
                } else {
                    conn.setAutoCommit(false);
                    sql.append("UPDATE t_sec_user_u SET FISACTIVED = '1' , FISREGISTED = '1' where fid = (SELECT fid from t_sec_user where FENABLE = '1' and FPHONE = ? and FNUMBER not in('administrator','cosmic','security','auditor'))");
                    pstmt = conn.prepareStatement(sql.toString());
                    pstmt.setString(1, account);
                    pstmt.executeUpdate();
                    sql = new StringBuilder();
                    sql.append("UPDATE t_sec_user SET fuid = ?  where  FENABLE = '1' and FPHONE = ?  and FNUMBER not in('administrator','cosmic','security','auditor')");
                    pstmtU = conn.prepareStatement(sql.toString());
                    pstmtU.setLong(1, Long.parseLong(uid));
                    pstmtU.setString(2, account);
                    pstmtU.executeUpdate();
                    conn.commit();
                }
                flag = true;
                SQLUtils.cleanup(rs, (Statement)pstmt, (Connection)conn);
            }
            catch (Exception e) {
                try {
                    if (conn != null) {
                        conn.rollback();
                    }
                }
                catch (SQLException e1) {
                    logger.error((Throwable)e1);
                }
                logger.error((Throwable)e);
                break block11;
            }
            finally {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                SQLUtils.cleanup(pstmtU);
            }
            SQLUtils.cleanup(pstmtU);
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean updateErpUserInfoByEmail(Account currentAccount, String account, String uid) {
        Properties dataBaseProperties = AccountUtils.getTenantDBInfo((Account)currentAccount);
        if (dataBaseProperties == null) {
            throw new KDException(BosErrorCode.configNotFound, new Object[]{ErrorCodeUtils.getDBGetError()});
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Boolean flag = false;
        try {
            conn = MCDBUtil.getConnection((Account)currentAccount, (Properties)dataBaseProperties);
            StringBuilder sql = new StringBuilder();
            if (uid.equals(VALUE_0)) {
                sql.append("UPDATE t_sec_user_u SET FISACTIVED = '1'  where fid = (SELECT fid from t_sec_user where FENABLE = '1' and FEMAIL = ? and FNUMBER not in('administrator','cosmic','security','auditor'))");
                pstmt = conn.prepareStatement(sql.toString());
                pstmt.setString(1, account);
                pstmt.executeUpdate();
            } else {
                conn.setAutoCommit(false);
                sql.append("UPDATE t_sec_user_u SET FISACTIVED = '1' , FISREGISTED = '1' where fid = (SELECT fid from t_sec_user where FENABLE = '1' and FEMAIL = ? and FNUMBER not in('administrator','cosmic','security','auditor'))");
                pstmt = conn.prepareStatement(sql.toString());
                pstmt.setString(1, account);
                pstmt.executeUpdate();
                sql = new StringBuilder();
                sql.append("UPDATE t_sec_user SET fuid = ?  where  FENABLE = '1' and FEMAIL = ?  and FNUMBER not in('administrator','cosmic','security','auditor')");
                pstmt = conn.prepareStatement(sql.toString());
                pstmt.setLong(1, Long.parseLong(uid));
                pstmt.setString(2, account);
                pstmt.executeUpdate();
                conn.commit();
            }
            flag = true;
            SQLUtils.cleanup(rs, (Statement)pstmt, (Connection)conn);
        }
        catch (Exception e) {
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException e1) {
                logger.error((Throwable)e1);
            }
            logger.error((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(rs, pstmt, (Connection)conn);
        }
        return flag;
    }

    public static boolean checkUserEnable(Account currentCenter, String userName) {
        return LoginUserService.checkUserEnable(currentCenter, userName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateUserLoginIpByUserId(HttpServletRequest request, Account currentCenter, long userId) {
        Properties dataBaseProperties = AccountUtils.getTenantDBInfo((Account)currentCenter);
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = MCDBUtil.getConnection((Account)currentCenter, (Properties)dataBaseProperties);
            StringBuilder sql = new StringBuilder();
            String ip = NetAddressUtils.getRemoteHost((HttpServletRequest)request);
            sql.append("UPDATE t_sec_user_u SET flastlogintime = ?,flastloginip = ?  where fid = ? ");
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setDate(1, new Date(new java.util.Date().getTime()));
            pstmt.setString(2, StringUtils.isNotEmpty((String)ip) ? ip.split(",")[0] : "");
            pstmt.setLong(3, userId);
            pstmt.executeUpdate();
            SQLUtils.cleanup(rs, (Statement)pstmt, (Connection)conn);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(rs, pstmt, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String checkUserType(Account currentCenter, String userName) {
        Properties dataBaseProperties = AccountUtils.getTenantDBInfo((Account)currentCenter);
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String usertype = VALUE_1;
        try {
            conn = MCDBUtil.getConnection((Account)currentCenter, (Properties)dataBaseProperties);
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT t.fid,t.fusertype from t_sec_user t left join t_sec_user_u u on t.fid = u.fid where 1 = 1 ");
            sql.append(" and (t.fphone = ? or t.femail = ? or u.fusername = ? or t.fnumber = ?) and t.fenable = '1' ");
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, userName);
            pstmt.setString(2, userName);
            pstmt.setString(3, userName);
            pstmt.setString(4, userName);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                usertype = rs.getString("fusertype");
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(rs, pstmt, (Connection)conn);
        }
        return StringUtils.isNotEmpty((String)usertype) ? usertype : VALUE_1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String checkUserType(Account currentCenter, Long userId) {
        Properties dataBaseProperties = AccountUtils.getTenantDBInfo((Account)currentCenter);
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String usertype = VALUE_1;
        try {
            conn = MCDBUtil.getConnection((Account)currentCenter, (Properties)dataBaseProperties);
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT t.fid,t.fusertype from t_sec_user t left join t_sec_user_u u on t.fid = u.fid where 1 = 1 ");
            sql.append(" and t.fid = ? and t.fenable = '1' ");
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setLong(1, userId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                usertype = rs.getString("fusertype");
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(rs, pstmt, (Connection)conn);
        }
        return StringUtils.isNotEmpty((String)usertype) ? usertype : VALUE_1;
    }

    public static Map<String, String> getUserInfo(Account currentAccount, String account) {
        DynamicObject[] userArray;
        HashMap<String, String> map = new HashMap<String, String>(8);
        boolean isEmail = ValidationUtils.isEmail(account);
        UserProperType userProperType = UserProperType.Mobile;
        if (isEmail) {
            userProperType = UserProperType.Email;
        }
        if ((userArray = LoginUserService.getUserList(account, userProperType)) != null && userArray.length > 0) {
            DynamicObject user = userArray[0];
            map.put("phone", user.getString("phone"));
            if (isEmail) {
                map.put("phone", user.getString("email"));
            }
            map.put("uid", user.getString("fuid"));
            map.put("username", user.getString("username"));
            String name = user.getString("name");
            String trueName = account;
            if (!ObjectUtils.isEmpty((Object)name)) {
                trueName = name.toString();
            }
            map.put("truename", trueName);
            map.put("usertype", user.getString("userType"));
            map.put(FID, user.getString("id"));
            map.put("isactived", user.getString("isactived"));
        }
        return map;
    }

    private static boolean checkDefaultOrg(String defaultOrgId) {
        return StringUtils.isNotEmpty((String)defaultOrgId) && !VALUE_0.equals(defaultOrgId);
    }

    private static Map<String, String> getDefaultOrg(Long userId) {
        String defaultOrgId = VALUE_0;
        String bizpartnerId = VALUE_0;
        String algoKey = ".getDefaultOrg";
        String sql = "select forgid,fbizpartnerid from t_bas_userdefaultorg where fuserid = ?";
        Object[] params = new Object[]{userId};
        try (DataSet ds = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.basedata, (String)sql, (Object[])params);){
            while (ds.hasNext()) {
                Row row = ds.next();
                defaultOrgId = row.getString(FORGID);
                bizpartnerId = row.getString("fbizpartnerid");
            }
        }
        HashMap<String, String> result = new HashMap<String, String>(8);
        result.put("defaultOrgId", defaultOrgId);
        result.put("bizpartnerId", bizpartnerId);
        return result;
    }

    private static Map<String, String> getUserExtendInfo(Long userId) {
        String lastLoginIp = "";
        String lastLoginTime = "";
        String algoKey = ".getUserExtendInfo";
        String sql = "select flastloginip,flastlogintime from t_sec_user_u where fid = ?";
        Object[] params = new Object[]{userId};
        try (DataSet ds = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.basedata, (String)sql, (Object[])params);){
            while (ds.hasNext()) {
                Row row = ds.next();
                lastLoginIp = row.getString(FLASTLOGINIP);
                lastLoginTime = row.getString(FLASTLOGINTIME);
            }
        }
        HashMap<String, String> result = new HashMap<String, String>(8);
        result.put("lastLoginIp", lastLoginIp);
        result.put("lastLoginTime", lastLoginTime);
        return result;
    }

    private static Map<String, String> wrapLoginUserInfo(DynamicObject user, String language) {
        HashMap<String, String> mapUser = new HashMap<String, String>(8);
        Long userId = user.getLong("id");
        DynamicObjectCollection departments = user.getDynamicObjectCollection("entryentity");
        if (departments != null && departments.size() > 0) {
            DynamicObject department = (DynamicObject)departments.get(0);
            mapUser.put(FORGID, department.getString("dpt.id"));
        }
        String name = user.getString("name");
        String trueName = null;
        if (!ObjectUtils.isEmpty((Object)name)) {
            trueName = name.toString();
        }
        mapUser.put("fphone", user.getString("phone"));
        mapUser.put("eid", user.getString("eid"));
        mapUser.put(USERID, user.getString("id"));
        mapUser.put("useropenid", user.getString("useropenid"));
        mapUser.put(FOPENID, user.getString("useropenid"));
        mapUser.put(FID, user.getString("id"));
        mapUser.put("fuid", user.getString("fuid"));
        mapUser.put("userType", user.getString("userType"));
        Map<String, String> result = LoginUserService.getDefaultOrg(userId);
        if (result != null) {
            if (LoginUserService.checkDefaultOrg(result.get("defaultOrgId"))) {
                mapUser.put(FORGID, result.get("defaultOrgId"));
            }
            mapUser.put("fbizpartnerid", result.get("bizpartnerId"));
        }
        mapUser.put(FISACTIVED, "true".equals(user.getString("isactived")) ? VALUE_1 : VALUE_0);
        mapUser.put(FISREGISTED, "true".equals(user.getString("isregisted")) ? VALUE_1 : VALUE_0);
        Map<String, String> userExtendInfo = LoginUserService.getUserExtendInfo(userId);
        mapUser.put(FLASTLOGINIP, userExtendInfo.get("lastLoginIp"));
        mapUser.put(FLASTLOGINTIME, userExtendInfo.get("lastLoginTime"));
        mapUser.put("ftruename", trueName);
        mapUser.put("username", trueName);
        mapUser.put("femail", user.getString("email"));
        mapUser.put(FENABLE, user.getString("enable"));
        mapUser.put("fpswstrategyid", user.getString("pswstrategy.id"));
        return mapUser;
    }

    private static DynamicObject[] getUserList(String mobile, UserProperType userProperType) {
        return LoginUserService.getUserList(mobile, userProperType, false);
    }

    private static DynamicObject[] getUserListInfo(String mobile, UserProperType userProperType, List<QFilter> qFilterList, String selectProperties) {
        switch (userProperType) {
            case Mobile: {
                LoginUserService.wrapFilterList(mobile, "phone", qFilterList);
                break;
            }
            case UserName: {
                LoginUserService.wrapFilterList(mobile, "username", qFilterList);
                break;
            }
            case UserId: {
                qFilterList.add(new QFilter("id", "=", (Object)Long.parseLong(mobile)));
                break;
            }
            case Email: {
                LoginUserService.wrapFilterList(mobile, "email", qFilterList);
                break;
            }
            case WorkerNumber: {
                LoginUserService.wrapFilterList(mobile, "number", qFilterList);
                break;
            }
            case UUID: {
                LoginUserService.wrapFilterList(mobile, "externaluuid", qFilterList);
                break;
            }
            case YunzhijiaUId: {
                LoginUserService.wrapFilterList(mobile, "fuid", qFilterList);
            }
        }
        return LoginUserService.getUserFromCache(qFilterList, selectProperties, mobile);
    }

    public static DynamicObject[] getUserList(String mobile, UserProperType userProperType, Boolean isAll) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(8);
        if (!isAll.booleanValue()) {
            qFilterList.add(new QFilter("enable", "=", (Object)VALUE_1));
            qFilterList.add(new QFilter("isforbidden", "=", (Object)VALUE_0));
        }
        return LoginUserService.getUserListInfo(mobile, userProperType, qFilterList, USER_SELECT_PROPERTIES);
    }

    public static DynamicObject[] getUserList(String mobile, UserProperType userProperType, String selectProperties, Boolean isAll) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(8);
        if (!isAll.booleanValue()) {
            qFilterList.add(new QFilter("enable", "=", (Object)VALUE_1));
            qFilterList.add(new QFilter("isforbidden", "=", (Object)VALUE_0));
        }
        return LoginUserService.getUserListInfo(mobile, userProperType, qFilterList, org.apache.commons.lang3.StringUtils.isBlank((CharSequence)selectProperties) ? USER_SELECT_PROPERTIES : selectProperties);
    }

    public static Map<String, String> getErpUserInfoByThirdUserId(Account currentCenter, String user, UserAuthResult uar, String language) {
        String userId;
        Map<String, String> result = new HashMap<String, String>(8);
        result.put("success", VALUE_0);
        if (VALUE_0.equals(uar.getThirdType())) {
            result = LoginUserService.getErpUserInfo(currentCenter, user, language);
        } else if (StringUtils.isNumeric((String)uar.getThirdType()) && StringUtils.isNotEmpty((String)(userId = ThirdAppService.getImMapping(user, Long.parseLong(uar.getThirdType()))))) {
            result = LoginUserService.getErpUserInfoByUserId(currentCenter, userId, language);
        }
        return result;
    }

    private static DynamicObject[] getUserFromCache(List<QFilter> qFilterList, String selectProperties, String user) {
        DynamicObject[] userArray = new DynamicObject[]{};
        if (LoginUserService.forbidUseCache(user)) {
            userArray = BusinessDataServiceHelper.load((String)BOS_USER, (String)(null != selectProperties ? selectProperties : USER_SELECT_PROPERTIES), (QFilter[])qFilterList.toArray(new QFilter[qFilterList.size()]));
            return userArray;
        }
        Map data = BusinessDataServiceHelper.loadFromCache((String)BOS_USER, (String)(null != selectProperties ? selectProperties : USER_SELECT_PROPERTIES), (QFilter[])qFilterList.toArray(new QFilter[qFilterList.size()]));
        if (!ObjectUtils.isEmpty((Object)data)) {
            userArray = data.values().toArray(new DynamicObject[data.size()]);
        }
        return userArray;
    }

    private static boolean forbidUseCache(String user) {
        if (AdminUtils.getAdminList().contains(user)) {
            return true;
        }
        if (RequestContext.get() != null) {
            return "true".equals(SystemPropertyUtils.getProptyByTenant((String)"bos.svc.user.forbidUseCache", (String)RequestContext.get().getTenantId()));
        }
        return false;
    }

    private static void wrapFilterList(String mobile, String filterProperty, List<QFilter> filterList) {
        if (AdminUtils.getAdminList().contains(mobile)) {
            filterList.add(new QFilter("number", "=", (Object)mobile));
        } else {
            filterList.add(new QFilter(filterProperty, "=", (Object)mobile));
            filterList.add(new QFilter("number", "not in", AdminUtils.getAdminList()));
        }
    }

    public static boolean checkUserEnable(Account currentCenter, String userName, UserProperType userProperType) {
        Boolean flag = false;
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(8);
        DynamicObject[] userArray = null;
        if (userProperType == null) {
            if (AdminUtils.getAdminList().contains(userName)) {
                qFilterList.add(new QFilter("username", "=", (Object)userName));
            } else {
                qFilterList.add(new QFilter("phone", "=", (Object)userName).or(new QFilter("username", "=", (Object)userName)).or(new QFilter("email", "=", (Object)userName)));
                qFilterList.add(new QFilter("number", "not in", AdminUtils.getAdminList()));
            }
            userArray = BusinessDataServiceHelper.load((String)BOS_USER, (String)"enable,isforbidden", (QFilter[])qFilterList.toArray(new QFilter[qFilterList.size()]));
        } else {
            userArray = LoginUserService.getUserList(userName, userProperType, true);
        }
        for (DynamicObject user : userArray) {
            String fenable = user.getString("enable");
            String fisforbidden = user.getString("isforbidden");
            if (!(StringUtils.isNotEmpty((String)fenable) && fenable.equals(VALUE_0) || "true".equals(fisforbidden))) {
                flag = false;
                break;
            }
            flag = true;
        }
        return flag;
    }
}

