/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.user;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.dc.utils.MCDBUtil;
import kd.bos.dc.utils.SQLUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.ErrorCodeUtils;
import kd.bos.util.StringUtils;

public class OpenApiService {
    private static Log logger = LogFactory.getLog(OpenApiService.class);

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> getAllAPIURLList(Account currentCenter) {
        ArrayList<String> returnList = new ArrayList<String>();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            Properties dataBaseProperties = AccountUtils.getTenantDBInfo((Account)currentCenter);
            if (dataBaseProperties == null) {
                throw new KDException(BosErrorCode.configNotFound, new Object[]{ErrorCodeUtils.getDBIntralError()});
            }
            conn = MCDBUtil.getConnection((Account)currentCenter, (Properties)dataBaseProperties);
            String sql = "select  furlformat from T_OPEN_APISERVICE where fallowguest='1' and fenable='1'";
            stmt = conn.prepareStatement(sql);
            rs = stmt.executeQuery();
            while (rs.next()) {
                if (!StringUtils.isNotEmpty((String)rs.getString("furlformat"))) continue;
                returnList.add("/kapi" + rs.getString("furlformat"));
            }
        }
        catch (SQLException e) {
            try {
                throw new KDException((Throwable)e, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + ErrorCodeUtils.getSlipSignerror() + e.getMessage()});
                catch (Exception e2) {
                    throw new KDException((Throwable)e2, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + ErrorCodeUtils.getSlipSignerror() + e2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return returnList;
    }

    public static String getURLByID(long fid, Account currentCenter) {
        return OpenApiService.getURLByID(fid, currentCenter, true);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getURLByID(long fid, Account currentCenter, boolean needCheckAllowGuest) {
        String returnValue = "";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            Properties dataBaseProperties = AccountUtils.getTenantDBInfo((Account)currentCenter);
            if (dataBaseProperties == null) {
                throw new KDException(BosErrorCode.configNotFound, new Object[]{ErrorCodeUtils.getDBIntralError()});
            }
            conn = MCDBUtil.getConnection((Account)currentCenter, (Properties)dataBaseProperties);
            String sql = "select  furl from T_OPEN_APISERVICE where fallowguest='1' and fenable='1' and fid=?";
            if (!needCheckAllowGuest) {
                sql = "select  furl from T_OPEN_APISERVICE where  fid=?";
            }
            stmt = conn.prepareStatement(sql);
            stmt.setLong(1, fid);
            rs = stmt.executeQuery();
            while (rs.next()) {
                if (!StringUtils.isNotEmpty((String)rs.getString("furl"))) continue;
                returnValue = "/kapi" + rs.getString("furl");
            }
        }
        catch (SQLException e) {
            try {
                throw new KDException((Throwable)e, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + ErrorCodeUtils.getSlipSignerror() + e.getMessage()});
                catch (Exception e2) {
                    throw new KDException((Throwable)e2, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + ErrorCodeUtils.getSlipSignerror() + e2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return returnValue;
    }
}

