/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.user;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLTransientConnectionException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.dc.utils.MCDBUtil;
import kd.bos.dc.utils.SQLUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.CacheLoginData;
import kd.bos.login.LoginClientEnum;
import kd.bos.login.lang.LoginLangUtils;
import kd.bos.login.service.PswService;
import kd.bos.login.service.session.dto.SessionParams;
import kd.bos.login.thirdauth.UserAuthResult;
import kd.bos.login.thirdauth.UserProperType;
import kd.bos.login.user.LoginUserService;
import kd.bos.login.utils.Constants;
import kd.bos.login.utils.ErrorCodeUtils;
import kd.bos.login.utils.LoginUtils;
import kd.bos.login.utils.PswStrategyUtils;
import kd.bos.login.utils.RegexMatchUtils;
import kd.bos.login.utils.StrategeUtils;
import kd.bos.login.utils.StringUtils;
import kd.bos.login.utils.SystemPropertyUtils;
import kd.bos.login.utils.log.LoginLogUtils;
import kd.bos.util.PasswordEncryptUtil;

public class PswStrategyService {
    private static final String ACCOUNT_ID = ",accountId=";
    private static final String QUERY_FPSWSTRATEGYID_BY_FID_SQL = "SELECT fpswstrategyid from t_sec_user_u where fid = ? ";
    private static final String DEFAULT_FPSWSTRATEGYID = "338333884850648064";
    private static final String UPDATE_PASSWORD_OPERATE_STATE_SQL = "UPDATE t_sec_user_u set FISLOCKED = ?,FLockedTime= ?,FErrCount=? where fid = ?";
    private static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    private static final String BOS_LOGIN = "bos-login";
    private static final String MESSAGE = "message";
    private static final String IS_LOCKED = "isLocked";
    private static final String SUCCESS = "success";
    private static final String RESET_PASSWORD_ACTION_23 = "ResetPasswordAction_23";
    private static Log logger = LogFactory.getLog(PswStrategyService.class);

    private static String getDescription() {
        return ResManager.loadKDString((String)"\u4e0d\u80fd\u542b\u6709\u7a7a\u683c\uff0c\u4e2d\u6587\uff0c\u975e\u6cd5\u7b26\u53f7", (String)RESET_PASSWORD_ACTION_23, (String)BOS_LOGIN, (Object[])new Object[0]);
    }

    public static Boolean isPassExpired(Account currentAccount, Long userId) {
        try {
            int fvalidity;
            Object[] userArray = LoginUserService.getUserList(String.valueOf(userId), UserProperType.UserId, false);
            if (ObjectUtils.isEmpty((Object[])userArray)) {
                return false;
            }
            HashMap<String, Object> userMap = new HashMap<String, Object>(8);
            userMap.put("fpswstrategyid", userArray[0].get("pswstrategy.id"));
            userMap.put("psweffectivedate", userArray[0].get("psweffectivedate"));
            Map<String, Object> passwordStrategy = PswStrategyService.getPasswordStrategyByUserId(currentAccount, userMap);
            int n = fvalidity = ObjectUtils.isEmpty((Object)passwordStrategy.get("fvalidity")) ? 0 : Integer.parseInt(passwordStrategy.get("fvalidity").toString());
            if (fvalidity == 0) {
                return false;
            }
            GregorianCalendar currCal = new GregorianCalendar();
            currCal.setTime(new Date());
            int remainTime = PswStrategyService.getRemainTime(currentAccount, userMap, passwordStrategy);
            if (remainTime <= 0) {
                return true;
            }
        }
        catch (Exception e) {
            logger.info(e.getMessage());
        }
        return false;
    }

    @Deprecated
    public static int getRemainTime(Account currentAccount, Long userId) {
        int remainTime = 0;
        GregorianCalendar cal = new GregorianCalendar(2000, 0, 1, 0, 0, 0);
        Calendar currCal = Calendar.getInstance();
        Calendar expiredTime = PswStrategyService.getExpiredTime(currentAccount, userId);
        remainTime = (int)((expiredTime.getTimeInMillis() - cal.getTimeInMillis()) / 86400000L - (currCal.getTimeInMillis() - cal.getTimeInMillis()) / 86400000L);
        return remainTime;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public static Calendar getExpiredTime(Account currentAccount, Long userId) {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection conn;
        GregorianCalendar gcInvalid;
        block9: {
            gcInvalid = new GregorianCalendar();
            Properties dataBaseProperties = AccountUtils.getTenantDBInfo((Account)currentAccount);
            if (dataBaseProperties == null) {
                throw new KDException(BosErrorCode.configNotFound, new Object[]{ErrorCodeUtils.getDBGetError()});
            }
            conn = null;
            pstmt = null;
            rs = null;
            try {
                conn = MCDBUtil.getConnection((Account)currentAccount, (Properties)dataBaseProperties);
                String sql = "SELECT fpswstrategyid,fpsweffectivedate from t_sec_user_u where fid = ? ";
                pstmt = conn.prepareStatement(sql);
                pstmt.setLong(1, userId);
                rs = pstmt.executeQuery();
                Long fpswstrategyid = 0L;
                Date fpsweffectivedate = new Date();
                if (!rs.next()) break block9;
                fpswstrategyid = rs.getLong(1);
                fpsweffectivedate = rs.getTimestamp(2);
                if (0L == fpswstrategyid) {
                    PswStrategyService.updateUserPSW(currentAccount);
                    fpswstrategyid = Long.parseLong(DEFAULT_FPSWSTRATEGYID);
                }
                if (null == fpsweffectivedate) {
                    fpsweffectivedate = new Date();
                }
                gcInvalid.setTime(fpsweffectivedate);
                sql = "SELECT FVALIDITY from t_perm_pswstrategy where FID = ?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setLong(1, fpswstrategyid);
                rs = pstmt.executeQuery();
                int fvalidity = 0;
                if (rs.next()) {
                    fvalidity = rs.getInt(1);
                    gcInvalid.add(6, fvalidity);
                }
            }
            catch (SQLException e) {
                try {
                    throw new KDException((Throwable)e, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + LoginUtils.SPLIT_SIGN + e.getMessage()});
                    catch (Exception e2) {
                        throw new KDException((Throwable)e2, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + LoginUtils.SPLIT_SIGN + e2.getMessage()});
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return gcInvalid;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getForewarnDay(Account currentAccount, Long userId) {
        int forewarnDay = 0;
        Properties dataBaseProperties = AccountUtils.getTenantDBInfo((Account)currentAccount);
        if (dataBaseProperties == null) {
            throw new KDException(BosErrorCode.configNotFound, new Object[]{ErrorCodeUtils.getDBGetError()});
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = MCDBUtil.getConnection((Account)currentAccount, (Properties)dataBaseProperties);
            String sql = QUERY_FPSWSTRATEGYID_BY_FID_SQL;
            pstmt = conn.prepareStatement(sql);
            pstmt.setLong(1, userId);
            rs = pstmt.executeQuery();
            Long fpswstrategyid = 0L;
            if (rs.next()) {
                fpswstrategyid = rs.getLong(1);
            }
            if (fpswstrategyid == 0L) {
                PswStrategyService.updateUserPSW(currentAccount);
                fpswstrategyid = Long.parseLong(DEFAULT_FPSWSTRATEGYID);
            }
            sql = "SELECT FFOREWARNDAY from t_perm_pswstrategy where FID = ?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setLong(1, fpswstrategyid);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                forewarnDay = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new KDException((Throwable)e, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + LoginUtils.SPLIT_SIGN + e.getMessage()});
                catch (Exception e2) {
                    throw new KDException((Throwable)e2, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + LoginUtils.SPLIT_SIGN + e2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return forewarnDay;
    }

    public static String handleAfterLogon(Account currentAccount, Long userId, boolean isLogon, String ip) {
        String returnMsg = null;
        returnMsg = PswStrategyService.handleAfterLogon(currentAccount, userId, isLogon, ip, null);
        return returnMsg;
    }

    public static String handleAfterLogon(Account currentAccount, Long userId, boolean isLogon, String ip, String userName) {
        String returnMsg = null;
        Properties dataBaseProperties = AccountUtils.getTenantDBInfo((Account)currentAccount);
        if (dataBaseProperties == null) {
            throw new KDException(BosErrorCode.configNotFound, new Object[]{ErrorCodeUtils.getDBGetError()});
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = "";
        try {
            conn = MCDBUtil.getConnection((Account)currentAccount, (Properties)dataBaseProperties);
            if (isLogon) {
                PswStrategyService.unLock(currentAccount, userId);
            } else {
                SimpleDateFormat format = new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS, Locale.CHINA);
                sql = "SELECT FErrCount,fpswstrategyid,fislocked,flockedtime from t_sec_user_u where fid = ? ";
                pstmt = conn.prepareStatement(sql);
                pstmt.setLong(1, userId);
                rs = pstmt.executeQuery();
                int ferrcount = 0;
                Long fpswstrategyid = 0L;
                String fislocked = "";
                Date flockedtime = new Date();
                if (rs.next()) {
                    ferrcount = rs.getInt(1);
                    fpswstrategyid = rs.getLong(2);
                    fislocked = rs.getString(3);
                    flockedtime = rs.getTimestamp(4);
                }
                if (fpswstrategyid == 0L) {
                    PswStrategyService.updateUserPSW(currentAccount);
                    fpswstrategyid = Long.parseLong(DEFAULT_FPSWSTRATEGYID);
                }
                sql = "SELECT FLOCKCOUNT,FLOCKTERM,FENABLELOCK from t_perm_pswstrategy where FID = ?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setLong(1, fpswstrategyid);
                rs = pstmt.executeQuery();
                int flockcount = 0;
                int flockterm = 0;
                String fenablelock = "";
                if (rs.next()) {
                    flockcount = rs.getInt(1);
                    flockterm = rs.getInt(2);
                    fenablelock = rs.getString(3);
                }
                GregorianCalendar unlockDate = new GregorianCalendar();
                if ("1".equals(fislocked) && fenablelock.equals("1")) {
                    unlockDate.setTime(flockedtime);
                    unlockDate.add(12, flockterm);
                    String string = returnMsg = String.format(ResManager.loadKDString((String)"\u8d26\u53f7\u4e8e %1s \u9501\u5b9a\uff0c%2s \u540e\u5c06\u81ea\u52a8\u89e3\u9501\u3002", (String)"PswStrategyService_0", (String)BOS_LOGIN, (Object[])new Object[0]), format.format(flockedtime), format.format(unlockDate.getTime()));
                    SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
                    return string;
                }
                if (flockcount != 0 && fenablelock.equals("1")) {
                    if (ferrcount + 1 >= flockcount) {
                        Date currDate = new Date();
                        Timestamp lockTime = new Timestamp(currDate.getTime());
                        sql = UPDATE_PASSWORD_OPERATE_STATE_SQL;
                        pstmt = conn.prepareStatement(sql);
                        pstmt.setString(1, Constants.YES);
                        pstmt.setTimestamp(2, lockTime);
                        pstmt.setInt(3, ferrcount + 1);
                        pstmt.setLong(4, userId);
                        pstmt.executeUpdate();
                        unlockDate = new GregorianCalendar();
                        unlockDate.setTime(currDate);
                        unlockDate.add(12, flockterm);
                        returnMsg = flockterm != 0 ? String.format(ResManager.loadKDString((String)"\u8d26\u53f7\u4e8e %1s \u9501\u5b9a\uff0c%2s \u540e\u5c06\u81ea\u52a8\u89e3\u9501\u3002", (String)"PswStrategyService_0", (String)BOS_LOGIN, (Object[])new Object[0]), format.format(currDate), format.format(unlockDate.getTime())) : ResManager.loadKDString((String)"\u8d26\u53f7\u5df2\u9501\u5b9a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u89e3\u9501\u3002", (String)"PswStrategyService_3", (String)BOS_LOGIN, (Object[])new Object[0]);
                        Map<String, String> userInfo = LoginUserService.getErpUserInfoByUserId(currentAccount, String.valueOf(userId), LoginLangUtils.getLang().toString());
                        SessionParams params = new SessionParams();
                        params.setClientEnum(LoginClientEnum.WEB);
                        params.setIP(ip);
                        LoginLogUtils.addLog(currentAccount, LoginLogUtils.initLoginLogInfo(String.valueOf(userId), userInfo.get("forgid"), params, "UserLock"));
                    } else {
                        sql = "UPDATE t_sec_user_u set FErrCount=? where fid = ?";
                        pstmt = conn.prepareStatement(sql);
                        pstmt.setInt(1, ferrcount + 1);
                        pstmt.setLong(2, userId);
                        pstmt.executeUpdate();
                        returnMsg = ResManager.loadKDString((String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef\u3002", (String)"PswStrategyService_6", (String)BOS_LOGIN, (Object[])new Object[0]);
                    }
                } else {
                    returnMsg = kd.bos.util.StringUtils.isNotEmpty((String)userName) && LoginUtils.checkLdapLogin(currentAccount, userName) ? ResManager.loadKDString((String)"\u767b\u5f55\u5931\u8d25\uff0cAD\u57df\u7528\u6237\u6216\u5bc6\u7801\u9519\u8bef\u3002", (String)"PswStrategyService_31", (String)BOS_LOGIN, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef\u3002", (String)"PswStrategyService_6", (String)BOS_LOGIN, (Object[])new Object[0]);
                }
            }
        }
        catch (SQLTransientConnectionException e) {
            logger.error((Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Throwable)e);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + LoginUtils.SPLIT_SIGN + e.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rs, pstmt, (Connection)conn);
        }
        return returnMsg;
    }

    /*
     * Exception decompiling
     */
    @Deprecated
    public static Map<String, Object> isIsLocked(Account currentAccount, Long userId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static int getVercodectrl(Account currentAccount, Map<String, Object> userMap) {
        int fverCodeCtrl = 0;
        Map<String, Object> passwordStrategy = PswStrategyService.getPasswordStrategyByUserId(currentAccount, userMap);
        if (!passwordStrategy.isEmpty() && null != passwordStrategy.get("fenablegraphiccode") && passwordStrategy.get("fenablegraphiccode").equals("1")) {
            fverCodeCtrl = null != passwordStrategy.get("fvercodectrl") ? Integer.parseInt(passwordStrategy.get("fvercodectrl").toString()) : 0;
        }
        return fverCodeCtrl;
    }

    @Deprecated
    public static int getVercodectrl(Account currentAccount, Long userId) {
        int fverCodeCtrl = 0;
        Map<String, Object> passwordStrategy = PswStrategyService.getPasswordStrategyByUserId(currentAccount, userId);
        if (!passwordStrategy.isEmpty() && null != passwordStrategy.get("fenablegraphiccode") && passwordStrategy.get("fenablegraphiccode").equals("1")) {
            fverCodeCtrl = null != passwordStrategy.get("fvercodectrl") ? Integer.parseInt(passwordStrategy.get("fvercodectrl").toString()) : 0;
        }
        return fverCodeCtrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insertDefaultPSW(Account currentAccount) {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection conn;
        block5: {
            Properties dataBaseProperties = AccountUtils.getTenantDBInfo((Account)currentAccount);
            if (dataBaseProperties == null) {
                throw new KDException(BosErrorCode.configNotFound, new Object[]{ErrorCodeUtils.getDBGetError()});
            }
            conn = null;
            pstmt = null;
            rs = null;
            try {
                conn = MCDBUtil.getConnection((Account)currentAccount, (Properties)dataBaseProperties);
                String sql = "SELECT FID FROM t_perm_pswstrategy WHERE FID=338333884850648064 ";
                pstmt = conn.prepareStatement(sql);
                rs = pstmt.executeQuery();
                if (rs.next()) break block5;
                sql = "INSERT INTO t_perm_pswstrategy(FID,FFOREWARNDAY,FSTATUS,FDISABLERID,FDEFAULT,FREPEATTIMES,FMODIFYTIME,FENABLE,FDISABLEDATE,FISREQUIRECHANGE,FNUMBER,FVALIDITY,FISSPECIAL,FMINLENGTH,FISNUMBER,FCREATORID,FISLETTER,FLOCKCOUNT,FMASTERID,FMODIFIERID,FVERCODECTRL,FLOCKTERM,FCREATETIME) VALUES (338333884850648064,0,'C',0,' ',0,{ts'2018-08-21  00:00:00'},'1',null,'0','low',20000,'0',6,'1',100,'0',0,338333884850648064,100,3,0,{ts'2018-08-21  00:00:00'});";
                pstmt = conn.prepareStatement(sql);
                pstmt.execute();
                sql = ResManager.loadKDString((String)"INSERT INTO t_perm_pswstrategy_l VALUES ('12L+997QAAO/', 338333884850648064, 'zh_CN', '\u521d\u7ea7', '\u521d\u7ea7\u7b56\u7565') ", (String)"PswStrategyService_8", (String)BOS_LOGIN, (Object[])new Object[0]);
                pstmt = conn.prepareStatement(sql);
                pstmt.execute();
            }
            catch (Exception e) {
                try {
                    logger.error((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                    throw throwable;
                }
                SQLUtils.cleanup(rs, (Statement)pstmt, (Connection)conn);
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateUserPSW(Account currentAccount) {
        Properties dataBaseProperties = AccountUtils.getTenantDBInfo((Account)currentAccount);
        if (dataBaseProperties == null) {
            throw new KDException(BosErrorCode.configNotFound, new Object[]{ErrorCodeUtils.getDBGetError()});
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = MCDBUtil.getConnection((Account)currentAccount, (Properties)dataBaseProperties);
            String sql = "UPDATE T_SEC_User_U set FPswEffectiveDate = CURDATE() where FPswEffectiveDate is null ";
            pstmt = conn.prepareStatement(sql);
            pstmt.executeUpdate();
            sql = "UPDATE T_SEC_User_U set fpswstrategyid = 338333884850648064 where fpswstrategyid = 0 or fpswstrategyid is null ";
            pstmt = conn.prepareStatement(sql);
            pstmt.executeUpdate();
        }
        catch (Exception e) {
            try {
                logger.error((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup(rs, (Statement)pstmt, (Connection)conn);
        }
        SQLUtils.cleanup(rs, (Statement)pstmt, (Connection)conn);
    }

    /*
     * Exception decompiling
     */
    public static Map<String, Object> isIsLocked(Account currentAccount, long userId, HttpServletRequest servletRequest) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, Object> verifyPSWStrategy(Account currentAccount, Long userId, String password) {
        HashMap<String, Object> hashMap;
        boolean fneedverifycode;
        boolean fweakpsw;
        boolean fhascaseletter;
        boolean fisspecial;
        boolean fisnumber;
        boolean fisletter;
        int fminlength;
        String sql;
        Boolean flag;
        Connection conn;
        ResultSet rs;
        PreparedStatement stmt;
        HashMap<String, Object> result;
        block22: {
            boolean flogincheckpsw;
            block21: {
                Properties dataBaseProperties;
                block20: {
                    result = new HashMap<String, Object>(8);
                    dataBaseProperties = AccountUtils.getTenantDBInfo((Account)currentAccount);
                    stmt = null;
                    rs = null;
                    conn = null;
                    Map<String, Object> extResult = PswStrategyService.verifyStrategy(currentAccount, userId, password);
                    if (extResult.isEmpty() || ((Boolean)extResult.get(SUCCESS)).booleanValue()) break block20;
                    Map<String, Object> map = extResult;
                    SQLUtils.cleanup(rs, stmt, (Connection)conn);
                    return map;
                }
                flag = false;
                conn = MCDBUtil.getConnection((Account)currentAccount, (Properties)dataBaseProperties);
                Long fpswstrategyid = 0L;
                sql = QUERY_FPSWSTRATEGYID_BY_FID_SQL;
                stmt = conn.prepareStatement(sql);
                stmt.setLong(1, userId);
                rs = stmt.executeQuery();
                if (rs.next() && (fpswstrategyid = Long.valueOf(rs.getLong(1))) == 0L) {
                    fpswstrategyid = Long.parseLong(DEFAULT_FPSWSTRATEGYID);
                }
                sql = "SELECT FMINLENGTH,FISLETTER,FISNUMBER,FISSPECIAL,FREPEATTIMES,FHASCASELETTER,FWEAKPSW,FLOGINCHECKSTGY,FNEEDVERIFYCODE from t_perm_pswstrategy where FID = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setLong(1, fpswstrategyid);
                rs = stmt.executeQuery();
                fminlength = 6;
                fisletter = false;
                fisnumber = false;
                fisspecial = false;
                fhascaseletter = false;
                fweakpsw = false;
                flogincheckpsw = false;
                fneedverifycode = true;
                if (rs.next()) {
                    fminlength = rs.getInt(1);
                    fisletter = StringUtils.getBooleanValue(rs.getString(2));
                    fisnumber = StringUtils.getBooleanValue(rs.getString(3));
                    fisspecial = StringUtils.getBooleanValue(rs.getString(4));
                    fhascaseletter = StringUtils.getBooleanValue(rs.getString(6));
                    fweakpsw = StringUtils.getBooleanValue(rs.getString(7));
                    flogincheckpsw = StringUtils.getBooleanValue(rs.getString(8));
                    fneedverifycode = StringUtils.getBooleanValue(rs.getString(9));
                    flag = true;
                    break block21;
                }
                result.put(SUCCESS, true);
                HashMap<String, Object> hashMap2 = result;
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
                return hashMap2;
            }
            if (flogincheckpsw) break block22;
            result.put(SUCCESS, true);
            HashMap<String, Object> hashMap3 = result;
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
            return hashMap3;
        }
        try {
            String regEx;
            Pattern p;
            Matcher m;
            if (flag.booleanValue() && password.length() < fminlength) {
                flag = false;
            }
            if (flag.booleanValue() && fisnumber && !(m = (p = Pattern.compile(regEx = "[0-9]")).matcher(password)).find()) {
                flag = false;
            }
            if (flag.booleanValue() && fisletter) {
                if (flag.booleanValue() && fhascaseletter) {
                    String regExLowerLetter = ".*?[a-z]+.*?";
                    String regExUpLetter = ".*?[A-Z]+.*?";
                    Pattern pL = Pattern.compile(regExLowerLetter);
                    Pattern pU = Pattern.compile(regExUpLetter);
                    Matcher mL = pL.matcher(password);
                    Matcher mU = pU.matcher(password);
                    if (!mL.find() || !mU.find()) {
                        flag = false;
                    }
                } else if (flag.booleanValue() && !(m = (p = Pattern.compile(regEx = "[A-Za-z]")).matcher(password)).find()) {
                    flag = false;
                }
            }
            if (flag.booleanValue() && fisspecial && !(m = (p = Pattern.compile(regEx = "[`~!@#$%^&*()_+=|{}':;',\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]")).matcher(password)).find()) {
                flag = false;
            }
            if (flag.booleanValue() && fweakpsw) {
                sql = "SELECT FPSW FROM T_PERM_WEAKPSW WHERE FPSW = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, password);
                rs = stmt.executeQuery();
                if (rs.next()) {
                    flag = false;
                }
            }
            result.put("fneedverifycode", fneedverifycode);
            result.put(SUCCESS, flag);
            hashMap = result;
        }
        catch (SQLException e) {
            try {
                throw new KDException((Throwable)e, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + ErrorCodeUtils.getSlipSignerror() + e.getMessage()});
                catch (Exception e2) {
                    throw new KDException((Throwable)e2, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + ErrorCodeUtils.getSlipSignerror() + e2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return hashMap;
    }

    public static Map<String, Object> customVerifyPSW(String password) {
        HashMap<String, Object> mpData = new HashMap<String, Object>();
        Boolean flag = true;
        if (password == null || password.trim().length() == 0) {
            flag = false;
            mpData.put("msg", ResManager.loadKDString((String)"\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ResetPasswordAction_21", (String)BOS_LOGIN, (Object[])new Object[0]));
        }
        if (RequestContext.get() != null && flag.booleanValue() && password.equals(PswStrategyUtils.getUserDefaultPsw(RequestContext.get().getTenantId()))) {
            flag = false;
            mpData.put("msg", ResManager.loadKDString((String)"\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e0e\u521d\u59cb\u5bc6\u7801\u76f8\u540c\u3002", (String)"ResetPasswordAction_22", (String)BOS_LOGIN, (Object[])new Object[0]));
        }
        String pattern = "\\s{1,}";
        String[] split = password.split(pattern);
        if (flag.booleanValue() && split.length > 1 || !password.equals(password.trim())) {
            flag = false;
            mpData.put("msg", PswStrategyService.getDescription());
        }
        if (flag.booleanValue() && PswStrategyService.isContainChineseChar(password)) {
            flag = false;
            mpData.put("msg", PswStrategyService.getDescription());
        }
        mpData.put(SUCCESS, flag);
        return mpData;
    }

    public static boolean isContainChineseChar(String value) {
        String pattern = "[^\\x00-\\xff]{1,}";
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(value);
        return m.find();
    }

    public static Map<String, Object> customVerifyPassword(String password) {
        String pattern;
        String[] split;
        HashMap<String, Object> mpData = new HashMap<String, Object>();
        Boolean flag = false;
        StringBuilder tipMsg = new StringBuilder();
        if (password == null || password.trim().length() == 0) {
            tipMsg.append(ResManager.loadKDString((String)"\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ResetPasswordAction_21", (String)BOS_LOGIN, (Object[])new Object[0])).append(",");
        }
        if (RequestContext.get() != null && password.equals(PswStrategyUtils.getUserDefaultPsw(RequestContext.get().getTenantId()))) {
            tipMsg.append(ResManager.loadKDString((String)"\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e0e\u521d\u59cb\u5bc6\u7801\u76f8\u540c\u3002", (String)"ResetPasswordAction_22", (String)BOS_LOGIN, (Object[])new Object[0])).append(",");
        }
        if ((split = password.split(pattern = "\\s{1,}")).length > 1 || !password.equals(password.trim())) {
            tipMsg.append(PswStrategyService.getDescription()).append(",");
        }
        if (PswStrategyService.isContainChineseChar(password)) {
            tipMsg.append(PswStrategyService.getDescription()).append(",");
        }
        if (tipMsg != null && tipMsg.length() > 0) {
            String msg = tipMsg.substring(0, tipMsg.length() - 1) + LoginUtils.getEndSymbol("\u3002");
            mpData.put("msg", msg);
        } else {
            flag = true;
        }
        mpData.put(SUCCESS, flag);
        return mpData;
    }

    public static Map<String, Object> verifyPwdByStrategy(Account currentAccount, Long userId, String password, String pswHisStr) {
        HashMap<String, Object> result;
        block35: {
            HashMap<String, Object> hashMap;
            result = new HashMap<String, Object>(8);
            Properties dataBaseProperties = AccountUtils.getTenantDBInfo((Account)currentAccount);
            PreparedStatement stmt = null;
            ResultSet rs = null;
            Connection conn = null;
            try {
                String regEx;
                Map<String, Object> extResult = PswStrategyService.verifyStrategy(currentAccount, userId, password);
                if (!extResult.isEmpty() && !((Boolean)extResult.get(SUCCESS)).booleanValue()) {
                    Map<String, Object> map = extResult;
                    return map;
                }
                StringBuilder tipMsg = new StringBuilder(ResManager.loadKDString((String)"\u65b0\u5bc6\u7801", (String)"ResetPasswordAction_56", (String)BOS_LOGIN, (Object[])new Object[0]));
                StringBuilder tip = new StringBuilder();
                Boolean flag = false;
                conn = MCDBUtil.getConnection((Account)currentAccount, (Properties)dataBaseProperties);
                Long fpswstrategyid = 0L;
                String sql = QUERY_FPSWSTRATEGYID_BY_FID_SQL;
                stmt = conn.prepareStatement(sql);
                stmt.setLong(1, userId);
                rs = stmt.executeQuery();
                if (rs.next() && (fpswstrategyid = Long.valueOf(rs.getLong(1))) == 0L) {
                    fpswstrategyid = Long.parseLong(DEFAULT_FPSWSTRATEGYID);
                }
                sql = "SELECT FMINLENGTH,FISLETTER,FISNUMBER,FISSPECIAL,FREPEATTIMES,FHASCASELETTER,FWEAKPSW,FLOGINCHECKSTGY from t_perm_pswstrategy where FID = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setLong(1, fpswstrategyid);
                rs = stmt.executeQuery();
                int fminlength = 6;
                int frepeattimes = 0;
                boolean fisletter = false;
                boolean fisnumber = false;
                boolean fisspecial = false;
                boolean fhascaseletter = false;
                boolean fweakpsw = false;
                boolean flogincheckpsw = false;
                if (!rs.next()) {
                    result.put(SUCCESS, true);
                    HashMap<String, Object> hashMap2 = result;
                    SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
                    return hashMap2;
                }
                fminlength = rs.getInt(1);
                fisletter = StringUtils.getBooleanValue(rs.getString(2));
                fisnumber = StringUtils.getBooleanValue(rs.getString(3));
                fisspecial = StringUtils.getBooleanValue(rs.getString(4));
                frepeattimes = rs.getInt(5);
                fhascaseletter = StringUtils.getBooleanValue(rs.getString(6));
                fweakpsw = StringUtils.getBooleanValue(rs.getString(7));
                flogincheckpsw = StringUtils.getBooleanValue(rs.getString(8));
                flag = true;
                if (password.length() < fminlength) {
                    flag = false;
                    tipMsg.append(String.format(ResManager.loadKDString((String)"\u957f\u5ea6\u4e0d\u80fd\u5c0f\u4e8e %s \u4e2a\u5b57\u7b26", (String)"ResetPasswordAction_70", (String)BOS_LOGIN, (Object[])new Object[0]), String.valueOf(fminlength))).append(",");
                }
                if (fisnumber) {
                    regEx = "[0-9]";
                    if (!RegexMatchUtils.regexMatch(regEx, password).booleanValue()) {
                        flag = false;
                    }
                    tip.append(ResManager.loadKDString((String)"\u9700\u8981\u5305\u542b\u6570\u5b57", (String)"ResetPasswordAction_71", (String)BOS_LOGIN, (Object[])new Object[0])).append("\u3001");
                }
                if (fisletter) {
                    if (fhascaseletter) {
                        String regExLowerLetter = ".*?[a-z]+.*?";
                        String regExUpLetter = ".*?[A-Z]+.*?";
                        if (!RegexMatchUtils.regexMatch(regExLowerLetter, password).booleanValue() || !RegexMatchUtils.regexMatch(regExUpLetter, password).booleanValue()) {
                            flag = false;
                        }
                        if (tip != null && tip.length() > 0) {
                            tip.append(ResManager.loadKDString((String)"\u5927\u5c0f\u5199\u5b57\u6bcd", (String)"ResetPasswordAction_72", (String)BOS_LOGIN, (Object[])new Object[0])).append("\u3001");
                        } else {
                            tip.append(ResManager.loadKDString((String)"\u5bc6\u7801\u5fc5\u987b\u5305\u542b\u5927\u5c0f\u5199\u5b57\u6bcd\u3002", (String)"ResetPasswordAction_73", (String)BOS_LOGIN, (Object[])new Object[0])).append("\u3001");
                        }
                    } else {
                        regEx = "[A-Za-z]";
                        if (!RegexMatchUtils.regexMatch(regEx, password).booleanValue()) {
                            flag = false;
                        }
                        if (tip != null && tip.length() > 0) {
                            tip.append(ResManager.loadKDString((String)"\u5b57\u6bcd", (String)"PswStrategyService_13", (String)BOS_LOGIN, (Object[])new Object[0])).append("\u3001");
                        } else {
                            tip.append(ResManager.loadKDString((String)"\u9700\u8981\u5305\u542b\u5b57\u6bcd", (String)"PswStrategyService_14", (String)BOS_LOGIN, (Object[])new Object[0])).append("\u3001");
                        }
                    }
                }
                if (fisspecial) {
                    regEx = "[`~!@#$%^&*()_+=|{}':;',\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]";
                    if (!RegexMatchUtils.regexMatch(regEx, password).booleanValue()) {
                        flag = false;
                    }
                    if (tip != null && tip.length() > 0) {
                        tip.append(ResManager.loadKDString((String)"\u7279\u6b8a\u5b57\u7b26", (String)"PswStrategyService_15", (String)BOS_LOGIN, (Object[])new Object[0])).append("\u3001");
                    } else {
                        tip.append(ResManager.loadKDString((String)"\u9700\u8981\u5305\u542b\u7279\u6b8a\u5b57\u7b26", (String)"PswStrategyService_16", (String)BOS_LOGIN, (Object[])new Object[0])).append("\u3001");
                    }
                }
                if (!flag.booleanValue() && tip != null && tip.length() > 0) {
                    tipMsg.append((CharSequence)tip);
                }
                if (flag.booleanValue() && frepeattimes > 0 && pswHisStr != null) {
                    String[] pswHisStrs = pswHisStr.split(",");
                    String PswStr = PasswordEncryptUtil.getEncryptePasswordWithSalt((String)password);
                    int currPswIndex = 0;
                    for (int i = 0; i < frepeattimes; ++i) {
                        currPswIndex = pswHisStrs.length - 1 - i;
                        if (currPswIndex < 0) {
                            currPswIndex = 0;
                        }
                        if (userId == null || !PasswordEncryptUtil.checkPasswordWithSalt((String)LoginUtils.getCorrectUserIDSalt(userId.toString()), (String)password, (String)pswHisStrs[currPswIndex])) continue;
                        flag = false;
                        tipMsg.append(String.format(ResManager.loadKDString((String)"\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e0e\u524d%s\u6b21\u65e7\u5bc6\u7801\u76f8\u540c\u3002", (String)"ResetPasswordAction_76", (String)BOS_LOGIN, (Object[])new Object[0]), String.valueOf(frepeattimes))).append("\u3002");
                        break;
                    }
                }
                if (flag.booleanValue() && fweakpsw) {
                    sql = "SELECT FPSW FROM T_PERM_WEAKPSW WHERE FPSW = ?";
                    stmt = conn.prepareStatement(sql);
                    stmt.setString(1, password);
                    rs = stmt.executeQuery();
                    if (rs.next()) {
                        flag = false;
                        tipMsg.append(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u8bbe\u7f6e\u5f31\u53e3\u4ee4\u5bc6\u7801\u3002", (String)"ResetPasswordAction_77", (String)BOS_LOGIN, (Object[])new Object[0])).append("\u3002");
                    }
                }
                if (tipMsg != null && tipMsg.length() > 0) {
                    String msg = tipMsg.substring(0, tipMsg.length() - 1) + LoginUtils.getEndSymbol("\u3002");
                    result.put("msg", msg);
                }
                result.put(SUCCESS, flag);
                hashMap = result;
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
            }
            catch (SQLException e) {
                logger.error((Throwable)e);
                break block35;
            }
            catch (Exception e) {
                throw new KDException((Throwable)e, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + ErrorCodeUtils.getSlipSignerror() + e.getMessage()});
            }
            finally {
                SQLUtils.cleanup(rs, stmt, conn);
            }
            return hashMap;
        }
        return result;
    }

    public static Map<String, Object> getPasswordWarningResult(Account currentCenter, String userId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(SUCCESS, false);
        int days = PswStrategyService.getRemainTime(currentCenter, Long.parseLong(userId));
        if (days > 0) {
            int warnDay = PswStrategyService.getForewarnDay(currentCenter, Long.parseLong(userId));
            if (days <= warnDay) {
                map.put(SUCCESS, true);
            }
        } else {
            map.put(SUCCESS, false);
        }
        map.put("days", days);
        return map;
    }

    public static Map<String, Object> checkPasswordWarning(HttpServletRequest servletRequest, HttpServletResponse servletResponse, Account currentCenter, String userId, UserAuthResult uar, String randomCode) throws IOException {
        String userName = servletRequest.getParameter(Constants.LOGIN_USER_KEY);
        Map<String, Object> passwordWarningResult = PswStrategyService.getPasswordWarningResult(currentCenter, userId);
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        result.put("errorcode", "0");
        if (null != passwordWarningResult && null != passwordWarningResult.get(SUCCESS) && ((Boolean)passwordWarningResult.get(SUCCESS)).booleanValue()) {
            result.put("errorcode", "305");
            result.put("description", String.format(ResManager.loadKDString((String)"\u5bc6\u7801\u5c06\u4e8e%s\u5929\u540e\u5230\u671f\uff0c\u8bf7\u5c3d\u5feb\u4fee\u6539\u5bc6\u7801\u3002", (String)"LoginAction_15", (String)BOS_LOGIN, (Object[])new Object[0]), passwordWarningResult.get("days").toString()));
            result.put("randomCode", randomCode);
            CacheLoginData.setAttribute((String)"passwordWarning", (String)(currentCenter.getAccountId() + "-" + userName), (String)(userName + "," + uar.getUser() + "," + uar.getUserType().toString() + "," + userId + "," + randomCode), (int)30);
            CacheLoginData.setAttribute((String)"passwordWarning", (String)(currentCenter.getAccountId() + "-" + userName + "-verifyCode"), (String)(userId + "," + randomCode), (int)300);
        }
        return result;
    }

    public static Map<String, Object> isLocked(Account currentAccount, Map<String, Object> passwordStrategy, long userId) {
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        Boolean isLocked = false;
        if (passwordStrategy.isEmpty()) {
            result.put(IS_LOCKED, isLocked);
            return result;
        }
        Integer flockcount = passwordStrategy.get("flockcount") != null ? Integer.parseInt(passwordStrategy.get("flockcount").toString()) : 0;
        int times = StrategeUtils.getPasswordWrongTimes(currentAccount, String.valueOf(userId), LoginClientEnum.WEB.toString());
        if (passwordStrategy.get("fenablelock") != null && passwordStrategy.get("fenablelock").equals("1") && flockcount > 0 && times >= flockcount) {
            isLocked = true;
        }
        if (isLocked.booleanValue()) {
            Integer flockterm = passwordStrategy.get("flockterm") != null ? Integer.parseInt(passwordStrategy.get("flockterm").toString()) : 0;
            if (flockcount > 0 && passwordStrategy.get("flockterm").equals(0)) {
                result.put(MESSAGE, ResManager.loadKDString((String)"\u5bc6\u7801\u9519\u8bef\u6b21\u6570\u8fc7\u591a,\u8d26\u53f7\u5df2\u88ab\u9501\u5b9a,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u89e3\u9501\u3002", (String)"PswStrategyService_7", (String)BOS_LOGIN, (Object[])new Object[0]));
                result.put(IS_LOCKED, true);
                return result;
            }
            Map<String, Object> userInfo = PswStrategyService.getLockedUserInfo(currentAccount, userId);
            if (ObjectUtils.isEmpty((Object)userInfo.get("lockedtime"))) {
                result.put(IS_LOCKED, false);
                return result;
            }
            Date flockedtime = (Date)userInfo.get("lockedtime");
            Date currrDate = new Date();
            int pastTime = (int)((currrDate.getTime() - flockedtime.getTime()) / 60000L);
            if (pastTime >= flockterm) {
                PswStrategyService.unLock(currentAccount, userId);
                isLocked = false;
            } else {
                GregorianCalendar unlockDate = new GregorianCalendar();
                unlockDate.setTime(flockedtime);
                unlockDate.add(12, flockterm);
                SimpleDateFormat format = new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS, Locale.CHINA);
                String returnMsg = String.format(ResManager.loadKDString((String)"\u8d26\u53f7\u4e8e %1s \u9501\u5b9a\uff0c%2s \u540e\u5c06\u81ea\u52a8\u89e3\u9501\u3002", (String)"PswStrategyService_0", (String)BOS_LOGIN, (Object[])new Object[0]), format.format(flockedtime), format.format(unlockDate.getTime()));
                result.put(MESSAGE, returnMsg);
            }
        }
        result.put(IS_LOCKED, isLocked);
        return result;
    }

    /*
     * Exception decompiling
     */
    @Deprecated
    public static Map<String, Object> getPasswordStrategyByUserId(Account currentAccount, Long userId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Map<String, Object> conversionData(Map<String, String> pswMap) {
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        for (Map.Entry<String, String> entry : pswMap.entrySet()) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    public static Map<String, Object> getLockedUserInfo(Account currentAccount, Long userId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static void unLock(Account currentAccount, Long userId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static Map<String, Object> getPasswordStrategyByUserId(Account currentAccount, Map<String, ?> userMap) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Map<String, Object> verifyPSWStrategy(Account currentAccount, Map<String, Object> userMap, String password) {
        String regEx;
        Pattern p;
        Matcher m;
        boolean fisspecial;
        String regEx2;
        Pattern p2;
        Matcher m2;
        int fminlength;
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        result.put("fneedverifycode", true);
        Map<String, Object> passwordStrategy = PswStrategyService.getPasswordStrategyByUserId(currentAccount, userMap);
        if (ObjectUtils.isEmpty(passwordStrategy)) {
            result.put(SUCCESS, true);
            return result;
        }
        boolean fneedverifycode = StringUtils.getBooleanValue(String.valueOf(passwordStrategy.get("fneedverifycode")));
        result.put("fneedverifycode", fneedverifycode);
        boolean flogincheckpsw = StringUtils.getBooleanValue(String.valueOf(passwordStrategy.get("flogincheckstgy")));
        if (!flogincheckpsw) {
            result.put(SUCCESS, true);
            return result;
        }
        int n = fminlength = ObjectUtils.isEmpty((Object)passwordStrategy.get("fminlength")) ? 6 : Integer.parseInt(passwordStrategy.get("fminlength").toString());
        if (password.length() < fminlength) {
            result.put(SUCCESS, false);
            return result;
        }
        boolean fisnumber = StringUtils.getBooleanValue(String.valueOf(passwordStrategy.get("fisnumber")));
        if (fisnumber && !(m2 = (p2 = Pattern.compile(regEx2 = "[0-9]")).matcher(password)).find()) {
            result.put(SUCCESS, false);
            return result;
        }
        boolean fisletter = StringUtils.getBooleanValue(String.valueOf(passwordStrategy.get("fisletter")));
        boolean fhascaseletter = StringUtils.getBooleanValue(String.valueOf(passwordStrategy.get("fhascaseletter")));
        if (fisletter) {
            String regEx3;
            Pattern p3;
            Matcher m3;
            if (fhascaseletter) {
                String regExLowerLetter = ".*?[a-z]+.*?";
                String regExUpLetter = ".*?[A-Z]+.*?";
                Pattern pL = Pattern.compile(regExLowerLetter);
                Pattern pU = Pattern.compile(regExUpLetter);
                Matcher mL = pL.matcher(password);
                Matcher mU = pU.matcher(password);
                if (!mL.find() || !mU.find()) {
                    result.put(SUCCESS, false);
                    return result;
                }
            }
            if (!(m3 = (p3 = Pattern.compile(regEx3 = "[A-Za-z]")).matcher(password)).find()) {
                result.put(SUCCESS, false);
                return result;
            }
        }
        if ((fisspecial = StringUtils.getBooleanValue(String.valueOf(passwordStrategy.get("fisspecial")))) && !(m = (p = Pattern.compile(regEx = "[`~!@#$%^&*()_+=|{}':;',\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]")).matcher(password)).find()) {
            result.put(SUCCESS, false);
            return result;
        }
        result.put(SUCCESS, true);
        return result;
    }

    private static int getRemainTime(Account currentAccount, Map<String, Object> userMap, Map<String, Object> passwordStrategy) {
        int remainTime = 0;
        GregorianCalendar cal = new GregorianCalendar(2000, 0, 1, 0, 0, 0);
        Calendar currCal = Calendar.getInstance();
        Calendar expiredTime = PswStrategyService.getExpiredTime(currentAccount, userMap, passwordStrategy);
        remainTime = (int)((expiredTime.getTimeInMillis() - cal.getTimeInMillis()) / 86400000L - (currCal.getTimeInMillis() - cal.getTimeInMillis()) / 86400000L);
        return remainTime;
    }

    private static Calendar getExpiredTime(Account currentAccount, Map<String, Object> userMap, Map<String, Object> passwordStrategy) {
        try {
            GregorianCalendar gcInvalid = new GregorianCalendar();
            Date fpsweffectivedate = ObjectUtils.isEmpty((Object)userMap.get("psweffectivedate")) ? new Date() : (Date)userMap.get("psweffectivedate");
            gcInvalid.setTime(fpsweffectivedate);
            int fvalidity = ObjectUtils.isEmpty((Object)passwordStrategy.get("fvalidity")) ? 0 : Integer.parseInt(passwordStrategy.get("fvalidity").toString());
            gcInvalid.add(6, fvalidity);
            return gcInvalid;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + LoginUtils.SPLIT_SIGN + e.getMessage()});
        }
    }

    private static Map<String, Object> verifyStrategy(Account currentAccount, Long userId, String password) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String s = SystemPropertyUtils.getProptyByTenant("ext.pswStrategy.class", currentAccount.getTenantId());
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)s)) {
            return Collections.emptyMap();
        }
        PswService pswService = (PswService)Class.forName(s).newInstance();
        return pswService.verifyStrategy(currentAccount, userId, password);
    }
}

