/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.user;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.dc.utils.MCDBUtil;
import kd.bos.dc.utils.SQLUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.ErrorCodeUtils;

public class SmsService {
    private static Log logger = LogFactory.getLog(SmsService.class);

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getSmsConfig(Account currentCenter) {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection conn;
        block6: {
            String string;
            Properties wfsProperties = AccountUtils.getTenantDBInfoByRoutekey((Account)currentCenter, (String)"wfs");
            if (wfsProperties == null) {
                throw new KDException(BosErrorCode.configNotFound, new Object[]{ErrorCodeUtils.getDBIntralError()});
            }
            conn = null;
            pstmt = null;
            rs = null;
            try {
                String signature;
                conn = MCDBUtil.getConnection((Properties)wfsProperties);
                String sql = "SELECT fmobileappconfig from t_msg_channel where fnumber = 'sms'";
                pstmt = conn.prepareStatement(sql);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block6;
                string = signature = rs.getString("fmobileappconfig");
            }
            catch (SQLException e) {
                try {
                    throw new KDException((Throwable)e, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + ErrorCodeUtils.getSlipSignerror() + e.getMessage()});
                    catch (Exception e2) {
                        throw new KDException((Throwable)e2, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + ErrorCodeUtils.getSlipSignerror() + e2.getMessage()});
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
            return string;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isSmsEnable(Account currentCenter) {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection conn;
        block6: {
            boolean bl;
            Properties wfsProperties = AccountUtils.getTenantDBInfoByRoutekey((Account)currentCenter, (String)"wfs");
            if (wfsProperties == null) {
                throw new KDException(BosErrorCode.configNotFound, new Object[]{ErrorCodeUtils.getDBIntralError()});
            }
            conn = null;
            pstmt = null;
            rs = null;
            try {
                conn = MCDBUtil.getConnection((Properties)wfsProperties);
                String sql = "SELECT fenable from t_msg_channel where fnumber = 'sms'";
                pstmt = conn.prepareStatement(sql);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block6;
                String enable = rs.getString("fenable");
                bl = "1".equals(enable);
            }
            catch (SQLException e) {
                try {
                    throw new KDException((Throwable)e, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + ErrorCodeUtils.getSlipSignerror() + e.getMessage()});
                    catch (Exception e2) {
                        throw new KDException((Throwable)e2, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + ErrorCodeUtils.getSlipSignerror() + e2.getMessage()});
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
            return bl;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return false;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isMsgChannelEnable(Account currentCenter, String msgChannel) {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection conn;
        block6: {
            boolean bl;
            Properties wfsProperties = AccountUtils.getTenantDBInfoByRoutekey((Account)currentCenter, (String)"wfs");
            if (wfsProperties == null) {
                logger.error(ErrorCodeUtils.getDBIntralError());
                throw new KDException(BosErrorCode.configNotFound, new Object[]{ErrorCodeUtils.getDBIntralError()});
            }
            conn = null;
            pstmt = null;
            rs = null;
            try {
                conn = MCDBUtil.getConnection((Properties)wfsProperties);
                String sql = "SELECT fenable from t_msg_channel where fnumber = ?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, msgChannel);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block6;
                String enable = rs.getString("fenable");
                bl = "1".equals(enable);
            }
            catch (SQLException e) {
                try {
                    throw new KDException((Throwable)e, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + ErrorCodeUtils.getSlipSignerror() + e.getMessage()});
                    catch (Exception e2) {
                        throw new KDException((Throwable)e2, BosErrorCode.sQLConnection, new Object[]{ErrorCodeUtils.getDBIntralError() + ErrorCodeUtils.getSlipSignerror() + e2.getMessage()});
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
            return bl;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return false;
    }
}

