/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.utils;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.actiondispatcher.ActionUtil;
import kd.bos.api.ApiRequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.CacheLoginData;
import kd.bos.login.utils.DateUtils;
import kd.bos.login.utils.JSONUtils;
import kd.bos.login.utils.StringUtils;
import kd.bos.login.utils.SystemPropertyUtils;

public class APIUtils {
    private static final Log logger = LogFactory.getLog(APIUtils.class);
    public static final Integer LOCK_TIME_OUT = 600;
    public static final Integer MAX_ERROR_COUNT = 5;
    public static final String LOCK_KEY = "lock_user";

    public static HashMap wrapSuccess(Object data) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("state", "success");
        if (data != null) {
            map.put("data", data);
        }
        return map;
    }

    public static HashMap wrapError(String errorCode, String errorMessage) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("state", "error");
        map.put("errorCode", errorCode);
        map.put("errorMsg", errorMessage);
        return map;
    }

    public static HashMap wrapAPIError(String errorCode, String errorMessage, String stack) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("success", "false");
        map.put("stack", stack);
        map.put("errorCode", errorCode);
        map.put("message", errorMessage);
        return map;
    }

    public static String getParameter4Post(HttpServletRequest request, HttpServletResponse response, String parameter) {
        String accountIdParameter = "";
        ApiRequestContext.initThreadLocal((HttpServletRequest)request, (HttpServletResponse)response);
        ApiRequestContext ctx = ApiRequestContext.get();
        Map mapReq = (Map)ctx.getPostData(HashMap.class);
        if (mapReq != null) {
            accountIdParameter = (String)mapReq.get(parameter);
        }
        return accountIdParameter;
    }

    public static void outputErrorMessage(HttpServletResponse response, String code, String message) {
        response.setContentType("text/json;charset=utf-8");
        try {
            String result = JSONUtils.toString(APIUtils.wrapError(code, message));
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)result);
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
    }

    public static void outputErrorMessage(HttpServletResponse response, String message) {
        response.setContentType("text/json;charset=utf-8");
        try {
            ActionUtil.writeResponseResult((ServletResponse)response, (CharSequence)message);
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
    }

    public static Boolean lockUser(String key) {
        try {
            String lockNum = CacheLoginData.getAttribute((String)LOCK_KEY, (String)key);
            if (StringUtils.isNotEmpty(lockNum) && Integer.parseInt(lockNum) >= MAX_ERROR_COUNT) {
                return true;
            }
            lockNum = StringUtils.isNotEmpty(lockNum) ? String.valueOf(Integer.parseInt(lockNum) + 1) : "1";
            CacheLoginData.setAttribute((String)LOCK_KEY, (String)key, (String)lockNum, (int)LOCK_TIME_OUT);
        }
        catch (Exception e) {
            logger.error("lockUser#", (Throwable)e);
        }
        return false;
    }

    public static Boolean lockUserAndWriteLockTime(String key) {
        try {
            String val = CacheLoginData.getAttribute((String)LOCK_KEY, (String)key);
            String value = StringUtils.getEmpty();
            String lockNum = StringUtils.getEmpty();
            if (StringUtils.isNotEmpty(val) && StringUtils.isNotEmpty(lockNum = val.split(",")[0]) && Integer.parseInt(lockNum) >= MAX_ERROR_COUNT) {
                return true;
            }
            value = lockNum = StringUtils.isNotEmpty(lockNum) ? String.valueOf(Integer.parseInt(lockNum) + 1) : "1";
            if (Integer.parseInt(lockNum) >= MAX_ERROR_COUNT) {
                value = value + "," + DateUtils.getTime((Date)new Date(new Date().getTime() + (long)(LOCK_TIME_OUT * 1000)));
            }
            CacheLoginData.setAttribute((String)LOCK_KEY, (String)key, (String)value, (int)LOCK_TIME_OUT);
        }
        catch (Exception e) {
            logger.error("lockUserAndWriteLockTime#", (Throwable)e);
        }
        return false;
    }

    public static String getLockTime(String key) {
        try {
            String val = CacheLoginData.getAttribute((String)LOCK_KEY, (String)key);
            if (StringUtils.isEmpty(val)) {
                return null;
            }
            String[] valarry = val.split(",");
            if (valarry.length < 2) {
                return null;
            }
            return valarry[1];
        }
        catch (Exception e) {
            logger.error("lockUserAndWriteLockTime#", (Throwable)e);
            return null;
        }
    }

    public static String getLockTimes(String key) {
        try {
            String val = CacheLoginData.getAttribute((String)LOCK_KEY, (String)key);
            if (StringUtils.isEmpty(val)) {
                return null;
            }
            String[] valarry = val.split(",");
            return valarry[0];
        }
        catch (Exception e) {
            logger.error("lockUserAndWriteLockTime#", (Throwable)e);
            return null;
        }
    }

    public static void outputAPIErrorMessage(HttpServletResponse response, String code, String message) {
        response.setContentType("text/json;charset=utf-8");
        try {
            String result = JSONUtils.toString(APIUtils.wrapAPIError(code, message, ""));
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)result);
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
    }

    public static boolean isSupportNonPasswordUserLogin(String tenantId) {
        boolean isSupport = true;
        String support = SystemPropertyUtils.getProptyByTenant("login_api_is_support_non_password", tenantId);
        if (StringUtils.isNotEmpty(support)) {
            isSupport = StringUtils.getBooleanValue(support);
        }
        return isSupport;
    }
}

