/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.utils;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.actiondispatcher.ActionUtil;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.login.CacheLoginData;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class AiUtils {
    private static final String SESSIONID = "sessionid";

    public static boolean isLegalAudioFile(String fileName) {
        if (fileName == null || fileName.isEmpty()) {
            return false;
        }
        return fileName.endsWith(".mp3") || fileName.endsWith(".wav");
    }

    public static boolean isEffectiveToken(String token) {
        return CacheLoginData.isEffectiveToken((String)token);
    }

    public static void addVoiceToken(String token) {
        CacheLoginData.addVoiceToken((String)token);
    }

    public static void cacheSessionId(String openId, String sessionId) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("", new DistributeCacheHAPolicy(true, true));
        String type = "ai_command";
        String key = "aitoken_" + openId;
        cache.put(type, key, (Object)sessionId);
    }

    public static void getTokenSessionId(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        String token = servletRequest.getParameter("token");
        HashMap<String, Object> mpData = new HashMap<String, Object>();
        String sessionId = AiUtils.getTokenSessionId(token);
        if (StringUtils.isEmpty((String)sessionId)) {
            mpData.put("success", false);
            mpData.put(SESSIONID, "");
        } else {
            mpData.put("success", true);
            mpData.put(SESSIONID, sessionId);
        }
        String sJson = JSONUtils.toString(mpData);
        ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)sJson);
    }

    public static String getTokenSessionId(String token) {
        String type = CacheLoginData.getType4AILoginSession((String)token);
        Map session = CacheLoginData.getCache((String)type);
        if (session != null) {
            return (String)session.get(SESSIONID);
        }
        return "";
    }
}

