/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.utils;

import java.util.concurrent.TimeUnit;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.crypto.MultiEncrypters;
import kd.bos.db.DBRoute;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.mc.LoginMCService;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.session.service.DBUtils;
import org.apache.commons.lang3.StringUtils;

public class DefaultPwdUtils {
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("LOGIN_DATA", new DistributeCacheHAPolicy(true, true));
    private static final String CONFIG = "_config";
    private static Log logger = LogFactory.getLog(DefaultPwdUtils.class);
    private static final String DEFAULT_CIPHER_ALGORITHM = "AES/GCM/NoPadding";

    public static LoginMCService getMcService() {
        return LoginMCService.create();
    }

    public static String AESEncrypt(String text, String encryptPass) throws Exception {
        try {
            return MultiEncrypters.encrypt((String)DEFAULT_CIPHER_ALGORITHM, (String)DefaultPwdUtils.getAESKey(), (int)256, (String)text);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return null;
        }
    }

    public static String AESDecrypt(String base64Encrypted, String encryptPass) throws Exception {
        try {
            return MultiEncrypters.decrypt((String)DEFAULT_CIPHER_ALGORITHM, (String)DefaultPwdUtils.getAESKey(), (int)256, (String)base64Encrypted);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return null;
        }
    }

    private static String getAESKey() {
        Account account = AccountUtils.getAccountById((String)RequestContext.get().getAccountId());
        StringBuilder sql = new StringBuilder("select fid,fparam_value, fparam_type  from T_BAS_DEFAULT_PARAMS where fparam_key = ?");
        String value = (String)DBUtils.query((Account)account, (DBRoute)DBRoute.basedata, (String)sql.toString(), (Object[])new Object[]{"LOGIN_DEFAULT_RANDOM_KEY"}, rs -> {
            if (rs.next()) {
                return rs.getString("fparam_value");
            }
            return null;
        });
        return value;
    }

    public static String getDefaultPwd(String key) {
        try {
            return DefaultPwdUtils.AESDecrypt(DefaultPwdUtils.getMcData(key), RequestContext.get().getAccountId());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void saveMcData(String key, String value) {
        try {
            DefaultPwdUtils.getMcService().setMCData(RequestContext.get().getTenantId(), key, value);
            cache.remove(key);
            cache.remove(key + CONFIG);
        }
        catch (Exception e) {
            throw new KDException(e.getMessage());
        }
    }

    public static String getMcData(String key) {
        try {
            String value = (String)cache.get(key);
            if (StringUtils.isNotBlank((CharSequence)value)) {
                return value;
            }
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)cache.get(key + CONFIG)))) {
                return null;
            }
            logger.info("load data from mc");
            String mcData = DefaultPwdUtils.getMcService().getMCData(RequestContext.get().getTenantId(), key);
            if (StringUtils.isNotBlank((CharSequence)mcData)) {
                cache.put(key, (Object)mcData, 30, TimeUnit.DAYS);
                return mcData;
            }
            cache.put(key + CONFIG, (Object)"false", 30, TimeUnit.DAYS);
            return null;
        }
        catch (Exception e) {
            throw new KDException(e.getMessage());
        }
    }
}

