/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.login.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.MCApiUtil;
import kd.bos.login.user.OpenApiService;
import kd.bos.login.utils.LocalCacheUtils;
import kd.bos.login.utils.StringUtils;

public class GuestURLUtils {
    private static Map<String, List<String>> accountList = new HashMap<String, List<String>>();
    private static final List<String> COMMON_API_GUEST_URL_LIST = new ArrayList<String>(64);
    private static final List<String> API_GUEST_URL_LIST = new ArrayList<String>(16);

    public static List<String> getCommonAPIURLList() {
        if (MCApiUtil.enableMcAuthLogin()) {
            return GuestURLUtils.getApiGuestUrlList(COMMON_API_GUEST_URL_LIST);
        }
        return COMMON_API_GUEST_URL_LIST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getAPIURLListByAccount(Account currentCenter) {
        List<String> returnList = null;
        if (currentCenter != null) {
            Object listObj = LocalCacheUtils.get(currentCenter.getAccountId());
            if (listObj != null) {
                returnList = (List<String>)listObj;
            }
            if (returnList == null || returnList.size() < 1) {
                returnList = OpenApiService.getAllAPIURLList(currentCenter);
                Map<String, List<String>> map = accountList;
                synchronized (map) {
                    LocalCacheUtils.put(currentCenter.getAccountId(), returnList);
                }
            }
        }
        return returnList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addAPIURL(long fid, Account currentCenter) {
        if (currentCenter != null) {
            String url;
            List<String> returnList = accountList.get(currentCenter.getAccountId());
            if (returnList == null) {
                returnList = OpenApiService.getAllAPIURLList(currentCenter);
            }
            if (StringUtils.isNotEmpty(url = OpenApiService.getURLByID(fid, currentCenter))) {
                if (returnList == null) {
                    returnList = new ArrayList<String>();
                }
                if (!COMMON_API_GUEST_URL_LIST.contains(url) && !returnList.contains(url)) {
                    Map<String, List<String>> map = accountList;
                    synchronized (map) {
                        returnList.add(url);
                        accountList.put(currentCenter.getAccountId(), returnList);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAPIURL(long fid, Account currentCenter) {
        if (currentCenter != null) {
            String url;
            List<String> returnList = accountList.get(currentCenter.getAccountId());
            if (returnList == null) {
                returnList = OpenApiService.getAllAPIURLList(currentCenter);
            }
            if (StringUtils.isNotEmpty(url = OpenApiService.getURLByID(fid, currentCenter, false))) {
                if (returnList == null) {
                    returnList = new ArrayList<String>();
                }
                Map<String, List<String>> map = accountList;
                synchronized (map) {
                    returnList.remove(url);
                    accountList.put(currentCenter.getAccountId(), returnList);
                }
            }
        }
    }

    private static List<String> getApiGuestUrlList(List<String> commonApiGuestUrlList) {
        if (API_GUEST_URL_LIST.size() <= 0) {
            for (String url : COMMON_API_GUEST_URL_LIST) {
                if (url.startsWith("/kapi/app/templic/") || url.startsWith("/kapi/app/mc/")) continue;
                API_GUEST_URL_LIST.add(url);
            }
        }
        return API_GUEST_URL_LIST;
    }

    static {
        COMMON_API_GUEST_URL_LIST.add("/kapi/app/mc/DataCenterMetaReBuildService");
        COMMON_API_GUEST_URL_LIST.add("/kapi/app/mc/getlicensebytenantid");
        COMMON_API_GUEST_URL_LIST.add("/kapi/app/mc/updateLicensefromEASCloud");
        COMMON_API_GUEST_URL_LIST.add("/kapi/app/mc/getDataCenterStatusService");
        COMMON_API_GUEST_URL_LIST.add("/kapi/app/mc/getEnvUpdateLogService");
        COMMON_API_GUEST_URL_LIST.add("/kapi/app/mc/getUpgradestateService");
        COMMON_API_GUEST_URL_LIST.add("/kapi/app/mc/DataSaveGetService");
        COMMON_API_GUEST_URL_LIST.add("/kapi/app/mc/DataSaveSetService");
        COMMON_API_GUEST_URL_LIST.add("/kapi/app/mc/GetDataCenterInfoService");
        COMMON_API_GUEST_URL_LIST.add("/kapi/app/mc/GetDbInstanceInfoService");
        COMMON_API_GUEST_URL_LIST.add("/kapi/app/mc/GetDbInstanceListService");
        COMMON_API_GUEST_URL_LIST.add("/kapi/app/mc/GetTenantInfoService");
        COMMON_API_GUEST_URL_LIST.add("/kapi/app/mc/UpgradeService");
        COMMON_API_GUEST_URL_LIST.add("/kapi/app/mc/WebClientFilesSaveService");
        COMMON_API_GUEST_URL_LIST.add("/kapi/app/mc/GetWebClientFilesService");
        COMMON_API_GUEST_URL_LIST.add("/kapi/app/mc/GetSingleDataCenterInfoService");
        COMMON_API_GUEST_URL_LIST.add("/kapi/app/mc/getRebuildDataResultService");
        COMMON_API_GUEST_URL_LIST.add("/kapi/app/mc/getEnvUpdateLogService");
        COMMON_API_GUEST_URL_LIST.add("/kapi/app/mc/GetCtripInfo");
        COMMON_API_GUEST_URL_LIST.add("/kapi/app/mc/GetUpgradeStatus");
        COMMON_API_GUEST_URL_LIST.add("/kapi/app/mc/ReleaseClusterService");
        COMMON_API_GUEST_URL_LIST.add("/tenant/updatelicensefromeascloud");
        COMMON_API_GUEST_URL_LIST.add("/tenant/getlicensebytenantid");
        COMMON_API_GUEST_URL_LIST.add("/datasave/get");
        COMMON_API_GUEST_URL_LIST.add("/datasave/set");
        COMMON_API_GUEST_URL_LIST.add("/login/tenantdb");
        COMMON_API_GUEST_URL_LIST.add("/datacenter/getDbInstanceInfo");
        COMMON_API_GUEST_URL_LIST.add("/datacenter/getSimpleDbInstanceList");
        COMMON_API_GUEST_URL_LIST.add("/login/gettenantbyclustername");
        COMMON_API_GUEST_URL_LIST.add("/environment/update");
        COMMON_API_GUEST_URL_LIST.add("/login/singletenant");
        COMMON_API_GUEST_URL_LIST.add("/login/getctripinfo");
        COMMON_API_GUEST_URL_LIST.add("/environment/getEnvUpdateStatus");
        COMMON_API_GUEST_URL_LIST.add("/mcLogTable.html");
        COMMON_API_GUEST_URL_LIST.add("/mcLogDetail.html");
        COMMON_API_GUEST_URL_LIST.add("/kapi/app/templic/checkPhoneService");
        COMMON_API_GUEST_URL_LIST.add("/kapi/app/templic/getTemLicInfoService");
        COMMON_API_GUEST_URL_LIST.add("/kapi/app/templic/saveTemLicInfoService");
        COMMON_API_GUEST_URL_LIST.add("/kapi/app/templic/temLicLogService");
        COMMON_API_GUEST_URL_LIST.add("/kapi/app/templic/getMCIDService");
        COMMON_API_GUEST_URL_LIST.add("/kapi/app/templic/getMCKeyService");
        COMMON_API_GUEST_URL_LIST.add("/kapi/app/templic/createTempLicService");
        COMMON_API_GUEST_URL_LIST.add("/api/login/getUserLanguage.do");
    }
}

